
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractSocket.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAbstractSocket_EventAdaptor.h"
#include "gsiDeclQAbstractSocket_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractSocket

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractSocket::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType socketType, QObject *parent)


static void _init_ctor_QAbstractSocket_4299 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketType");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QAbstractSocket *> ();
}

static void _call_ctor_QAbstractSocket_4299 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & > ();
  QObject *arg2 = args.read<QObject * > ();
  ret.write<QAbstractSocket *> (new QAbstractSocket (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketType>(arg1).cref(), arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAbstractSocket_4299 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType socketType, QObject *parent)\nThis method creates an object of class QAbstractSocket.", &_init_ctor_QAbstractSocket_4299, &_call_ctor_QAbstractSocket_4299);
}

// void QAbstractSocket::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractSocket *)cls)->abort ();
}

static qt_gsi::GenericMethod *_create_f_abort_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@brief Method void QAbstractSocket::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
}

// bool QAbstractSocket::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QAbstractSocket::atEnd()\nThis is a reimplementation of QIODevice::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// qint64 QAbstractSocket::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->bytesAvailable ());
}

static qt_gsi::GenericMethod *_create_f_bytesAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QAbstractSocket::bytesAvailable()\nThis is a reimplementation of QIODevice::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
}

// qint64 QAbstractSocket::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->bytesToWrite ());
}

static qt_gsi::GenericMethod *_create_f_bytesToWrite_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QAbstractSocket::bytesToWrite()\nThis is a reimplementation of QIODevice::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
}

// bool QAbstractSocket::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->canReadLine ());
}

static qt_gsi::GenericMethod *_create_f_canReadLine_c0 ()
{
  return new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QAbstractSocket::canReadLine()\nThis is a reimplementation of QIODevice::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
}

// void QAbstractSocket::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractSocket *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QAbstractSocket::close()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
}

// void QAbstractSocket::connectToHost(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHost_6151 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHost_6151 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  quint16 arg2 = args.read<quint16 > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QAbstractSocket *)cls)->connectToHost (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_connectToHost_6151 ()
{
  return new qt_gsi::GenericMethod ("connectToHost", "@brief Method void QAbstractSocket::connectToHost(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHost_6151, &_call_f_connectToHost_6151);
}

// void QAbstractSocket::connectToHost(const QHostAddress &address, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHost_6644 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHost_6644 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QHostAddress &arg1 = args.read<const QHostAddress & > ();
  quint16 arg2 = args.read<quint16 > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QAbstractSocket *)cls)->connectToHost (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_connectToHost_6644 ()
{
  return new qt_gsi::GenericMethod ("connectToHost", "@brief Method void QAbstractSocket::connectToHost(const QHostAddress &address, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHost_6644, &_call_f_connectToHost_6644);
}

// void QAbstractSocket::disconnectFromHost()


static void _init_f_disconnectFromHost_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_disconnectFromHost_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractSocket *)cls)->disconnectFromHost ();
}

static qt_gsi::GenericMethod *_create_f_disconnectFromHost_0 ()
{
  return new qt_gsi::GenericMethod ("disconnectFromHost", "@brief Method void QAbstractSocket::disconnectFromHost()\n", false, &_init_f_disconnectFromHost_0, &_call_f_disconnectFromHost_0);
}

// QAbstractSocket::SocketError QAbstractSocket::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketError>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketError>(((QAbstractSocket *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QAbstractSocket::SocketError QAbstractSocket::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// bool QAbstractSocket::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->flush ());
}

static qt_gsi::GenericMethod *_create_f_flush_0 ()
{
  return new qt_gsi::GenericMethod ("flush", "@brief Method bool QAbstractSocket::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
}

// bool QAbstractSocket::isSequential()


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->isSequential ());
}

static qt_gsi::GenericMethod *_create_f_isSequential_c0 ()
{
  return new qt_gsi::GenericMethod ("isSequential?", "@brief Method bool QAbstractSocket::isSequential()\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
}

// bool QAbstractSocket::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QAbstractSocket::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// QHostAddress QAbstractSocket::localAddress()


static void _init_f_localAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_localAddress_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QHostAddress > ((QHostAddress)((QAbstractSocket *)cls)->localAddress ());
}

static qt_gsi::GenericMethod *_create_f_localAddress_c0 ()
{
  return new qt_gsi::GenericMethod ("localAddress", "@brief Method QHostAddress QAbstractSocket::localAddress()\n", true, &_init_f_localAddress_c0, &_call_f_localAddress_c0);
}

// quint16 QAbstractSocket::localPort()


static void _init_f_localPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_localPort_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<quint16 > ((quint16)((QAbstractSocket *)cls)->localPort ());
}

static qt_gsi::GenericMethod *_create_f_localPort_c0 ()
{
  return new qt_gsi::GenericMethod ("localPort", "@brief Method quint16 QAbstractSocket::localPort()\n", true, &_init_f_localPort_c0, &_call_f_localPort_c0);
}

// QHostAddress QAbstractSocket::peerAddress()


static void _init_f_peerAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_peerAddress_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QHostAddress > ((QHostAddress)((QAbstractSocket *)cls)->peerAddress ());
}

static qt_gsi::GenericMethod *_create_f_peerAddress_c0 ()
{
  return new qt_gsi::GenericMethod ("peerAddress", "@brief Method QHostAddress QAbstractSocket::peerAddress()\n", true, &_init_f_peerAddress_c0, &_call_f_peerAddress_c0);
}

// QString QAbstractSocket::peerName()


static void _init_f_peerName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_peerName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QAbstractSocket *)cls)->peerName ());
}

static qt_gsi::GenericMethod *_create_f_peerName_c0 ()
{
  return new qt_gsi::GenericMethod ("peerName", "@brief Method QString QAbstractSocket::peerName()\n", true, &_init_f_peerName_c0, &_call_f_peerName_c0);
}

// quint16 QAbstractSocket::peerPort()


static void _init_f_peerPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_peerPort_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<quint16 > ((quint16)((QAbstractSocket *)cls)->peerPort ());
}

static qt_gsi::GenericMethod *_create_f_peerPort_c0 ()
{
  return new qt_gsi::GenericMethod ("peerPort", "@brief Method quint16 QAbstractSocket::peerPort()\n", true, &_init_f_peerPort_c0, &_call_f_peerPort_c0);
}

// QNetworkProxy QAbstractSocket::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxy > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QNetworkProxy > ((QNetworkProxy)((QAbstractSocket *)cls)->proxy ());
}

static qt_gsi::GenericMethod *_create_f_proxy_c0 ()
{
  return new qt_gsi::GenericMethod (":proxy", "@brief Method QNetworkProxy QAbstractSocket::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
}

// qint64 QAbstractSocket::readBufferSize()


static void _init_f_readBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_readBufferSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->readBufferSize ());
}

static qt_gsi::GenericMethod *_create_f_readBufferSize_c0 ()
{
  return new qt_gsi::GenericMethod (":readBufferSize", "@brief Method qint64 QAbstractSocket::readBufferSize()\n", true, &_init_f_readBufferSize_c0, &_call_f_readBufferSize_c0);
}

// void QAbstractSocket::setProxy(const QNetworkProxy &networkProxy)


static void _init_f_setProxy_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("networkProxy");
  decl->add_arg<const QNetworkProxy & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxy_2686 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkProxy &arg1 = args.read<const QNetworkProxy & > ();
  ((QAbstractSocket *)cls)->setProxy (arg1);
}

static qt_gsi::GenericMethod *_create_f_setProxy_2686 ()
{
  return new qt_gsi::GenericMethod ("setProxy|proxy=", "@brief Method void QAbstractSocket::setProxy(const QNetworkProxy &networkProxy)\n", false, &_init_f_setProxy_2686, &_call_f_setProxy_2686);
}

// void QAbstractSocket::setReadBufferSize(qint64 size)


static void _init_f_setReadBufferSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadBufferSize_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ((QAbstractSocket *)cls)->setReadBufferSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setReadBufferSize_986 ()
{
  return new qt_gsi::GenericMethod ("setReadBufferSize|readBufferSize=", "@brief Method void QAbstractSocket::setReadBufferSize(qint64 size)\n", false, &_init_f_setReadBufferSize_986, &_call_f_setReadBufferSize_986);
}

// bool QAbstractSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_setSocketDescriptor_6993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("state", true, "QAbstractSocket::ConnectedState");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setSocketDescriptor_6993 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > () : (const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type &)(qt_gsi::CppToQtReadAdaptor<QAbstractSocket::SocketState>(heap, QAbstractSocket::ConnectedState));
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->setSocketDescriptor (arg1, qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketState>(arg2).cref(), qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_setSocketDescriptor_6993 ()
{
  return new qt_gsi::GenericMethod ("setSocketDescriptor", "@brief Method bool QAbstractSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_setSocketDescriptor_6993, &_call_f_setSocketDescriptor_6993);
}

// void QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)


static void _init_f_setSocketOption_5331 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSocketOption_5331 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QAbstractSocket *)cls)->setSocketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setSocketOption_5331 ()
{
  return new qt_gsi::GenericMethod ("setSocketOption", "@brief Method void QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)\n", false, &_init_f_setSocketOption_5331, &_call_f_setSocketOption_5331);
}

// int QAbstractSocket::socketDescriptor()


static void _init_f_socketDescriptor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_socketDescriptor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractSocket *)cls)->socketDescriptor ());
}

static qt_gsi::GenericMethod *_create_f_socketDescriptor_c0 ()
{
  return new qt_gsi::GenericMethod ("socketDescriptor", "@brief Method int QAbstractSocket::socketDescriptor()\n", true, &_init_f_socketDescriptor_c0, &_call_f_socketDescriptor_c0);
}

// QVariant QAbstractSocket::socketOption(QAbstractSocket::SocketOption option)


static void _init_f_socketOption_3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_socketOption_3320 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QAbstractSocket *)cls)->socketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_socketOption_3320 ()
{
  return new qt_gsi::GenericMethod ("socketOption", "@brief Method QVariant QAbstractSocket::socketOption(QAbstractSocket::SocketOption option)\n", false, &_init_f_socketOption_3320, &_call_f_socketOption_3320);
}

// QAbstractSocket::SocketType QAbstractSocket::socketType()


static void _init_f_socketType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketType>::target_type > ();
}

static void _call_f_socketType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketType>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketType>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketType>(((QAbstractSocket *)cls)->socketType ()));
}

static qt_gsi::GenericMethod *_create_f_socketType_c0 ()
{
  return new qt_gsi::GenericMethod ("socketType", "@brief Method QAbstractSocket::SocketType QAbstractSocket::socketType()\n", true, &_init_f_socketType_c0, &_call_f_socketType_c0);
}

// QAbstractSocket::SocketState QAbstractSocket::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketState>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketState>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketState>(((QAbstractSocket *)cls)->state ()));
}

static qt_gsi::GenericMethod *_create_f_state_c0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Method QAbstractSocket::SocketState QAbstractSocket::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
}

// bool QAbstractSocket::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForBytesWritten (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForBytesWritten_767 ()
{
  return new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QAbstractSocket::waitForBytesWritten(int msecs)\nThis is a reimplementation of QIODevice::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
}

// bool QAbstractSocket::waitForConnected(int msecs)


static void _init_f_waitForConnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForConnected_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForConnected (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForConnected_767 ()
{
  return new qt_gsi::GenericMethod ("waitForConnected", "@brief Method bool QAbstractSocket::waitForConnected(int msecs)\n", false, &_init_f_waitForConnected_767, &_call_f_waitForConnected_767);
}

// bool QAbstractSocket::waitForDisconnected(int msecs)


static void _init_f_waitForDisconnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForDisconnected_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForDisconnected (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForDisconnected_767 ()
{
  return new qt_gsi::GenericMethod ("waitForDisconnected", "@brief Method bool QAbstractSocket::waitForDisconnected(int msecs)\n", false, &_init_f_waitForDisconnected_767, &_call_f_waitForDisconnected_767);
}

// bool QAbstractSocket::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForReadyRead (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForReadyRead_767 ()
{
  return new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QAbstractSocket::waitForReadyRead(int msecs)\nThis is a reimplementation of QIODevice::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
}

// static QString QAbstractSocket::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractSocket::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractSocket::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QAbstractSocket::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractSocket::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractSocket::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QAbstractSocket::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractSocket::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractSocket::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QAbstractSocket::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractSocket::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractSocket::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QAbstractSocket, QAbstractSocket_EventAdaptor> ea_QAbstractSocket;


namespace gsi
{
extern gsi::Class<QIODevice> decl_QIODevice;

gsi::Class<QAbstractSocket> decl_QAbstractSocket (ea_QAbstractSocket, decl_QIODevice, "QAbstractSocket",
  gsi::Methods(_create_ctor_QAbstractSocket_4299 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_abort_0 ()) +
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_bytesAvailable_c0 ()) +
  gsi::Methods(_create_f_bytesToWrite_c0 ()) +
  gsi::Methods(_create_f_canReadLine_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_connectToHost_6151 ()) +
  gsi::Methods(_create_f_connectToHost_6644 ()) +
  gsi::Methods(_create_f_disconnectFromHost_0 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_flush_0 ()) +
  gsi::Methods(_create_f_isSequential_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_localAddress_c0 ()) +
  gsi::Methods(_create_f_localPort_c0 ()) +
  gsi::Methods(_create_f_peerAddress_c0 ()) +
  gsi::Methods(_create_f_peerName_c0 ()) +
  gsi::Methods(_create_f_peerPort_c0 ()) +
  gsi::Methods(_create_f_proxy_c0 ()) +
  gsi::Methods(_create_f_readBufferSize_c0 ()) +
  gsi::Methods(_create_f_setProxy_2686 ()) +
  gsi::Methods(_create_f_setReadBufferSize_986 ()) +
  gsi::Methods(_create_f_setSocketDescriptor_6993 ()) +
  gsi::Methods(_create_f_setSocketOption_5331 ()) +
  gsi::Methods(_create_f_socketDescriptor_c0 ()) +
  gsi::Methods(_create_f_socketOption_3320 ()) +
  gsi::Methods(_create_f_socketType_c0 ()) +
  gsi::Methods(_create_f_state_c0 ()) +
  gsi::Methods(_create_f_waitForBytesWritten_767 ()) +
  gsi::Methods(_create_f_waitForConnected_767 ()) +
  gsi::Methods(_create_f_waitForDisconnected_767 ()) +
  gsi::Methods(_create_f_waitForReadyRead_767 ()) +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor> ("aboutToClose", &QAbstractSocket_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QAbstractSocket::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor, qint64> ("bytesWritten", &QAbstractSocket_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QAbstractSocket::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor> ("connected", &QAbstractSocket_EventAdaptor::connected_e_0, "@brief Signal declaration for QAbstractSocket::connected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor, QObject *> ("destroyed", &QAbstractSocket_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor> ("disconnected", &QAbstractSocket_EventAdaptor::disconnected_e_0, "@brief Signal declaration for QAbstractSocket::disconnected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor, const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type &> ("error", &QAbstractSocket_EventAdaptor::error_e_3209, gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::error(QAbstractSocket::SocketError)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor> ("hostFound", &QAbstractSocket_EventAdaptor::hostFound_e_0, "@brief Signal declaration for QAbstractSocket::hostFound()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor, const QNetworkProxy &, QAuthenticator *> ("proxyAuthenticationRequired", &QAbstractSocket_EventAdaptor::proxyAuthenticationRequired_e_4652, gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QAbstractSocket::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor> ("readChannelFinished", &QAbstractSocket_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QAbstractSocket::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor> ("readyRead", &QAbstractSocket_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QAbstractSocket::readyRead()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractSocket, QAbstractSocket_EventAdaptor, const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type &> ("stateChanged", &QAbstractSocket_EventAdaptor::stateChanged_e_3200, gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::stateChanged(QAbstractSocket::SocketState)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QAbstractSocket");

}


//  Implementation of the enum wrapper class for QAbstractSocket::NetworkLayerProtocol
namespace qt_gsi
{

static QAbstractSocket_NetworkLayerProtocol_Enum *c_1_QAbstractSocket_NetworkLayerProtocol_Enum () { return new QAbstractSocket_NetworkLayerProtocol_Enum (QAbstractSocket::IPv4Protocol); }
static QAbstractSocket_NetworkLayerProtocol_Enum *c_2_QAbstractSocket_NetworkLayerProtocol_Enum () { return new QAbstractSocket_NetworkLayerProtocol_Enum (QAbstractSocket::IPv6Protocol); }
static QAbstractSocket_NetworkLayerProtocol_Enum *c_3_QAbstractSocket_NetworkLayerProtocol_Enum () { return new QAbstractSocket_NetworkLayerProtocol_Enum (QAbstractSocket::UnknownNetworkLayerProtocol); }

static gsi::Methods mkdefs_QAbstractSocket_NetworkLayerProtocol () {
  return
    gsi::constant ("IPv4Protocol", &qt_gsi::c_1_QAbstractSocket_NetworkLayerProtocol_Enum, "@brief Enum constant QAbstractSocket::IPv4Protocol") +
    gsi::constant ("IPv6Protocol", &qt_gsi::c_2_QAbstractSocket_NetworkLayerProtocol_Enum, "@brief Enum constant QAbstractSocket::IPv6Protocol") +
    gsi::constant ("UnknownNetworkLayerProtocol", &qt_gsi::c_3_QAbstractSocket_NetworkLayerProtocol_Enum, "@brief Enum constant QAbstractSocket::UnknownNetworkLayerProtocol");
}

static std::string to_s_QAbstractSocket_NetworkLayerProtocol_Enum (const QAbstractSocket_NetworkLayerProtocol_Enum *e)
{
  if (e->value () == QAbstractSocket::IPv4Protocol) { return tl::sprintf ("IPv4Protocol (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::IPv6Protocol) { return tl::sprintf ("IPv6Protocol (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::UnknownNetworkLayerProtocol) { return tl::sprintf ("UnknownNetworkLayerProtocol (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractSocket_NetworkLayerProtocol_Enum (const QAbstractSocket_NetworkLayerProtocol_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractSocket_NetworkLayerProtocol_Enum *from_i_QAbstractSocket_NetworkLayerProtocol_Enum (unsigned int i)
{
  return new QAbstractSocket_NetworkLayerProtocol_Enum ((QAbstractSocket::NetworkLayerProtocol) i);
}

static bool equalQAbstractSocket_NetworkLayerProtocol_Enum (const QAbstractSocket_NetworkLayerProtocol_Enum *e, QAbstractSocket_NetworkLayerProtocol_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractSocket_NetworkLayerProtocol_Enum (const QAbstractSocket_NetworkLayerProtocol_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractSocket_NetworkLayerProtocol_Enums oropQAbstractSocket_NetworkLayerProtocol_Enums (const QAbstractSocket_NetworkLayerProtocol_Enums *e, const QAbstractSocket_NetworkLayerProtocol_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractSocket_NetworkLayerProtocol_Enums andopQAbstractSocket_NetworkLayerProtocol_Enums (const QAbstractSocket_NetworkLayerProtocol_Enums *e, const QAbstractSocket_NetworkLayerProtocol_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractSocket_NetworkLayerProtocol_Enums xoropQAbstractSocket_NetworkLayerProtocol_Enums (const QAbstractSocket_NetworkLayerProtocol_Enums *e, const QAbstractSocket_NetworkLayerProtocol_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractSocket_NetworkLayerProtocol_Enums (const QAbstractSocket_NetworkLayerProtocol_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractSocket::IPv4Protocol)) { if (!l.empty ()) l += "|"; l += "IPv4Protocol"; }
  if (e->testFlag (QAbstractSocket::IPv6Protocol)) { if (!l.empty ()) l += "|"; l += "IPv6Protocol"; }
  if (e->testFlag (QAbstractSocket::UnknownNetworkLayerProtocol)) { if (!l.empty ()) l += "|"; l += "UnknownNetworkLayerProtocol"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractSocket_NetworkLayerProtocol_Enums (const QAbstractSocket_NetworkLayerProtocol_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractSocket_NetworkLayerProtocol_Enums (const QAbstractSocket_NetworkLayerProtocol_Enums *e, const QAbstractSocket_NetworkLayerProtocol_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractSocket_NetworkLayerProtocol_Enums> decl_QAbstractSocket_NetworkLayerProtocol_Enums ("QAbstractSocket_QFlags_NetworkLayerProtocol",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractSocket_NetworkLayerProtocol_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractSocket_NetworkLayerProtocol_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractSocket_NetworkLayerProtocol_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_NetworkLayerProtocol_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_NetworkLayerProtocol_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractSocket_NetworkLayerProtocol_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::NetworkLayerProtocol> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractSocket_NetworkLayerProtocol_Enum> decl_QAbstractSocket_NetworkLayerProtocol_Enum (decl_QAbstractSocket_NetworkLayerProtocol_Enums, "QAbstractSocket_NetworkLayerProtocol",
  qt_gsi::mkdefs_QAbstractSocket_NetworkLayerProtocol () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_NetworkLayerProtocol_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_NetworkLayerProtocol_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractSocket_NetworkLayerProtocol_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractSocket_NetworkLayerProtocol_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractSocket_NetworkLayerProtocol_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractSocket::NetworkLayerProtocol enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_NetworkLayerProtocol_Enum_in_parent (qt_gsi::mkdefs_QAbstractSocket_NetworkLayerProtocol ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_NetworkLayerProtocol_Enum_as_child (decl_QAbstractSocket_NetworkLayerProtocol_Enum, "NetworkLayerProtocol");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketError
namespace qt_gsi
{

static QAbstractSocket_SocketError_Enum *c_1_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::ConnectionRefusedError); }
static QAbstractSocket_SocketError_Enum *c_2_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::RemoteHostClosedError); }
static QAbstractSocket_SocketError_Enum *c_3_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::HostNotFoundError); }
static QAbstractSocket_SocketError_Enum *c_4_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::SocketAccessError); }
static QAbstractSocket_SocketError_Enum *c_5_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::SocketResourceError); }
static QAbstractSocket_SocketError_Enum *c_6_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::SocketTimeoutError); }
static QAbstractSocket_SocketError_Enum *c_7_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::DatagramTooLargeError); }
static QAbstractSocket_SocketError_Enum *c_8_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::NetworkError); }
static QAbstractSocket_SocketError_Enum *c_9_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::AddressInUseError); }
static QAbstractSocket_SocketError_Enum *c_10_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::SocketAddressNotAvailableError); }
static QAbstractSocket_SocketError_Enum *c_11_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::UnsupportedSocketOperationError); }
static QAbstractSocket_SocketError_Enum *c_12_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::UnfinishedSocketOperationError); }
static QAbstractSocket_SocketError_Enum *c_13_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::ProxyAuthenticationRequiredError); }
static QAbstractSocket_SocketError_Enum *c_14_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::SslHandshakeFailedError); }
static QAbstractSocket_SocketError_Enum *c_15_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::ProxyConnectionRefusedError); }
static QAbstractSocket_SocketError_Enum *c_16_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::ProxyConnectionClosedError); }
static QAbstractSocket_SocketError_Enum *c_17_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::ProxyConnectionTimeoutError); }
static QAbstractSocket_SocketError_Enum *c_18_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::ProxyNotFoundError); }
static QAbstractSocket_SocketError_Enum *c_19_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::ProxyProtocolError); }
static QAbstractSocket_SocketError_Enum *c_20_QAbstractSocket_SocketError_Enum () { return new QAbstractSocket_SocketError_Enum (QAbstractSocket::UnknownSocketError); }

static gsi::Methods mkdefs_QAbstractSocket_SocketError () {
  return
    gsi::constant ("ConnectionRefusedError", &qt_gsi::c_1_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::ConnectionRefusedError") +
    gsi::constant ("RemoteHostClosedError", &qt_gsi::c_2_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::RemoteHostClosedError") +
    gsi::constant ("HostNotFoundError", &qt_gsi::c_3_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::HostNotFoundError") +
    gsi::constant ("SocketAccessError", &qt_gsi::c_4_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::SocketAccessError") +
    gsi::constant ("SocketResourceError", &qt_gsi::c_5_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::SocketResourceError") +
    gsi::constant ("SocketTimeoutError", &qt_gsi::c_6_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::SocketTimeoutError") +
    gsi::constant ("DatagramTooLargeError", &qt_gsi::c_7_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::DatagramTooLargeError") +
    gsi::constant ("NetworkError", &qt_gsi::c_8_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::NetworkError") +
    gsi::constant ("AddressInUseError", &qt_gsi::c_9_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::AddressInUseError") +
    gsi::constant ("SocketAddressNotAvailableError", &qt_gsi::c_10_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::SocketAddressNotAvailableError") +
    gsi::constant ("UnsupportedSocketOperationError", &qt_gsi::c_11_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::UnsupportedSocketOperationError") +
    gsi::constant ("UnfinishedSocketOperationError", &qt_gsi::c_12_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::UnfinishedSocketOperationError") +
    gsi::constant ("ProxyAuthenticationRequiredError", &qt_gsi::c_13_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::ProxyAuthenticationRequiredError") +
    gsi::constant ("SslHandshakeFailedError", &qt_gsi::c_14_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::SslHandshakeFailedError") +
    gsi::constant ("ProxyConnectionRefusedError", &qt_gsi::c_15_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::ProxyConnectionRefusedError") +
    gsi::constant ("ProxyConnectionClosedError", &qt_gsi::c_16_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::ProxyConnectionClosedError") +
    gsi::constant ("ProxyConnectionTimeoutError", &qt_gsi::c_17_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::ProxyConnectionTimeoutError") +
    gsi::constant ("ProxyNotFoundError", &qt_gsi::c_18_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::ProxyNotFoundError") +
    gsi::constant ("ProxyProtocolError", &qt_gsi::c_19_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::ProxyProtocolError") +
    gsi::constant ("UnknownSocketError", &qt_gsi::c_20_QAbstractSocket_SocketError_Enum, "@brief Enum constant QAbstractSocket::UnknownSocketError");
}

static std::string to_s_QAbstractSocket_SocketError_Enum (const QAbstractSocket_SocketError_Enum *e)
{
  if (e->value () == QAbstractSocket::ConnectionRefusedError) { return tl::sprintf ("ConnectionRefusedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::RemoteHostClosedError) { return tl::sprintf ("RemoteHostClosedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::HostNotFoundError) { return tl::sprintf ("HostNotFoundError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::SocketAccessError) { return tl::sprintf ("SocketAccessError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::SocketResourceError) { return tl::sprintf ("SocketResourceError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::SocketTimeoutError) { return tl::sprintf ("SocketTimeoutError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::DatagramTooLargeError) { return tl::sprintf ("DatagramTooLargeError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::NetworkError) { return tl::sprintf ("NetworkError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::AddressInUseError) { return tl::sprintf ("AddressInUseError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::SocketAddressNotAvailableError) { return tl::sprintf ("SocketAddressNotAvailableError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::UnsupportedSocketOperationError) { return tl::sprintf ("UnsupportedSocketOperationError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::UnfinishedSocketOperationError) { return tl::sprintf ("UnfinishedSocketOperationError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ProxyAuthenticationRequiredError) { return tl::sprintf ("ProxyAuthenticationRequiredError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::SslHandshakeFailedError) { return tl::sprintf ("SslHandshakeFailedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ProxyConnectionRefusedError) { return tl::sprintf ("ProxyConnectionRefusedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ProxyConnectionClosedError) { return tl::sprintf ("ProxyConnectionClosedError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ProxyConnectionTimeoutError) { return tl::sprintf ("ProxyConnectionTimeoutError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ProxyNotFoundError) { return tl::sprintf ("ProxyNotFoundError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ProxyProtocolError) { return tl::sprintf ("ProxyProtocolError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::UnknownSocketError) { return tl::sprintf ("UnknownSocketError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractSocket_SocketError_Enum (const QAbstractSocket_SocketError_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractSocket_SocketError_Enum *from_i_QAbstractSocket_SocketError_Enum (unsigned int i)
{
  return new QAbstractSocket_SocketError_Enum ((QAbstractSocket::SocketError) i);
}

static bool equalQAbstractSocket_SocketError_Enum (const QAbstractSocket_SocketError_Enum *e, QAbstractSocket_SocketError_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractSocket_SocketError_Enum (const QAbstractSocket_SocketError_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractSocket_SocketError_Enums oropQAbstractSocket_SocketError_Enums (const QAbstractSocket_SocketError_Enums *e, const QAbstractSocket_SocketError_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractSocket_SocketError_Enums andopQAbstractSocket_SocketError_Enums (const QAbstractSocket_SocketError_Enums *e, const QAbstractSocket_SocketError_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractSocket_SocketError_Enums xoropQAbstractSocket_SocketError_Enums (const QAbstractSocket_SocketError_Enums *e, const QAbstractSocket_SocketError_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractSocket_SocketError_Enums (const QAbstractSocket_SocketError_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractSocket::ConnectionRefusedError)) { if (!l.empty ()) l += "|"; l += "ConnectionRefusedError"; }
  if (e->testFlag (QAbstractSocket::RemoteHostClosedError)) { if (!l.empty ()) l += "|"; l += "RemoteHostClosedError"; }
  if (e->testFlag (QAbstractSocket::HostNotFoundError)) { if (!l.empty ()) l += "|"; l += "HostNotFoundError"; }
  if (e->testFlag (QAbstractSocket::SocketAccessError)) { if (!l.empty ()) l += "|"; l += "SocketAccessError"; }
  if (e->testFlag (QAbstractSocket::SocketResourceError)) { if (!l.empty ()) l += "|"; l += "SocketResourceError"; }
  if (e->testFlag (QAbstractSocket::SocketTimeoutError)) { if (!l.empty ()) l += "|"; l += "SocketTimeoutError"; }
  if (e->testFlag (QAbstractSocket::DatagramTooLargeError)) { if (!l.empty ()) l += "|"; l += "DatagramTooLargeError"; }
  if (e->testFlag (QAbstractSocket::NetworkError)) { if (!l.empty ()) l += "|"; l += "NetworkError"; }
  if (e->testFlag (QAbstractSocket::AddressInUseError)) { if (!l.empty ()) l += "|"; l += "AddressInUseError"; }
  if (e->testFlag (QAbstractSocket::SocketAddressNotAvailableError)) { if (!l.empty ()) l += "|"; l += "SocketAddressNotAvailableError"; }
  if (e->testFlag (QAbstractSocket::UnsupportedSocketOperationError)) { if (!l.empty ()) l += "|"; l += "UnsupportedSocketOperationError"; }
  if (e->testFlag (QAbstractSocket::UnfinishedSocketOperationError)) { if (!l.empty ()) l += "|"; l += "UnfinishedSocketOperationError"; }
  if (e->testFlag (QAbstractSocket::ProxyAuthenticationRequiredError)) { if (!l.empty ()) l += "|"; l += "ProxyAuthenticationRequiredError"; }
  if (e->testFlag (QAbstractSocket::SslHandshakeFailedError)) { if (!l.empty ()) l += "|"; l += "SslHandshakeFailedError"; }
  if (e->testFlag (QAbstractSocket::ProxyConnectionRefusedError)) { if (!l.empty ()) l += "|"; l += "ProxyConnectionRefusedError"; }
  if (e->testFlag (QAbstractSocket::ProxyConnectionClosedError)) { if (!l.empty ()) l += "|"; l += "ProxyConnectionClosedError"; }
  if (e->testFlag (QAbstractSocket::ProxyConnectionTimeoutError)) { if (!l.empty ()) l += "|"; l += "ProxyConnectionTimeoutError"; }
  if (e->testFlag (QAbstractSocket::ProxyNotFoundError)) { if (!l.empty ()) l += "|"; l += "ProxyNotFoundError"; }
  if (e->testFlag (QAbstractSocket::ProxyProtocolError)) { if (!l.empty ()) l += "|"; l += "ProxyProtocolError"; }
  if (e->testFlag (QAbstractSocket::UnknownSocketError)) { if (!l.empty ()) l += "|"; l += "UnknownSocketError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractSocket_SocketError_Enums (const QAbstractSocket_SocketError_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractSocket_SocketError_Enums (const QAbstractSocket_SocketError_Enums *e, const QAbstractSocket_SocketError_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketError_Enums> decl_QAbstractSocket_SocketError_Enums ("QAbstractSocket_QFlags_SocketError",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractSocket_SocketError_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractSocket_SocketError_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractSocket_SocketError_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketError_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketError_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractSocket_SocketError_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketError> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketError_Enum> decl_QAbstractSocket_SocketError_Enum (decl_QAbstractSocket_SocketError_Enums, "QAbstractSocket_SocketError",
  qt_gsi::mkdefs_QAbstractSocket_SocketError () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketError_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketError_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractSocket_SocketError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractSocket_SocketError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractSocket_SocketError_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketError enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketError_Enum_in_parent (qt_gsi::mkdefs_QAbstractSocket_SocketError ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketError_Enum_as_child (decl_QAbstractSocket_SocketError_Enum, "SocketError");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketOption
namespace qt_gsi
{

static QAbstractSocket_SocketOption_Enum *c_1_QAbstractSocket_SocketOption_Enum () { return new QAbstractSocket_SocketOption_Enum (QAbstractSocket::LowDelayOption); }
static QAbstractSocket_SocketOption_Enum *c_2_QAbstractSocket_SocketOption_Enum () { return new QAbstractSocket_SocketOption_Enum (QAbstractSocket::KeepAliveOption); }

static gsi::Methods mkdefs_QAbstractSocket_SocketOption () {
  return
    gsi::constant ("LowDelayOption", &qt_gsi::c_1_QAbstractSocket_SocketOption_Enum, "@brief Enum constant QAbstractSocket::LowDelayOption") +
    gsi::constant ("KeepAliveOption", &qt_gsi::c_2_QAbstractSocket_SocketOption_Enum, "@brief Enum constant QAbstractSocket::KeepAliveOption");
}

static std::string to_s_QAbstractSocket_SocketOption_Enum (const QAbstractSocket_SocketOption_Enum *e)
{
  if (e->value () == QAbstractSocket::LowDelayOption) { return tl::sprintf ("LowDelayOption (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::KeepAliveOption) { return tl::sprintf ("KeepAliveOption (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractSocket_SocketOption_Enum (const QAbstractSocket_SocketOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractSocket_SocketOption_Enum *from_i_QAbstractSocket_SocketOption_Enum (unsigned int i)
{
  return new QAbstractSocket_SocketOption_Enum ((QAbstractSocket::SocketOption) i);
}

static bool equalQAbstractSocket_SocketOption_Enum (const QAbstractSocket_SocketOption_Enum *e, QAbstractSocket_SocketOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractSocket_SocketOption_Enum (const QAbstractSocket_SocketOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractSocket_SocketOption_Enums oropQAbstractSocket_SocketOption_Enums (const QAbstractSocket_SocketOption_Enums *e, const QAbstractSocket_SocketOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractSocket_SocketOption_Enums andopQAbstractSocket_SocketOption_Enums (const QAbstractSocket_SocketOption_Enums *e, const QAbstractSocket_SocketOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractSocket_SocketOption_Enums xoropQAbstractSocket_SocketOption_Enums (const QAbstractSocket_SocketOption_Enums *e, const QAbstractSocket_SocketOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractSocket_SocketOption_Enums (const QAbstractSocket_SocketOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractSocket::LowDelayOption)) { if (!l.empty ()) l += "|"; l += "LowDelayOption"; }
  if (e->testFlag (QAbstractSocket::KeepAliveOption)) { if (!l.empty ()) l += "|"; l += "KeepAliveOption"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractSocket_SocketOption_Enums (const QAbstractSocket_SocketOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractSocket_SocketOption_Enums (const QAbstractSocket_SocketOption_Enums *e, const QAbstractSocket_SocketOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketOption_Enums> decl_QAbstractSocket_SocketOption_Enums ("QAbstractSocket_QFlags_SocketOption",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractSocket_SocketOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractSocket_SocketOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractSocket_SocketOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractSocket_SocketOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketOption_Enum> decl_QAbstractSocket_SocketOption_Enum (decl_QAbstractSocket_SocketOption_Enums, "QAbstractSocket_SocketOption",
  qt_gsi::mkdefs_QAbstractSocket_SocketOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractSocket_SocketOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractSocket_SocketOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractSocket_SocketOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketOption_Enum_in_parent (qt_gsi::mkdefs_QAbstractSocket_SocketOption ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketOption_Enum_as_child (decl_QAbstractSocket_SocketOption_Enum, "SocketOption");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketState
namespace qt_gsi
{

static QAbstractSocket_SocketState_Enum *c_1_QAbstractSocket_SocketState_Enum () { return new QAbstractSocket_SocketState_Enum (QAbstractSocket::UnconnectedState); }
static QAbstractSocket_SocketState_Enum *c_2_QAbstractSocket_SocketState_Enum () { return new QAbstractSocket_SocketState_Enum (QAbstractSocket::HostLookupState); }
static QAbstractSocket_SocketState_Enum *c_3_QAbstractSocket_SocketState_Enum () { return new QAbstractSocket_SocketState_Enum (QAbstractSocket::ConnectingState); }
static QAbstractSocket_SocketState_Enum *c_4_QAbstractSocket_SocketState_Enum () { return new QAbstractSocket_SocketState_Enum (QAbstractSocket::ConnectedState); }
static QAbstractSocket_SocketState_Enum *c_5_QAbstractSocket_SocketState_Enum () { return new QAbstractSocket_SocketState_Enum (QAbstractSocket::BoundState); }
static QAbstractSocket_SocketState_Enum *c_6_QAbstractSocket_SocketState_Enum () { return new QAbstractSocket_SocketState_Enum (QAbstractSocket::ListeningState); }
static QAbstractSocket_SocketState_Enum *c_7_QAbstractSocket_SocketState_Enum () { return new QAbstractSocket_SocketState_Enum (QAbstractSocket::ClosingState); }

static gsi::Methods mkdefs_QAbstractSocket_SocketState () {
  return
    gsi::constant ("UnconnectedState", &qt_gsi::c_1_QAbstractSocket_SocketState_Enum, "@brief Enum constant QAbstractSocket::UnconnectedState") +
    gsi::constant ("HostLookupState", &qt_gsi::c_2_QAbstractSocket_SocketState_Enum, "@brief Enum constant QAbstractSocket::HostLookupState") +
    gsi::constant ("ConnectingState", &qt_gsi::c_3_QAbstractSocket_SocketState_Enum, "@brief Enum constant QAbstractSocket::ConnectingState") +
    gsi::constant ("ConnectedState", &qt_gsi::c_4_QAbstractSocket_SocketState_Enum, "@brief Enum constant QAbstractSocket::ConnectedState") +
    gsi::constant ("BoundState", &qt_gsi::c_5_QAbstractSocket_SocketState_Enum, "@brief Enum constant QAbstractSocket::BoundState") +
    gsi::constant ("ListeningState", &qt_gsi::c_6_QAbstractSocket_SocketState_Enum, "@brief Enum constant QAbstractSocket::ListeningState") +
    gsi::constant ("ClosingState", &qt_gsi::c_7_QAbstractSocket_SocketState_Enum, "@brief Enum constant QAbstractSocket::ClosingState");
}

static std::string to_s_QAbstractSocket_SocketState_Enum (const QAbstractSocket_SocketState_Enum *e)
{
  if (e->value () == QAbstractSocket::UnconnectedState) { return tl::sprintf ("UnconnectedState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::HostLookupState) { return tl::sprintf ("HostLookupState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ConnectingState) { return tl::sprintf ("ConnectingState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ConnectedState) { return tl::sprintf ("ConnectedState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::BoundState) { return tl::sprintf ("BoundState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ListeningState) { return tl::sprintf ("ListeningState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::ClosingState) { return tl::sprintf ("ClosingState (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractSocket_SocketState_Enum (const QAbstractSocket_SocketState_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractSocket_SocketState_Enum *from_i_QAbstractSocket_SocketState_Enum (unsigned int i)
{
  return new QAbstractSocket_SocketState_Enum ((QAbstractSocket::SocketState) i);
}

static bool equalQAbstractSocket_SocketState_Enum (const QAbstractSocket_SocketState_Enum *e, QAbstractSocket_SocketState_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractSocket_SocketState_Enum (const QAbstractSocket_SocketState_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractSocket_SocketState_Enums oropQAbstractSocket_SocketState_Enums (const QAbstractSocket_SocketState_Enums *e, const QAbstractSocket_SocketState_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractSocket_SocketState_Enums andopQAbstractSocket_SocketState_Enums (const QAbstractSocket_SocketState_Enums *e, const QAbstractSocket_SocketState_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractSocket_SocketState_Enums xoropQAbstractSocket_SocketState_Enums (const QAbstractSocket_SocketState_Enums *e, const QAbstractSocket_SocketState_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractSocket_SocketState_Enums (const QAbstractSocket_SocketState_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractSocket::UnconnectedState)) { if (!l.empty ()) l += "|"; l += "UnconnectedState"; }
  if (e->testFlag (QAbstractSocket::HostLookupState)) { if (!l.empty ()) l += "|"; l += "HostLookupState"; }
  if (e->testFlag (QAbstractSocket::ConnectingState)) { if (!l.empty ()) l += "|"; l += "ConnectingState"; }
  if (e->testFlag (QAbstractSocket::ConnectedState)) { if (!l.empty ()) l += "|"; l += "ConnectedState"; }
  if (e->testFlag (QAbstractSocket::BoundState)) { if (!l.empty ()) l += "|"; l += "BoundState"; }
  if (e->testFlag (QAbstractSocket::ListeningState)) { if (!l.empty ()) l += "|"; l += "ListeningState"; }
  if (e->testFlag (QAbstractSocket::ClosingState)) { if (!l.empty ()) l += "|"; l += "ClosingState"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractSocket_SocketState_Enums (const QAbstractSocket_SocketState_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractSocket_SocketState_Enums (const QAbstractSocket_SocketState_Enums *e, const QAbstractSocket_SocketState_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketState_Enums> decl_QAbstractSocket_SocketState_Enums ("QAbstractSocket_QFlags_SocketState",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractSocket_SocketState_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractSocket_SocketState_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractSocket_SocketState_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketState_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketState_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractSocket_SocketState_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketState> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketState_Enum> decl_QAbstractSocket_SocketState_Enum (decl_QAbstractSocket_SocketState_Enums, "QAbstractSocket_SocketState",
  qt_gsi::mkdefs_QAbstractSocket_SocketState () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketState_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketState_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractSocket_SocketState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractSocket_SocketState_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractSocket_SocketState_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketState enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketState_Enum_in_parent (qt_gsi::mkdefs_QAbstractSocket_SocketState ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketState_Enum_as_child (decl_QAbstractSocket_SocketState_Enum, "SocketState");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketType
namespace qt_gsi
{

static QAbstractSocket_SocketType_Enum *c_1_QAbstractSocket_SocketType_Enum () { return new QAbstractSocket_SocketType_Enum (QAbstractSocket::TcpSocket); }
static QAbstractSocket_SocketType_Enum *c_2_QAbstractSocket_SocketType_Enum () { return new QAbstractSocket_SocketType_Enum (QAbstractSocket::UdpSocket); }
static QAbstractSocket_SocketType_Enum *c_3_QAbstractSocket_SocketType_Enum () { return new QAbstractSocket_SocketType_Enum (QAbstractSocket::UnknownSocketType); }

static gsi::Methods mkdefs_QAbstractSocket_SocketType () {
  return
    gsi::constant ("TcpSocket", &qt_gsi::c_1_QAbstractSocket_SocketType_Enum, "@brief Enum constant QAbstractSocket::TcpSocket") +
    gsi::constant ("UdpSocket", &qt_gsi::c_2_QAbstractSocket_SocketType_Enum, "@brief Enum constant QAbstractSocket::UdpSocket") +
    gsi::constant ("UnknownSocketType", &qt_gsi::c_3_QAbstractSocket_SocketType_Enum, "@brief Enum constant QAbstractSocket::UnknownSocketType");
}

static std::string to_s_QAbstractSocket_SocketType_Enum (const QAbstractSocket_SocketType_Enum *e)
{
  if (e->value () == QAbstractSocket::TcpSocket) { return tl::sprintf ("TcpSocket (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::UdpSocket) { return tl::sprintf ("UdpSocket (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAbstractSocket::UnknownSocketType) { return tl::sprintf ("UnknownSocketType (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAbstractSocket_SocketType_Enum (const QAbstractSocket_SocketType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAbstractSocket_SocketType_Enum *from_i_QAbstractSocket_SocketType_Enum (unsigned int i)
{
  return new QAbstractSocket_SocketType_Enum ((QAbstractSocket::SocketType) i);
}

static bool equalQAbstractSocket_SocketType_Enum (const QAbstractSocket_SocketType_Enum *e, QAbstractSocket_SocketType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAbstractSocket_SocketType_Enum (const QAbstractSocket_SocketType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAbstractSocket_SocketType_Enums oropQAbstractSocket_SocketType_Enums (const QAbstractSocket_SocketType_Enums *e, const QAbstractSocket_SocketType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAbstractSocket_SocketType_Enums andopQAbstractSocket_SocketType_Enums (const QAbstractSocket_SocketType_Enums *e, const QAbstractSocket_SocketType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAbstractSocket_SocketType_Enums xoropQAbstractSocket_SocketType_Enums (const QAbstractSocket_SocketType_Enums *e, const QAbstractSocket_SocketType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAbstractSocket_SocketType_Enums (const QAbstractSocket_SocketType_Enums *e)
{
  std::string l;
  if (e->testFlag (QAbstractSocket::TcpSocket)) { if (!l.empty ()) l += "|"; l += "TcpSocket"; }
  if (e->testFlag (QAbstractSocket::UdpSocket)) { if (!l.empty ()) l += "|"; l += "UdpSocket"; }
  if (e->testFlag (QAbstractSocket::UnknownSocketType)) { if (!l.empty ()) l += "|"; l += "UnknownSocketType"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAbstractSocket_SocketType_Enums (const QAbstractSocket_SocketType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAbstractSocket_SocketType_Enums (const QAbstractSocket_SocketType_Enums *e, const QAbstractSocket_SocketType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketType_Enums> decl_QAbstractSocket_SocketType_Enums ("QAbstractSocket_QFlags_SocketType",
  gsi::method_ext ("|", &qt_gsi::oropQAbstractSocket_SocketType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAbstractSocket_SocketType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAbstractSocket_SocketType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAbstractSocket_SocketType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAbstractSocket_SocketType_Enum> decl_QAbstractSocket_SocketType_Enum (decl_QAbstractSocket_SocketType_Enums, "QAbstractSocket_SocketType",
  qt_gsi::mkdefs_QAbstractSocket_SocketType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAbstractSocket_SocketType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAbstractSocket_SocketType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAbstractSocket_SocketType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAbstractSocket_SocketType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAbstractSocket_SocketType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketType_Enum_in_parent (qt_gsi::mkdefs_QAbstractSocket_SocketType ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketType_Enum_as_child (decl_QAbstractSocket_SocketType_Enum, "SocketType");

}

