# Human theme

This theme works with **GTK 2.24** *(with murrine)* & **GTK 3.24** & **GTK 4.12..4.19**, with or without compositor, with or without CSD windows, and with or without gtk3/4-classic.

It is mainly intended for **MATE** desktop environment, it's not too bad with **Xfce**, it's experimental with **Cinnamon**.

## Screenshots

GTK 2.24 (Pango 1.56)\
[<img alt="Preview with GTK 2 - Main window" src="images/thumbs/gtk2.png?raw=true" width="200" />](images/gtk2.png?raw=true)
[<img alt="Preview with GTK 2 - Orange variation - Main window" src="images/thumbs/gtk2-orange.png?raw=true" width="200" />](images/gtk2-orange.png?raw=true)
[<img alt="Preview with GTK 2 - Blue variation - Main window" src="images/thumbs/gtk2-blue.png?raw=true" width="200" />](images/gtk2-blue.png?raw=true)
[<img alt="Preview with GTK 2 - Green variation - Main window" src="images/thumbs/gtk2-green.png?raw=true" width="200" />](images/gtk2-green.png?raw=true)\
[<img alt="Preview with GTK 2 - Main window with menu" src="images/thumbs/gtk2-menu.png?raw=true" width="200" />](images/gtk2-menu.png?raw=true)
[<img alt="Preview with GTK 2 - Orange variation - Main window with menu" src="images/thumbs/gtk2-orange-menu.png?raw=true" width="200" />](images/gtk2-orange-menu.png?raw=true)
[<img alt="Preview with GTK 2 - Blue variation - Main window with menu" src="images/thumbs/gtk2-blue-menu.png?raw=true" width="200" />](images/gtk2-blue-menu.png?raw=true)
[<img alt="Preview with GTK 2 - Green variation - Main window with menu" src="images/thumbs/gtk2-green-menu.png?raw=true" width="200" />](images/gtk2-green-menu.png?raw=true)

GTK 2.24 RTL (Pango 1.56)\
[<img alt="Preview with GTK 2 - RTL - Main window" src="images/thumbs/gtk2-rtl.png?raw=true" width="200" />](images/gtk2-rtl.png?raw=true)
[<img alt="Preview with GTK 2 - RTL - Orange variation - Main window" src="images/thumbs/gtk2-rtl-orange.png?raw=true" width="200" />](images/gtk2-rtl-orange.png?raw=true)
[<img alt="Preview with GTK 2 - RTL - Blue variation - Main window" src="images/thumbs/gtk2-rtl-blue.png?raw=true" width="200" />](images/gtk2-rtl-blue.png?raw=true)
[<img alt="Preview with GTK 2 - RTL - Green variation - Main window" src="images/thumbs/gtk2-rtl-green.png?raw=true" width="200" />](images/gtk2-rtl-green.png?raw=true)\
[<img alt="Preview with GTK 2 - RTL - Main window with menu" src="images/thumbs/gtk2-rtl-menu.png?raw=true" width="200" />](images/gtk2-rtl-menu.png?raw=true)
[<img alt="Preview with GTK 2 - RTL - Orange variation - Main window with menu" src="images/thumbs/gtk2-rtl-orange-menu.png?raw=true" width="200" />](images/gtk2-rtl-orange-menu.png?raw=true)
[<img alt="Preview with GTK 2 - RTL - Blue variation - Main window with menu" src="images/thumbs/gtk2-rtl-blue-menu.png?raw=true" width="200" />](images/gtk2-rtl-blue-menu.png?raw=true)
[<img alt="Preview with GTK 2 - RTL - Green variation - Main window with menu" src="images/thumbs/gtk2-rtl-green-menu.png?raw=true" width="200" />](images/gtk2-rtl-green-menu.png?raw=true)

GTK 3.24-classic (Pango 1.56)\
[<img alt="Preview with GTK 3 - Main window" src="images/thumbs/gtk3.png?raw=true" width="200" />](images/gtk3.png?raw=true)
[<img alt="Preview with GTK 3 - Orange variation - Main window" src="images/thumbs/gtk3-orange.png?raw=true" width="200" />](images/gtk3-orange.png?raw=true)
[<img alt="Preview with GTK 3 - Blue variation - Main window" src="images/thumbs/gtk3-blue.png?raw=true" width="200" />](images/gtk3-blue.png?raw=true)
[<img alt="Preview with GTK 3 - Green variation - Main window" src="images/thumbs/gtk3-green.png?raw=true" width="200" />](images/gtk3-green.png?raw=true)\
[<img alt="Preview with GTK 3 - Main window with menu" src="images/thumbs/gtk3-menu.png?raw=true" width="200" />](images/gtk3-menu.png?raw=true)
[<img alt="Preview with GTK 3 - Orange variation - Main window with menu" src="images/thumbs/gtk3-orange-menu.png?raw=true" width="200" />](images/gtk3-orange-menu.png?raw=true)
[<img alt="Preview with GTK 3 - Blue variation - Main window with menu" src="images/thumbs/gtk3-blue-menu.png?raw=true" width="200" />](images/gtk3-blue-menu.png?raw=true)
[<img alt="Preview with GTK 3 - Green variation - Main window with menu" src="images/thumbs/gtk3-green-menu.png?raw=true" width="200" />](images/gtk3-green-menu.png?raw=true)\
[<img alt="Preview with GTK 3 - Main window with plus button" src="images/thumbs/gtk3-plus.png?raw=true" width="200" />](images/gtk3-plus.png?raw=true)
[<img alt="Preview with GTK 3 - Orange variation - Main window with plus button" src="images/thumbs/gtk3-orange-plus.png?raw=true" width="200" />](images/gtk3-orange-plus.png?raw=true)
[<img alt="Preview with GTK 3 - Blue variation - Main window with plus button" src="images/thumbs/gtk3-blue-plus.png?raw=true" width="200" />](images/gtk3-blue-plus.png?raw=true)
[<img alt="Preview with GTK 3 - Green variation - Main window with plus button" src="images/thumbs/gtk3-green-plus.png?raw=true" width="200" />](images/gtk3-green-plus.png?raw=true)\
[<img alt="Preview with GTK 3 - CSD main window" src="images/thumbs/gtk3-csd.png?raw=true" width="200" />](images/gtk3-csd.png?raw=true)
[<img alt="Preview with GTK 3 - Orange variation - CSD main window" src="images/thumbs/gtk3-orange-csd.png?raw=true" width="200" />](images/gtk3-orange-plus.png?raw=true)
[<img alt="Preview with GTK 3 - Blue variation - CSD main window" src="images/thumbs/gtk3-blue-csd.png?raw=true" width="200" />](images/gtk3-blue-csd.png?raw=true)
[<img alt="Preview with GTK 3 - Green variation - CSD main window" src="images/thumbs/gtk3-green-csd.png?raw=true" width="200" />](images/gtk3-green-csd.png?raw=true)

GTK 3.24-classic RTL (Pango 1.56)\
[<img alt="Preview with GTK 3 - RTL - Main window" src="images/thumbs/gtk3-rtl.png?raw=true" width="200" />](images/gtk3-rtl.png?raw=true)
[<img alt="Preview with GTK 3 - RTL - Orange variation - Main window" src="images/thumbs/gtk3-rtl-orange.png?raw=true" width="200" />](images/gtk3-rtl-orange.png?raw=true)
[<img alt="Preview with GTK 3 - RTL - Blue variation - Main window" src="images/thumbs/gtk3-rtl-blue.png?raw=true" width="200" />](images/gtk3-rtl-blue.png?raw=true)
[<img alt="Preview with GTK 3 - RTL - Green variation - Main window" src="images/thumbs/gtk3-rtl-green.png?raw=true" width="200" />](images/gtk3-rtl-green.png?raw=true)\
[<img alt="Preview with GTK 3 - RTL - Main window with menu" src="images/thumbs/gtk3-rtl-menu.png?raw=true" width="200" />](images/gtk3-rtl-menu.png?raw=true)
[<img alt="Preview with GTK 3 - RTL - Orange variation - Main window with menu" src="images/thumbs/gtk3-rtl-orange-menu.png?raw=true" width="200" />](images/gtk3-rtl-orange-menu.png?raw=true)
[<img alt="Preview with GTK 3 - RTL - Blue variation - Main window with menu" src="images/thumbs/gtk3-rtl-blue-menu.png?raw=true" width="200" />](images/gtk3-rtl-blue-menu.png?raw=true)
[<img alt="Preview with GTK 3 - RTL - Green variation - Main window with menu" src="images/thumbs/gtk3-rtl-green-menu.png?raw=true" width="200" />](images/gtk3-rtl-green-menu.png?raw=true)

GTK 4.12..4.18-classic (Pango 1.56)\
[<img alt="Preview with GTK 4 - Main window" src="images/thumbs/gtk4.png?raw=true" width="200" />](images/gtk4.png?raw=true)
[<img alt="Preview with GTK 4 - Orange variation - Main window" src="images/thumbs/gtk4-orange.png?raw=true" width="200" />](images/gtk4-orange.png?raw=true)
[<img alt="Preview with GTK 4 - Blue variation - Main window" src="images/thumbs/gtk4-blue.png?raw=true" width="200" />](images/gtk4-blue.png?raw=true)
[<img alt="Preview with GTK 4 - Green variation - Main window" src="images/thumbs/gtk4-green.png?raw=true" width="200" />](images/gtk4-green.png?raw=true)\
[<img alt="Preview with GTK 4 - Main window with menu" src="images/thumbs/gtk4-menu.png?raw=true" width="200" />](images/gtk4-menu.png?raw=true)
[<img alt="Preview with GTK 4 - Orange variation - Main window with menu" src="images/thumbs/gtk4-orange-menu.png?raw=true" width="200" />](images/gtk4-orange-menu.png?raw=true)
[<img alt="Preview with GTK 4 - Blue variation - Main window with menu" src="images/thumbs/gtk4-blue-menu.png?raw=true" width="200" />](images/gtk4-blue-menu.png?raw=true)
[<img alt="Preview with GTK 4 - Green variation - Main window with menu" src="images/thumbs/gtk4-green-menu.png?raw=true" width="200" />](images/gtk4-green-menu.png?raw=true)

GTK 4.12..4.18-classic RTL (Pango 1.56)\
[<img alt="Preview with GTK 4 - RTL - Main window" src="images/thumbs/gtk4-rtl.png?raw=true" width="200" />](images/gtk4-rtl.png?raw=true)
[<img alt="Preview with GTK 4 - RTL - Orange variation - Main window" src="images/thumbs/gtk4-rtl-orange.png?raw=true" width="200" />](images/gtk4-rtl-orange.png?raw=true)
[<img alt="Preview with GTK 4 - RTL - Blue variation - Main window" src="images/thumbs/gtk4-rtl-blue.png?raw=true" width="200" />](images/gtk4-rtl-blue.png?raw=true)
[<img alt="Preview with GTK 4 - RTL - Green variation - Main window" src="images/thumbs/gtk4-rtl-green.png?raw=true" width="200" />](images/gtk4-rtl-green.png?raw=true)\
[<img alt="Preview with GTK 4 - RTL - Main window with menu" src="images/thumbs/gtk4-rtl-menu.png?raw=true" width="200" />](images/gtk4-rtl-menu.png?raw=true)
[<img alt="Preview with GTK 4 - RTL - Orange variation - Main window with menu" src="images/thumbs/gtk4-rtl-orange-menu.png?raw=true" width="200" />](images/gtk4-rtl-orange-menu.png?raw=true)
[<img alt="Preview with GTK 4 - RTL - Blue variation - Main window with menu" src="images/thumbs/gtk4-rtl-blue-menu.png?raw=true" width="200" />](images/gtk4-rtl-blue-menu.png?raw=true)
[<img alt="Preview with GTK 4 - RTL - Green variation - Main window with menu" src="images/thumbs/gtk4-rtl-green-menu.png?raw=true" width="200" />](images/gtk4-rtl-green-menu.png?raw=true)

GTK 5.0 (Pango 1.56)\
_GtkWindow will likely be deprecated... lol_

Program used for the screenshots is available [here](https://github.com/luigifab/awf-extended).

## Installation

For MATE, the following packages no longer install the *metacity/marco* theme (ClearlooksRe), because it is provided by *marco* package.

#### Before you begin

To meet the truth (not required, if you can't/won't, no worries, but the truth will be far):
- remove [gtk3-nocsd](https://github.com/PCMan/gtk3-nocsd)
- install gtk3-classic & gtk4-classic
- use Pango 1.42- or 1.51+

For **Debian Testing**, I provide a repository for [gtk3-classic](https://build.opensuse.org/package/show/home:luigifab/gtk3-classic) and for [gtk4-classic](https://build.opensuse.org/package/show/home:luigifab/gtk4-classic), it also includes [mate-settings-daemon 1.26](https://build.opensuse.org/package/show/home:luigifab/mate-notification) with a patch to customize notifications from theme.

For **Ubuntu**, I also provide a repository for [gtk3-classic & gtk4-classic](https://launchpad.net/~luigifab/+archive/ubuntu/gtk-classic).

#### Installation for Debian, Devuan, Ubuntu, Trisquel, Linux Mint, MX Linux

* Run: `sudo apt install human-theme-gtk`
* Restart your session

#### Installation for Fedora, OpenMandriva

* Run: `sudo dnf install human-theme-gtk`
* Restart your session

#### Installation for openSUSE

* Run: `sudo zypper install human-theme-gtk`
* Restart your session

#### Installation for Mageia

* Run: `sudo urpmi human-theme-gtk`
* Restart your session

#### Alternative installation for Debian, Devuan, Ubuntu, Trisquel, Linux Mint, MX Linux

* Run:
```bash
# PPA: https://launchpad.net/~luigifab/+archive/ubuntu/packages
# with Debian 12+/Bookworm+ you can use mantic+ instead of focal (https://unix.stackexchange.com/a/669008/364800)
# for Debian you can use focal for buster, jammy for bullseye, oracular or noble for bookworm, questing or plucky for trixie
# for Devuan you can use focal for beowulf, jammy for chimaera, oracular or noble for daedalus, questing or plucky for excalibur and ceres
# for Trisquel you can use focal for nabia, jammy for aramo
# for Linux Mint you can use focal for 20.x and 4/debbie, jammy for 21.x and 5/elsie, noble for 22.x and 6/faye, questing or plucky for 7/gigi
# for MX Linux you can use focal for 19.x, jammy for 21.x, oracular or noble for 23.x
# for Kali Linux you can use questing or plucky

sudo add-apt-repository ppa:luigifab/packages
sudo apt update
sudo apt install human-theme-gtk
# or
sudo apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv-keys FFE5BD439356DF7D
echo "deb http://ppa.launchpad.net/luigifab/packages/ubuntu focal main" | sudo tee -a /etc/apt/sources.list
sudo apt update
sudo apt install human-theme-gtk
# or
sudo wget -O /etc/apt/trusted.gpg.d/luigifab.gpg https://www.luigifab.fr/apt.gpg
echo "deb http://ppa.launchpad.net/luigifab/packages/ubuntu focal main" | sudo tee -a /etc/apt/sources.list
sudo apt update
sudo apt install human-theme-gtk
# or
wget -qO - https://www.luigifab.fr/apt.gpg | sudo gpg --dearmor -o /etc/apt/trusted.gpg.d/luigifab.gpg
echo "deb http://ppa.launchpad.net/luigifab/packages/ubuntu focal main" | sudo tee -a /etc/apt/sources.list
sudo apt update
sudo apt install human-theme-gtk

# sha256sum /etc/apt/trusted.gpg.d/luigifab.gpg
578c89a677048e38007462d543686b53587efba9f93814601169253c45ff9213
# apt-key list
/etc/apt/trusted.gpg.d/luigifab.gpg
pub   rsa4096 2020-10-31 [SC]
      458B 0C46 D024 FD8C B8BC  99CD FFE5 BD43 9356 DF7D
```
* Restart your session

#### Manual installation

* Download the archive and extract its subdirectories into `~/.themes/`
* Configure font rendering, GTK and Qt settings, by adding the following to `/etc/environment` ([details](data/profile.sh)):
```
FREETYPE_PROPERTIES="truetype:interpreter-version=35"
QT_QPA_PLATFORMTHEME=gtk2
GTK_OVERLAY_SCROLLING=0
GTK_BACKDROP=1
GTKM_INSERT_EMOJI=1
GTK_USE_IEC_UNITS=1
GTK_FOCUS_VISIBLE=1
GTK_PROGRESS_TEXT_INSIDE=1
GTK_TREEVIEW_LINES=0
GTK_ENLARGE_SCROLLBAR=1
```
* Install the icons and cursors themes: `gnome-icon-theme` or `mate-icon-theme` + `dmz-cursor-theme`
* Install package for GTK 2 apps: `gtk2-engines-murrine` or `gtk2-engine-murrine` or `gtk2-murrine-engine` or `gtk-engine-murrine` or `gtk-murrine-engine` or `murrine` or similar
* Install package for Qt 5 apps: `qt5-gtk2-platformtheme` + `qt5-gtk-platformtheme` or similar
* Install package for Qt 6 apps: `qt6-gtk-platformtheme` or similar
* Restart your session

## Configuration

For **MATE** desktop:
* Go to: *System / Preferences / Appearance*, or run: `mate-appearance-properties`\
  Then select the *Human* theme and update fonts.
* Go to: *System / Preferences / Windows*, or run: `mate-window-properties`\
  Then disable software compositing from last tab (or enable it, as you want).
* Go to: *System / Preferences / Notifications*, or run: `mate-notification-properties`\
  Then select the *Coco* or *Default* theme.
* Go to: *panel preferences*\
  Then set panel height to 23px.

For **Xfce** desktop:
* Go to: *Applications / Settings / Appearance*, or run: `xfce4-appearance-settings`\
  Then select the *Human* theme and update fonts.
* Go to: *Applications / Settings / Window Manager*, or run: `xfwm4-settings`\
  Then select the *Human* theme and update fonts.
* Go to: *Applications / Settings / Window Manager Tweaks*, or run: `xfwm4-tweaks-settings`\
  Then disable software compositing from last tab (or enable it, as you want).
* Go to: *Applications / Settings / Mouse and Touchpad*, or run: `xfce4-mouse-settings`\
  Then select the *DMZ White* theme from last tab.
* Go to: *panel preferences*\
  Then set panel height to 22px, panel icons sizes to 16px or automatic.

For **Cinnamon** desktop:
* Go to: *Menu / Preferences / Themes*, or run: `cinnamon-settings themes`\
  Click on *Advanced settings*\
  Then select the *Human* theme for applications and desktop.\
  And select the *DMZ White* theme for mouse.
* Go to: *Menu / Preferences / Fonts*, or run: `cinnamon-settings fonts`\
  Then update fonts.
* Go to: *main menu preferences* and *panel preferences*\
  Then set panel height to 25px/23px, panel icons sizes to 16px, menu icons sizes to 22px 22px 32px.

Fonts:
* *DejaVu Sans Book*, 10
* *DejaVu Sans Bold*, 10
* *DejaVu Sans Mono Book*, 10
* *Best shapes* or *Medium hinting* for fonts rendering (anti-aliasing)

Icons:
* *gnome* or *mate*

Cursors:
* *DMZ white*, 24

Desktop panels:
* 23px for panel height, 16px or automatic for icons size

Extra configuration for cursors:
* Run `sudo update-alternatives --config x-cursor-theme` and select again *DMZ white*

## Known issues

#### Firefox/Thunderbird/Chromium

If font rendering is bad, try this:
```bash
cd /etc/fonts/conf.d/
sudo rm 10-hinting-slight.conf # /usr/share/fontconfig/conf.avail/10-hinting-slight.conf
sudo ln -s /usr/share/fontconfig/conf.avail/10-hinting-full.conf
```

For classic menu bar and menu items on [Firefox 46+](https://www.mozilla.org/firefox) and [Thunderbird 46+](https://www.mozilla.org/thunderbird), see [bug 1622545](https://bugzilla.mozilla.org/show_bug.cgi?id=1622545).

#### GTK 4

If font rendering is bad, try to add in `~/.config/gtk-4.0/settings.ini`:
```
[Settings]
gtk-font-rendering=manual
gtk-hint-font-metrics=1
gtk-xft-hintstyle=hintfull
gtk-xft-antialias=0
gtk-xft-hinting=1
```

#### Xfce panels

Unfortunately, the border cannot be removed, see [forum](https://forum.xfce.org/viewtopic.php?id=15112).

When a window is maximized, window bottom border color is wrong and there is an offset of 1px.

#### Windows shadow

With window compositor, the window/dialog/menu shadow can't be removed or configured.

## Customize

Use `~/.config/gtk-3.0/gtk.css` and `~/.config/gtk-4.0/gtk.css` files.

## Dev

To restore notifications from `nm-applet`, run:
```bash
gsettings reset org.gnome.nm-applet disable-connected-notifications
gsettings reset org.gnome.nm-applet disable-disconnected-notifications
gsettings reset org.gnome.nm-applet disable-vpn-notifications
gsettings reset org.gnome.nm-applet disable-wifi-create
gsettings reset org.gnome.nm-applet suppress-wireless-networks-available
gsettings reset org.gnome.nm-applet show-applet
```

To enable [GtkInspector](https://developer.gnome.org/documentation/tools/inspector.html) via `Ctrl+Shift+I` / `Ctrl+Shift+D`, run:
```bash
gsettings set org.gtk.Settings.Debug enable-inspector-keybinding true
gsettings set org.gtk.gtk4.Settings.Debug enable-inspector-keybinding true
```

Run [AWF](https://github.com/luigifab/awf-extended) with screenshot on theme reload:
```bash
awf-gtk2 -s ~/2.png
awf-gtk3 -s ~/3.png
awf-gtk4 -s ~/4.png
```

Run [Entr](https://github.com/eradman/entr) to send `SIGHUP` signal when files change to reload theme:
```bash
ls ~/.themes/human-theme*/gtk-2*/gtkrc | entr killall -s SIGHUP awf-gtk2
ls ~/.themes/human-theme*/gtk-3*/*.css | entr killall -s SIGHUP awf-gtk3
ls ~/.themes/human-theme*/gtk-4*/*.css | entr killall -s SIGHUP awf-gtk4
```

Run [ImageTragick](https://imagemagick.org/) to create the diff image:
```bash
killall -q eom
rm -f dif.png
compare -fuzz 1% -compose src -highlight-color blue -lowlight-color none 2.png 3.png dif.png
composite dif.png 2.png dif.png
eom dif.png &
```

Run `svg.sh` and `cinnamon.sh` to update colors. See also [technical informations](https://github.com/mk-fg/clearlooks-phenix-humanity). For any issue and pull request, please add before/after screenshots.

## Copyright

- Current version: 2.5.0 (06/06/2025)
- Compatibility: GTK 2.24 / 3.24 / 4.12..4.19
- Links: [luigifab.fr](https://www.luigifab.fr/gtk/human-theme) - [github.com](https://github.com/luigifab/human-theme) - [mate-look.org](https://www.mate-look.org/p/1376363/) - [xfce-look.org](https://www.xfce-look.org/p/1376363/) - [ppa/dpa](https://launchpad.net/~luigifab/+archive/ubuntu/packages)

This theme is provided under the terms of the **GNU GPLv3+** license.\
If you like, take some of your time to improve some translations, go to https://bit.ly/2HyCCEc.

## Packages in official distros repositories

[![Packages status](https://repology.org/badge/vertical-allrepos/human-theme-gtk.svg?header=human-theme-gtk)](https://repology.org/project/human-theme-gtk/versions)

## Credits

GTK 2 theme *(CC-BY-SA-3.0+)*
- Created by Kenneth Wimer and Conn O'Griofa (see [human-theme](https://packages.ubuntu.com/search?keywords=human-theme) Ubuntu package)

GTK 3 theme *(GNU GPLv3+)*
- Forked from [Clearlooks-Phénix](https://github.com/mk-fg/clearlooks-phenix) by Mike Kazantsev (mk-fg)
- Forked from [Clearlooks-Phénix](https://github.com/jpfleury/clearlooks-phenix) by Jean-Philippe Fleury (jpfleury) and Andrew Shadura

Metacity theme *(Clearlooks, GNU LGPLv2.1+)*
- Created by Daniel Borgmann and Andrea Cimitan
