#
# This is the insanely huge list of completions for gcc. Most of it is autogenerated, but it needs some hand editing...
#

#
# These are 'special' completions, ones that take some kind of parameter.
#

complete -c gcc -o std --description "Standard mode" -x -a '
	c89\t"ISO C90"
	iso9899:1990\t"ISO C90"
	iso9899:199409\t"ISO C90 as modified in amendment 1"
	c99\t"ISO C99"
	c9x \t"ISO C99"
	iso9899:1999\t"ISO C99"
	iso9899:199x\t"ISO C99"
	gnu89\t"ISO C90 plus GNU extentions"
	gnu99\t"ISO C99 plus GNU extentions"
	gnu9x\t"ISO C99 plus GNU extentions"
	c++98\t"ISO C++98"
	gnu++98\t"ISO C++98 plus GNU extentions"
'

for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17;
	complete -c gcc -o ftemplate-depth-$i --description "Set maximum template depth"
end;

complete -c gcc -s o --description 'Place output in file' -r
complete -c gcc -o aux-info --description 'Output to the given filename prototyped declarations for all functions declared and/or defined in a translation unit, including those in header files' -r
complete -c gcc -o fabi-version --description 'Use specified version of the C++ ABI' -xa "0 1"
complete -c gcc -l sysroot -x -a '(__fish_complete_directories)' --description 'Use dir as the logical root directory for headers and libraries'


#
# These completions are autogenerated form the manual page using make_completions.py
#

complete -c gcc -s x --description 'Specify explicitly the language for the following input files (rather than letting the compiler choose a default based on the file name suffix)'
complete -c gcc -s x --description 'Turn off any specification of a language, so that subsequent files are handled according to their file name suffixes (as they are if -x has not been used at all)'
complete -c gcc -o pass-exit-codes --description 'Normally the gcc program will exit with the code of 1 if any phase of the compiler returns a non-success return code'
complete -c gcc -s c --description 'Compile or assemble the source files, but do not link'
complete -c gcc -s S --description 'Stop after the stage of compilation proper; do not assemble'
complete -c gcc -s E --description 'Stop after the preprocessing stage; do not run the compiler proper'
complete -c gcc -s v --description 'Print (on standard error output) the commands executed to run the stages of compilation'
complete -c gcc -o \#\#\# --description 'Like -v except the commands are not executed and all command arguments are quoted'
complete -c gcc -o pipe --description 'Use pipes rather than temporary files for communication between the various stages of compilation'
complete -c gcc -o combine --description 'If you are compiling multiple source files, this option tells the driver to pass all the source files to the compiler at once (for those languages for which the compiler can handle this)'
complete -c gcc -l help --description 'Print (on the standard output) a description of the command line options understood by gcc'
complete -c gcc -l target-help --description 'Print (on the standard output) a description of target specific command line options for each tool'
complete -c gcc -l version --description 'Display the version number and copyrights of the invoked GCC'
complete -c gcc -o ansi --description 'In C mode, support all ISO C90 programs'
complete -c gcc -o fno-asm --description 'Do not recognize "asm", "inline" or "typeof" as a keyword, so that code can use these words as identifiers'
complete -c gcc -o fno-builtin --description 'Don’t recognize built-in functions that do not begin with __builtin_ as prefix'
complete -c gcc -o fno-builtin-function --description 'Don’t recognize built-in functions that do not begin with __builtin_ as prefix'
complete -c gcc -o fhosted --description 'Assert that compilation takes place in a hosted environment'
complete -c gcc -o ffreestanding --description 'Assert that compilation takes place in a freestanding environment'
complete -c gcc -o fms-extensions --description 'Accept some non-standard constructs used in Microsoft header files'
complete -c gcc -o trigraphs --description 'Support ISO C trigraphs'
complete -c gcc -o no-integrated-cpp --description 'Performs a compilation in two passes: preprocessing and compiling'
complete -c gcc -o traditional --description 'Formerly, these options caused GCC to attempt to emulate a prestandard C compiler'
complete -c gcc -o traditional-cpp --description 'Formerly, these options caused GCC to attempt to emulate a prestandard C compiler'
complete -c gcc -o fcond-mismatch --description 'Allow conditional expressions with mismatched types in the second and third arguments'
complete -c gcc -o funsigned-char --description 'Let the type "char" be unsigned, like "unsigned char"'
complete -c gcc -o fsigned-char --description 'Let the type "char" be signed, like "signed char"'
complete -c gcc -o fsigned-bitfields --description 'These options control whether a bit-field is signed or unsigned, when the declaration does not use either "signed" or "unsigned"'
complete -c gcc -o funsigned-bitfields --description 'These options control whether a bit-field is signed or unsigned, when the declaration does not use either "signed" or "unsigned"'
complete -c gcc -o fno-signed-bitfields --description 'These options control whether a bit-field is signed or unsigned, when the declaration does not use either "signed" or "unsigned"'
complete -c gcc -o fno-unsigned-bitfields --description 'These options control whether a bit-field is signed or unsigned, when the declaration does not use either "signed" or "unsigned"'
complete -c gcc -o fno-access-control --description 'Turn off all access checking'
complete -c gcc -o fcheck-new --description 'Check that the pointer returned by "operator new" is non-null before attempting to modify the storage allocated'
complete -c gcc -o fconserve-space --description 'Put uninitialized or runtime-initialized global variables into the common segment, as C does'
complete -c gcc -o ffriend-injection --description 'Inject friend functions into the enclosing namespace, so that they are visible outside the scope of the class in which they are declared'
complete -c gcc -o fno-const-strings --description 'Give string constants type "char *" instead of type "const char *"'
complete -c gcc -o fno-elide-constructors --description 'The C++ standard allows an implementation to omit creating a temporary which is only used to initialize another object of the same type'
complete -c gcc -o fno-enforce-eh-specs --description 'Don’t generate code to check for violation of exception specifications at runtime'
complete -c gcc -o ffor-scope --description 'If -ffor-scope is specified, the scope of variables declared in a for-init-statement is limited to the for loop itself, as specified by the C++ standard'
complete -c gcc -o fno-for-scope --description 'If -ffor-scope is specified, the scope of variables declared in a for-init-statement is limited to the for loop itself, as specified by the C++ standard'
complete -c gcc -o fno-gnu-keywords --description 'Do not recognize "typeof" as a keyword, so that code can use this word as an identifier'
complete -c gcc -o fno-implicit-templates --description 'Never emit code for non-inline templates which are instantiated implicitly (i'
complete -c gcc -o fno-implicit-inline-templates --description 'Don’t emit code for implicit instantiations of inline templates, either'
complete -c gcc -o fno-implement-inlines --description 'To save space, do not emit out-of-line copies of inline functions controlled by #pragma implementation'
complete -c gcc -o fms-extensions --description 'Disable pedantic warnings about constructs used in MFC, such as implicit int and getting a pointer to member function via non-standard syntax'
complete -c gcc -o fno-nonansi-builtins --description 'Disable built-in declarations of functions that are not mandated by ANSI/ISO C'
complete -c gcc -o fno-operator-names --description 'Do not treat the operator name keywords "and", "bitand", "bitor", "compl", "not", "or" and "xor" as synonyms as keywords'
complete -c gcc -o fno-optional-diags --description 'Disable diagnostics that the standard says a compiler does not need to issue'
complete -c gcc -o fpermissive --description 'Downgrade some diagnostics about nonconformant code from errors to warnings'
complete -c gcc -o frepo --description 'Enable automatic template instantiation at link time'
complete -c gcc -o fno-rtti --description 'Disable generation of information about every class with virtual functions for use by the C++ runtime type identification features (dynamic_cast and typeid)'
complete -c gcc -o fstats --description 'Emit statistics about front-end processing at the end of the compilation'
complete -c gcc -o fno-threadsafe-statics --description 'Do not emit the extra code to use the routines specified in the C++ ABI for thread-safe initialization of local statics'
complete -c gcc -o fuse-cxa-atexit --description 'Register destructors for objects with static storage duration with the "__cxa_atexit" function rather than the "atexit" function'
complete -c gcc -o fvisibility-inlines-hidden --description 'Causes all inlined methods to be marked with "__attribute__ ((visibility ("hidden")))" so that they do not appear in the export table of a DSO and do not require a PLT indirection when used within the DSO'
complete -c gcc -o fno-weak --description 'Do not use weak symbol support, even if it is provided by the linker'
complete -c gcc -o nostdinc++ --description 'Do not search for header files in the standard directories specific to C++, but do still search the other standard directories'
complete -c gcc -o fno-default-inline --description 'Do not assume inline for functions defined inside a class scope'
complete -c gcc -o Wabi --description '(C++ only) Warn when G++ generates code that is probably not compatible with the vendor-neutral C++ ABI'
complete -c gcc -o Wctor-dtor-privacy --description '(C++ only) Warn when a class seems unusable because all the constructors or destructors in that class are private, and it has neither friends nor public static member functions'
complete -c gcc -o Wnon-virtual-dtor --description '(C++ only) Warn when a class appears to be polymorphic, thereby requiring a virtual destructor, yet it declares a non-virtual one'
complete -c gcc -o Wreorder --description '(C++ only) Warn when the order of member initializers given in the code does not match the order in which they must be executed'
complete -c gcc -o Weffc++ --description '(C++ only) Warn about violations of the following style guidelines from Scott Meyers’ Effective C++ book: * Item 11: Define a copy constructor and an assignment operator for classes with dynamically allocated memory'
complete -c gcc -o Wno-deprecated --description '(C++ only) Do not warn about usage of deprecated features'
complete -c gcc -o Wstrict-null-sentinel --description '(C++ only) Warn also about the use of an uncasted "NULL" as sentinel'
complete -c gcc -o Wno-non-template-friend --description '(C++ only) Disable warnings when non-templatized friend functions are declared within a template'
complete -c gcc -o Wold-style-cast --description '(C++ only) Warn if an old-style (C-style) cast to a non-void type is used within a C++ program'
complete -c gcc -o Woverloaded-virtual --description '(C++ only) Warn when a function declaration hides virtual functions from a base class'
complete -c gcc -o Wno-pmf-conversions --description '(C++ only) Disable the diagnostic for converting a bound pointer to member function to a plain pointer'
complete -c gcc -o Wsign-promo --description '(C++ only) Warn when overload resolution chooses a promotion from unsigned or enumerated type to a signed type, over a conversion to an unsigned type of the same size'
complete -c gcc -o fconstant-string-class --description 'Use class-name as the name of the class to instantiate for each literal string specified with the syntax "@"'
complete -c gcc -o name --description 'Use class-name as the name of the class to instantiate for each literal string specified with the syntax "@"'
complete -c gcc -o fgnu-runtime --description 'Generate object code compatible with the standard GNU Objective-C runtime'
complete -c gcc -o fnext-runtime --description 'Generate output compatible with the NeXT runtime'
complete -c gcc -o fno-nil-receivers --description 'Assume that all Objective-C message dispatches (e'
complete -c gcc -o fobjc-call-cxx-cdtors --description 'For each Objective-C class, check if any of its instance variables is a C++ object with a non-trivial default constructor'
complete -c gcc -o fobjc-direct-dispatch --description 'Allow fast jumps to the message dispatcher'
complete -c gcc -o fobjc-exceptions --description 'Enable syntactic support for structured exception handling in Objective-C, similar to what is offered by C++ and Java'
complete -c gcc -o fobjc-gc --description 'Enable garbage collection (GC) in Objective-C and Objective-C++ programs'
complete -c gcc -o freplace-objc-classes --description 'Emit a special marker instructing ld(1) not to statically link in the resulting object file, and allow dyld(1) to load it in at run time instead'
complete -c gcc -o fzero-link --description 'When compiling for the NeXT runtime, the compiler ordinarily replaces calls to "objc_getClass("'
complete -c gcc -o gen-decls --description 'Dump interface declarations for all classes seen in the source file to a file named sourcename'
complete -c gcc -o Wassign-intercept --description 'Warn whenever an Objective-C assignment is being intercepted by the garbage collector'
complete -c gcc -o Wno-protocol --description 'If a class is declared to implement a protocol, a warning is issued for every method in the protocol that is not implemented by the class'
complete -c gcc -o Wselector --description 'Warn if multiple methods of different types for the same selector are found during compilation'
complete -c gcc -o Wstrict-selector-match --description 'Warn if multiple methods with differing argument and/or return types are found for a given selector when attempting to send a message using this selector to a receiver of type "id" or "Class"'
complete -c gcc -o Wundeclared-selector --description 'Warn if a "@selector('
complete -c gcc -o print-objc-runtime-info --description 'Generate C header describing the largest structure that is passed by value, if any'
complete -c gcc -o fmessage-length --description 'Try to format error messages so that they fit on lines of the specified number of characters' -x -a "80"
complete -c gcc -o fdiagnostics-show-location --description 'Only meaningful in line-wrapping mode' -a "once"
complete -c gcc -o line --description 'Only meaningful in line-wrapping mode'
complete -c gcc -o fdiagnostics-show-options --description 'This option instructs the diagnostic machinery to add text to each diagnostic emitted, which indicates which command line option directly controls that diagnostic, when such an option is known to the diagnostic machinery'
complete -c gcc -o Wno- --description 'to turn off warnings; for example, -Wno-implicit'
complete -c gcc -o fsyntax-only --description 'Check the code for syntax errors, but don’t do anything beyond that'
complete -c gcc -o pedantic --description 'Issue all the warnings demanded by strict ISO C and ISO C++; reject all programs that use forbidden extensions, and some other programs that do not follow ISO C and ISO C++'
complete -c gcc -o pedantic-errors --description 'Like -pedantic, except that errors are produced rather than warnings'
complete -c gcc -s w --description 'Inhibit all warning messages'
complete -c gcc -o Wno-import --description 'Inhibit warning messages about the use of #import'
complete -c gcc -o Wchar-subscripts --description 'Warn if an array subscript has type "char"'
complete -c gcc -o Wcomment --description 'Warn whenever a comment-start sequence /* appears in a /* comment, or whenever a Backslash-Newline appears in a // comment'
complete -c gcc -o Wfatal-errors --description 'This option causes the compiler to abort compilation on the first error occurred rather than trying to keep going and printing further error messages'
complete -c gcc -o Wformat --description 'Check calls to "printf" and "scanf", etc'
complete -c gcc -o Wformat-y2k --description 'If -Wformat is specified, also warn about "strftime" formats which may yield only a two-digit year'
complete -c gcc -o Wno-format-extra-args --description 'If -Wformat is specified, do not warn about excess arguments to a "printf" or "scanf" format function'
complete -c gcc -o Wno-format-zero-length --description 'If -Wformat is specified, do not warn about zero-length formats'
complete -c gcc -o Wformat-nonliteral --description 'If -Wformat is specified, also warn if the format string is not a string literal and so cannot be checked, unless the format function takes its format arguments as a "va_list"'
complete -c gcc -o Wformat-security --description 'If -Wformat is specified, also warn about uses of format functions that represent possible security problems'
complete -c gcc -o Wnonnull --description 'Warn about passing a null pointer for arguments marked as requiring a non-null value by the "nonnull" function attribute'
complete -c gcc -o Winit-self --description '(C, C++, Objective-C and Objective-C++ only) Warn about uninitialized variables which are initialized with themselves'
complete -c gcc -o Wimplicit-int --description 'Warn when a declaration does not specify a type'
complete -c gcc -o Wimplicit-function-declaration --description 'Give a warning (or error) whenever a function is used before being declared'
complete -c gcc -o Werror-implicit-function-declaration --description 'Give a warning (or error) whenever a function is used before being declared'
complete -c gcc -o Wimplicit --description 'Same as -Wimplicit-int and -Wimplicit-function-declaration'
complete -c gcc -o Wmain --description 'Warn if the type of main is suspicious'
complete -c gcc -o Wmissing-braces --description 'Warn if an aggregate or union initializer is not fully bracketed'
complete -c gcc -o Wmissing-include-dirs --description '(C, C++, Objective-C and Objective-C++ only) Warn if a user-supplied include directory does not exist'
complete -c gcc -o Wparentheses --description 'Warn if parentheses are omitted in certain contexts, such as when there is an assignment in a context where a truth value is expected, or when operators are nested whose precedence people often get confused about'
complete -c gcc -o Wsequence-point --description 'Warn about code that may have undefined semantics because of violations of sequence point rules in the C standard'
complete -c gcc -o Wreturn-type --description 'Warn whenever a function is defined with a return-type that defaults to "int"'
complete -c gcc -o Wswitch --description 'Warn whenever a "switch" statement has an index of enumerated type and lacks a "case" for one or more of the named codes of that enumeration'
complete -c gcc -o Wswitch-default --description 'Warn whenever a "switch" statement does not have a "default" case'
complete -c gcc -o Wswitch-enum --description 'Warn whenever a "switch" statement has an index of enumerated type and lacks a "case" for one or more of the named codes of that enumeration'
complete -c gcc -o Wtrigraphs --description 'Warn if any trigraphs are encountered that might change the meaning of the program (trigraphs within comments are not warned about)'
complete -c gcc -o Wunused-function --description 'Warn whenever a static function is declared but not defined or a non-inline static function is unused'
complete -c gcc -o Wunused-label --description 'Warn whenever a label is declared but not used'
complete -c gcc -o Wunused-parameter --description 'Warn whenever a function parameter is unused aside from its declaration'
complete -c gcc -o Wunused-variable --description 'Warn whenever a local variable or non-constant static variable is unused aside from its declaration'
complete -c gcc -o Wunused-value --description 'Warn whenever a statement computes a result that is explicitly not used'
complete -c gcc -o Wunused --description 'All the above -Wunused options combined'
complete -c gcc -o Wuninitialized --description 'Warn if an automatic variable is used without first being initialized or if a variable may be clobbered by a "setjmp" call'
complete -c gcc -o Wunknown-pragmas --description 'Warn when a #pragma directive is encountered which is not understood by GCC'
complete -c gcc -o Wno-pragmas --description 'Do not warn about misuses of pragmas, such as incorrect parameters, invalid syntax, or conflicts between pragmas'
complete -c gcc -o Wstrict-aliasing --description 'This option is only active when -fstrict-aliasing is active' -a "2"
complete -c gcc -o Wall --description 'All of the above -W options combined'
complete -c gcc -o Wextra --description '(This option used to be called -W'
complete -c gcc -o Wno-div-by-zero --description 'Do not warn about compile-time integer division by zero'
complete -c gcc -o Wsystem-headers --description 'Print warning messages for constructs found in system header files'
complete -c gcc -o Wfloat-equal --description 'Warn if floating point values are used in equality comparisons'
complete -c gcc -o Wtraditional --description '(C only) Warn about certain constructs that behave differently in traditional and ISO C'
complete -c gcc -o Wdeclaration-after-statement --description '(C only) Warn when a declaration is found after a statement in a block'
complete -c gcc -o Wundef --description 'Warn if an undefined identifier is evaluated in an #if directive'
complete -c gcc -o Wno-endif-labels --description 'Do not warn whenever an #else or an #endif are followed by text'
complete -c gcc -o Wshadow --description 'Warn whenever a local variable shadows another local variable, parameter or global variable or whenever a built-in function is shadowed'
complete -c gcc -o Wlarger-than-len --description 'Warn whenever an object of larger than len bytes is defined'
complete -c gcc -o Wunsafe-loop-optimizations --description 'Warn if the loop cannot be optimized because the compiler could not assume anything on the bounds of the loop indices'
complete -c gcc -o Wpointer-arith --description 'Warn about anything that depends on the "size of" a function type or of "void"'
complete -c gcc -o Wbad-function-cast --description '(C only) Warn whenever a function call is cast to a non-matching type'
complete -c gcc -o Wc++-compat --description 'Warn about ISO C constructs that are outside of the common subset of ISO C and ISO C++, e'
complete -c gcc -o Wcast-qual --description 'Warn whenever a pointer is cast so as to remove a type qualifier from the target type'
complete -c gcc -o Wcast-align --description 'Warn whenever a pointer is cast such that the required alignment of the target is increased'
complete -c gcc -o Wwrite-strings --description 'When compiling C, give string constants the type "const char[length]" so that copying the address of one into a non-"const" "char *" pointer will get a warning; when compiling C++, warn about the deprecated conversion from string constants to "char *"'
complete -c gcc -o Wconversion --description 'Warn if a prototype causes a type conversion that is different from what would happen to the same argument in the absence of a prototype'
complete -c gcc -o Wsign-compare --description 'Warn when a comparison between signed and unsigned values could produce an incorrect result when the signed value is converted to unsigned'
complete -c gcc -o Waggregate-return --description 'Warn if any functions that return structures or unions are defined or called'
complete -c gcc -o Wno-attributes --description 'Do not warn if an unexpected "__attribute__" is used, such as unrecognized attributes, function attributes applied to variables, etc'
complete -c gcc -o Wstrict-prototypes --description '(C only) Warn if a function is declared or defined without specifying the argument types'
complete -c gcc -o Wold-style-definition --description '(C only) Warn if an old-style function definition is used'
complete -c gcc -o Wmissing-prototypes --description '(C only) Warn if a global function is defined without a previous prototype declaration'
complete -c gcc -o Wmissing-declarations --description '(C only) Warn if a global function is defined without a previous declaration'
complete -c gcc -o Wmissing-field-initializers --description 'Warn if a structure’s initializer has some fields missing'
complete -c gcc -o Wmissing-noreturn --description 'Warn about functions which might be candidates for attribute "noreturn"'
complete -c gcc -o Wmissing-format-attribute --description 'Warn about function pointers which might be candidates for "format" attributes'
complete -c gcc -o Wno-multichar --description 'Do not warn if a multicharacter constant (’FOOF’) is used'
complete -c gcc -o Wnormalized --description 'In ISO C and ISO C++, two identifiers are different if they are different sequences of characters' -x -a "none id nfc nfkc"
complete -c gcc -o Wno-deprecated-declarations --description 'Do not warn about uses of functions, variables, and types marked as deprecated by using the "deprecated" attribute'
complete -c gcc -o Wpacked --description 'Warn if a structure is given the packed attribute, but the packed attribute has no effect on the layout or size of the structure'
complete -c gcc -o Wpadded --description 'Warn if padding is included in a structure, either to align an element of the structure or to align the whole structure'
complete -c gcc -o Wredundant-decls --description 'Warn if anything is declared more than once in the same scope, even in cases where multiple declaration is valid and changes nothing'
complete -c gcc -o Wnested-externs --description '(C only) Warn if an "extern" declaration is encountered within a function'
complete -c gcc -o Wunreachable-code --description 'Warn if the compiler detects that code will never be executed'
complete -c gcc -o Winline --description 'Warn if a function can not be inlined and it was declared as inline'
complete -c gcc -o Wno-invalid-offsetof --description '(C++ only) Suppress warnings from applying the offsetof macro to a non-POD type'
complete -c gcc -o Wno-int-to-pointer-cast --description '(C only) Suppress warnings from casts to pointer type of an integer of a different size'
complete -c gcc -o Wno-pointer-to-int-cast --description '(C only) Suppress warnings from casts from a pointer to an integer type of a different size'
complete -c gcc -o Winvalid-pch --description 'Warn if a precompiled header is found in the search path but can’t be used'
complete -c gcc -o Wlong-long --description 'Warn if long long type is used'
complete -c gcc -o Wvariadic-macros --description 'Warn if variadic macros are used in pedantic ISO C90 mode, or the GNU alternate syntax when in pedantic ISO C99 mode'
complete -c gcc -o Wvolatile-register-var --description 'Warn if a register variable is declared volatile'
complete -c gcc -o Wdisabled-optimization --description 'Warn if a requested optimization pass is disabled'
complete -c gcc -o Wpointer-sign --description 'Warn for pointer argument passing or assignment with different signedness'
complete -c gcc -o Werror --description 'Make all warnings into errors'
complete -c gcc -o Wstack-protector --description 'This option is only active when -fstack-protector is active'
complete -c gcc -s g --description 'Produce debugging information in the operating system’s native format (stabs, COFF, XCOFF, or DWARF 2)'
complete -c gcc -o ggdb --description 'Produce debugging information for use by GDB'
complete -c gcc -o gstabs --description 'Produce debugging information in stabs format (if that is supported), without GDB extensions'
complete -c gcc -o feliminate-unused-debug-symbols --description 'Produce debugging information in stabs format (if that is supported), for only symbols that are actually used'
complete -c gcc -o gstabs+ --description 'Produce debugging information in stabs format (if that is supported), using GNU extensions understood only by the GNU debugger (GDB)'
complete -c gcc -o gcoff --description 'Produce debugging information in COFF format (if that is supported)'
complete -c gcc -o gxcoff --description 'Produce debugging information in XCOFF format (if that is supported)'
complete -c gcc -o gxcoff+ --description 'Produce debugging information in XCOFF format (if that is supported), using GNU extensions understood only by the GNU debugger (GDB)'
complete -c gcc -o gdwarf-2 --description 'Produce debugging information in DWARF version 2 format (if that is supported)'
complete -c gcc -o gvms --description 'Produce debugging information in VMS debug format (if that is supported)'
complete -c gcc -o glevel --description 'Request debugging information and also use level to specify how much information'
complete -c gcc -o ggdblevel --description 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gstabslevel --description 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gcofflevel --description 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gxcofflevel --description 'Request debugging information and also use level to specify how much information'
complete -c gcc -o gvmslevel --description 'Request debugging information and also use level to specify how much information'
complete -c gcc -o feliminate-dwarf2-dups --description 'Compress DWARF2 debugging information by eliminating duplicated information about each symbol'
complete -c gcc -s p --description 'Generate extra code to write profile information suitable for the analysis program prof'
complete -c gcc -o pg --description 'Generate extra code to write profile information suitable for the analysis program gprof'
complete -c gcc -s Q --description 'Makes the compiler print out each function name as it is compiled, and print some statistics about each pass when it finishes'
complete -c gcc -o ftime-report --description 'Makes the compiler print some statistics about the time consumed by each pass when it finishes'
complete -c gcc -o fmem-report --description 'Makes the compiler print some statistics about permanent memory allocation when it finishes'
complete -c gcc -o fprofile-arcs --description 'Add code so that program flow arcs are instrumented'
complete -c gcc -l coverage --description 'This option is used to compile and link code instrumented for coverage analysis'
complete -c gcc -o ftest-coverage --description 'Produce a notes file that the gcov code-coverage utility can use to show program coverage'
complete -c gcc -o dletters --description 'Says to make debugging dumps during compilation at times specified by letters'
complete -c gcc -o fdump-rtl-pass --description 'Says to make debugging dumps during compilation at times specified by letters'
complete -c gcc -o fdump-unnumbered --description 'When doing debugging dumps (see -d option above), suppress instruction numbers and line number note output'
complete -c gcc -o fdump-translation-unit --description '(C++ only) Dump a representation of the tree structure for the entire translation unit to a file'
complete -c gcc -o fdump-translation-unit-options --description '(C++ only) Dump a representation of the tree structure for the entire translation unit to a file'
complete -c gcc -o fdump-class-hierarchy --description '(C++ only) Dump a representation of each class’s hierarchy and virtual function table layout to a file'
complete -c gcc -o fdump-class-hierarchy-options --description '(C++ only) Dump a representation of each class’s hierarchy and virtual function table layout to a file'
complete -c gcc -o fdump-ipa-switch --description 'Control the dumping at various stages of inter-procedural analysis language tree to a file'
complete -c gcc -o fdump-tree-switch --description 'Control the dumping at various stages of processing the intermediate language tree to a file'
complete -c gcc -o fdump-tree-switch-options --description 'Control the dumping at various stages of processing the intermediate language tree to a file'
complete -c gcc -o ftree-vectorizer-verbose --description 'This option controls the amount of debugging output the vectorizer prints' -x -a "1 2 3 4 5"
complete -c gcc -o frandom-seed --description 'This option provides a seed that GCC uses when it would otherwise use random numbers' -x
complete -c gcc -o fsched-verbose --description 'On targets that use instruction scheduling, this option controls the amount of debugging output the scheduler prints' -x -a "1 2 3 4 5"
complete -c gcc -o save-temps --description 'Store the usual "temporary" intermediate files permanently; place them in the current directory and name them based on the source file'
complete -c gcc -o time --description 'Report the CPU time taken by each subprocess in the compilation sequence'
complete -c gcc -o fvar-tracking --description 'Run variable tracking pass'
complete -c gcc -o print-file-name -r --description 'Print the full absolute name of the library file library that would be used when linking---and don\'t do anything else'
complete -c gcc -o print-multi-directory --description 'Print the directory name corresponding to the multilib selected by any other switches present in the command line'
complete -c gcc -o print-multi-lib --description 'Print the mapping from multilib directory names to compiler switches that enable them'
complete -c gcc -o print-prog-name -r --description 'Like -print-file-name, but searches for a program such as cpp'
complete -c gcc -o print-libgcc-file-name --description 'Same as -print-file-name=libgcc'
complete -c gcc -o print-search-dirs --description 'Print the name of the configured installation directory and a list of program and library directories gcc will search---and don’t do anything else'
complete -c gcc -o dumpmachine --description 'Print the compiler’s target machine (for example, i686-pc-linux-gnu)---and don’t do anything else'
complete -c gcc -o dumpversion --description 'Print the compiler version (for example, 3'
complete -c gcc -o dumpspecs --description 'Print the compiler’s built-in specs---and don’t do anything else'
complete -c gcc -o feliminate-unused-debug-types --description 'Normally, when producing DWARF2 output, GCC will emit debugging information for all types declared in a compilation unit, regardless of whether or not they are actually used in that compilation unit'
complete -c gcc -o O2 --description 'Optimize even more'
complete -c gcc -o O3 --description 'Optimize yet more'
complete -c gcc -o O0 --description 'Do not optimize'
complete -c gcc -o Os --description 'Optimize for size'
complete -c gcc -o fno-default-inline --description 'Do not make member functions inline by default merely because they are defined inside the class scope (C++ only)'
complete -c gcc -o fno-defer-pop --description 'Always pop the arguments to each function call as soon as that function returns'
complete -c gcc -o fforce-mem --description 'Force memory operands to be copied into registers before doing arithmetic on them'
complete -c gcc -o fforce-addr --description 'Force memory address constants to be copied into registers before doing arithmetic on them'
complete -c gcc -o fomit-frame-pointer --description 'Don’t keep the frame pointer in a register for functions that don’t need one'
complete -c gcc -o foptimize-sibling-calls --description 'Optimize sibling and tail recursive calls'
complete -c gcc -o fno-inline --description 'Don’t pay attention to the "inline" keyword'
complete -c gcc -o finline-functions --description 'Integrate all simple functions into their callers'
complete -c gcc -o finline-functions-called-once --description 'Consider all "static" functions called once for inlining into their caller even if they are not marked "inline"'
complete -c gcc -o fearly-inlining --description 'Inline functions marked by "always_inline" and functions whose body seems smaller than the function call overhead early before doing -fprofile-generate instrumentation and real inlining pass'
complete -c gcc -o finline-limit --description 'By default, GCC limits the size of functions that can be inlined' -x -a "1 2 3 4 5"
complete -c gcc -o fkeep-inline-functions --description 'In C, emit "static" functions that are declared "inline" into the object file, even if the function has been inlined into all of its callers'
complete -c gcc -o fkeep-static-consts --description 'Emit variables declared "static const" when optimization isn’t turned on, even if the variables aren’t referenced'
complete -c gcc -o fmerge-constants --description 'Attempt to merge identical constants (string constants and floating point constants) across compilation units'
complete -c gcc -o fmerge-all-constants --description 'Attempt to merge identical constants and identical variables'
complete -c gcc -o fmodulo-sched --description 'Perform swing modulo scheduling immediately before the first scheduling pass'
complete -c gcc -o fno-branch-count-reg --description 'Do not use "decrement and branch" instructions on a count register, but instead generate a sequence of instructions that decrement a register, compare it against zero, then branch based upon the result'
complete -c gcc -o fno-function-cse --description 'Do not put function addresses in registers; make each instruction that calls a constant function contain the function’s address explicitly'
complete -c gcc -o fno-zero-initialized-in-bss --description 'If the target supports a BSS section, GCC by default puts variables that are initialized to zero into BSS'
complete -c gcc -o fbounds-check --description 'For front-ends that support it, generate additional code to check that indices used to access arrays are within the declared range'
complete -c gcc -o fmudflap --description 'For front-ends that support it (C and C++), instrument all risky pointer/array dereferencing operations, some standard library string/heap functions, and some other associated constructs with range/validity tests'
complete -c gcc -o fmudflapth --description 'For front-ends that support it (C and C++), instrument all risky pointer/array dereferencing operations, some standard library string/heap functions, and some other associated constructs with range/validity tests'
complete -c gcc -o fmudflapir --description 'For front-ends that support it (C and C++), instrument all risky pointer/array dereferencing operations, some standard library string/heap functions, and some other associated constructs with range/validity tests'
complete -c gcc -o fstrength-reduce --description 'Perform the optimizations of loop strength reduction and elimination of iteration variables'
complete -c gcc -o fthread-jumps --description 'Perform optimizations where we check to see if a jump branches to a location where another comparison subsumed by the first is found'
complete -c gcc -o fcse-follow-jumps --description 'In common subexpression elimination, scan through jump instructions when the target of the jump is not reached by any other path'
complete -c gcc -o fcse-skip-blocks --description 'This is similar to -fcse-follow-jumps, but causes CSE to follow jumps which conditionally skip over blocks'
complete -c gcc -o frerun-cse-after-loop --description 'Re-run common subexpression elimination after loop optimizations has been performed'
complete -c gcc -o frerun-loop-opt --description 'Run the loop optimizer twice'
complete -c gcc -o fgcse --description 'Perform a global common subexpression elimination pass'
complete -c gcc -o fgcse-lm --description 'When -fgcse-lm is enabled, global common subexpression elimination will attempt to move loads which are only killed by stores into themselves'
complete -c gcc -o fgcse-sm --description 'When -fgcse-sm is enabled, a store motion pass is run after global common subexpression elimination'
complete -c gcc -o fgcse-las --description 'When -fgcse-las is enabled, the global common subexpression elimination pass eliminates redundant loads that come after stores to the same memory location (both partial and full redundancies)'
complete -c gcc -o fgcse-after-reload --description 'When -fgcse-after-reload is enabled, a redundant load elimination pass is performed after reload'
complete -c gcc -o floop-optimize --description 'Perform loop optimizations: move constant expressions out of loops, simplify exit test conditions and optionally do strength-reduction as well'
complete -c gcc -o floop-optimize2 --description 'Perform loop optimizations using the new loop optimizer'
complete -c gcc -o funsafe-loop-optimizations --description 'If given, the loop optimizer will assume that loop indices do not overflow, and that the loops with nontrivial exit condition are not infinite'
complete -c gcc -o fcrossjumping --description 'Perform cross-jumping transformation'
complete -c gcc -o fif-conversion --description 'Attempt to transform conditional jumps into branch-less equivalents'
complete -c gcc -o fif-conversion2 --description 'Use conditional execution (where available) to transform conditional jumps into branch-less equivalents'
complete -c gcc -o fdelete-null-pointer-checks --description 'Use global dataflow analysis to identify and eliminate useless checks for null pointers'
complete -c gcc -o fexpensive-optimizations --description 'Perform a number of minor optimizations that are relatively expensive'
complete -c gcc -o foptimize-register-move --description 'Attempt to reassign register numbers in move instructions and as operands of other simple instructions in order to maximize the amount of register tying'
complete -c gcc -o fregmove --description 'Attempt to reassign register numbers in move instructions and as operands of other simple instructions in order to maximize the amount of register tying'
complete -c gcc -o fdelayed-branch --description 'If supported for the target machine, attempt to reorder instructions to exploit instruction slots available after delayed branch instructions'
complete -c gcc -o fschedule-insns --description 'If supported for the target machine, attempt to reorder instructions to eliminate execution stalls due to required data being unavailable'
complete -c gcc -o fschedule-insns2 --description 'Similar to -fschedule-insns, but requests an additional pass of instruction scheduling after register allocation has been done'
complete -c gcc -o fno-sched-interblock --description 'Don’t schedule instructions across basic blocks'
complete -c gcc -o fno-sched-spec --description 'Don’t allow speculative motion of non-load instructions'
complete -c gcc -o fsched-spec-load --description 'Allow speculative motion of some load instructions'
complete -c gcc -o fsched-spec-load-dangerous --description 'Allow speculative motion of more load instructions'
complete -c gcc -o fsched-stalled-insns --description 'Define how many insns (if any) can be moved prematurely from the queue of stalled insns into the ready list, during the second scheduling pass'
complete -c gcc -o fsched-stalled-insns-dep --description 'Define how many insn groups (cycles) will be examined for a dependency on a stalled insn that is candidate for premature removal from the queue of stalled insns'
complete -c gcc -o fsched2-use-superblocks --description 'When scheduling after register allocation, do use superblock scheduling algorithm'
complete -c gcc -o fsched2-use-traces --description 'Use -fsched2-use-superblocks algorithm when scheduling after register allocation and additionally perform code duplication in order to increase the size of superblocks using tracer pass'
complete -c gcc -o freschedule-modulo-scheduled-loops --description 'The modulo scheduling comes before the traditional scheduling, if a loop was modulo scheduled we may want to prevent the later scheduling passes from changing its schedule, we use this option to control that'
complete -c gcc -o fcaller-saves --description 'Enable values to be allocated in registers that will be clobbered by function calls, by emitting extra instructions to save and restore the registers around such calls'
complete -c gcc -o ftree-pre --description 'Perform Partial Redundancy Elimination (PRE) on trees'
complete -c gcc -o ftree-fre --description 'Perform Full Redundancy Elimination (FRE) on trees'
complete -c gcc -o ftree-copy-prop --description 'Perform copy propagation on trees'
complete -c gcc -o ftree-store-copy-prop --description 'Perform copy propagation of memory loads and stores'
complete -c gcc -o ftree-salias --description 'Perform structural alias analysis on trees'
complete -c gcc -o ftree-sink --description 'Perform forward store motion on trees'
complete -c gcc -o ftree-ccp --description 'Perform sparse conditional constant propagation (CCP) on trees'
complete -c gcc -o ftree-store-ccp --description 'Perform sparse conditional constant propagation (CCP) on trees'
complete -c gcc -o ftree-dce --description 'Perform dead code elimination (DCE) on trees'
complete -c gcc -o ftree-dominator-opts --description 'Perform a variety of simple scalar cleanups (constant/copy propagation, redundancy elimination, range propagation and expression simplification) based on a dominator tree traversal'
complete -c gcc -o ftree-ch --description 'Perform loop header copying on trees'
complete -c gcc -o ftree-loop-optimize --description 'Perform loop optimizations on trees'
complete -c gcc -o ftree-loop-linear --description 'Perform linear loop transformations on tree'
complete -c gcc -o ftree-loop-im --description 'Perform loop invariant motion on trees'
complete -c gcc -o ftree-loop-ivcanon --description 'Create a canonical counter for number of iterations in the loop for that determining number of iterations requires complicated analysis'
complete -c gcc -o fivopts --description 'Perform induction variable optimizations (strength reduction, induction variable merging and induction variable elimination) on trees'
complete -c gcc -o ftree-sra --description 'Perform scalar replacement of aggregates'
complete -c gcc -o ftree-copyrename --description 'Perform copy renaming on trees'
complete -c gcc -o ftree-ter --description 'Perform temporary expression replacement during the SSA->normal phase'
complete -c gcc -o ftree-lrs --description 'Perform live range splitting during the SSA->normal phase'
complete -c gcc -o ftree-vectorize --description 'Perform loop vectorization on trees'
complete -c gcc -o ftree-vect-loop-version --description 'Perform loop versioning when doing loop vectorization on trees'
complete -c gcc -o ftree-vrp --description 'Perform Value Range Propagation on trees'
complete -c gcc -o ftracer --description 'Perform tail duplication to enlarge superblock size'
complete -c gcc -o funroll-loops --description 'Unroll loops whose number of iterations can be determined at compile time or upon entry to the loop'
complete -c gcc -o funroll-all-loops --description 'Unroll all loops, even if their number of iterations is uncertain when the loop is entered'
complete -c gcc -o fsplit-ivs-in-unroller --description 'Enables expressing of values of induction variables in later iterations of the unrolled loop using the value in the first iteration'
complete -c gcc -o fvariable-expansion-in-unroller --description 'With this option, the compiler will create multiple copies of some local variables when unrolling a loop which can result in superior code'
complete -c gcc -o fprefetch-loop-arrays --description 'If supported by the target machine, generate instructions to prefetch memory to improve the performance of loops that access large arrays'
complete -c gcc -o fno-peephole --description 'Disable any machine-specific peephole optimizations'
complete -c gcc -o fno-peephole2 --description 'Disable any machine-specific peephole optimizations'
complete -c gcc -o fno-guess-branch-probability --description 'Do not guess branch probabilities using heuristics'
complete -c gcc -o freorder-blocks --description 'Reorder basic blocks in the compiled function in order to reduce number of taken branches and improve code locality'
complete -c gcc -o freorder-blocks-and-partition --description 'In addition to reordering basic blocks in the compiled function, in order to reduce number of taken branches, partitions hot and cold basic blocks into separate sections of the assembly and '
complete -c gcc -o freorder-functions --description 'Reorder functions in the object file in order to improve code locality'
complete -c gcc -o fstrict-aliasing --description 'Allows the compiler to assume the strictest aliasing rules applicable to the language being compiled'
complete -c gcc -o falign-functions --description 'Align the start of functions to the next power-of-two greater than n, skipping up to n bytes'
complete -c gcc -o falign-functions --description 'Align the start of functions to the next power-of-two greater than n, skipping up to n bytes'
complete -c gcc -o falign-labels --description 'Align all branch targets to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-labels --description 'Align all branch targets to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-loops --description 'Align loops to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-loops --description 'Align loops to a power-of-two boundary, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-jumps --description 'Align branch targets to a power-of-two boundary, for branch targets where the targets can only be reached by jumping, skipping up to n bytes like -falign-functions'
complete -c gcc -o falign-jumps --description 'Align branch targets to a power-of-two boundary, for branch targets where the targets can only be reached by jumping, skipping up to n bytes like -falign-functions'
complete -c gcc -o funit-at-a-time --description 'Parse the whole compilation unit before starting to produce code'
complete -c gcc -o fweb --description 'Constructs webs as commonly used for register allocation purposes and assign each web individual pseudo register'
complete -c gcc -o fwhole-program --description 'Assume that the current compilation unit represents whole program being compiled'
complete -c gcc -o fno-cprop-registers --description 'After register allocation and post-register allocation instruction splitting, we perform a copy-propagation pass to try to reduce scheduling dependencies and occasionally eliminate the copy'
complete -c gcc -o fprofile-generate --description 'Enable options usually used for instrumenting application to produce profile useful for later recompilation with profile feedback based optimization'
complete -c gcc -o fprofile-use --description 'Enable profile feedback directed optimizations, and optimizations generally profitable only with profile feedback available'
complete -c gcc -o ffloat-store --description 'Do not store floating point variables in registers, and inhibit other options that might change whether a floating point value is taken from a register or memory'
complete -c gcc -o ffast-math --description 'Sets -fno-math-errno, -funsafe-math-optimizations, -fno-trapping-math, -ffinite-math-only, -fno-rounding-math, -fno-signaling-nans and fcx-limited-range'
complete -c gcc -o fno-math-errno --description 'Do not set ERRNO after calling math functions that are executed with a single instruction, e'
complete -c gcc -o funsafe-math-optimizations --description 'Allow optimizations for floating-point arithmetic that (a) assume that arguments and results are valid and (b) may violate IEEE or ANSI standards'
complete -c gcc -o ffinite-math-only --description 'Allow optimizations for floating-point arithmetic that assume that arguments and results are not NaNs or +-Infs'
complete -c gcc -o fno-trapping-math --description 'Compile code assuming that floating-point operations cannot generate user-visible traps'
complete -c gcc -o frounding-math --description 'Disable transformations and optimizations that assume default floating point rounding behavior'
complete -c gcc -o fsignaling-nans --description 'Compile code assuming that IEEE signaling NaNs may generate uservisible traps during floating-point operations'
complete -c gcc -o fsingle-precision-constant --description 'Treat floating point constant as single precision constant instead of implicitly converting it to double precision constant'
complete -c gcc -o fcx-limited-range --description 'When enabled, this option states that a range reduction step is not needed when performing complex division'
complete -c gcc -o fno-cx-limited-range --description 'When enabled, this option states that a range reduction step is not needed when performing complex division'
complete -c gcc -o fbranch-probabilities --description 'After running a program compiled with -fprofile-arcs, you can compile it a second time using -fbranch-probabilities, to improve optimizations based on the number of times each branch was taken'
complete -c gcc -o fprofile-values --description 'If combined with -fprofile-arcs, it adds code so that some data about values of expressions in the program is gathered'
complete -c gcc -o fvpt --description 'If combined with -fprofile-arcs, it instructs the compiler to add a code to gather information about values of expressions'
complete -c gcc -o frename-registers --description 'Attempt to avoid false dependencies in scheduled code by making use of registers left over after register allocation'
complete -c gcc -o ftracer --description 'Perform tail duplication to enlarge superblock size'
complete -c gcc -o funroll-loops --description 'Unroll loops whose number of iterations can be determined at compile time or upon entry to the loop'
complete -c gcc -o funroll-all-loops --description 'Unroll all loops, even if their number of iterations is uncertain when the loop is entered'
complete -c gcc -o fpeel-loops --description 'Peels the loops for that there is enough information that they do not roll much (from profile feedback)'
complete -c gcc -o fmove-loop-invariants --description 'Enables the loop invariant motion pass in the new loop optimizer'
complete -c gcc -o funswitch-loops --description 'Move branches with loop invariant conditions out of the loop, with duplicates of the loop on both branches (modified according to result of the condition)'
complete -c gcc -o fprefetch-loop-arrays --description 'If supported by the target machine, generate instructions to prefetch memory to improve the performance of loops that access large arrays'
complete -c gcc -o ffunction-sections --description 'Place each function or data item into its own section in the output file if the target supports arbitrary sections'
complete -c gcc -o fdata-sections --description 'Place each function or data item into its own section in the output file if the target supports arbitrary sections'
complete -c gcc -o fbranch-target-load-optimize --description 'Perform branch target register load optimization before prologue / epilogue threading'
complete -c gcc -o fbranch-target-load-optimize2 --description 'Perform branch target register load optimization after prologue / epilogue threading'
complete -c gcc -o fbtr-bb-exclusive --description 'When performing branch target register load optimization, don’t reuse branch target registers in within any basic block'
complete -c gcc -o fstack-protector --description 'Emit extra code to check for buffer overflows, such as stack smashing attacks'
complete -c gcc -o fstack-protector-all --description 'Like -fstack-protector except that all functions are protected'
complete -c gcc -l param --description 'In some places, GCC uses various constants to control the amount of optimization that is done'
complete -c gcc -o Xpreprocessor --description 'Pass option as an option to the preprocessor'
complete -c gcc -s D --description 'Predefine name as a macro, with definition 1'
complete -c gcc -s D --description 'The contents of definition are tokenized and processed as if they appeared during translation phase three in a #define directive'
complete -c gcc -s U --description 'Cancel any previous definition of name, either built in or provided with a -D option'
complete -c gcc -o undef --description 'Do not predefine any system-specific or GCC-specific macros'
complete -c gcc -s I --description 'Add the directory dir to the list of directories to be searched for header files'
complete -c gcc -s o --description 'Write output to file'
complete -c gcc -o Wall --description 'Turns on all optional warnings which are desirable for normal code'
complete -c gcc -o Wcomment --description 'Warn whenever a comment-start sequence /* appears in a /* comment, or whenever a backslash-newline appears in a // comment'
complete -c gcc -o Wcomments --description 'Warn whenever a comment-start sequence /* appears in a /* comment, or whenever a backslash-newline appears in a // comment'
complete -c gcc -o Wtrigraphs --description '@anchor{Wtrigraphs} Most trigraphs in comments cannot affect the meaning of the program'
complete -c gcc -o Wtraditional --description 'Warn about certain constructs that behave differently in traditional and ISO C'
complete -c gcc -o Wimport --description 'Warn the first time #import is used'
complete -c gcc -o Wundef --description 'Warn whenever an identifier which is not a macro is encountered in an #if directive, outside of defined'
complete -c gcc -o Wunused-macros --description 'Warn about macros defined in the main file that are unused'
complete -c gcc -o Wendif-labels --description 'Warn whenever an #else or an #endif are followed by text'
complete -c gcc -o Werror --description 'Make all warnings into hard errors'
complete -c gcc -o Wsystem-headers --description 'Issue warnings for code in system headers'
complete -c gcc -s w --description 'Suppress all warnings, including those which GNU CPP issues by default'
complete -c gcc -o pedantic --description 'Issue all the mandatory diagnostics listed in the C standard'
complete -c gcc -o pedantic-errors --description 'Issue all the mandatory diagnostics, and make all mandatory diagnostics into errors'
complete -c gcc -s M --description 'Instead of outputting the result of preprocessing, output a rule suitable for make describing the dependencies of the main source file'
complete -c gcc -o MM --description 'Like -M but do not mention header files that are found in system header directories, nor header files that are included, directly or indirectly, from such a header'
complete -c gcc -o MF --description 'When used with -M or -MM, specifies a file to write the dependencies to'
complete -c gcc -o MG --description 'In conjunction with an option such as -M requesting dependency generation, -MG assumes missing header files are generated files and adds them to the dependency list without raising an error'
complete -c gcc -o MP --description 'This option instructs CPP to add a phony target for each dependency other than the main file, causing each to depend on nothing'
complete -c gcc -o MT --description 'Change the target of the rule emitted by dependency generation'
complete -c gcc -o MQ --description 'Same as -MT, but it quotes any characters which are special to Make'
complete -c gcc -o MD --description 'is equivalent to -M -MF file, except that -E is not implied'
complete -c gcc -o MD --description 'is equivalent to -M -MF file, except that -E is not implied'
complete -c gcc -o MMD --description 'Like -MD except mention only user header files, not system header files'
complete -c gcc -o fpch-deps --description 'When using precompiled headers, this flag will cause the dependency-output flags to also list the files from the precompiled header’s dependencies'
complete -c gcc -o fpch-preprocess --description 'This option allows use of a precompiled header together with -E'
complete -c gcc -s x --description 'assembler-with-cpp Specify the source language: C, C++, Objective-C, or assembly'
complete -c gcc -s x --description 'assembler-with-cpp Specify the source language: C, C++, Objective-C, or assembly'
complete -c gcc -s x --description 'assembler-with-cpp Specify the source language: C, C++, Objective-C, or assembly'
complete -c gcc -s x --description 'assembler-with-cpp Specify the source language: C, C++, Objective-C, or assembly'
complete -c gcc -o std --description 'Specify the standard to which the code should conform'
complete -c gcc -o ansi --description 'Specify the standard to which the code should conform'
complete -c gcc -o I- --description 'Split the include path'
complete -c gcc -o nostdinc --description 'Do not search the standard system directories for header files'
complete -c gcc -o nostdinc++ --description 'Do not search for header files in the C++-specific standard directories, but do still search the other standard directories'
complete -c gcc -o include --description 'Process file as if "#include "file"" appeared as the first line of the primary source file'
complete -c gcc -o imacros --description 'Exactly like -include, except that any output produced by scanning file is thrown away'
complete -c gcc -o idirafter --description 'Search dir for header files, but do it after all directories specified with -I and the standard system directories have been exhausted'
complete -c gcc -o iprefix --description 'Specify prefix as the prefix for subsequent -iwithprefix options'
complete -c gcc -o iwithprefix --description 'Append dir to the prefix specified previously with -iprefix, and add the resulting directory to the include search path'
complete -c gcc -o iwithprefixbefore --description 'Append dir to the prefix specified previously with -iprefix, and add the resulting directory to the include search path'
complete -c gcc -o isysroot --description 'This option is like the --sysroot option, but applies only to header files'
complete -c gcc -o isystem --description 'Search dir for header files, after all directories specified by -I but before the standard system directories'
complete -c gcc -o iquote --description 'Search dir only for header files requested with "#include "file""; they are not searched for "#include <file>", before all directories specified by -I and before the standard system directories'
complete -c gcc -o fdollars-in-identifiers --description '@anchor{fdollars-in-identifiers} Accept $ in identifiers'
complete -c gcc -o fextended-identifiers --description 'Accept universal character names in identifiers'
complete -c gcc -o fpreprocessed --description 'Indicate to the preprocessor that the input file has already been preprocessed'
complete -c gcc -o ftabstop --description 'Set the distance between tab stops'
complete -c gcc -o fexec-charset --description 'Set the execution character set, used for string and character constants' -a "(__fish_print_encodings)"
complete -c gcc -o fwide-exec-charset --description 'Set the wide execution character set, used for wide string and character constants' -a "(__fish_print_encodings)"
complete -c gcc -o finput-charset --description 'Set the input character set, used for translation from the character set of the input file to the source character set used by GCC' -a "(__fish_print_encodings)"
complete -c gcc -o fworking-directory --description 'Enable generation of linemarkers in the preprocessor output that will let the compiler know the current working directory at the time of preprocessing'
complete -c gcc -o fno-show-column --description 'Do not print column numbers in diagnostics'
complete -c gcc -s A --description 'Make an assertion with the predicate predicate and answer answer'
complete -c gcc -s A --description 'Cancel an assertion with the predicate predicate and answer answer' -x
complete -c gcc -o predicate --description 'Cancel an assertion with the predicate predicate and answer answer' -x
complete -c gcc -o dCHARS --description 'CHARS is a sequence of one or more of the following characters, and must not be preceded by a space'
complete -c gcc -s P --description 'Inhibit generation of linemarkers in the output from the preprocessor'
complete -c gcc -s C --description 'Do not discard comments'
complete -c gcc -o CC --description 'Do not discard comments, including during macro expansion'
complete -c gcc -o traditional-cpp --description 'Try to imitate the behavior of old-fashioned C preprocessors, as opposed to ISO C preprocessors'
complete -c gcc -o trigraphs --description 'Process trigraph sequences'
complete -c gcc -o remap --description 'Enable special code to work around file systems which only permit very short file names, such as MS-DOS'
complete -c gcc -l help --description 'Print text describing all the command line options instead of preprocessing anything'
complete -c gcc -l target-help --description 'Print text describing all the command line options instead of preprocessing anything'
complete -c gcc -s v --description 'Verbose mode'
complete -c gcc -s H --description 'Print the name of each header file used, in addition to other normal activities'
complete -c gcc -o version --description 'Print out GNU CPP’s version number'
complete -c gcc -l version --description 'Print out GNU CPP’s version number'
complete -c gcc -o Xassembler --description 'Pass option as an option to the assembler'
complete -c gcc -s c --description 'If any of these options is used, then the linker is not run, and object file names should not be used as arguments'
complete -c gcc -s S --description 'If any of these options is used, then the linker is not run, and object file names should not be used as arguments'
complete -c gcc -s E --description 'If any of these options is used, then the linker is not run, and object file names should not be used as arguments'
complete -c gcc -o llibrary --description 'Search the library named library when linking'
complete -c gcc -s l --description 'Search the library named library when linking'
complete -c gcc -o lobjc --description 'You need this special case of the -l option in order to link an Objective-C or Objective-C++ program'
complete -c gcc -o nostartfiles --description 'Do not use the standard system startup files when linking'
complete -c gcc -o nodefaultlibs --description 'Do not use the standard system libraries when linking'
complete -c gcc -o nostdlib --description 'Do not use the standard system startup files or libraries when linking'
complete -c gcc -o pie --description 'Produce a position independent executable on targets which support it'
complete -c gcc -o rdynamic --description 'Pass the flag -export-dynamic to the ELF linker, on targets that support it'
complete -c gcc -s s --description 'Remove all symbol table and relocation information from the executable'
complete -c gcc -o static --description 'On systems that support dynamic linking, this prevents linking with the shared libraries'
complete -c gcc -o shared --description 'Produce a shared object which can then be linked with other objects to form an executable'
complete -c gcc -o shared-libgcc --description 'On systems that provide libgcc as a shared library, these options force the use of either the shared or static version respectively'
complete -c gcc -o static-libgcc --description 'On systems that provide libgcc as a shared library, these options force the use of either the shared or static version respectively'
complete -c gcc -o symbolic --description 'Bind references to global symbols when building a shared object'
complete -c gcc -o Xlinker --description 'Pass option as an option to the linker'
complete -c gcc -s u --description 'Pretend the symbol symbol is undefined, to force linking of library modules to define it'
complete -c gcc -o Idir --description 'Add the directory dir to the head of the list of directories to be searched for header files'
complete -c gcc -o iquotedir --description 'Add the directory dir to the head of the list of directories to be searched for header files only for the case of #include "file"; they are not searched for #include <file>, otherwise just like -I'
complete -c gcc -o Ldir --description 'Add directory dir to the list of directories to be searched for -l'
complete -c gcc -o Bprefix --description 'This option specifies where to find the executables, libraries, include files, and data files of the compiler itself'
complete -c gcc -o specs -r --description 'Process file after the compiler reads in the standard specs file, in order to override the defaults that the gcc driver program uses when determining what switches to pass to cc1, cc1plus, as, ld, etc'
complete -c gcc -l sysroot -x -a '(__fish_complete_directories)' --description 'Use dir as the logical root directory for headers and libraries'
complete -c gcc -o I- --description 'This option has been deprecated'
complete -c gcc -s b --description 'The argument machine specifies the target machine for compilation'
complete -c gcc -s V --description 'The argument version specifies which version of GCC to run'
complete -c gcc -o EL --description 'Compile code for little endian mode'
complete -c gcc -o EB --description 'Compile code for big endian mode'
complete -c gcc -o mmangle-cpu --description 'Prepend the name of the cpu to all public symbol names'
complete -c gcc -o mcpu --description 'Compile code for ARC variant cpu' -x
complete -c gcc -o mtext --description 'Put functions, data, and readonly data in text-section, data-section, and readonly-data-section respectively by default'
complete -c gcc -o mdata --description 'Put functions, data, and readonly data in text-section, data-section, and readonly-data-section respectively by default'
complete -c gcc -o mrodata --description 'Put functions, data, and readonly data in text-section, data-section, and readonly-data-section respectively by default'
complete -c gcc -o section --description 'Put functions, data, and readonly data in text-section, data-section, and readonly-data-section respectively by default'
complete -c gcc -o mabi --description 'Generate code for the specified ABI' -x
complete -c gcc -o mapcs-frame --description 'Generate a stack frame that is compliant with the ARM Procedure Call Standard for all functions, even if this is not strictly necessary for correct execution of the code'
complete -c gcc -o mapcs --description 'This is a synonym for -mapcs-frame'
complete -c gcc -o mthumb-interwork --description 'Generate code which supports calling between the ARM and Thumb instruction sets'
complete -c gcc -o mno-sched-prolog --description 'Prevent the reordering of instructions in the function prolog, or the merging of those instruction with the instructions in the function’s body'
complete -c gcc -o mhard-float --description 'Generate output containing floating point instructions'
complete -c gcc -o msoft-float --description 'Generate output containing library calls for floating point'
complete -c gcc -o mfloat-abi --description 'Specifies which ABI to use for floating point values' -x
complete -c gcc -o mlittle-endian --description 'Generate code for a processor running in little-endian mode'
complete -c gcc -o mbig-endian --description 'Generate code for a processor running in big-endian mode; the default is to compile code for a little-endian processor'
complete -c gcc -o mwords-little-endian --description 'This option only applies when generating code for big-endian processors'
complete -c gcc -o mcpu --description 'This specifies the name of the target ARM processor' -x
complete -c gcc -o mtune --description 'This option is very similar to the -mcpu= option, except that instead of specifying the actual target processor type, and hence restricting which instructions can be used, it specifies that GCC should tune the performance of the code as if the target were of the type specified in this option, but still choosing the instructions that it will generate based on the cpu specified by a -mcpu= option' -x
complete -c gcc -o march --description 'This specifies the name of the target ARM architecture' -x
complete -c gcc -o mfpu -x --description 'This specifies what floating point hardware (or hardware emulation) is available on the target'
complete -c gcc -o mfpe -x --description 'This specifies what floating point hardware (or hardware emulation) is available on the target'
complete -c gcc -o mfp -x --description 'This specifies what floating point hardware (or hardware emulation) is available on the target'
complete -c gcc -o mstructure-size-boundary -x --description 'The size of all structures and unions will be rounded up to a multiple of the number of bits set by this option'
complete -c gcc -o mabort-on-noreturn --description 'Generate a call to the function "abort" at the end of a "noreturn" function'
complete -c gcc -o mlong-calls --description 'Tells the compiler to perform function calls by first loading the address of the function into a register and then performing a subroutine call on this register'
complete -c gcc -o mno-long-calls --description 'Tells the compiler to perform function calls by first loading the address of the function into a register and then performing a subroutine call on this register'
complete -c gcc -o mnop-fun-dllimport --description 'Disable support for the "dllimport" attribute'
complete -c gcc -o msingle-pic-base --description 'Treat the register used for PIC addressing as read-only, rather than loading it in the prologue for each function'
complete -c gcc -o mpic-register -x --description 'Specify the register to be used for PIC addressing'
complete -c gcc -o mcirrus-fix-invalid-insns --description 'Insert NOPs into the instruction stream to in order to work around problems with invalid Maverick instruction combinations'
complete -c gcc -o mpoke-function-name --description 'Write the name of each function into the text section, directly preceding the function prologue'
complete -c gcc -o mthumb --description 'Generate code for the 16-bit Thumb instruction set'
complete -c gcc -o mtpcs-frame --description 'Generate a stack frame that is compliant with the Thumb Procedure Call Standard for all non-leaf functions'
complete -c gcc -o mtpcs-leaf-frame --description 'Generate a stack frame that is compliant with the Thumb Procedure Call Standard for all leaf functions'
complete -c gcc -o mcallee-super-interworking --description 'Gives all externally visible functions in the file being compiled an ARM instruction set header which switches to Thumb mode before executing the rest of the function'
complete -c gcc -o mcaller-super-interworking --description 'Allows calls via function pointers (including virtual functions) to execute correctly regardless of whether the target code has been compiled for interworking or not'
complete -c gcc -o mtp -x --description 'Specify the access model for the thread local storage pointer'
complete -c gcc -o mmcu -x --description 'Specify ATMEL AVR instruction set or MCU type'
complete -c gcc -o msize --description 'Output instruction sizes to the asm file'
complete -c gcc -o minit-stack -x --description 'Specify the initial stack address, which may be a symbol or numeric value, __stack is the default'
complete -c gcc -o mno-interrupts --description 'Generated code is not compatible with hardware interrupts'
complete -c gcc -o mcall-prologues --description 'Functions prologues/epilogues expanded as call to appropriate subroutines'
complete -c gcc -o mno-tablejump --description 'Do not generate tablejump insns which sometimes increase code size'
complete -c gcc -o mtiny-stack --description 'Change only the low 8 bits of the stack pointer'
complete -c gcc -o mint8 --description 'Assume int to be 8 bit integer'
complete -c gcc -o momit-leaf-frame-pointer --description 'Don’t keep the frame pointer in a register for leaf functions'
complete -c gcc -o mspecld-anomaly --description 'When enabled, the compiler will ensure that the generated code does not contain speculative loads after jump instructions'
complete -c gcc -o mno-specld-anomaly --description 'Don’t generate extra code to prevent speculative loads from occurring'
complete -c gcc -o mcsync-anomaly --description 'When enabled, the compiler will ensure that the generated code does not contain CSYNC or SSYNC instructions too soon after conditional branches'
complete -c gcc -o mno-csync-anomaly --description 'Don’t generate extra code to prevent CSYNC or SSYNC instructions from occurring too soon after a conditional branch'
complete -c gcc -o mlow-64k --description 'When enabled, the compiler is free to take advantage of the knowledge that the entire program fits into the low 64k of memory'
complete -c gcc -o mno-low-64k --description 'Assume that the program is arbitrarily large'
complete -c gcc -o mid-shared-library --description 'Generate code that supports shared libraries via the library ID method'
complete -c gcc -o mno-id-shared-library --description 'Generate code that doesn’t assume ID based shared libraries are being used'
complete -c gcc -o mshared-library-id -x --description 'Specified the identification number of the ID based shared library being compiled'
complete -c gcc -o mlong-calls --description 'Tells the compiler to perform function calls by first loading the address of the function into a register and then performing a subroutine call on this register'
complete -c gcc -o mno-long-calls --description 'Tells the compiler to perform function calls by first loading the address of the function into a register and then performing a subroutine call on this register'
complete -c gcc -o march --description 'Generate code for the specified architecture'
complete -c gcc -o mcpu --description 'Generate code for the specified architecture'
complete -c gcc -o type --description 'Generate code for the specified architecture'
complete -c gcc -o mtune --description 'Tune to architecture-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o type --description 'Tune to architecture-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o mmax-stack-frame --description '=n Warn when the stack frame of a function exceeds n bytes'
complete -c gcc -o melinux-stacksize --description '=n Only available with the cris-axis-aout target'
complete -c gcc -o metrax4 --description 'The options -metrax4 and -metrax100 are synonyms for -march=v3 and -march=v8 respectively'
complete -c gcc -o metrax100 --description 'The options -metrax4 and -metrax100 are synonyms for -march=v3 and -march=v8 respectively'
complete -c gcc -o mmul-bug-workaround --description 'Work around a bug in the "muls" and "mulu" instructions for CPU models where it applies'
complete -c gcc -o mno-mul-bug-workaround --description 'Work around a bug in the "muls" and "mulu" instructions for CPU models where it applies'
complete -c gcc -o mpdebug --description 'Enable CRIS-specific verbose debug-related information in the assembly code'
complete -c gcc -o mcc-init --description 'Do not use condition-code results from previous instruction; always emit compare and test instructions before use of condition codes'
complete -c gcc -o mno-side-effects --description 'Do not emit instructions with side-effects in addressing modes other than post-increment'
complete -c gcc -o mstack-align --description 'These options (no-options) arranges (eliminate arrangements) for the stack-frame, individual data and constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mno-stack-align --description 'These options (no-options) arranges (eliminate arrangements) for the stack-frame, individual data and constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mdata-align --description 'These options (no-options) arranges (eliminate arrangements) for the stack-frame, individual data and constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mno-data-align --description 'These options (no-options) arranges (eliminate arrangements) for the stack-frame, individual data and constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mconst-align --description 'These options (no-options) arranges (eliminate arrangements) for the stack-frame, individual data and constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o mno-const-align --description 'These options (no-options) arranges (eliminate arrangements) for the stack-frame, individual data and constants to be aligned for the maximum single data access size for the chosen CPU model'
complete -c gcc -o m32-bit --description 'Similar to the stack- data- and const-align options above, these options arrange for stack-frame, writable data and constants to all be 32-bit, 16-bit or 8-bit aligned'
complete -c gcc -o m16-bit --description 'Similar to the stack- data- and const-align options above, these options arrange for stack-frame, writable data and constants to all be 32-bit, 16-bit or 8-bit aligned'
complete -c gcc -o m8-bit --description 'Similar to the stack- data- and const-align options above, these options arrange for stack-frame, writable data and constants to all be 32-bit, 16-bit or 8-bit aligned'
complete -c gcc -o mno-prologue-epilogue --description 'With -mno-prologue-epilogue, the normal function prologue and epilogue that sets up the stack-frame are omitted and no return instructions or return sequences are generated in the code'
complete -c gcc -o mprologue-epilogue --description 'With -mno-prologue-epilogue, the normal function prologue and epilogue that sets up the stack-frame are omitted and no return instructions or return sequences are generated in the code'
complete -c gcc -o mno-gotplt --description 'With -fpic and -fPIC, don’t generate (do generate) instruction sequences that load addresses for functions from the PLT part of the GOT rather than (traditional on other architectures) calls to the PLT'
complete -c gcc -o mgotplt --description 'With -fpic and -fPIC, don’t generate (do generate) instruction sequences that load addresses for functions from the PLT part of the GOT rather than (traditional on other architectures) calls to the PLT'
complete -c gcc -o maout --description 'Legacy no-op option only recognized with the cris-axis-aout target'
complete -c gcc -o melf --description 'Legacy no-op option only recognized with the cris-axis-elf and cris-axis-linux-gnu targets'
complete -c gcc -o melinux --description 'Only recognized with the cris-axis-aout target, where it selects a GNU/linux-like multilib, include files and instruction set for -march=v8'
complete -c gcc -o mlinux --description 'Legacy no-op option only recognized with the cris-axis-linux-gnu target'
complete -c gcc -o sim --description 'This option, recognized for the cris-axis-aout and cris-axis-elf arranges to link with input-output functions from a simulator library'
complete -c gcc -o sim2 --description 'Like -sim, but pass linker options to locate initialized data at 0x40000000 and zero-initialized data at 0x80000000'
complete -c gcc -o mmac --description 'Enable the use of multiply-accumulate instructions'
complete -c gcc -o mpush-args --description 'Push instructions will be used to pass outgoing arguments when functions are called'
complete -c gcc -o Fdir --description 'Add the framework directory dir to the head of the list of directories to be searched for header files'
complete -c gcc -o gused --description 'Emit debugging information for symbols that are used'
complete -c gcc -o gfull --description 'Emit debugging information for all symbols and types'
complete -c gcc -o mmacosx-version-min --description '=version The earliest version of MacOS X that this executable will run on is version'
complete -c gcc -o mone-byte-bool --description 'Override the defaults for bool so that sizeof(bool)==1'
complete -c gcc -o mfix-and-continue --description 'Generate code suitable for fast turn around development'
complete -c gcc -o ffix-and-continue --description 'Generate code suitable for fast turn around development'
complete -c gcc -o findirect-data --description 'Generate code suitable for fast turn around development'
complete -c gcc -o all_load --description 'Loads all members of static archive libraries'
complete -c gcc -o arch_errors_fatal --description 'Cause the errors having to do with files that have the wrong architecture to be fatal'
complete -c gcc -o bind_at_load --description 'Causes the output file to be marked such that the dynamic linker will bind all undefined references when the file is loaded or launched'
complete -c gcc -o bundle --description 'Produce a Mach-o bundle format file'
complete -c gcc -o bundle_loader --description 'This option specifies the executable that will be loading the build output file being linked'
complete -c gcc -o dynamiclib --description 'When passed this option, GCC will produce a dynamic library instead of an executable when linking, using the Darwin libtool command'
complete -c gcc -o force_cpusubtype_ALL --description 'This causes GCC’s output file to have the ALL subtype, instead of one controlled by the -mcpu or -march option'
complete -c gcc -o allowable_client --description 'These options are passed to the Darwin linker'
complete -c gcc -o client_name --description 'These options are passed to the Darwin linker'
complete -c gcc -o compatibility_version --description 'These options are passed to the Darwin linker'
complete -c gcc -o current_version --description 'These options are passed to the Darwin linker'
complete -c gcc -o dead_strip --description 'These options are passed to the Darwin linker'
complete -c gcc -o dependency-file --description 'These options are passed to the Darwin linker'
complete -c gcc -o dylib_file --description 'These options are passed to the Darwin linker'
complete -c gcc -o dylinker_install_name --description 'These options are passed to the Darwin linker'
complete -c gcc -o dynamic --description 'These options are passed to the Darwin linker'
complete -c gcc -o exported_symbols_list --description 'These options are passed to the Darwin linker'
complete -c gcc -o filelist --description 'These options are passed to the Darwin linker'
complete -c gcc -o flat_namespace --description 'These options are passed to the Darwin linker'
complete -c gcc -o force_flat_namespace --description 'These options are passed to the Darwin linker'
complete -c gcc -o headerpad_max_install_names --description 'These options are passed to the Darwin linker'
complete -c gcc -o image_base --description 'These options are passed to the Darwin linker'
complete -c gcc -o init --description 'These options are passed to the Darwin linker'
complete -c gcc -o install_name --description 'These options are passed to the Darwin linker'
complete -c gcc -o keep_private_externs --description 'These options are passed to the Darwin linker'
complete -c gcc -o multi_module --description 'These options are passed to the Darwin linker'
complete -c gcc -o multiply_defined --description 'These options are passed to the Darwin linker'
complete -c gcc -o multiply_defined_unused --description 'These options are passed to the Darwin linker'
complete -c gcc -o noall_load --description 'These options are passed to the Darwin linker'
complete -c gcc -o no_dead_strip_inits_and_terms --description 'These options are passed to the Darwin linker'
complete -c gcc -o nofixprebinding --description 'These options are passed to the Darwin linker'
complete -c gcc -o nomultidefs --description 'These options are passed to the Darwin linker'
complete -c gcc -o noprebind --description 'These options are passed to the Darwin linker'
complete -c gcc -o noseglinkedit --description 'These options are passed to the Darwin linker'
complete -c gcc -o pagezero_size --description 'These options are passed to the Darwin linker'
complete -c gcc -o prebind --description 'These options are passed to the Darwin linker'
complete -c gcc -o prebind_all_twolevel_modules --description 'These options are passed to the Darwin linker'
complete -c gcc -o private_bundle --description 'These options are passed to the Darwin linker'
complete -c gcc -o read_only_relocs --description 'These options are passed to the Darwin linker'
complete -c gcc -o sectalign --description 'These options are passed to the Darwin linker'
complete -c gcc -o sectobjectsymbols --description 'These options are passed to the Darwin linker'
complete -c gcc -o whyload --description 'These options are passed to the Darwin linker'
complete -c gcc -o seg1addr --description 'These options are passed to the Darwin linker'
complete -c gcc -o sectcreate --description 'These options are passed to the Darwin linker'
complete -c gcc -o sectobjectsymbols --description 'These options are passed to the Darwin linker'
complete -c gcc -o sectorder --description 'These options are passed to the Darwin linker'
complete -c gcc -o segaddr --description 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_only_addr --description 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_write_addr --description 'These options are passed to the Darwin linker'
complete -c gcc -o seg_addr_table --description 'These options are passed to the Darwin linker'
complete -c gcc -o seg_addr_table_filename --description 'These options are passed to the Darwin linker'
complete -c gcc -o seglinkedit --description 'These options are passed to the Darwin linker'
complete -c gcc -o segprot --description 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_only_addr --description 'These options are passed to the Darwin linker'
complete -c gcc -o segs_read_write_addr --description 'These options are passed to the Darwin linker'
complete -c gcc -o single_module --description 'These options are passed to the Darwin linker'
complete -c gcc -o static --description 'These options are passed to the Darwin linker'
complete -c gcc -o sub_library --description 'These options are passed to the Darwin linker'
complete -c gcc -o sub_umbrella --description 'These options are passed to the Darwin linker'
complete -c gcc -o twolevel_namespace --description 'These options are passed to the Darwin linker'
complete -c gcc -o umbrella --description 'These options are passed to the Darwin linker'
complete -c gcc -o undefined --description 'These options are passed to the Darwin linker'
complete -c gcc -o unexported_symbols_list --description 'These options are passed to the Darwin linker'
complete -c gcc -o weak_reference_mismatches --description 'These options are passed to the Darwin linker'
complete -c gcc -o whatsloaded --description 'These options are passed to the Darwin linker'
complete -c gcc -o mno-soft-float --description 'Use (do not use) the hardware floating-point instructions for floating-point operations'
complete -c gcc -o msoft-float --description 'Use (do not use) the hardware floating-point instructions for floating-point operations'
complete -c gcc -o mfp-reg --description 'Generate code that uses (does not use) the floating-point register set'
complete -c gcc -o mno-fp-regs --description 'Generate code that uses (does not use) the floating-point register set'
complete -c gcc -o mieee --description 'The Alpha architecture implements floating-point hardware optimized for maximum performance'
complete -c gcc -o mieee-with-inexact --description 'This is like -mieee except the generated code also maintains the IEEE inexact-flag'
complete -c gcc -o mfp-trap-mode --description 'This option controls what floating-point related traps are enabled'
complete -c gcc -o mode --description 'This option controls what floating-point related traps are enabled'
complete -c gcc -o mfp-rounding-mode --description 'Selects the IEEE rounding mode'
complete -c gcc -o mode --description 'Selects the IEEE rounding mode'
complete -c gcc -o mtrap-precision --description 'In the Alpha architecture, floating point traps are imprecise'
complete -c gcc -o precision --description 'In the Alpha architecture, floating point traps are imprecise'
complete -c gcc -o mieee-conformant --description 'This option marks the generated code as IEEE conformant'
complete -c gcc -o mbuild-constants --description 'Normally GCC examines a 32- or 64-bit integer constant to see if it can construct it from smaller constants in two or three instructions'
complete -c gcc -o malpha-as --description 'Select whether to generate code to be assembled by the vendor-supplied assembler (-malpha-as) or by the GNU assembler -mgas'
complete -c gcc -o mgas --description 'Select whether to generate code to be assembled by the vendor-supplied assembler (-malpha-as) or by the GNU assembler -mgas'
complete -c gcc -o mbwx --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-bwx --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mcix --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-cix --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mfix --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-fix --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mmax --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mno-max --description 'Indicate whether GCC should generate code to use the optional BWX, CIX, FIX and MAX instruction sets'
complete -c gcc -o mfloat-vax --description 'Generate code that uses (does not use) VAX F and G floating point arithmetic instead of IEEE single and double precision'
complete -c gcc -o mfloat-ieee --description 'Generate code that uses (does not use) VAX F and G floating point arithmetic instead of IEEE single and double precision'
complete -c gcc -o mexplicit-relocs --description 'Older Alpha assemblers provided no way to generate symbol relocations except via assembler macros'
complete -c gcc -o mno-explicit-relocs --description 'Older Alpha assemblers provided no way to generate symbol relocations except via assembler macros'
complete -c gcc -o msmall-data --description 'When -mexplicit-relocs is in effect, static data is accessed via gp-relative relocations'
complete -c gcc -o mlarge-data --description 'When -mexplicit-relocs is in effect, static data is accessed via gp-relative relocations'
complete -c gcc -o msmall-text --description 'When -msmall-text is used, the compiler assumes that the code of the entire program (or shared library) fits in 4MB, and is thus reachable with a branch instruction'
complete -c gcc -o mlarge-text --description 'When -msmall-text is used, the compiler assumes that the code of the entire program (or shared library) fits in 4MB, and is thus reachable with a branch instruction'
complete -c gcc -o mcpu --description '=cpu_type Set the instruction set and instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mtune --description '=cpu_type Set only the instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mmemory-latency --description '=time Sets the latency the scheduler should assume for typical memory references as seen by the application'
complete -c gcc -o mvms-return-codes --description 'Return VMS condition codes from main'
complete -c gcc -o mgpr-32 --description 'Only use the first 32 general purpose registers'
complete -c gcc -o mgpr-64 --description 'Use all 64 general purpose registers'
complete -c gcc -o mfpr-32 --description 'Use only the first 32 floating point registers'
complete -c gcc -o mfpr-64 --description 'Use hardware instructions for floating point operations'
complete -c gcc -o mhard-float --description 'Use hardware instructions for floating point operations'
complete -c gcc -o msoft-float --description 'Use library routines for floating point operations'
complete -c gcc -o malloc-cc --description 'Dynamically allocate condition code registers'
complete -c gcc -o mfixed-cc --description 'Do not try to dynamically allocate condition code registers, only use "icc0" and "fcc0"'
complete -c gcc -o mdword --description 'Change ABI to use double word insns'
complete -c gcc -o mno-dword --description 'Do not use double word instructions'
complete -c gcc -o mdouble --description 'Use floating point double instructions'
complete -c gcc -o mno-double --description 'Do not use floating point double instructions'
complete -c gcc -o mmedia --description 'Use media instructions'
complete -c gcc -o mno-media --description 'Do not use media instructions'
complete -c gcc -o mmuladd --description 'Use multiply and add/subtract instructions'
complete -c gcc -o mno-muladd --description 'Do not use multiply and add/subtract instructions'
complete -c gcc -o mfdpic --description 'Select the FDPIC ABI, that uses function descriptors to represent pointers to functions'
complete -c gcc -o minline-plt --description 'Enable inlining of PLT entries in function calls to functions that are not known to bind locally'
complete -c gcc -o mTLS --description 'Assume a large TLS segment when generating thread-local code'
complete -c gcc -o mtls --description 'Do not assume a large TLS segment when generating thread-local code'
complete -c gcc -o mgprel-ro --description 'Enable the use of "GPREL" relocations in the FDPIC ABI for data that is known to be in read-only sections'
complete -c gcc -o multilib-library-pic --description 'Link with the (library, not FD) pic libraries'
complete -c gcc -o mlinked-fp --description 'Follow the EABI requirement of always creating a frame pointer whenever a stack frame is allocated'
complete -c gcc -o mlong-calls --description 'Use indirect addressing to call functions outside the current compilation unit'
complete -c gcc -o malign-labels --description 'Try to align labels to an 8-byte boundary by inserting nops into the previous packet'
complete -c gcc -o mlibrary-pic --description 'Generate position-independent EABI code'
complete -c gcc -o macc-4 --description 'Use only the first four media accumulator registers'
complete -c gcc -o macc-8 --description 'Use all eight media accumulator registers'
complete -c gcc -o mpack --description 'Pack VLIW instructions'
complete -c gcc -o mno-pack --description 'Do not pack VLIW instructions'
complete -c gcc -o mno-eflags --description 'Do not mark ABI switches in e_flags'
complete -c gcc -o mcond-move --description 'Enable the use of conditional-move instructions (default)'
complete -c gcc -o mno-cond-move --description 'Disable the use of conditional-move instructions'
complete -c gcc -o mscc --description 'Enable the use of conditional set instructions (default)'
complete -c gcc -o mno-scc --description 'Disable the use of conditional set instructions'
complete -c gcc -o mcond-exec --description 'Enable the use of conditional execution (default)'
complete -c gcc -o mno-cond-exec --description 'Disable the use of conditional execution'
complete -c gcc -o mvliw-branch --description 'Run a pass to pack branches into VLIW instructions (default)'
complete -c gcc -o mno-vliw-branch --description 'Do not run a pass to pack branches into VLIW instructions'
complete -c gcc -o mmulti-cond-exec --description 'Enable optimization of "&&" and "││" in conditional execution (default)'
complete -c gcc -o mno-multi-cond-exec --description 'Disable optimization of "&&" and "││" in conditional execution'
complete -c gcc -o mnested-cond-exec --description 'Enable nested conditional execution optimizations (default)'
complete -c gcc -o mno-nested-cond-exec --description 'Disable nested conditional execution optimizations'
complete -c gcc -o moptimize-membar --description 'This switch removes redundant "membar" instructions from the compiler generated code'
complete -c gcc -o mno-optimize-membar --description 'This switch disables the automatic removal of redundant "membar" instructions from the generated code'
complete -c gcc -o mtomcat-stats --description 'Cause gas to print out tomcat statistics'
complete -c gcc -o mcpu --description '=cpu Select the processor type for which to generate code'
complete -c gcc -o mrelax --description 'Shorten some address references at link time, when possible; uses the linker option -relax'
complete -c gcc -o mh --description 'Generate code for the H8/300H'
complete -c gcc -o ms --description 'Generate code for the H8S'
complete -c gcc -o mn --description 'Generate code for the H8S and H8/300H in the normal mode'
complete -c gcc -o ms2600 --description 'Generate code for the H8S/2600'
complete -c gcc -o mint32 --description 'Make "int" data 32 bits by default'
complete -c gcc -o malign-300 --description 'On the H8/300H and H8S, use the same alignment rules as for the H8/300'
complete -c gcc -o march --description 'Generate code for the specified architecture'
complete -c gcc -o type --description 'Generate code for the specified architecture'
complete -c gcc -o mpa-risc-1-0 --description 'Synonyms for -march=1'
complete -c gcc -o mpa-risc-1-1 --description 'Synonyms for -march=1'
complete -c gcc -o mpa-risc-2-0 --description 'Synonyms for -march=1'
complete -c gcc -o mbig-switch --description 'Generate code suitable for big switch tables'
complete -c gcc -o mjump-in-delay --description 'Fill delay slots of function calls with unconditional jump instructions by modifying the return pointer for the function call to be the target of the conditional jump'
complete -c gcc -o mdisable-fpregs --description 'Prevent floating point registers from being used in any manner'
complete -c gcc -o mdisable-indexing --description 'Prevent the compiler from using indexing address modes'
complete -c gcc -o mno-space-regs --description 'Generate code that assumes the target has no space registers'
complete -c gcc -o mfast-indirect-calls --description 'Generate code that assumes calls never cross space boundaries'
complete -c gcc -o mfixed-range --description 'Generate code treating the given register range as fixed registers'
complete -c gcc -o range --description 'Generate code treating the given register range as fixed registers'
complete -c gcc -o mlong-load-store --description 'Generate 3-instruction load and store sequences as sometimes required by the HP-UX 10 linker'
complete -c gcc -o mportable-runtime --description 'Use the portable calling conventions proposed by HP for ELF systems'
complete -c gcc -o mgas --description 'Enable the use of assembler directives only GAS understands'
complete -c gcc -o mschedule --description 'Schedule code according to the constraints for the machine type cpu-type'
complete -c gcc -o type --description 'Schedule code according to the constraints for the machine type cpu-type'
complete -c gcc -o mlinker-opt --description 'Enable the optimization pass in the HP-UX linker'
complete -c gcc -o msoft-float --description 'Generate output containing library calls for floating point'
complete -c gcc -o msio --description 'Generate the predefine, "_SIO", for server IO'
complete -c gcc -o mgnu-ld --description 'Use GNU ld specific options'
complete -c gcc -o mhp-ld --description 'Use HP ld specific options'
complete -c gcc -o mlong-calls --description 'Generate code that uses long call sequences'
complete -c gcc -o munix --description 'Generate compiler predefines and select a startfile for the specified UNIX standard'
complete -c gcc -o std --description 'Generate compiler predefines and select a startfile for the specified UNIX standard'
complete -c gcc -o nolibdld --description 'Suppress the generation of link options to search libdld'
complete -c gcc -o static --description 'The HP-UX implementation of setlocale in libc has a dependency on libdld'
complete -c gcc -o threads --description 'Add support for multithreading with the dce thread library under HP-UX'
complete -c gcc -o mtune --description 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o type --description 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o march --description 'Generate instructions for the machine type cpu-type'
complete -c gcc -o type --description 'Generate instructions for the machine type cpu-type'
complete -c gcc -o mcpu --description 'A deprecated synonym for -mtune'
complete -c gcc -o type --description 'A deprecated synonym for -mtune'
complete -c gcc -o m386 --description 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o m486 --description 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o mpentium --description 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o mpentiumpro --description 'These options are synonyms for -mtune=i386, -mtune=i486, -mtune=pentium, and -mtune=pentiumpro respectively'
complete -c gcc -o mfpmath --description '=unit Generate floating point arithmetics for selected unit unit'
complete -c gcc -o masm --description '=dialect Output asm instructions using selected dialect'
complete -c gcc -o mieee-fp --description 'Control whether or not the compiler uses IEEE floating point comparisons'
complete -c gcc -o mno-ieee-fp --description 'Control whether or not the compiler uses IEEE floating point comparisons'
complete -c gcc -o msoft-float --description 'Generate output containing library calls for floating point'
complete -c gcc -o mno-fp-ret-in-387 --description 'Do not use the FPU registers for return values of functions'
complete -c gcc -o mno-fancy-math-387 --description 'Some 387 emulators do not support the "sin", "cos" and "sqrt" instructions for the 387'
complete -c gcc -o malign-double --description 'Control whether GCC aligns "double", "long double", and "long long" variables on a two word boundary or a one word boundary'
complete -c gcc -o mno-align-double --description 'Control whether GCC aligns "double", "long double", and "long long" variables on a two word boundary or a one word boundary'
complete -c gcc -o m96bit-long-double --description 'These switches control the size of "long double" type'
complete -c gcc -o m128bit-long-double --description 'These switches control the size of "long double" type'
complete -c gcc -o mmlarge-data-threshold --description '=number When -mcmodel=medium is specified, the data greater than threshold are placed in large data section'
complete -c gcc -o msvr3-shlib --description 'Control whether GCC places uninitialized local variables into the "bss" or "data" segments'
complete -c gcc -o mno-svr3-shlib --description 'Control whether GCC places uninitialized local variables into the "bss" or "data" segments'
complete -c gcc -o mrtd --description 'Use a different function-calling convention, in which functions that take a fixed number of arguments return with the "ret" num instruction, which pops their arguments while returning'
complete -c gcc -o mregparm --description '=num Control how many registers are used to pass integer arguments'
complete -c gcc -o msseregparm --description 'Use SSE register passing conventions for float and double arguments and return values'
complete -c gcc -o mpreferred-stack-boundary --description '=num Attempt to keep the stack boundary aligned to a 2 raised to num byte boundary'
complete -c gcc -o mmmx --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-mmx --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o msse --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-sse --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o msse2 --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-sse2 --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o msse3 --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-sse3 --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mmni --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-mni --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o m3dnow --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mno-3dnow --description 'These switches enable or disable the use of instructions in the MMX, SSE, SSE2 or 3DNow! extended instruction sets'
complete -c gcc -o mpush-args --description 'Use PUSH operations to store outgoing parameters'
complete -c gcc -o mno-push-args --description 'Use PUSH operations to store outgoing parameters'
complete -c gcc -o maccumulate-outgoing-args --description 'If enabled, the maximum amount of space required for outgoing arguments will be computed in the function prologue'
complete -c gcc -o mthreads --description 'Support thread-safe exception handling on Mingw32'
complete -c gcc -o mno-align-stringops --description 'Do not align destination of inlined string operations'
complete -c gcc -o minline-all-stringops --description 'By default GCC inlines string operations only when destination is known to be aligned at least to 4 byte boundary'
complete -c gcc -o momit-leaf-frame-pointer --description 'Don’t keep the frame pointer in a register for leaf functions'
complete -c gcc -o mtls-direct-seg-refs --description 'Controls whether TLS variables may be accessed with offsets from the TLS segment register (%gs for 32-bit, %fs for 64-bit), or whether the thread base pointer must be added'
complete -c gcc -o mno-tls-direct-seg-refs --description 'Controls whether TLS variables may be accessed with offsets from the TLS segment register (%gs for 32-bit, %fs for 64-bit), or whether the thread base pointer must be added'
complete -c gcc -o m32 --description 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o m64 --description 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mno-red-zone --description 'Do not use a so called red zone for x86-64 code'
complete -c gcc -o mcmodel --description '=small Generate code for the small code model: the program and its symbols must be linked in the lower 2 GB of the address space'
complete -c gcc -o mcmodel --description '=kernel Generate code for the kernel code model'
complete -c gcc -o mcmodel --description '=medium Generate code for the medium model: The program is linked in the lower 2 GB of the address space but symbols can be located anywhere in the address space'
complete -c gcc -o mcmodel --description '=large Generate code for the large model: This model makes no assumptions about addresses and sizes of sections'
complete -c gcc -o mbig-endian --description 'Generate code for a big endian target'
complete -c gcc -o mlittle-endian --description 'Generate code for a little endian target'
complete -c gcc -o mgnu-as --description 'Generate (or don’t) code for the GNU assembler'
complete -c gcc -o mno-gnu-as --description 'Generate (or don’t) code for the GNU assembler'
complete -c gcc -o mgnu-ld --description 'Generate (or don’t) code for the GNU linker'
complete -c gcc -o mno-gnu-ld --description 'Generate (or don’t) code for the GNU linker'
complete -c gcc -o mno-pic --description 'Generate code that does not use a global pointer register'
complete -c gcc -o mvolatile-asm-stop --description 'Generate (or don’t) a stop bit immediately before and after volatile asm statements'
complete -c gcc -o mno-volatile-asm-stop --description 'Generate (or don’t) a stop bit immediately before and after volatile asm statements'
complete -c gcc -o mregister-names --description 'Generate (or don’t) in, loc, and out register names for the stacked registers'
complete -c gcc -o mno-register-names --description 'Generate (or don’t) in, loc, and out register names for the stacked registers'
complete -c gcc -o mno-sdata --description 'Disable (or enable) optimizations that use the small data section'
complete -c gcc -o msdata --description 'Disable (or enable) optimizations that use the small data section'
complete -c gcc -o mconstant-gp --description 'Generate code that uses a single constant global pointer value'
complete -c gcc -o mauto-pic --description 'Generate code that is self-relocatable'
complete -c gcc -o minline-float-divide-min-latency --description 'Generate code for inline divides of floating point values using the minimum latency algorithm'
complete -c gcc -o minline-float-divide-max-throughput --description 'Generate code for inline divides of floating point values using the maximum throughput algorithm'
complete -c gcc -o minline-int-divide-min-latency --description 'Generate code for inline divides of integer values using the minimum latency algorithm'
complete -c gcc -o minline-int-divide-max-throughput --description 'Generate code for inline divides of integer values using the maximum throughput algorithm'
complete -c gcc -o minline-sqrt-min-latency --description 'Generate code for inline square roots using the minimum latency algorithm'
complete -c gcc -o minline-sqrt-max-throughput --description 'Generate code for inline square roots using the maximum throughput algorithm'
complete -c gcc -o mno-dwarf2-asm --description 'Don’t (or do) generate assembler code for the DWARF2 line number debugging info'
complete -c gcc -o mdwarf2-asm --description 'Don’t (or do) generate assembler code for the DWARF2 line number debugging info'
complete -c gcc -o mearly-stop-bits --description 'Allow stop bits to be placed earlier than immediately preceding the instruction that triggered the stop bit'
complete -c gcc -o mno-early-stop-bits --description 'Allow stop bits to be placed earlier than immediately preceding the instruction that triggered the stop bit'
complete -c gcc -o mfixed-range --description 'Generate code treating the given register range as fixed registers'
complete -c gcc -o range --description 'Generate code treating the given register range as fixed registers'
complete -c gcc -o mtls-size --description 'Specify bit size of immediate TLS offsets'
complete -c gcc -o size --description 'Specify bit size of immediate TLS offsets'
complete -c gcc -o mtune --description 'Tune the instruction scheduling for a particular CPU, Valid values are itanium, itanium1, merced, itanium2, and mckinley'
complete -c gcc -o type --description 'Tune the instruction scheduling for a particular CPU, Valid values are itanium, itanium1, merced, itanium2, and mckinley'
complete -c gcc -o mt --description 'Add support for multithreading using the POSIX threads library'
complete -c gcc -o pthread --description 'Add support for multithreading using the POSIX threads library'
complete -c gcc -o milp32 --description 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mlp64 --description 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mcpu --description '=name Select the CPU for which code is generated'
complete -c gcc -o msim --description 'Specifies that the program will be run on the simulator'
complete -c gcc -o memregs --description '=number Specifies the number of memory-based pseudo-registers GCC will use during code generation'
complete -c gcc -o m32r2 --description 'Generate code for the M32R/2'
complete -c gcc -o m32rx --description 'Generate code for the M32R/X'
complete -c gcc -o m32r --description 'Generate code for the M32R'
complete -c gcc -o mmodel --description '=small Assume all objects live in the lower 16MB of memory (so that their addresses can be loaded with the "ld24" instruction), and assume all subroutines are reachable with the "bl" instruction'
complete -c gcc -o mmodel --description '=medium Assume objects may be anywhere in the 32-bit address space (the compiler will generate "seth/add3" instructions to load their addresses), and assume all subroutines are reachable with the "bl" instruction'
complete -c gcc -o mmodel --description '=large Assume objects may be anywhere in the 32-bit address space (the compiler will generate "seth/add3" instructions to load their addresses), and assume subroutines may not be reachable with the "bl" instruction (the compiler will generate the much slower "seth/add3/jl" instruction sequence)'
complete -c gcc -o msdata --description '=none Disable use of the small data area'
complete -c gcc -o msdata --description '=sdata Put small global and static data in the small data area, but do not generate special code to reference them'
complete -c gcc -o msdata --description '=use Put small global and static data in the small data area, and generate special instructions to reference them'
complete -c gcc -s G --description 'Put global and static objects less than or equal to num bytes into the small data or bss sections instead of the normal data or bss sections'
complete -c gcc -o mdebug --description 'Makes the M32R specific code in the compiler display some statistics that might help in debugging programs'
complete -c gcc -o malign-loops --description 'Align all loops to a 32-byte boundary'
complete -c gcc -o mno-align-loops --description 'Do not enforce a 32-byte alignment for loops'
complete -c gcc -o missue-rate --description '=number Issue number instructions per cycle'
complete -c gcc -o mbranch-cost --description '=number number can only be 1 or 2'
complete -c gcc -o mflush-trap --description '=number Specifies the trap number to use to flush the cache'
complete -c gcc -o mno-flush-trap --description 'Specifies that the cache cannot be flushed by using a trap'
complete -c gcc -o mflush-func --description '=name Specifies the name of the operating system function to call to flush the cache'
complete -c gcc -o mno-flush-func --description 'Indicates that there is no OS function for flushing the cache'
complete -c gcc -o m68000 --description 'Generate output for a 68000'
complete -c gcc -o mc68000 --description 'Generate output for a 68000'
complete -c gcc -o m68020 --description 'Generate output for a 68020'
complete -c gcc -o mc68020 --description 'Generate output for a 68020'
complete -c gcc -o m68881 --description 'Generate output containing 68881 instructions for floating point'
complete -c gcc -o m68030 --description 'Generate output for a 68030'
complete -c gcc -o m68040 --description 'Generate output for a 68040'
complete -c gcc -o m68060 --description 'Generate output for a 68060'
complete -c gcc -o mcpu32 --description 'Generate output for a CPU32'
complete -c gcc -o m5200 --description 'Generate output for a 520X "coldfire" family cpu'
complete -c gcc -o m68020-40 --description 'Generate output for a 68040, without using any of the new instructions'
complete -c gcc -o m68020-60 --description 'Generate output for a 68060, without using any of the new instructions'
complete -c gcc -o msoft-float --description 'Generate output containing library calls for floating point'
complete -c gcc -o mshort --description 'Consider type "int" to be 16 bits wide, like "short int"'
complete -c gcc -o mnobitfield --description 'Do not use the bit-field instructions'
complete -c gcc -o mbitfield --description 'Do use the bit-field instructions'
complete -c gcc -o mrtd --description 'Use a different function-calling convention, in which functions that take a fixed number of arguments return with the "rtd" instruction, which pops their arguments while returning'
complete -c gcc -o malign-int --description 'Control whether GCC aligns "int", "long", "long long", "float", "double", and "long double" variables on a 32-bit boundary (-malign-int) or a 16-bit boundary (-mno-align-int)'
complete -c gcc -o mno-align-int --description 'Control whether GCC aligns "int", "long", "long long", "float", "double", and "long double" variables on a 32-bit boundary (-malign-int) or a 16-bit boundary (-mno-align-int)'
complete -c gcc -o mpcrel --description 'Use the pc-relative addressing mode of the 68000 directly, instead of using a global offset table'
complete -c gcc -o mno-strict-align --description 'Do not (do) assume that unaligned memory references will be handled by the system'
complete -c gcc -o mstrict-align --description 'Do not (do) assume that unaligned memory references will be handled by the system'
complete -c gcc -o msep-data --description 'Generate code that allows the data segment to be located in a different area of memory from the text segment'
complete -c gcc -o mno-sep-data --description 'Generate code that assumes that the data segment follows the text segment'
complete -c gcc -o mid-shared-library --description 'Generate code that supports shared libraries via the library ID method'
complete -c gcc -o mno-id-shared-library --description 'Generate code that doesn’t assume ID based shared libraries are being used'
complete -c gcc -o mshared-library-id --description '=n Specified the identification number of the ID based shared library being compiled'
complete -c gcc -o m6811 --description 'Generate output for a 68HC11'
complete -c gcc -o m68hc11 --description 'Generate output for a 68HC11'
complete -c gcc -o m6812 --description 'Generate output for a 68HC12'
complete -c gcc -o m68hc12 --description 'Generate output for a 68HC12'
complete -c gcc -o m68S12 --description 'Generate output for a 68HCS12'
complete -c gcc -o m68hcs12 --description 'Generate output for a 68HCS12'
complete -c gcc -o mauto-incdec --description 'Enable the use of 68HC12 pre and post auto-increment and autodecrement addressing modes'
complete -c gcc -o minmax --description 'Enable the use of 68HC12 min and max instructions'
complete -c gcc -o nominmax --description 'Enable the use of 68HC12 min and max instructions'
complete -c gcc -o mlong-calls --description 'Treat all calls as being far away (near)'
complete -c gcc -o mno-long-calls --description 'Treat all calls as being far away (near)'
complete -c gcc -o mshort --description 'Consider type "int" to be 16 bits wide, like "short int"'
complete -c gcc -o msoft-reg-count --description '=count Specify the number of pseudo-soft registers which are used for the code generation'
complete -c gcc -o mhardlit --description 'Inline constants into the code stream if it can be done in two instructions or less'
complete -c gcc -o mno-hardlit --description 'Inline constants into the code stream if it can be done in two instructions or less'
complete -c gcc -o mdiv --description 'Use the divide instruction'
complete -c gcc -o mno-div --description 'Use the divide instruction'
complete -c gcc -o mrelax-immediate --description 'Allow arbitrary sized immediates in bit operations'
complete -c gcc -o mno-relax-immediate --description 'Allow arbitrary sized immediates in bit operations'
complete -c gcc -o mwide-bitfields --description 'Always treat bit-fields as int-sized'
complete -c gcc -o mno-wide-bitfields --description 'Always treat bit-fields as int-sized'
complete -c gcc -o m4byte-functions --description 'Force all functions to be aligned to a four byte boundary'
complete -c gcc -o mno-4byte-functions --description 'Force all functions to be aligned to a four byte boundary'
complete -c gcc -o mcallgraph-data --description 'Emit callgraph information'
complete -c gcc -o mno-callgraph-data --description 'Emit callgraph information'
complete -c gcc -o mslow-bytes --description 'Prefer word access when reading byte quantities'
complete -c gcc -o mno-slow-bytes --description 'Prefer word access when reading byte quantities'
complete -c gcc -o mlittle-endian --description 'Generate code for a little endian target'
complete -c gcc -o mbig-endian --description 'Generate code for a little endian target'
complete -c gcc -o m210 --description 'Generate code for the 210 processor'
complete -c gcc -o m340 --description 'Generate code for the 210 processor'
complete -c gcc -o EB --description 'Generate big-endian code'
complete -c gcc -o EL --description 'Generate little-endian code'
complete -c gcc -o march --description '=arch Generate code that will run on arch, which can be the name of a generic MIPS ISA, or the name of a particular processor'
complete -c gcc -o mtune --description '=arch Optimize for arch'
complete -c gcc -o mips1 --description 'Equivalent to -march=mips1'
complete -c gcc -o mips2 --description 'Equivalent to -march=mips2'
complete -c gcc -o mips3 --description 'Equivalent to -march=mips3'
complete -c gcc -o mips4 --description 'Equivalent to -march=mips4'
complete -c gcc -o mips32 --description 'Equivalent to -march=mips32'
complete -c gcc -o mips32r2 --description 'Equivalent to -march=mips32r2'
complete -c gcc -o mips64 --description 'Equivalent to -march=mips64'
complete -c gcc -o mips16 --description 'Generate (do not generate) MIPS16 code'
complete -c gcc -o mno-mips16 --description 'Generate (do not generate) MIPS16 code'
complete -c gcc -o mabi --description '=eabi Generate code for the given ABI'
complete -c gcc -o mabi --description '=eabi Generate code for the given ABI'
complete -c gcc -o mabi --description '=eabi Generate code for the given ABI'
complete -c gcc -o mabi --description '=eabi Generate code for the given ABI'
complete -c gcc -o mabi --description '=eabi Generate code for the given ABI'
complete -c gcc -o mabicalls --description 'Generate (do not generate) SVR4-style position-independent code'
complete -c gcc -o mno-abicalls --description 'Generate (do not generate) SVR4-style position-independent code'
complete -c gcc -o mxgot --description 'Lift (do not lift) the usual restrictions on the size of the global offset table'
complete -c gcc -o mno-xgot --description 'Lift (do not lift) the usual restrictions on the size of the global offset table'
complete -c gcc -o mgp32 --description 'Assume that general-purpose registers are 32 bits wide'
complete -c gcc -o mgp64 --description 'Assume that general-purpose registers are 64 bits wide'
complete -c gcc -o mfp32 --description 'Assume that floating-point registers are 32 bits wide'
complete -c gcc -o mfp64 --description 'Assume that floating-point registers are 64 bits wide'
complete -c gcc -o mhard-float --description 'Use floating-point coprocessor instructions'
complete -c gcc -o msoft-float --description 'Do not use floating-point coprocessor instructions'
complete -c gcc -o msingle-float --description 'Assume that the floating-point coprocessor only supports singleprecision operations'
complete -c gcc -o mdouble-float --description 'Assume that the floating-point coprocessor supports double-precision operations'
complete -c gcc -o mdsp --description 'Use (do not use) the MIPS DSP ASE'
complete -c gcc -o mno-dsp --description 'Use (do not use) the MIPS DSP ASE'
complete -c gcc -o mpaired-single --description 'Use (do not use) paired-single floating-point instructions'
complete -c gcc -o mno-paired-single --description 'Use (do not use) paired-single floating-point instructions'
complete -c gcc -o mips3d --description 'Use (do not use) the MIPS-3D ASE'
complete -c gcc -o mno-mips3d --description 'Use (do not use) the MIPS-3D ASE'
complete -c gcc -o mlong64 --description 'Force "long" types to be 64 bits wide'
complete -c gcc -o mlong32 --description 'Force "long", "int", and pointer types to be 32 bits wide'
complete -c gcc -o msym32 --description 'Assume (do not assume) that all symbols have 32-bit values, regardless of the selected ABI'
complete -c gcc -o mno-sym32 --description 'Assume (do not assume) that all symbols have 32-bit values, regardless of the selected ABI'
complete -c gcc -s G --description 'Put global and static items less than or equal to num bytes into the small data or bss section instead of the normal data or bss section'
complete -c gcc -o membedded-data --description 'Allocate variables to the read-only data section first if possible, then next in the small data section if possible, otherwise in data'
complete -c gcc -o mno-embedded-data --description 'Allocate variables to the read-only data section first if possible, then next in the small data section if possible, otherwise in data'
complete -c gcc -o muninit-const-in-rodata --description 'Put uninitialized "const" variables in the read-only data section'
complete -c gcc -o mno-uninit-const-in-rodata --description 'Put uninitialized "const" variables in the read-only data section'
complete -c gcc -o msplit-addresses --description 'Enable (disable) use of the "%hi()" and "%lo()" assembler relocation operators'
complete -c gcc -o mno-split-addresses --description 'Enable (disable) use of the "%hi()" and "%lo()" assembler relocation operators'
complete -c gcc -o mexplicit-relocs --description 'Use (do not use) assembler relocation operators when dealing with symbolic addresses'
complete -c gcc -o mno-explicit-relocs --description 'Use (do not use) assembler relocation operators when dealing with symbolic addresses'
complete -c gcc -o mcheck-zero-division --description 'Trap (do not trap) on integer division by zero'
complete -c gcc -o mno-check-zero-division --description 'Trap (do not trap) on integer division by zero'
complete -c gcc -o mdivide-traps --description 'MIPS systems check for division by zero by generating either a conditional trap or a break instruction'
complete -c gcc -o mdivide-breaks --description 'MIPS systems check for division by zero by generating either a conditional trap or a break instruction'
complete -c gcc -o mmemcpy --description 'Force (do not force) the use of "memcpy()" for non-trivial block moves'
complete -c gcc -o mno-memcpy --description 'Force (do not force) the use of "memcpy()" for non-trivial block moves'
complete -c gcc -o mlong-calls --description 'Disable (do not disable) use of the "jal" instruction'
complete -c gcc -o mno-long-calls --description 'Disable (do not disable) use of the "jal" instruction'
complete -c gcc -o mmad --description 'Enable (disable) use of the "mad", "madu" and "mul" instructions, as provided by the R4650 ISA'
complete -c gcc -o mno-mad --description 'Enable (disable) use of the "mad", "madu" and "mul" instructions, as provided by the R4650 ISA'
complete -c gcc -o mfused-madd --description 'Enable (disable) use of the floating point multiply-accumulate instructions, when they are available'
complete -c gcc -o mno-fused-madd --description 'Enable (disable) use of the floating point multiply-accumulate instructions, when they are available'
complete -c gcc -o nocpp --description 'Tell the MIPS assembler to not run its preprocessor over user assembler files (with a '
complete -c gcc -o mfix-r4000 --description 'Work around certain R4000 CPU errata: - A double-word or a variable shift may give an incorrect result if executed immediately after starting an integer division'
complete -c gcc -o mno-fix-r4000 --description 'Work around certain R4000 CPU errata: - A double-word or a variable shift may give an incorrect result if executed immediately after starting an integer division'
complete -c gcc -o mfix-r4400 --description 'Work around certain R4400 CPU errata: - A double-word or a variable shift may give an incorrect result if executed immediately after starting an integer division'
complete -c gcc -o mno-fix-r4400 --description 'Work around certain R4400 CPU errata: - A double-word or a variable shift may give an incorrect result if executed immediately after starting an integer division'
complete -c gcc -o mfix-vr4120 --description 'Work around certain VR4120 errata: - "dmultu" does not always produce the correct result'
complete -c gcc -o mno-fix-vr4120 --description 'Work around certain VR4120 errata: - "dmultu" does not always produce the correct result'
complete -c gcc -o mfix-vr4130 --description 'Work around the VR4130 "mflo"/"mfhi" errata'
complete -c gcc -o mfix-sb1 --description 'Work around certain SB-1 CPU core errata'
complete -c gcc -o mno-fix-sb1 --description 'Work around certain SB-1 CPU core errata'
complete -c gcc -o mflush-func --description 'Specifies the function to call to flush the I and D caches, or to not call any such function'
complete -c gcc -o mno-flush-func --description 'Specifies the function to call to flush the I and D caches, or to not call any such function'
complete -c gcc -o mbranch-likely --description 'Enable or disable use of Branch Likely instructions, regardless of the default for the selected architecture'
complete -c gcc -o mno-branch-likely --description 'Enable or disable use of Branch Likely instructions, regardless of the default for the selected architecture'
complete -c gcc -o mfp-exceptions --description 'Specifies whether FP exceptions are enabled'
complete -c gcc -o mno-fp-exceptions --description 'Specifies whether FP exceptions are enabled'
complete -c gcc -o mvr4130-align --description 'The VR4130 pipeline is two-way superscalar, but can only issue two instructions together if the first one is 8-byte aligned'
complete -c gcc -o mno-vr4130-align --description 'The VR4130 pipeline is two-way superscalar, but can only issue two instructions together if the first one is 8-byte aligned'
complete -c gcc -o mlibfuncs --description 'Specify that intrinsic library functions are being compiled, passing all values in registers, no matter the size'
complete -c gcc -o mno-libfuncs --description 'Specify that intrinsic library functions are being compiled, passing all values in registers, no matter the size'
complete -c gcc -o mepsilon --description 'Generate floating-point comparison instructions that compare with respect to the "rE" epsilon register'
complete -c gcc -o mno-epsilon --description 'Generate floating-point comparison instructions that compare with respect to the "rE" epsilon register'
complete -c gcc -o mabi --description '=gnu Generate code that passes function parameters and return values that (in the called function) are seen as registers $0 and up, as opposed to the GNU ABI which uses global registers $231 and up'
complete -c gcc -o mabi --description '=gnu Generate code that passes function parameters and return values that (in the called function) are seen as registers $0 and up, as opposed to the GNU ABI which uses global registers $231 and up'
complete -c gcc -o mzero-extend --description 'When reading data from memory in sizes shorter than 64 bits, use (do not use) zero-extending load instructions by default, rather than sign-extending ones'
complete -c gcc -o mno-zero-extend --description 'When reading data from memory in sizes shorter than 64 bits, use (do not use) zero-extending load instructions by default, rather than sign-extending ones'
complete -c gcc -o mknuthdiv --description 'Make the result of a division yielding a remainder have the same sign as the divisor'
complete -c gcc -o mno-knuthdiv --description 'Make the result of a division yielding a remainder have the same sign as the divisor'
complete -c gcc -o mtoplevel-symbols --description 'Prepend (do not prepend) a : to all global symbols, so the assembly code can be used with the "PREFIX" assembly directive'
complete -c gcc -o mno-toplevel-symbols --description 'Prepend (do not prepend) a : to all global symbols, so the assembly code can be used with the "PREFIX" assembly directive'
complete -c gcc -o melf --description 'Generate an executable in the ELF format, rather than the default mmo format used by the mmix simulator'
complete -c gcc -o mbranch-predict --description 'Use (do not use) the probable-branch instructions, when static branch prediction indicates a probable branch'
complete -c gcc -o mno-branch-predict --description 'Use (do not use) the probable-branch instructions, when static branch prediction indicates a probable branch'
complete -c gcc -o mbase-addresses --description 'Generate (do not generate) code that uses base addresses'
complete -c gcc -o mno-base-addresses --description 'Generate (do not generate) code that uses base addresses'
complete -c gcc -o msingle-exit --description 'Force (do not force) generated code to have a single exit point in each function'
complete -c gcc -o mno-single-exit --description 'Force (do not force) generated code to have a single exit point in each function'
complete -c gcc -o mmult-bug --description 'Generate code to avoid bugs in the multiply instructions for the MN10300 processors'
complete -c gcc -o mno-mult-bug --description 'Do not generate code to avoid bugs in the multiply instructions for the MN10300 processors'
complete -c gcc -o mam33 --description 'Generate code which uses features specific to the AM33 processor'
complete -c gcc -o mno-am33 --description 'Do not generate code which uses features specific to the AM33 processor'
complete -c gcc -o mreturn-pointer-on-d0 --description 'When generating a function which returns a pointer, return the pointer in both "a0" and "d0"'
complete -c gcc -o mno-crt0 --description 'Do not link in the C run-time initialization object file'
complete -c gcc -o mrelax --description 'Indicate to the linker that it should perform a relaxation optimization pass to shorten branches, calls and absolute memory addresses'
complete -c gcc -o march --description 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o type --description 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o mbacc --description 'Use byte loads and stores when generating code'
complete -c gcc -o mno-bacc --description 'Do not use byte loads and stores when generating code'
complete -c gcc -o msim --description 'Do not link in the C run-time initialization object file crti'
complete -c gcc -o mno-crt0 --description 'Do not link in the C run-time initialization object file crti'
complete -c gcc -o mfpu --description 'Use hardware FPP floating point'
complete -c gcc -o msoft-float --description 'Do not use hardware floating point'
complete -c gcc -o mac0 --description 'Return floating-point results in ac0 (fr0 in Unix assembler syntax)'
complete -c gcc -o mno-ac0 --description 'Return floating-point results in memory'
complete -c gcc -o m40 --description 'Generate code for a PDP-11/40'
complete -c gcc -o m45 --description 'Generate code for a PDP-11/45'
complete -c gcc -o m10 --description 'Generate code for a PDP-11/10'
complete -c gcc -o mbcopy-builtin --description 'Use inline "movmemhi" patterns for copying memory'
complete -c gcc -o mbcopy --description 'Do not use inline "movmemhi" patterns for copying memory'
complete -c gcc -o mint16 --description 'Use 16-bit "int"'
complete -c gcc -o mno-int32 --description 'Use 16-bit "int"'
complete -c gcc -o mint32 --description 'Use 32-bit "int"'
complete -c gcc -o mno-int16 --description 'Use 32-bit "int"'
complete -c gcc -o mfloat64 --description 'Use 64-bit "float"'
complete -c gcc -o mno-float32 --description 'Use 64-bit "float"'
complete -c gcc -o mfloat32 --description 'Use 32-bit "float"'
complete -c gcc -o mno-float64 --description 'Use 32-bit "float"'
complete -c gcc -o mabshi --description 'Use "abshi2" pattern'
complete -c gcc -o mno-abshi --description 'Do not use "abshi2" pattern'
complete -c gcc -o mbranch-expensive --description 'Pretend that branches are expensive'
complete -c gcc -o mbranch-cheap --description 'Do not pretend that branches are expensive'
complete -c gcc -o msplit --description 'Generate code for a system with split I&D'
complete -c gcc -o mno-split --description 'Generate code for a system without split I&D'
complete -c gcc -o munix-asm --description 'Use Unix assembler syntax'
complete -c gcc -o mdec-asm --description 'Use DEC assembler syntax'
complete -c gcc -o mpower --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-power --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpower2 --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-power2 --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc-gpopt --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc-gpopt --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc-gfxopt --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc-gfxopt --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpowerpc64 --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-powerpc64 --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mmfcrf --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-mfcrf --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mpopcntb --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-popcntb --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mfprnd --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-fprnd --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mmfpgpr --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mno-mfpgpr --description 'GCC supports two related instruction set architectures for the RS/6000 and PowerPC'
complete -c gcc -o mnew-mnemonics --description 'Select which mnemonics to use in the generated assembler code'
complete -c gcc -o mold-mnemonics --description 'Select which mnemonics to use in the generated assembler code'
complete -c gcc -o mcpu --description '=cpu_type Set architecture type, register usage, choice of mnemonics, and instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mtune --description '=cpu_type Set the instruction scheduling parameters for machine type cpu_type, but do not set the architecture type, register usage, or choice of mnemonics, as -mcpu=cpu_type would'
complete -c gcc -o mswdiv --description 'Generate code to compute division as reciprocal estimate and iterative refinement, creating opportunities for increased throughput'
complete -c gcc -o mno-swdiv --description 'Generate code to compute division as reciprocal estimate and iterative refinement, creating opportunities for increased throughput'
complete -c gcc -o maltivec --description 'Generate code that uses (does not use) AltiVec instructions, and also enable the use of built-in functions that allow more direct access to the AltiVec instruction set'
complete -c gcc -o mno-altivec --description 'Generate code that uses (does not use) AltiVec instructions, and also enable the use of built-in functions that allow more direct access to the AltiVec instruction set'
complete -c gcc -o mvrsave --description 'Generate VRSAVE instructions when generating AltiVec code'
complete -c gcc -o mno-vrsave --description 'Generate VRSAVE instructions when generating AltiVec code'
complete -c gcc -o msecure-plt --description 'Generate code that allows ld and ld'
complete -c gcc -o mbss-plt --description 'Generate code that uses a BSS '
complete -c gcc -o misel --description 'This switch enables or disables the generation of ISEL instructions'
complete -c gcc -o mno-isel --description 'This switch enables or disables the generation of ISEL instructions'
complete -c gcc -o misel --description '=yes/no This switch has been deprecated'
complete -c gcc -o mspe --description 'This switch enables or disables the generation of SPE simd instructions'
complete -c gcc -o mno-isel --description 'This switch enables or disables the generation of SPE simd instructions'
complete -c gcc -o mspe --description '=yes/no This option has been deprecated'
complete -c gcc -o mfloat-gprs --description 'This switch enables or disables the generation of floating point operations on the general purpose registers for architectures that support it'
complete -c gcc -o mfloat-gprs --description 'This switch enables or disables the generation of floating point operations on the general purpose registers for architectures that support it'
complete -c gcc -o m32 --description 'Generate code for 32-bit or 64-bit environments of Darwin and SVR4 targets (including GNU/Linux)'
complete -c gcc -o m64 --description 'Generate code for 32-bit or 64-bit environments of Darwin and SVR4 targets (including GNU/Linux)'
complete -c gcc -o mfull-toc --description 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o mno-fp-in-toc --description 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o mno-sum-in-toc --description 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o mminimal-toc --description 'Modify generation of the TOC (Table Of Contents), which is created for every executable file'
complete -c gcc -o maix64 --description 'Enable 64-bit AIX ABI and calling convention: 64-bit pointers, 64-bit "long" type, and the infrastructure needed to support them'
complete -c gcc -o maix32 --description 'Enable 64-bit AIX ABI and calling convention: 64-bit pointers, 64-bit "long" type, and the infrastructure needed to support them'
complete -c gcc -o mxl-compat --description 'Produce code that conforms more closely to IBM XL compiler semantics when using AIX-compatible ABI'
complete -c gcc -o mno-xl-compat --description 'Produce code that conforms more closely to IBM XL compiler semantics when using AIX-compatible ABI'
complete -c gcc -o mpe --description 'Support IBM RS/6000 SP Parallel Environment (PE)'
complete -c gcc -o malign-natural --description 'On AIX, 32-bit Darwin, and 64-bit PowerPC GNU/Linux, the option -malign-natural overrides the ABI-defined alignment of larger types, such as floating-point doubles, on their natural size-based boundary'
complete -c gcc -o malign-power --description 'On AIX, 32-bit Darwin, and 64-bit PowerPC GNU/Linux, the option -malign-natural overrides the ABI-defined alignment of larger types, such as floating-point doubles, on their natural size-based boundary'
complete -c gcc -o msoft-float --description 'Generate code that does not use (uses) the floating-point register set'
complete -c gcc -o mhard-float --description 'Generate code that does not use (uses) the floating-point register set'
complete -c gcc -o mmultiple --description 'Generate code that uses (does not use) the load multiple word instructions and the store multiple word instructions'
complete -c gcc -o mno-multiple --description 'Generate code that uses (does not use) the load multiple word instructions and the store multiple word instructions'
complete -c gcc -o mstring --description 'Generate code that uses (does not use) the load string instructions and the store string word instructions to save multiple registers and do small block moves'
complete -c gcc -o mno-string --description 'Generate code that uses (does not use) the load string instructions and the store string word instructions to save multiple registers and do small block moves'
complete -c gcc -o mupdate --description 'Generate code that uses (does not use) the load or store instructions that update the base register to the address of the calculated memory location'
complete -c gcc -o mno-update --description 'Generate code that uses (does not use) the load or store instructions that update the base register to the address of the calculated memory location'
complete -c gcc -o mfused-madd --description 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mno-fused-madd --description 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mno-bit-align --description 'On System V'
complete -c gcc -o mbit-align --description 'On System V'
complete -c gcc -o mno-strict-align --description 'On System V'
complete -c gcc -o mstrict-align --description 'On System V'
complete -c gcc -o mrelocatable --description 'On embedded PowerPC systems generate code that allows (does not allow) the program to be relocated to a different address at runtime'
complete -c gcc -o mno-relocatable --description 'On embedded PowerPC systems generate code that allows (does not allow) the program to be relocated to a different address at runtime'
complete -c gcc -o mrelocatable-lib --description 'On embedded PowerPC systems generate code that allows (does not allow) the program to be relocated to a different address at runtime'
complete -c gcc -o mno-relocatable-lib --description 'On embedded PowerPC systems generate code that allows (does not allow) the program to be relocated to a different address at runtime'
complete -c gcc -o mno-toc --description 'On System V'
complete -c gcc -o mtoc --description 'On System V'
complete -c gcc -o mlittle --description 'On System V'
complete -c gcc -o mlittle-endian --description 'On System V'
complete -c gcc -o mbig --description 'On System V'
complete -c gcc -o mbig-endian --description 'On System V'
complete -c gcc -o mdynamic-no-pic --description 'On Darwin and Mac OS X systems, compile code so that it is not relocatable, but that its external references are relocatable'
complete -c gcc -o mprioritize-restricted-insns --description '=priority This option controls the priority that is assigned to dispatch-slot restricted instructions during the second scheduling pass'
complete -c gcc -o msched-costly-dep --description '=dependence_type This option controls which dependences are considered costly by the target during instruction scheduling'
complete -c gcc -o minsert-sched-nops --description '=scheme This option controls which nop insertion scheme will be used during the second scheduling pass'
complete -c gcc -o mcall-sysv --description 'On System V'
complete -c gcc -o mcall-sysv-eabi --description 'Specify both -mcall-sysv and -meabi options'
complete -c gcc -o mcall-sysv-noeabi --description 'Specify both -mcall-sysv and -mno-eabi options'
complete -c gcc -o mcall-solaris --description 'On System V'
complete -c gcc -o mcall-linux --description 'On System V'
complete -c gcc -o mcall-gnu --description 'On System V'
complete -c gcc -o mcall-netbsd --description 'On System V'
complete -c gcc -o maix-struct-return --description 'Return all structures in memory (as specified by the AIX ABI)'
complete -c gcc -o msvr4-struct-return --description 'Return structures smaller than 8 bytes in registers (as specified by the SVR4 ABI)'
complete -c gcc -o mabi --description 'Extend the current ABI with a particular extension, or remove such extension'
complete -c gcc -o type --description 'Extend the current ABI with a particular extension, or remove such extension'
complete -c gcc -o mabi --description '=spe Extend the current ABI with SPE ABI extensions'
complete -c gcc -o mabi --description 'Disable Booke SPE ABI extensions for the current ABI'
complete -c gcc -o spe --description 'Disable Booke SPE ABI extensions for the current ABI'
complete -c gcc -o mabi --description '=ibmlongdouble Change the current ABI to use IBM extended precision long double'
complete -c gcc -o mabi --description '=ieeelongdouble Change the current ABI to use IEEE extended precision long double'
complete -c gcc -o mprototype --description 'On System V'
complete -c gcc -o mno-prototype --description 'On System V'
complete -c gcc -o msim --description 'On embedded PowerPC systems, assume that the startup module is called sim-crt0'
complete -c gcc -o mmvme --description 'On embedded PowerPC systems, assume that the startup module is called crt0'
complete -c gcc -o mads --description 'On embedded PowerPC systems, assume that the startup module is called crt0'
complete -c gcc -o myellowknife --description 'On embedded PowerPC systems, assume that the startup module is called crt0'
complete -c gcc -o mvxworks --description 'On System V'
complete -c gcc -o mwindiss --description 'Specify that you are compiling for the WindISS simulation environment'
complete -c gcc -o memb --description 'On embedded PowerPC systems, set the PPC_EMB bit in the ELF flags header to indicate that eabi extended relocations are used'
complete -c gcc -o meabi --description 'On System V'
complete -c gcc -o mno-eabi --description 'On System V'
complete -c gcc -o msdata --description '=eabi On System V'
complete -c gcc -o msdata --description '=sysv On System V'
complete -c gcc -o msdata --description 'On System V'
complete -c gcc -o msdata --description 'On System V'
complete -c gcc -o msdata-data --description 'On System V'
complete -c gcc -o msdata --description 'On embedded PowerPC systems, put all initialized global and static data in the '
complete -c gcc -o mno-sdata --description 'On embedded PowerPC systems, put all initialized global and static data in the '
complete -c gcc -s G --description 'On embedded PowerPC systems, put global and static items less than or equal to num bytes into the small data or bss sections instead of the normal data or bss section'
complete -c gcc -o mregnames --description 'On System V'
complete -c gcc -o mno-regnames --description 'On System V'
complete -c gcc -o mlongcall --description 'Default to making all function calls indirectly, using a register, so that functions which reside further than 32 megabytes (33,554,432 bytes) from the current location can be called'
complete -c gcc -o mno-longcall --description 'Default to making all function calls indirectly, using a register, so that functions which reside further than 32 megabytes (33,554,432 bytes) from the current location can be called'
complete -c gcc -o pthread --description 'Adds support for multithreading with the pthreads library'
complete -c gcc -o mhard-float --description 'Use (do not use) the hardware floating-point instructions and registers for floating-point operations'
complete -c gcc -o msoft-float --description 'Use (do not use) the hardware floating-point instructions and registers for floating-point operations'
complete -c gcc -o mlong-double-64 --description 'These switches control the size of "long double" type'
complete -c gcc -o mlong-double-128 --description 'These switches control the size of "long double" type'
complete -c gcc -o mbackchain --description 'Store (do not store) the address of the caller’s frame as backchain pointer into the callee’s stack frame'
complete -c gcc -o mno-backchain --description 'Store (do not store) the address of the caller’s frame as backchain pointer into the callee’s stack frame'
complete -c gcc -o mpacked-stack --description 'Use (do not use) the packed stack layout'
complete -c gcc -o mno-packed-stack --description 'Use (do not use) the packed stack layout'
complete -c gcc -o msmall-exec --description 'Generate (or do not generate) code using the "bras" instruction to do subroutine calls'
complete -c gcc -o mno-small-exec --description 'Generate (or do not generate) code using the "bras" instruction to do subroutine calls'
complete -c gcc -o m64 --description 'When -m31 is specified, generate code compliant to the GNU/Linux for S/390 ABI'
complete -c gcc -o m31 --description 'When -m31 is specified, generate code compliant to the GNU/Linux for S/390 ABI'
complete -c gcc -o mzarch --description 'When -mzarch is specified, generate code using the instructions available on z/Architecture'
complete -c gcc -o mesa --description 'When -mzarch is specified, generate code using the instructions available on z/Architecture'
complete -c gcc -o mmvcle --description 'Generate (or do not generate) code using the "mvcle" instruction to perform block moves'
complete -c gcc -o mno-mvcle --description 'Generate (or do not generate) code using the "mvcle" instruction to perform block moves'
complete -c gcc -o mdebug --description 'Print (or do not print) additional debug information when compiling'
complete -c gcc -o mno-debug --description 'Print (or do not print) additional debug information when compiling'
complete -c gcc -o march --description 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o type --description 'Generate code that will run on cpu-type, which is the name of a system representing a certain processor type'
complete -c gcc -o mtune --description 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o type --description 'Tune to cpu-type everything applicable about the generated code, except for the ABI and the set of available instructions'
complete -c gcc -o mtpf-trace --description 'Generate code that adds (does not add) in TPF OS specific branches to trace routines in the operating system'
complete -c gcc -o mno-tpf-trace --description 'Generate code that adds (does not add) in TPF OS specific branches to trace routines in the operating system'
complete -c gcc -o mfused-madd --description 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mno-fused-madd --description 'Generate code that uses (does not use) the floating point multiply and accumulate instructions'
complete -c gcc -o mwarn-framesize --description '=framesize Emit a warning if the current function exceeds the given frame size'
complete -c gcc -o mwarn-dynamicstack --description 'Emit a warning if the function calls alloca or uses dynamically sized arrays'
complete -c gcc -o mstack-guard --description 'These arguments always have to be used in conjunction'
complete -c gcc -o mstack-size --description 'These arguments always have to be used in conjunction'
complete -c gcc -o size --description 'These arguments always have to be used in conjunction'
complete -c gcc -o m1 --description 'Generate code for the SH1'
complete -c gcc -o m2 --description 'Generate code for the SH2'
complete -c gcc -o m2e --description 'Generate code for the SH2e'
complete -c gcc -o m3 --description 'Generate code for the SH3'
complete -c gcc -o m3e --description 'Generate code for the SH3e'
complete -c gcc -o m4-nofpu --description 'Generate code for the SH4 without a floating-point unit'
complete -c gcc -o m4-single-only --description 'Generate code for the SH4 with a floating-point unit that only supports single-precision arithmetic'
complete -c gcc -o m4-single --description 'Generate code for the SH4 assuming the floating-point unit is in single-precision mode by default'
complete -c gcc -o m4 --description 'Generate code for the SH4'
complete -c gcc -o m4a-nofpu --description 'Generate code for the SH4al-dsp, or for a SH4a in such a way that the floating-point unit is not used'
complete -c gcc -o m4a-single-only --description 'Generate code for the SH4a, in such a way that no double-precision floating point operations are used'
complete -c gcc -o m4a-single --description 'Generate code for the SH4a assuming the floating-point unit is in single-precision mode by default'
complete -c gcc -o m4a --description 'Generate code for the SH4a'
complete -c gcc -o m4al --description 'Same as -m4a-nofpu, except that it implicitly passes -dsp to the assembler'
complete -c gcc -o mb --description 'Compile code for the processor in big endian mode'
complete -c gcc -o ml --description 'Compile code for the processor in little endian mode'
complete -c gcc -o mdalign --description 'Align doubles at 64-bit boundaries'
complete -c gcc -o mrelax --description 'Shorten some address references at link time, when possible; uses the linker option -relax'
complete -c gcc -o mbigtable --description 'Use 32-bit offsets in "switch" tables'
complete -c gcc -o mfmovd --description 'Enable the use of the instruction "fmovd"'
complete -c gcc -o mhitachi --description 'Comply with the calling conventions defined by Renesas'
complete -c gcc -o mrenesas --description 'Comply with the calling conventions defined by Renesas'
complete -c gcc -o mno-renesas --description 'Comply with the calling conventions defined for GCC before the Renesas conventions were available'
complete -c gcc -o mnomacsave --description 'Mark the "MAC" register as call-clobbered, even if -mhitachi is given'
complete -c gcc -o mieee --description 'Increase IEEE-compliance of floating-point code'
complete -c gcc -o misize --description 'Dump instruction size and location in the assembly code'
complete -c gcc -o mpadstruct --description 'This option is deprecated'
complete -c gcc -o mspace --description 'Optimize for space instead of speed'
complete -c gcc -o mprefergot --description 'When generating position-independent code, emit function calls using the Global Offset Table instead of the Procedure Linkage Table'
complete -c gcc -o musermode --description 'Generate a library function call to invalidate instruction cache entries, after fixing up a trampoline'
complete -c gcc -o multcost --description '=number Set the cost to assume for a multiply insn'
complete -c gcc -o mdiv --description '=strategy Set the division strategy to use for SHmedia code'
complete -c gcc -o mdivsi3_libfunc --description '=name Set the name of the library function used for 32 bit signed division to name'
complete -c gcc -o madjust-unroll --description 'Throttle unrolling to avoid thrashing target registers'
complete -c gcc -o mindexed-addressing --description 'Enable the use of the indexed addressing mode for SHmedia32/SHcompact'
complete -c gcc -o mgettrcost --description '=number Set the cost assumed for the gettr instruction to number'
complete -c gcc -o mpt-fixed --description 'Assume pt* instructions won’t trap'
complete -c gcc -o minvalid-symbols --description 'Assume symbols might be invalid'
complete -c gcc -o mno-app-regs --description 'Specify -mapp-regs to generate output using the global registers 2 through 4, which the SPARC SVR4 ABI reserves for applications'
complete -c gcc -o mapp-regs --description 'Specify -mapp-regs to generate output using the global registers 2 through 4, which the SPARC SVR4 ABI reserves for applications'
complete -c gcc -o mfpu --description 'Generate output containing floating point instructions'
complete -c gcc -o mhard-float --description 'Generate output containing floating point instructions'
complete -c gcc -o mno-fpu --description 'Generate output containing library calls for floating point'
complete -c gcc -o msoft-float --description 'Generate output containing library calls for floating point'
complete -c gcc -o mhard-quad-float --description 'Generate output containing quad-word (long double) floating point instructions'
complete -c gcc -o msoft-quad-float --description 'Generate output containing library calls for quad-word (long double) floating point instructions'
complete -c gcc -o mno-unaligned-doubles --description 'Assume that doubles have 8 byte alignment'
complete -c gcc -o munaligned-doubles --description 'Assume that doubles have 8 byte alignment'
complete -c gcc -o mno-faster-structs --description 'With -mfaster-structs, the compiler assumes that structures should have 8 byte alignment'
complete -c gcc -o mfaster-structs --description 'With -mfaster-structs, the compiler assumes that structures should have 8 byte alignment'
complete -c gcc -o mimpure-text --description '-mimpure-text, used in addition to -shared, tells the compiler to not pass -z text to the linker when linking a shared object'
complete -c gcc -o mcpu --description '=cpu_type Set the instruction set, register set, and instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mtune --description '=cpu_type Set the instruction scheduling parameters for machine type cpu_type, but do not set the instruction set or register set that the option -mcpu=cpu_type would'
complete -c gcc -o mv8plus --description 'With -mv8plus, GCC generates code for the SPARC-V8+ ABI'
complete -c gcc -o mno-v8plus --description 'With -mv8plus, GCC generates code for the SPARC-V8+ ABI'
complete -c gcc -o mvis --description 'With -mvis, GCC generates code that takes advantage of the UltraSPARC Visual Instruction Set extensions'
complete -c gcc -o mno-vis --description 'With -mvis, GCC generates code that takes advantage of the UltraSPARC Visual Instruction Set extensions'
complete -c gcc -o mlittle-endian --description 'Generate code for a processor running in little-endian mode'
complete -c gcc -o m32 --description 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o m64 --description 'Generate code for a 32-bit or 64-bit environment'
complete -c gcc -o mcmodel --description '=medlow Generate code for the Medium/Low code model: 64-bit addresses, programs must be linked in the low 32 bits of memory'
complete -c gcc -o mcmodel --description '=medmid Generate code for the Medium/Middle code model: 64-bit addresses, programs must be linked in the low 44 bits of memory, the text and data segments must be less than 2GB in size and the data segment must be located within 2GB of the text segment'
complete -c gcc -o mcmodel --description '=medany Generate code for the Medium/Anywhere code model: 64-bit addresses, programs may be linked anywhere in memory, the text and data segments must be less than 2GB in size and the data segment must be located within 2GB of the text segment'
complete -c gcc -o mcmodel --description '=embmedany Generate code for the Medium/Anywhere code model for embedded systems: 64-bit addresses, the text and data segments must be less than 2GB in size, both starting anywhere in memory (determined at link time)'
complete -c gcc -o mstack-bias --description 'With -mstack-bias, GCC assumes that the stack pointer, and frame pointer if present, are offset by -2047 which must be added back when making stack frame references'
complete -c gcc -o mno-stack-bias --description 'With -mstack-bias, GCC assumes that the stack pointer, and frame pointer if present, are offset by -2047 which must be added back when making stack frame references'
complete -c gcc -o threads --description 'Add support for multithreading using the Solaris threads library'
complete -c gcc -o pthreads --description 'Add support for multithreading using the POSIX threads library'
complete -c gcc -o pthread --description 'This is a synonym for -pthreads'
complete -c gcc -s G --description 'Create a shared object'
complete -c gcc -o Qy --description 'Identify the versions of each tool used by the compiler, in a "'
complete -c gcc -o Qn --description 'Refrain from adding "'
complete -c gcc -o mcpu --description '=cpu_type Set the instruction set, register set, and instruction scheduling parameters for machine type cpu_type'
complete -c gcc -o mbig-memory --description 'Generates code for the big or small memory model'
complete -c gcc -o mbig --description 'Generates code for the big or small memory model'
complete -c gcc -o msmall-memory --description 'Generates code for the big or small memory model'
complete -c gcc -o msmall --description 'Generates code for the big or small memory model'
complete -c gcc -o mbk --description 'Allow (disallow) allocation of general integer operands into the block count register BK'
complete -c gcc -o mno-bk --description 'Allow (disallow) allocation of general integer operands into the block count register BK'
complete -c gcc -o mdb --description 'Enable (disable) generation of code using decrement and branch, DBcond(D), instructions'
complete -c gcc -o mno-db --description 'Enable (disable) generation of code using decrement and branch, DBcond(D), instructions'
complete -c gcc -o mdp-isr-reload --description 'Force the DP register to be saved on entry to an interrupt service routine (ISR), reloaded to point to the data section, and restored on exit from the ISR'
complete -c gcc -o mparanoid --description 'Force the DP register to be saved on entry to an interrupt service routine (ISR), reloaded to point to the data section, and restored on exit from the ISR'
complete -c gcc -o mmpyi --description 'For the C3x use the 24-bit MPYI instruction for integer multiplies instead of a library call to guarantee 32-bit results'
complete -c gcc -o mno-mpyi --description 'For the C3x use the 24-bit MPYI instruction for integer multiplies instead of a library call to guarantee 32-bit results'
complete -c gcc -o mfast-fix --description 'The C3x/C4x FIX instruction to convert a floating point value to an integer value chooses the nearest integer less than or equal to the floating point value rather than to the nearest integer'
complete -c gcc -o mno-fast-fix --description 'The C3x/C4x FIX instruction to convert a floating point value to an integer value chooses the nearest integer less than or equal to the floating point value rather than to the nearest integer'
complete -c gcc -o mrptb --description 'Enable (disable) generation of repeat block sequences using the RPTB instruction for zero overhead looping'
complete -c gcc -o mno-rptb --description 'Enable (disable) generation of repeat block sequences using the RPTB instruction for zero overhead looping'
complete -c gcc -o mrpts --description 'Enable (disable) the use of the single instruction repeat instruction RPTS'
complete -c gcc -o mno-rpts --description 'Enable (disable) the use of the single instruction repeat instruction RPTS'
complete -c gcc -o mloop-unsigned --description 'The maximum iteration count when using RPTS and RPTB (and DB on the C40) is 2^{31 + 1} since these instructions test if the iteration count is negative to terminate the loop'
complete -c gcc -o mno-loop-unsigned --description 'The maximum iteration count when using RPTS and RPTB (and DB on the C40) is 2^{31 + 1} since these instructions test if the iteration count is negative to terminate the loop'
complete -c gcc -o mti --description 'Try to emit an assembler syntax that the TI assembler (asm30) is happy with'
complete -c gcc -o mregparm --description 'Generate code that uses registers (stack) for passing arguments to functions'
complete -c gcc -o mmemparm --description 'Generate code that uses registers (stack) for passing arguments to functions'
complete -c gcc -o mparallel-insns --description 'Allow the generation of parallel instructions'
complete -c gcc -o mno-parallel-insns --description 'Allow the generation of parallel instructions'
complete -c gcc -o mparallel-mpy --description 'Allow the generation of MPY││ADD and MPY││SUB parallel instructions, provided -mparallel-insns is also specified'
complete -c gcc -o mno-parallel-mpy --description 'Allow the generation of MPY││ADD and MPY││SUB parallel instructions, provided -mparallel-insns is also specified'
complete -c gcc -o mlong-calls --description 'Treat all calls as being far away (near)'
complete -c gcc -o mno-long-calls --description 'Treat all calls as being far away (near)'
complete -c gcc -o mno-ep --description 'Do not optimize (do optimize) basic blocks that use the same index pointer 4 or more times to copy pointer into the "ep" register, and use the shorter "sld" and "sst" instructions'
complete -c gcc -o mep --description 'Do not optimize (do optimize) basic blocks that use the same index pointer 4 or more times to copy pointer into the "ep" register, and use the shorter "sld" and "sst" instructions'
complete -c gcc -o mno-prolog-function --description 'Do not use (do use) external functions to save and restore registers at the prologue and epilogue of a function'
complete -c gcc -o mprolog-function --description 'Do not use (do use) external functions to save and restore registers at the prologue and epilogue of a function'
complete -c gcc -o mspace --description 'Try to make the code as small as possible'
complete -c gcc -o mtda --description '=n Put static or global variables whose size is n bytes or less into the tiny data area that register "ep" points to'
complete -c gcc -o msda --description '=n Put static or global variables whose size is n bytes or less into the small data area that register "gp" points to'
complete -c gcc -o mzda --description '=n Put static or global variables whose size is n bytes or less into the first 32 kilobytes of memory'
complete -c gcc -o mv850 --description 'Specify that the target processor is the V850'
complete -c gcc -o mbig-switch --description 'Generate code suitable for big switch tables'
complete -c gcc -o mapp-regs --description 'This option will cause r2 and r5 to be used in the code generated by the compiler'
complete -c gcc -o mno-app-regs --description 'This option will cause r2 and r5 to be treated as fixed registers'
complete -c gcc -o mv850e1 --description 'Specify that the target processor is the V850E1'
complete -c gcc -o mv850e --description 'Specify that the target processor is the V850E'
complete -c gcc -o mdisable-callt --description 'This option will suppress generation of the CALLT instruction for the v850e and v850e1 flavors of the v850 architecture'
complete -c gcc -o munix --description 'Do not output certain jump instructions ("aobleq" and so on) that the Unix assembler for the VAX cannot handle across long ranges'
complete -c gcc -o mgnu --description 'Do output those jump instructions, on the assumption that you will assemble with the GNU assembler'
complete -c gcc -o mg --description 'Output code for g-format floating point numbers instead of d-format'
complete -c gcc -o msim --description 'Choose startup files and linker script suitable for the simulator'
complete -c gcc -o mconst16 --description 'Enable or disable use of "CONST16" instructions for loading constant values'
complete -c gcc -o mno-const16 --description 'Enable or disable use of "CONST16" instructions for loading constant values'
complete -c gcc -o mfused-madd --description 'Enable or disable use of fused multiply/add and multiply/subtract instructions in the floating-point option'
complete -c gcc -o mno-fused-madd --description 'Enable or disable use of fused multiply/add and multiply/subtract instructions in the floating-point option'
complete -c gcc -o mtext-section-literals --description 'Control the treatment of literal pools'
complete -c gcc -o mno-text-section-literals --description 'Control the treatment of literal pools'
complete -c gcc -o mtarget-align --description 'When this option is enabled, GCC instructs the assembler to automatically align instructions to reduce branch penalties at the expense of some code density'
complete -c gcc -o mno-target-align --description 'When this option is enabled, GCC instructs the assembler to automatically align instructions to reduce branch penalties at the expense of some code density'
complete -c gcc -o mlongcalls --description 'When this option is enabled, GCC instructs the assembler to translate direct calls to indirect calls unless it can determine that the target of a direct call is in the range allowed by the call instruction'
complete -c gcc -o mno-longcalls --description 'When this option is enabled, GCC instructs the assembler to translate direct calls to indirect calls unless it can determine that the target of a direct call is in the range allowed by the call instruction'
complete -c gcc -o fbounds-check --description 'For front-ends that support it, generate additional code to check that indices used to access arrays are within the declared range'
complete -c gcc -o ftrapv --description 'This option generates traps for signed overflow on addition, subtraction, multiplication operations'
complete -c gcc -o fwrapv --description 'This option instructs the compiler to assume that signed arithmetic overflow of addition, subtraction and multiplication wraps around using twos-complement representation'
complete -c gcc -o fexceptions --description 'Enable exception handling'
complete -c gcc -o fnon-call-exceptions --description 'Generate code that allows trapping instructions to throw exceptions'
complete -c gcc -o funwind-tables --description 'Similar to -fexceptions, except that it will just generate any needed static data, but will not affect the generated code in any other way'
complete -c gcc -o fasynchronous-unwind-tables --description 'Generate unwind table in dwarf2 format, if supported by target machine'
complete -c gcc -o fpcc-struct-return --description 'Return "short" "struct" and "union" values in memory like longer ones, rather than in registers'
complete -c gcc -o freg-struct-return --description 'Return "struct" and "union" values in registers when possible'
complete -c gcc -o fshort-enums --description 'Allocate to an "enum" type only as many bytes as it needs for the declared range of possible values'
complete -c gcc -o fshort-double --description 'Use the same size for "double" as for "float"'
complete -c gcc -o fshort-wchar --description 'Override the underlying type for wchar_t to be short unsigned int instead of the default for the target'
complete -c gcc -o fshared-data --description 'Requests that the data and non-"const" variables of this compilation be shared data rather than private data'
complete -c gcc -o fno-common --description 'In C, allocate even uninitialized global variables in the data section of the object file, rather than generating them as common blocks'
complete -c gcc -o fno-ident --description 'Ignore the #ident directive'
complete -c gcc -o finhibit-size-directive --description 'Don’t output a "'
complete -c gcc -o fverbose-asm --description 'Put extra commentary information in the generated assembly code to make it more readable'
complete -c gcc -o fpic --description 'Generate position-independent code (PIC) suitable for use in a shared library, if supported for the target machine'
complete -c gcc -o fPIC --description 'If supported for the target machine, emit position-independent code, suitable for dynamic linking and avoiding any limit on the size of the global offset table'
complete -c gcc -o fpie --description 'These options are similar to -fpic and -fPIC, but generated position independent code can be only linked into executables'
complete -c gcc -o fPIE --description 'These options are similar to -fpic and -fPIC, but generated position independent code can be only linked into executables'
complete -c gcc -o fno-jump-tables --description 'Do not use jump tables for switch statements even where it would be more efficient than other code generation strategies'
complete -c gcc -o ffixed-reg --description 'Treat the register named reg as a fixed register; generated code should never refer to it (except perhaps as a stack pointer, frame pointer or in some other fixed role)'
complete -c gcc -o fcall-used-reg --description 'Treat the register named reg as an allocable register that is clobbered by function calls'
complete -c gcc -o fcall-saved-reg --description 'Treat the register named reg as an allocable register saved by functions'
complete -c gcc -o fpack-struct --description 'Without a value specified, pack all structure members together without holes' -x
complete -c gcc -o finstrument-functions --description 'Generate instrumentation calls for entry and exit to functions'
complete -c gcc -o fstack-check --description 'Generate code to verify that you do not go beyond the boundary of the stack'
complete -c gcc -o fstack-limit-register --description 'Generate code to ensure that the stack does not grow beyond a certain value, either the value of a register or the address of a symbol'
complete -c gcc -o fstack-limit-symbol --description 'Generate code to ensure that the stack does not grow beyond a certain value, either the value of a register or the address of a symbol'
complete -c gcc -o fno-stack-limit --description 'Generate code to ensure that the stack does not grow beyond a certain value, either the value of a register or the address of a symbol'
complete -c gcc -o fargument-alias --description 'Specify the possible relationships among parameters and between parameters and global data'
complete -c gcc -o fargument-noalias --description 'Specify the possible relationships among parameters and between parameters and global data'
complete -c gcc -o fargument-noalias-global --description 'Specify the possible relationships among parameters and between parameters and global data'
complete -c gcc -o fleading-underscore --description 'This option and its counterpart, -fno-leading-underscore, forcibly change the way C symbols are represented in the object file'
complete -c gcc -o ftls-model --description '=model Alter the thread-local storage model to be used'
complete -c gcc -o fvisibility --description '=default│internal│hidden│protected Set the default ELF image symbol visibility to the specified option---all symbols will be marked with this unless overridden within the code'
complete -c gcc -o fopenmp --description 'Enable handling of OpenMP directives "#pragma omp" in C/C++ and "!$omp" in Fortran'
