/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import java.util.Collections;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.ui.notifications.DatabaseNotification;
import org.jkiss.dbeaver.ui.notifications.DatabaseNotificationSink;
import org.jkiss.dbeaver.ui.notifications.GeneralNotification;
import org.jkiss.dbeaver.ui.notifications.NotificationSinkEvent;

public abstract class NotificationUtils {
    private static final Log log = Log.getLog(NotificationUtils.class);
    private static final DatabaseNotificationSink NOTIFICATION_SINK = new DatabaseNotificationSink();

    public static void sendNotification(DBPDataSource dataSource, String id, String text) {
        NotificationUtils.sendNotification(dataSource, id, text, null, null);
    }

    public static void sendNotification(DBPDataSource dataSource, String id, String text, DBPMessageType messageType, Runnable feedback) {
        if (!ModelPreferences.getPreferences().getBoolean("notifications.enabled")) {
            return;
        }
        DatabaseNotification notification = new DatabaseNotification(dataSource, id, text, messageType, feedback);
        try {
            NOTIFICATION_SINK.notify(new NotificationSinkEvent(Collections.singletonList(notification)));
        }
        catch (Exception e) {
            log.debug((Object)"Error sending Mylin notification", (Throwable)e);
        }
    }

    public static void sendNotification(String id, String title, String text, DBPMessageType messageType, Runnable feedback) {
        if (!ModelPreferences.getPreferences().getBoolean("notifications.enabled")) {
            return;
        }
        GeneralNotification notification = new GeneralNotification(id, title, text, messageType, feedback);
        try {
            NOTIFICATION_SINK.notify(new NotificationSinkEvent(Collections.singletonList(notification)));
        }
        catch (Exception e) {
            log.debug((Object)"Error sending Mylin notification", (Throwable)e);
        }
    }
}

