/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.registry.GeometryViewerRegistry;
import org.jkiss.dbeaver.ui.gis.registry.LeafletTilesDescriptor;
import org.jkiss.dbeaver.utils.HelpUtils;

class TilesManagementDialog
extends BaseDialog {
    private static final Log log = Log.getLog(TilesManagementDialog.class);
    private final List<LeafletTilesDescriptor> predefinedTiles = new ArrayList<LeafletTilesDescriptor>(GeometryViewerRegistry.getInstance().getPredefinedLeafletTiles());
    private final List<LeafletTilesDescriptor> userDefinedTiles = new ArrayList<LeafletTilesDescriptor>(GeometryViewerRegistry.getInstance().getUserDefinedLeafletTiles());
    @Nullable
    private final LeafletTilesDescriptor oldSelectedTileLayer;
    @Nullable
    private LeafletTilesDescriptor currentSelectedTileLayer = this.oldSelectedTileLayer = GeometryViewerRegistry.getInstance().getDefaultLeafletTiles();
    private Tree tree;
    @Nullable
    private TreeItem predefinedTilesRootItem;
    @Nullable
    private TreeItem userDefinedTilesRootItem;
    private TreeItem lastSelectedTreeItem;
    private ToolItem viewOrEditTilesItem;
    private ToolItem deleteTilesItem;

    TilesManagementDialog(Shell parentShell) {
        super(parentShell, GISMessages.panel_select_tiles_action_manage_dialog_title, null);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.PROCEED_LABEL, true);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Group group = UIUtils.createControlGroup((Composite)composite, (String)"", (int)2, (int)1808, (int)0);
        this.tree = new Tree((Composite)group, 67616);
        this.tree.setLayoutData((Object)new GridData(1808));
        UIUtils.createTreeColumn((Tree)this.tree, (int)0, (String)GISMessages.panel_select_tiles_action_manage_dialog_tiles_column_name);
        this.tree.setVisible(true);
        ToolBar toolBar = new ToolBar((Composite)group, 512);
        toolBar.setLayoutData((Object)new GridData(2));
        ToolItem addNewTilesItem = UIUtils.createToolItem((ToolBar)toolBar, (String)GISMessages.panel_select_tiles_action_manage_dialog_toolbar_add_new_tiles, (DBPImage)UIIcon.ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TileLayerDefinitionDialog dialog = new TileLayerDefinitionDialog(TilesManagementDialog.this.getShell(), null);
                int status = dialog.open();
                if (status != 0) {
                    return;
                }
                LeafletTilesDescriptor descriptor = dialog.getResultingTilesDescriptor();
                if (descriptor == null) {
                    log.error((Object)"New descriptor is null despite that user clicked ok");
                    return;
                }
                if (TilesManagementDialog.this.isModelContainsDescriptorWithLabel(descriptor.getLabel())) {
                    DBWorkbench.getPlatformUI().showError(GISMessages.panel_select_tiles_action_manage_dialog_error_adding_new_tiles_title, GISMessages.panel_select_tiles_action_manage_dialog_error_adding_new_tiles_message);
                    return;
                }
                TilesManagementDialog.this.userDefinedTiles.add(descriptor);
                TilesManagementDialog.this.repopulateTree(descriptor, true);
            }
        });
        addNewTilesItem.setEnabled(true);
        this.viewOrEditTilesItem = UIUtils.createToolItem((ToolBar)toolBar, (String)GISMessages.panel_select_tiles_action_manage_dialog_toolbar_view_or_edit_tiles, (DBPImage)UIIcon.TEXTFIELD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TilesManagementDialog.this.isRootItem((Widget)TilesManagementDialog.this.lastSelectedTreeItem)) {
                    log.error((Object)"Can't find tiles to edit!");
                    return;
                }
                LeafletTilesDescriptor originalDescriptor = (LeafletTilesDescriptor)((Object)TilesManagementDialog.this.lastSelectedTreeItem.getData());
                TileLayerDefinitionDialog dialog = new TileLayerDefinitionDialog(TilesManagementDialog.this.getShell(), originalDescriptor);
                int result = dialog.open();
                if (result != 0 || originalDescriptor.isPredefined()) {
                    return;
                }
                LeafletTilesDescriptor editedDescriptor = dialog.getResultingTilesDescriptor();
                if (editedDescriptor == null) {
                    log.error((Object)"Edited descriptor is null despite that user clicked ok");
                    return;
                }
                if (TilesManagementDialog.containsDescriptorWithLabel(TilesManagementDialog.this.predefinedTiles, editedDescriptor.getLabel()) || TilesManagementDialog.this.userDefinedTiles.stream().anyMatch(t -> t.getLabel().equals(editedDescriptor.getLabel()) && !t.equals((Object)originalDescriptor))) {
                    DBWorkbench.getPlatformUI().showError(GISMessages.panel_select_tiles_action_manage_dialog_error_editing_tiles_title, GISMessages.panel_select_tiles_action_manage_dialog_error_editing_tiles_message);
                    return;
                }
                TilesManagementDialog.replace(TilesManagementDialog.this.userDefinedTiles, originalDescriptor, editedDescriptor);
                TilesManagementDialog.this.repopulateTree(editedDescriptor, true);
                if (originalDescriptor.equals((Object)TilesManagementDialog.this.currentSelectedTileLayer)) {
                    TilesManagementDialog.this.currentSelectedTileLayer = editedDescriptor;
                }
            }
        });
        this.viewOrEditTilesItem.setEnabled(false);
        this.deleteTilesItem = UIUtils.createToolItem((ToolBar)toolBar, (String)GISMessages.panel_select_tiles_action_manage_dialog_toolbar_delete_tiles, (DBPImage)UIIcon.DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TilesManagementDialog.this.lastSelectedTreeItem == null || TilesManagementDialog.this.lastSelectedTreeItem.equals(TilesManagementDialog.this.predefinedTilesRootItem)) {
                    log.error((Object)"Can't find tiles to delete!");
                    return;
                }
                if (TilesManagementDialog.this.lastSelectedTreeItem.equals(TilesManagementDialog.this.userDefinedTilesRootItem)) {
                    TilesManagementDialog.this.userDefinedTiles.clear();
                    TilesManagementDialog.this.repopulateTree(null, true);
                    return;
                }
                LeafletTilesDescriptor descriptor = (LeafletTilesDescriptor)((Object)TilesManagementDialog.this.lastSelectedTreeItem.getData());
                if (descriptor.isPredefined()) {
                    log.error((Object)"Can't delete predefined descriptor!");
                    return;
                }
                int i = TilesManagementDialog.this.userDefinedTiles.indexOf((Object)descriptor);
                if (i == -1) {
                    log.error((Object)"Can't delete predefined descriptor! It's not found in the model!");
                    return;
                }
                TilesManagementDialog.this.userDefinedTiles.remove(i);
                if (i < TilesManagementDialog.this.userDefinedTiles.size()) {
                    TilesManagementDialog.this.repopulateTree((LeafletTilesDescriptor)((Object)TilesManagementDialog.this.userDefinedTiles.get(i)), true);
                } else if (i == TilesManagementDialog.this.userDefinedTiles.size() && !TilesManagementDialog.this.userDefinedTiles.isEmpty()) {
                    TilesManagementDialog.this.repopulateTree((LeafletTilesDescriptor)((Object)TilesManagementDialog.this.userDefinedTiles.get(i - 1)), true);
                } else {
                    TilesManagementDialog.this.repopulateTree(null, true);
                }
                if (descriptor.equals((Object)TilesManagementDialog.this.currentSelectedTileLayer)) {
                    TilesManagementDialog.this.currentSelectedTileLayer = null;
                }
            }
        });
        this.deleteTilesItem.setEnabled(false);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(e.item instanceof TreeItem)) {
                    return;
                }
                TilesManagementDialog.this.lastSelectedTreeItem = (TreeItem)e.item;
                if ((e.detail & 0x20) == 32) {
                    this.reactOnCheck(TilesManagementDialog.this.lastSelectedTreeItem);
                }
                TilesManagementDialog.this.changeToolbarState(TilesManagementDialog.this.lastSelectedTreeItem);
            }

            private void reactOnCheck(@NotNull TreeItem item) {
                if (TilesManagementDialog.this.isRootItem((Widget)item)) {
                    List list = item.equals(TilesManagementDialog.this.userDefinedTilesRootItem) ? TilesManagementDialog.this.userDefinedTiles : TilesManagementDialog.this.predefinedTiles;
                    LeafletTilesDescriptor lastSelectedDescriptor = null;
                    if (TilesManagementDialog.this.lastSelectedTreeItem != null && TilesManagementDialog.this.lastSelectedTreeItem.getData() instanceof LeafletTilesDescriptor) {
                        lastSelectedDescriptor = (LeafletTilesDescriptor)((Object)TilesManagementDialog.this.lastSelectedTreeItem.getData());
                    }
                    int i = 0;
                    while (i < list.size()) {
                        LeafletTilesDescriptor descriptor = (LeafletTilesDescriptor)((Object)list.get(i));
                        if (item.getChecked() != descriptor.isVisible()) {
                            LeafletTilesDescriptor newDescriptor = descriptor.withFlippedVisibility();
                            list.set(i, newDescriptor);
                            if (lastSelectedDescriptor != null && lastSelectedDescriptor.getId().equals(newDescriptor.getId())) {
                                lastSelectedDescriptor = newDescriptor;
                            }
                        }
                        ++i;
                    }
                    TilesManagementDialog.this.repopulateTree(lastSelectedDescriptor, true);
                    return;
                }
                LeafletTilesDescriptor descriptor = (LeafletTilesDescriptor)((Object)item.getData());
                LeafletTilesDescriptor withFlippedVisibility = descriptor.withFlippedVisibility();
                item.setData((Object)withFlippedVisibility);
                List tilesContainer = descriptor.isPredefined() ? TilesManagementDialog.this.predefinedTiles : TilesManagementDialog.this.userDefinedTiles;
                TilesManagementDialog.replace(tilesContainer, descriptor, withFlippedVisibility);
                boolean checkOnRoot = tilesContainer.stream().anyMatch(LeafletTilesDescriptor::isVisible);
                if (descriptor.isPredefined()) {
                    if (TilesManagementDialog.this.predefinedTilesRootItem != null) {
                        TilesManagementDialog.this.predefinedTilesRootItem.setChecked(checkOnRoot);
                    } else {
                        log.error((Object)"Predefined item hangs without its root");
                    }
                } else if (TilesManagementDialog.this.userDefinedTilesRootItem != null) {
                    TilesManagementDialog.this.userDefinedTilesRootItem.setChecked(checkOnRoot);
                } else {
                    log.error((Object)"User defined item hangs without its root");
                }
            }
        });
        UIUtils.createInfoLabel((Composite)composite, (String)GISMessages.panel_select_tiles_action_manage_dialog_infolabel_about_checkboxes_meaning);
        this.repopulateTree(null, false);
        return dialogArea;
    }

    private void changeToolbarState(@Nullable TreeItem item) {
        if (item == null) {
            this.viewOrEditTilesItem.setEnabled(false);
            this.deleteTilesItem.setEnabled(false);
            return;
        }
        if (item.getData() == null) {
            this.viewOrEditTilesItem.setEnabled(false);
            this.deleteTilesItem.setEnabled(item.equals(this.userDefinedTilesRootItem));
            return;
        }
        this.viewOrEditTilesItem.setEnabled(true);
        LeafletTilesDescriptor descriptor = (LeafletTilesDescriptor)((Object)item.getData());
        this.deleteTilesItem.setEnabled(!descriptor.isPredefined());
    }

    private static void replace(@NotNull List<LeafletTilesDescriptor> list, @NotNull LeafletTilesDescriptor what, @NotNull LeafletTilesDescriptor with) {
        int i = 0;
        while (i < list.size()) {
            if (what.equals((Object)list.get(i))) {
                list.set(i, with);
                return;
            }
            ++i;
        }
    }

    private boolean isRootItem(Widget widget) {
        return this.predefinedTilesRootItem != null && this.predefinedTilesRootItem.equals(widget) || this.userDefinedTilesRootItem != null && this.userDefinedTilesRootItem.equals(widget);
    }

    private boolean isModelContainsDescriptorWithLabel(@NotNull String label) {
        return TilesManagementDialog.containsDescriptorWithLabel(this.predefinedTiles, label) || TilesManagementDialog.containsDescriptorWithLabel(this.userDefinedTiles, label);
    }

    private static boolean containsDescriptorWithLabel(@NotNull Collection<LeafletTilesDescriptor> collection, @NotNull String label) {
        return collection.stream().anyMatch(descriptor -> label.equals(descriptor.getLabel()));
    }

    private void repopulateTree(@Nullable LeafletTilesDescriptor tilesToSelect, boolean retainExpansion) {
        boolean expandPredefined = true;
        boolean expandUserDefined = true;
        if (retainExpansion) {
            TreeItem[] children;
            TreeItem[] treeItemArray = children = this.tree.getItems();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (GISMessages.panel_select_tiles_action_manage_dialog_predefined_tiles.equals(item.getText())) {
                    expandPredefined = item.getExpanded();
                } else if (GISMessages.panel_select_tiles_action_manage_dialog_user_defined_tiles.equals(item.getText())) {
                    expandUserDefined = item.getExpanded();
                }
                ++n2;
            }
        }
        this.tree.removeAll();
        this.predefinedTilesRootItem = null;
        this.userDefinedTilesRootItem = null;
        this.lastSelectedTreeItem = null;
        if (!this.predefinedTiles.isEmpty()) {
            this.predefinedTilesRootItem = new TreeItem(this.tree, 0);
            this.predefinedTilesRootItem.setText(GISMessages.panel_select_tiles_action_manage_dialog_predefined_tiles);
            for (LeafletTilesDescriptor descriptor : this.predefinedTiles) {
                TreeItem item = new TreeItem(this.predefinedTilesRootItem, 0);
                item.setData((Object)descriptor);
                item.setText(descriptor.getLabel());
                item.setChecked(descriptor.isVisible());
                if (!descriptor.equals((Object)tilesToSelect)) continue;
                this.lastSelectedTreeItem = item;
            }
            this.predefinedTilesRootItem.setChecked(this.predefinedTiles.stream().anyMatch(LeafletTilesDescriptor::isVisible));
            this.predefinedTilesRootItem.setExpanded(expandPredefined);
        }
        if (!this.userDefinedTiles.isEmpty()) {
            this.userDefinedTilesRootItem = new TreeItem(this.tree, 0);
            this.userDefinedTilesRootItem.setText(GISMessages.panel_select_tiles_action_manage_dialog_user_defined_tiles);
            for (LeafletTilesDescriptor descriptor : this.userDefinedTiles) {
                TreeItem item = new TreeItem(this.userDefinedTilesRootItem, 0);
                item.setData((Object)descriptor);
                item.setText(descriptor.getLabel());
                item.setChecked(descriptor.isVisible());
                if (!descriptor.equals((Object)tilesToSelect)) continue;
                this.lastSelectedTreeItem = item;
            }
            this.userDefinedTilesRootItem.setChecked(this.userDefinedTiles.stream().anyMatch(LeafletTilesDescriptor::isVisible));
            this.userDefinedTilesRootItem.setExpanded(expandUserDefined);
        }
        if (this.lastSelectedTreeItem == null) {
            this.lastSelectedTreeItem = this.predefinedTilesRootItem;
        }
        this.tree.setSelection(this.lastSelectedTreeItem);
        this.changeToolbarState(this.lastSelectedTreeItem);
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.tree, (boolean)true, (float[])new float[]{1.0f}));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            GeometryViewerRegistry.getInstance().updateTiles(this.predefinedTiles, this.userDefinedTiles);
            if (!Objects.equals((Object)this.oldSelectedTileLayer, (Object)this.currentSelectedTileLayer)) {
                GeometryViewerRegistry.getInstance().setDefaultLeafletTiles(this.currentSelectedTileLayer);
            }
        }
        super.buttonPressed(buttonId);
    }

    private static class TileLayerDefinitionDialog
    extends BaseDialog {
        @Nullable
        private final LeafletTilesDescriptor originalTilesDescriptor;
        @Nullable
        private LeafletTilesDescriptor resultingTilesDescriptor;
        private Text labelText;
        private Text layersDefinitionText;

        TileLayerDefinitionDialog(Shell parentShell, @Nullable LeafletTilesDescriptor tilesDescriptor) {
            super(parentShell, TileLayerDefinitionDialog.getTitle(tilesDescriptor), null);
            this.originalTilesDescriptor = tilesDescriptor;
        }

        private static String getTitle(@Nullable LeafletTilesDescriptor tilesDescriptor) {
            if (tilesDescriptor == null) {
                return GISMessages.panel_select_tiles_action_manage_dialog_tile_layer_definition_dialog_add_tiles_title;
            }
            if (tilesDescriptor.isPredefined()) {
                return GISMessages.panel_select_tiles_action_manage_dialog_tile_layer_definition_dialog_view_tiles_title;
            }
            return GISMessages.panel_select_tiles_action_manage_dialog_tile_layer_definition_dialog_edit_tiles_title;
        }

        protected Composite createDialogArea(Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)1);
            composite.setLayoutData((Object)new GridData(1808));
            Group group = UIUtils.createControlGroup((Composite)dialogArea, (String)GISMessages.panel_select_tiles_action_manage_dialog_tile_layer_definition_dialog_tiles_properties_group, (int)2, (int)0, (int)0);
            group.setLayoutData((Object)new GridData(1808));
            int mutabilityStyle = this.originalTilesDescriptor != null && this.originalTilesDescriptor.isPredefined() ? 8 : 0;
            this.labelText = UIUtils.createLabelText((Composite)group, (String)GISMessages.panel_select_tiles_action_manage_dialog_tile_layer_definition_dialog_text_label_label, (String)(this.originalTilesDescriptor == null ? "" : this.originalTilesDescriptor.getLabel()), (int)(0x800 | mutabilityStyle));
            this.layersDefinitionText = UIUtils.createLabelText((Composite)group, (String)GISMessages.panel_select_tiles_action_manage_dialog_tile_layer_definition_dialog_text_label_layers_definition, (String)(this.originalTilesDescriptor == null ? "" : this.originalTilesDescriptor.getLayersDefinition()), (int)(0xA42 | mutabilityStyle));
            GridData gd = new GridData(1808);
            gd.heightHint = UIUtils.getFontHeight((Control)this.layersDefinitionText) * 15;
            gd.widthHint = UIUtils.getFontHeight((Control)this.layersDefinitionText) * 60;
            this.layersDefinitionText.setLayoutData((Object)gd);
            UIUtils.createLink((Composite)dialogArea, (String)GISMessages.panel_select_tiles_action_manage_dialog_tile_layer_definition_dialog_layers_definition_explanation_link_text, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Working-with-Spatial-GIS-data#defining-custom-tile-layer"));
                }
            });
            return dialogArea;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        @Nullable
        public LeafletTilesDescriptor getResultingTilesDescriptor() {
            return this.resultingTilesDescriptor;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                this.resultingTilesDescriptor = LeafletTilesDescriptor.createUserDefined(this.labelText.getText().trim(), this.layersDefinitionText.getText().trim(), this.originalTilesDescriptor == null || this.originalTilesDescriptor.isVisible());
            }
            super.buttonPressed(buttonId);
        }
    }
}

