/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tasks;

import java.util.List;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolBaseVacuumSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreToolWithStatus;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreToolBaseVacuum
extends PostgreToolWithStatus<DBSObject, PostgreToolBaseVacuumSettings> {
    public PostgreToolBaseVacuumSettings createToolSettings() {
        return new PostgreToolBaseVacuumSettings();
    }

    public void generateObjectQueries(DBCSession session, PostgreToolBaseVacuumSettings settings, List<DBEPersistAction> queries, DBSObject object) throws DBCException {
        String sql = "VACUUM (";
        if (settings.isFull()) {
            sql = String.valueOf(sql) + "FULL, ";
        }
        if (settings.isFreeze()) {
            sql = String.valueOf(sql) + "FREEZE, ";
        }
        sql = String.valueOf(sql) + "VERBOSE";
        if (settings.isAnalyzed()) {
            sql = String.valueOf(sql) + ", ANALYZE";
        }
        if (settings.isDisableSkipping()) {
            sql = String.valueOf(sql) + ", DISABLE_PAGE_SKIPPING";
        }
        if (settings.isSkipLocked()) {
            sql = String.valueOf(sql) + ", SKIP_LOCKED";
        }
        if (settings.isIndexCleaning()) {
            sql = String.valueOf(sql) + ", INDEX_CLEANUP";
        }
        if (settings.isTruncated()) {
            sql = String.valueOf(sql) + ", TRUNCATE";
        }
        sql = String.valueOf(sql) + ")";
        if (object instanceof PostgreTableBase) {
            PostgreTableBase postObject = (PostgreTableBase)object;
            sql = String.valueOf(sql) + " " + postObject.getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        queries.add((DBEPersistAction)new SQLDatabasePersistAction(sql));
    }

    public boolean isRunInAutoCommit() {
        return true;
    }
}

