/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguageManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.language.PlatformLanguageDescriptor;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseUserInterface
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main";
    private Button automaticUpdateCheck;
    private Combo workspaceLanguage;
    private Button longOperationsCheck;
    private Spinner longOperationsTimeout;
    private Button notificationsEnabled;
    private Spinner notificationsCloseDelay;
    private boolean isStandalone = DBeaverCore.isStandalone();

    public PrefPageDatabaseUserInterface() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        if (this.isStandalone) {
            Group groupObjects = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_general, (int)2, (int)2, (int)0);
            this.automaticUpdateCheck = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_ui_general_checkbox_automatic_updates, null, (boolean)false, (int)2);
        }
        if (this.isStandalone) {
            Group groupLanguage = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_language, (int)2, (int)2, (int)0);
            this.workspaceLanguage = UIUtils.createLabelCombo((Composite)groupLanguage, (String)CoreMessages.pref_page_ui_general_combo_language, (String)CoreMessages.pref_page_ui_general_combo_language_tip, (int)12);
            this.workspaceLanguage.setLayoutData((Object)new GridData(32));
            List languages = PlatformLanguageRegistry.getInstance().getLanguages();
            DBPPlatformLanguage pLanguage = DBWorkbench.getPlatform().getLanguage();
            int i = 0;
            while (i < languages.size()) {
                PlatformLanguageDescriptor lang = (PlatformLanguageDescriptor)languages.get(i);
                this.workspaceLanguage.add(lang.getLabel());
                if (CommonUtils.equalObjects((Object)pLanguage, (Object)lang)) {
                    this.workspaceLanguage.select(i);
                }
                ++i;
            }
            if (this.workspaceLanguage.getSelectionIndex() < 0) {
                this.workspaceLanguage.select(0);
            }
            if (!((DBPPlatformLanguageManager)DBWorkbench.getPlatform()).isLanguageChangeEnabled()) {
                this.workspaceLanguage.setEnabled(false);
                Label tipLabel = UIUtils.createLabel((Composite)groupLanguage, (String)("File '" + DBWorkbench.getPlatform().getApplicationConfiguration().getAbsolutePath() + "' is read-only.\nLanguage can't be changed from preferences."));
                tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
                Link languageChangeLink = new Link((Composite)groupLanguage, 0);
                languageChangeLink.setText("See <a>instructions</a> how to change language manually.");
                languageChangeLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UIUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"UI-Language"));
                    }
                });
                languageChangeLink.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
            } else {
                Label tipLabel = UIUtils.createLabel((Composite)groupLanguage, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
                tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
            }
        }
        Group notificationsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_notifications, (int)2, (int)770, (int)0);
        this.notificationsEnabled = UIUtils.createCheckbox((Composite)notificationsGroup, (String)CoreMessages.pref_page_ui_general_label_enable_notifications, (String)CoreMessages.pref_page_ui_general_label_enable_notifications_tip, (boolean)false, (int)2);
        this.notificationsCloseDelay = UIUtils.createLabelSpinner((Composite)notificationsGroup, (String)CoreMessages.pref_page_ui_general_label_notifications_close_delay, (int)0, (int)0, (int)Integer.MAX_VALUE);
        Group agentGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_task_bar, (int)2, (int)770, (int)0);
        this.longOperationsCheck = UIUtils.createCheckbox((Composite)agentGroup, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations_tip, (boolean)false, (int)2);
        this.longOperationsTimeout = UIUtils.createLabelSpinner((Composite)agentGroup, (String)(String.valueOf(CoreMessages.pref_page_ui_general_label_long_operation_timeout) + UIMessages.label_sec), (int)0, (int)0, (int)Integer.MAX_VALUE);
        if (RuntimeUtils.isMacOS()) {
            ControlEnableState.disable((Control)agentGroup);
        }
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.isStandalone) {
            this.automaticUpdateCheck.setSelection(store.getBoolean("ui.auto.update.check"));
        }
        this.notificationsEnabled.setSelection(store.getBoolean("notifications.enabled"));
        this.notificationsCloseDelay.setSelection(store.getInt("notifications.closeDelay"));
        this.longOperationsCheck.setSelection(store.getBoolean("agent.long.operation.notify"));
        this.longOperationsTimeout.setSelection(store.getInt("agent.long.operation.timeout"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (this.isStandalone) {
            store.setValue("ui.auto.update.check", this.automaticUpdateCheck.getSelection());
        }
        store.setValue("notifications.enabled", this.notificationsEnabled.getSelection());
        store.setValue("notifications.closeDelay", this.notificationsCloseDelay.getSelection());
        store.setValue("agent.long.operation.notify", this.longOperationsCheck.getSelection());
        store.setValue("agent.long.operation.timeout", this.longOperationsTimeout.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        if (this.workspaceLanguage.getSelectionIndex() >= 0) {
            PlatformLanguageDescriptor language = (PlatformLanguageDescriptor)PlatformLanguageRegistry.getInstance().getLanguages().get(this.workspaceLanguage.getSelectionIndex());
            DBPPlatformLanguage curLanguage = DBWorkbench.getPlatform().getLanguage();
            try {
                if (curLanguage != language) {
                    if (!((DBPPlatformLanguageManager)DBWorkbench.getPlatform()).isLanguageChangeEnabled()) {
                        UIUtils.showMessageBox((Shell)this.getShell(), (String)"Can't change language", (String)"Language cannot be changed from preferences", (int)1);
                    } else {
                        ((DBPPlatformLanguageManager)DBWorkbench.getPlatform()).setPlatformLanguage((DBPPlatformLanguage)language);
                        if (UIUtils.confirmAction((Shell)this.getShell(), (String)("Restart " + GeneralUtils.getProductName()), (String)("You need to restart " + GeneralUtils.getProductName() + " to perform actual language change.\nDo you want to restart?"))) {
                            UIUtils.asyncExec(() -> {
                                boolean bl = PlatformUI.getWorkbench().restart();
                            });
                        }
                    }
                }
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Change language", "Can't switch language to " + language, (Throwable)e);
            }
        }
        return true;
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

