/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final String FAKE_I_CONSTR_MSG = "Fake IConstr";
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;
    private static final IConstr FAKE_CONSTR = new IConstr(){

        public int size() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public boolean learnt() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public double getActivity() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public int get(int i) {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public boolean canBePropagatedMultipleTimes() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }
    };

    public OPBStringSolver() {
    }

    public OPBStringSolver(int initSize) {
        super(initSize);
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        for (int p : assumps) {
            if (p > 0) {
                this.getOut().append("+1 x" + p + " >= 1 ;\n");
            } else {
                this.getOut().append("-1 x" + -p + " >= 0 ;\n");
            }
            ++this.nbOfConstraints;
        }
        throw new TimeoutException();
    }

    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        return super.isSatisfiable(assumps, global);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        if (moreThan) {
            return this.addAtLeast(lits, coeffs, d);
        }
        return this.addAtMost(lits, coeffs, d);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        this.obj = obj;
    }

    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        for (int p : literals) {
            assert (p != 0);
            if (p > 0) {
                out.append("+1 x" + p + " ");
                continue;
            }
            out.append("-1 x" + -p + " ");
            ++negationweight;
        }
        out.append(">= " + (degree - negationweight) + " ;\n");
        return FAKE_CONSTR;
    }

    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        for (int p : literals) {
            assert (p != 0);
            if (p > 0) {
                out.append("-1 x" + p + " ");
                continue;
            }
            out.append("+1 x" + -p + " ");
            ++negationweight;
        }
        out.append(">= " + (-degree + negationweight) + " ;\n");
        return FAKE_CONSTR;
    }

    public IConstr addClause(IVecInt literals) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        for (int lit : literals) {
            if (lit > 0) {
                out.append("+1 x" + lit + " ");
                continue;
            }
            out.append("-1 x" + -lit + " ");
            ++negationweight;
        }
        out.append(">=" + (1 - negationweight) + ";\n");
        return FAKE_CONSTR;
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt listOfVariables) {
    }

    public String toString() {
        StringBuffer out = this.getOut();
        if (!this.inserted) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("* #variable= ");
            tmp.append(this.nVars());
            tmp.append(" #constraint= ");
            tmp.append(this.nbOfConstraints);
            if (this.obj != null) {
                tmp.append("\n");
                tmp.append("min: ");
                tmp.append(this.obj);
                tmp.append(";");
            }
            out.insert(this.indxConstrObj, tmp.toString());
            this.inserted = true;
        }
        return out.toString();
    }

    public String toString(String prefix) {
        return "OPB output solver";
    }

    public int newVar(int howmany) {
        StringBuffer out = this.getOut();
        this.setNbVars(howmany);
        this.indxConstrObj = out.length();
        out.append("\n");
        return howmany;
    }

    public void setExpectedNumberOfClauses(int nb) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }

    public int nConstraints() {
        return this.nbOfConstraints;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int i = 0;
        while (i < literals.size()) {
            out.append(-coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
            ++i;
        }
        out.append(">= ");
        out.append(-degree);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int i = 0;
        while (i < literals.size()) {
            out.append(((BigInteger)coeffs.get(i)).negate());
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
            ++i;
        }
        out.append(">= ");
        out.append(degree.negate());
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int i = 0;
        while (i < literals.size()) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
            ++i;
        }
        out.append(">= ");
        out.append(degree);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int i = 0;
        while (i < literals.size()) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
            ++i;
        }
        out.append(">= ");
        out.append(degree);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    public IConstr addExactly(IVecInt literals, int weight) throws ContradictionException {
        StringBuffer out = this.getOut();
        ++this.nbOfConstraints;
        int negationweight = 0;
        for (int p : literals) {
            assert (p != 0);
            if (p > 0) {
                out.append("+1 x" + p + " ");
                continue;
            }
            out.append("-1 x" + -p + " ");
            ++negationweight;
        }
        out.append("= " + (weight - negationweight) + " ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int i = 0;
        while (i < literals.size()) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
            ++i;
        }
        out.append("= ");
        out.append(weight);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        StringBuffer out = this.getOut();
        assert (literals.size() == coeffs.size());
        ++this.nbOfConstraints;
        int i = 0;
        while (i < literals.size()) {
            out.append(coeffs.get(i));
            out.append(" x");
            out.append(literals.get(i));
            out.append(" ");
            ++i;
        }
        out.append("= ");
        out.append(weight);
        out.append(" ;\n");
        return FAKE_CONSTR;
    }
}

