/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructLookupCache;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.utils.CommonUtils;

public class TableCache
extends JDBCStructLookupCache<GenericStructContainer, GenericTableBase, GenericTableColumn> {
    private static final Log log = Log.getLog(TableCache.class);
    final GenericDataSource dataSource;
    final GenericMetaObject tableObject;
    final GenericMetaObject columnObject;

    TableCache(GenericDataSource dataSource) {
        super(GenericUtils.getColumn(dataSource, "table", "TABLE_NAME"));
        this.dataSource = dataSource;
        this.tableObject = dataSource.getMetaObject("table");
        this.columnObject = dataSource.getMetaObject("table-column");
        this.setListOrderComparator(DBUtils.nameComparator());
    }

    public GenericDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        return this.dataSource.getMetaModel().prepareTableLoadStatement(session, owner, object, objectName);
    }

    @Nullable
    protected GenericTableBase fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return this.getDataSource().getMetaModel().createTableImpl(session, owner, this.tableObject, dbResult);
    }

    protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forTable) throws SQLException {
        return this.dataSource.getMetaModel().prepareTableColumnLoadStatement(session, owner, forTable);
    }

    protected GenericTableColumn fetchChild(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericTableBase table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        DBSDataType dataType;
        String columnName = GenericUtils.safeGetStringTrimmed(this.columnObject, (ResultSet)dbResult, "COLUMN_NAME");
        int valueType = GenericUtils.safeGetInt(this.columnObject, (ResultSet)dbResult, "DATA_TYPE");
        int sourceType = GenericUtils.safeGetInt(this.columnObject, (ResultSet)dbResult, "SOURCE_DATA_TYPE");
        String typeName = GenericUtils.safeGetStringTrimmed(this.columnObject, (ResultSet)dbResult, "TYPE_NAME");
        long columnSize = GenericUtils.safeGetLong(this.columnObject, (ResultSet)dbResult, "COLUMN_SIZE");
        boolean isNotNull = GenericUtils.safeGetInt(this.columnObject, (ResultSet)dbResult, "NULLABLE") == 0;
        Integer scale = null;
        try {
            scale = GenericUtils.safeGetInteger(this.columnObject, (ResultSet)dbResult, "DECIMAL_DIGITS");
        }
        catch (Throwable e) {
            log.warn((Object)"Error getting column scale", e);
        }
        Integer precision = null;
        if (valueType == 2 || valueType == 3) {
            precision = (int)columnSize;
        }
        int radix = 10;
        try {
            radix = GenericUtils.safeGetInt(this.columnObject, (ResultSet)dbResult, "NUM_PREC_RADIX");
        }
        catch (Exception e) {
            log.warn((Object)"Error getting column radix", (Throwable)e);
        }
        String defaultValue = GenericUtils.safeGetString(this.columnObject, (ResultSet)dbResult, "COLUMN_DEF");
        String remarks = GenericUtils.safeGetString(this.columnObject, (ResultSet)dbResult, "REMARKS");
        long charLength = GenericUtils.safeGetLong(this.columnObject, (ResultSet)dbResult, "CHAR_OCTET_LENGTH");
        int ordinalPos = GenericUtils.safeGetInt(this.columnObject, (ResultSet)dbResult, "ORDINAL_POSITION");
        boolean autoIncrement = "YES".equals(GenericUtils.safeGetStringTrimmed(this.columnObject, (ResultSet)dbResult, "IS_AUTOINCREMENT"));
        boolean autoGenerated = "YES".equals(GenericUtils.safeGetStringTrimmed(this.columnObject, (ResultSet)dbResult, "IS_GENERATEDCOLUMN"));
        if (!CommonUtils.isEmpty((String)typeName)) {
            if (typeName.toUpperCase(Locale.ENGLISH).endsWith(" IDENTITY")) {
                autoIncrement = true;
                typeName = typeName.substring(0, typeName.length() - " IDENTITY".length());
            }
            if (typeName.endsWith("()")) {
                typeName = typeName.substring(0, typeName.length() - 2);
            }
        } else {
            typeName = "N/A";
        }
        if ((dataType = this.dataSource.getLocalDataType(typeName)) != null) {
            valueType = dataType.getTypeID();
        }
        return this.getDataSource().getMetaModel().createTableColumnImpl(session.getProgressMonitor(), dbResult, table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, isNotNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }
}

