#!/usr/bin/env python
#-*- coding: utf-8 -*-
#
# --BETA--
#################################################################
#    CPU-G version 0.11.1 beta, Fotis Tsamis, October 2009.     #
#    modified by M. Schmoeller, December 2010.
#    modified by Michał Głowienka & Michał Olber, February 2012.
#################################################################
#    CPU-G is a program that displays information about your CPU,
#    RAM, Motherboard and some general information about your System.
#    Copyright © 2009  Fotis Tsamis <ftsamis at gmail dot com>.
#    Copyright © 2012  Michał Głowienka <eloaders at yahoo dot com>
#    Copyright © 2012  Michał Olber
#
#    This program is free software: you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation, either version 3
#    of the License, or any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied
#    warranty of MERCHANTABILITY or FITNESS FOR A
#    PARTICULAR PURPOSE.
#    See the GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public
#    License along with this program.
#    If not, see <http://www.gnu.org/licenses/>.

import os, re, sys, platform, subprocess
try:
    import pygtk, gtk, gtk.glade, gobject, commands
except:
    print 'You need to have PyGTK 2.10.0'
    print 'GTK.Glade and GTK+ 2.10.0 or higher installed in your system in order to run CPU-G.'
    sys.exit(1)


class main:

    global lm, ht
    ht = False
    lm = False

    def readfile(self, name):
        try:
            f = file(name, 'r')
            data = f.read()
            f.close()
            return data
        except:
            return 'N/A'

    def amd64(self):
        global lm
        info = self.readfile("/proc/cpuinfo")

        if re.findall(" lm ", re.findall("flags\s*:(.*)",info)[0]):
          label = '/usr/share/cpug/gfx/check_true.png'
          lm = True
        else:
          label = '/usr/share/cpug/gfx/check_false.png'

        return label

    def hwv(self):
        info = self.readfile("/proc/cpuinfo")

        if re.findall(" svm ", re.findall("flags\s*:(.*)",info)[0]) or re.findall(" vmx ", re.findall("flags\s*:(.*)",info)[0]):
         label = '/usr/share/cpug/gfx/check_true.png'
        else:
         label = '/usr/share/cpug/gfx/check_false.png'

        return label

    def cpulogo(self):
        global ht
        model = self.cpuinfo("model")

        path = '/usr/share/cpug/gfx/logos/processors/'

    #AMDs
    ##Athlon(64)/Athlon II
        if re.match("AMD Athlon\(tm\) 64 X2.*",model):
            label = 'AMD-Athlon64-X2.png'
        elif re.match("AMD Athlon\(tm\) X2.*",model):
            label = 'AMD-AthlonX2.png'
        elif re.match("AMD Athlon\(tm\) II X4.*",model):
            label = 'AMD-AthlonII-X4.png'
        elif re.match("AMD Athlon\(tm\) II X3.*",model):
            label = 'AMD-AthlonII-X3.png'
        elif re.match("AMD Athlon\(tm\) II X2.*",model):
            label = 'AMD-AthlonII-X2.png'
        elif re.match("AMD Athlon\(tm\) 64.*",model):
            label = 'AMD-Athlon64.png'
        elif re.match("AMD Athlon\(tm\) XP.*",model):
            label = 'AMD-AthlonXP.png'
        elif re.match("AMD Athlon\(tm\).*",model):
            label = 'AMD-Athlon.png'

    ##AMD APU
        elif re.match("AMD E-450.*",model):
            label = 'AMD-E2-Vision.jpg'
        elif re.match("AMD E-350.*",model):
            label = 'AMD-Vision.jpg'
        elif re.match("AMD A4*",model):
            label = 'AMD-Vision.jpg'

    ##Sempron/Duron
        elif re.match("Mobile AMD Sempron\(tm\).*",model):
            label = 'AMD-Sempron-Mobile.png'
        elif re.match("AMD Sempron\(tm\).*",model):
            if lm == True:
              label = 'AMD-Sempron_K8.png'
            else:
              label = 'AMD-Sempron_K7.png'
        elif re.match("AMD Duron\(tm\).*",model):
            label = 'AMD-Duron.png'

    ##Opteron
        elif re.match("Quad-Core AMD Opteron\(tm\).*",model) or re.match("Six-Core AMD Opteron\(tm\).*",model):
            label = 'AMD-Opteron_K10.png'
        elif re.match("Dual-Core AMD Opteron\(tm\).*",model) or re.match("AMD Opteron\(tm\).*",model):
            label = 'AMD-Opteron_K8.png'

    ##Turion
        elif re.match("AMD Turion\(tm\) 64 X2.*",model):
            label = 'AMD-Turion64-X2.png'
        elif re.match("AMD Turion\(tm\) 64.*",model):
            label = 'AMD-Turion64.png'
        elif re.match("AMD Turion\(tm\). X2 Ultra.*",model):
            label = 'AMD-Turion-X2Ultra.png'
        elif re.match("AMD Turion\(tm\) X2.*",model):
            label = 'AMD-Turion-X2.png'

    ##Phenom/Phenom II
        elif re.match("AMD Phenom\(tm\) II X4.*",model):
            label = 'AMD-PhenomII-X4.png'
        elif re.match("AMD Phenom\(tm\) II X3.*",model):
            label = 'AMD-PhenomII-X3.png'
        elif re.match("AMD Phenom\(tm\) II X2.*",model):
            label = 'AMD-PhenomII-X2.png'
        elif re.match("AMD Phenom\(tm\) II.*",model):
            label = 'AMD-PhenomII.png'
        elif re.match("AMD Phenom\(tm\) X4.*",model):
            label = 'AMD-Phenom-X4.png'
        elif re.match("AMD Phenom\(tm\) X3.*",model):
            label = 'AMD-Phenom-X3.png'

    #Intels
    ##Core
        elif re.match("Intel\(R\) Core\(TM\) i7 Extreme.*",model):
            label = 'Intel-Core-i7Extreme.png'
        elif re.match("Intel\(R\) Core\(TM\) i7.*",model):
            label = 'Intel-Core-i7.png'
        elif re.match("Intel\(R\) Core\(TM\) i5.*",model):
            label = 'Intel-Core-i5.png'
        elif re.match("Intel\(R\) Core\(TM\) i3.*",model):
            label = 'Intel-Core-i3.png'
        elif re.match("Intel\(R\) Core\(TM\)2 Extreme.*",model):
            label = 'Intel-Core2Extreme.png'
        elif re.match("Intel\(R\) Core\(TM\)2 Duo.*",model):
            label = 'Intel-Core2Duo.png'
        elif re.match("Intel\(R\) Core\(TM\)2 Quad.*",model):
            label = 'Intel-Core2Quad.png'
        elif re.match("Intel\(R\) Core\(TM\)2.*",model):
            label = 'Intel-Core2Duo.png'
        elif re.match("Intel\(R\) Core\(TM\) Duo.*",model):
            label = 'Intel-CoreDuo.png'
        elif re.match("Intel\(R\) Core\(TM\) Solo.*",model):
            label = 'Intel-CoreSolo.png'

    ##Atom
        elif re.match("Intel\(R\) Atom\(TM\).*",model):
            label = 'Intel-Atom.png'

    ##Xeon
        elif re.match("Intel\(R\) Xeon\(TM\).*",model):
            label = 'Intel-Xeon.png'

    ##Pentium
        elif re.match("Intel\(R\) Pentium\(R\) Dual CPU.*",model):
            label = 'Intel-PentiumDual.png'
        elif re.match("Intel\(R\) Pentium\(R\) Extreme.*",model):
            label = 'Intel-PentiumXE.png'
        elif re.match("Intel\(R\) Pentium\(R\) 4 Extreme.*",model):
            label = 'Intel-Pentium4XE.png'
        elif re.match("Intel\(R\) Pentium\(R\) 4.*",model):
          if ht == True:
            label = 'Intel-Pentium4HT.png'
          else:
            label = 'Intel-Pentium4.png'
        elif re.match("Intel\(R\) Pentium\(R\) M.*",model):
            label = 'Intel-PentiumM.png'
        elif re.match("Intel\(R\) Pentium\(R\) D.*",model):
            label = 'Intel-PentiumD.png'
        elif re.match("Pentium III.*",model):
            label = 'Intel-Pentium3.png'
        elif re.match("Pentium II.*",model):
            label = 'Intel-Pentium2.png'

    ##Celeron
        elif re.match("Intel\(R\) Celeron\(R\) D.*",model):
            label = 'Intel-CeleronD.png'
        elif re.match("Intel\(R\) Celeron\(R\) M.*",model):
            label = 'Intel-CeleronM.png'
        elif re.match("Intel\(R\) Celeron\(R\).*",model):
           if lm == True:
                label = 'Intel-Celeron_Core.png'
           else:
                label = 'Intel-Celeron.png'
        elif re.match("Celeron.*",model):
            label = 'Intel-Celeron_old.png'

    #VIA
        elif re.match("VIA Ezra.*",model) or re.match("VIA Nehemiah.*",model):
            label = 'VIA-C3.png'
        elif re.match("VIA C7-M.*",model):
            label = 'VIA-C7-M.png'
        elif re.match("VIA Esther.*",model):
            label = 'VIA-C7.png'
        elif re.match("VIA Nano.*",model):
            label = 'VIA-Nano.png'

        else:
            label = 'noimage.png'

        return path + label

    def bogomips(self, core):
	info = self.readfile("/proc/cpuinfo")
        return re.findall("bogomips\s*:\s*(.*)",info)[core]

    def cpuinfo(self, var):
        global ht
        info = self.readfile("/proc/cpuinfo")
        vendor = re.findall("vendor_id\s*:\s*(.*)",info)[0]

        if var == 'vendor':
            if vendor == 'AuthenticAMD':
                vendor='Advanced Micro Devices, Inc.'
            elif vendor == 'GenuineIntel':
                vendor='Intel Corporation'
            elif vendor == 'CentaurHauls':
                vendor='VIA/Centaur Technology'
            elif vendor == 'CyrixInstead':
                vendor='Cyrix'
            elif vendor == 'CentaurHauls':
                vendor='Centaur'
            elif vendor == 'NexGenDriven':
                vendor='NexGen'
            elif vendor == 'GenuineTMx86':
                vendor='Transmeta'
            elif vendor == 'Geode by NSC':
                vendor = 'National Semiconductor'
            return vendor
        elif var == 'model':
            return re.findall("model name\s*:\s*(.*)",info)[0]
        elif var == 'modelnumber':
            return re.findall("model\s*:\s*(.*)",info)[0]
        elif var == 'familynum':
            return re.findall("cpu family\s*:\s*(.*)",info)[0]
        elif var == 'stepping':
            return re.findall("stepping\s*:\s*(.*)",info)[0]
        elif var == 'coresnum':
            return str(len(re.findall("cpu cores\s*:\s*(.*)",info)))
        elif var == 'threads':
            threads = str(len(re.findall("core id\s*:\s*(.*)",info)))
            if self.cpuinfo("coresnum") == 2*int(threads):
              ht = True
            return threads
	elif var == 'realcoresnum':
	    try:
                cores = re.findall("cpu cores\s*:\s*(.*)",info)[0]
	    except:
		cores = '1'
	    return cores
        elif var == 'extensions':
            if re.findall(' mmxext ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = 'MMX(+)'
            elif re.findall(' mmx ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = 'MMX'
            if re.findall(' 3dnowext ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', 3DNow!(+)'
            elif re.findall(' 3dnow ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', 3DNow!'
            if re.findall(' sse ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', SSE'
            if re.findall(' sse2 ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', SSE2'
            if re.findall(' pni ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', SSE3'
            if re.findall(' ssse3 ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', SSSE3'
            if re.findall(' sse4_2 ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', SSE4.2'
            elif re.findall(' sse4_1 ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', SSE4.1'
            if re.findall(' sse4a ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', SSE4a'
            if re.findall(' nx ', re.findall("flags\s*:(.*)",info)[0]) and vendor == 'GenuineIntel':
              extensions = extensions + ', XD-Bit'
            elif re.findall(' nx ', re.findall("flags\s*:(.*)",info)[0]):
              extensions = extensions + ', NX-Bit'
            return extensions


    def sysdevcpu(self, core, level, kind):
        coresinsysdev = str(len(re.findall("'cpu[0-9]'", str(os.listdir("/sys/devices/system/cpu/")))))
        if coresinsysdev == self.cpuinfo('coresnum'):
            cores_matching = True
        else:
            print "Error: Cannot decide if the cores are %s or %s.\nUsing the lowest value as the real cores number." %(cpuinfo('coresnum'), coresinsysdev) #FIXME: Wrong text. (?)



        path = '/sys/devices/system/cpu/cpu%i/cache/' %(core)
        indexes = len(re.findall("'index[0-9]*'",str(os.listdir(path))))


        for index in range(indexes):
            levelpath = path+'index%i/level' %(index)
            typepath = path+'index%i/type' %(index)
            size = path+'index%i/size' %(index)
            #os.chdir(newpath)
            if self.readfile(levelpath).strip() == str(level) and self.readfile(typepath).strip() == kind:
                return self.readfile(size).strip()
            elif index == range(indexes)[-1]:
                return 'N/A'



    def distro(self):
        try:
            values = platform.linux_distribution()
        except AttributeError:
            values = platform.dist()

        if len(values) !=0:
            return "%s %s %s" %(values[0], values[1], values[2])
        else:
            return self.readfile('/etc/lsb-release').strip()

    def gccver(self):
        gcc_version = os.popen('gcc -dumpversion').read().strip()
        if gcc_version != '':
            return gcc_version
        else:
            return 'N/A'

    def xver(self):
        command = subprocess.Popen(['Xorg', '-version'],stdout=subprocess.PIPE,stderr=subprocess.PIPE)
        stdout, stderr = command.communicate()
        return re.findall("X\.Org X Server (.*)", stderr)[0]


    def mobo(self, var):
        # var can be: board_vendor, board_name, bios_vendor,
        # bios_version, bios_date, or chassis_type
        string = self.readfile('/sys/devices/virtual/dmi/id/'+var).strip()
        if string != '':
          return string
        else:
          return 'N/A'

    def mobochipset(self):

        chipset = os.popen('lspci | grep \'PCI bridge\'').read()

        return re.findall("PCI bridge: (.*)",chipset)[0]

    def chipsetlogo(self):

        path = '/usr/share/cpug/gfx/logos/chipsets/'
        chipset = os.popen('lspci | grep \'PCI bridge\'').read()

        if re.findall("nVidia Corporation\s*",chipset):
          label = 'nVidia.png'
        elif re.findall("VIA Technologies\s*",chipset):
          label = 'VIA.png'
        elif re.findall("Intel Corporation\s*",chipset):
          label = 'intel.png'
        elif re.findall("ATI\s*",chipset):
          label = 'AMD.png'
        elif re.findall("AMD\s*",chipset):
          label = 'AMD.png'
        elif re.findall("SiS\s*",chipset):
          label = 'SiS.png'
	else: label = 'unknown.png'

        return path + label

    def graphic_logo(self):

	path = '/usr/share/cpug/gfx/logos/graphic_card/'
	card_logo = os.popen("lspci | grep \'VGA\'").read()
	#Intel
	if re.findall("Intel\s*",card_logo):
	   label = 'intel.png'
	#ATI
	#ATI Technologies replace to ATI. See bug https://bugs.launchpad.net/cpug/+bug/959115
	elif re.findall("ATI\s*",card_logo): 
	   label = 'ati.png'
	#nVidia
	elif re.findall("nVidia\s*",card_logo):
	   label = 'nvidia.png'
	else: label = 'unknown.png'

	return path + label

    def distro_logos(self):

	path = '/usr/share/cpug/gfx/logos/distro_logo/'
	dist = self.distro()


	#Ubuntu
	if re.findall("Ubuntu\s*",dist):
	    label = 'ubuntu-logo-large.png'
	#LinuxMint
	elif re.findall("Mint\s*",dist):
	    label = 'linuxmintlogo.png'
	#If any distro not found then set standard Tux logo
	elif re.findall("Linux\s*",dist):
	    label = 'linux_logo.png'
	else: label = 'unknown.png'

	return path + label

    def uptime(self):
        total = int(self.readfile('/proc/uptime').split('.')[0])
        days = int(total / 86400)
        hours = int((total / 3600) - (days * 24))
        minutes = int( (total / 60) - ((days * 1440) + (hours * 60)) )

        return "%i days, %i hours, %i minutes" %(days, hours, minutes)

    # Graphic tab
    def open_gl(self, var):

	open_gl_ = os.popen('glxinfo').read()
	vga = commands.getoutput("lspci | grep 'VGA' | cut -d ':' -f 3")

	if var == 'vendor':
	   if open_gl_ != '':
               return re.findall("OpenGL vendor string: (.*)",open_gl_)[0]
           else:
               return 'N/A'

	elif var == 'renderer':
	   if open_gl_ != '':
	       return re.findall("OpenGL renderer string: (.*)",open_gl_)[0]
	   else:
	       return 'N/A'

	elif var == 'version':
	   if open_gl_ != '':
	       return re.findall("OpenGL version string: (.*)",open_gl_)[0]
	   else:
	       return 'N/A'

	elif var == 'VGA':
	   if vga != '':
	       return vga
	   else:
	       return 'N/A'
	#End Graphic Tab

    def raminfo(self):
        data = self.readfile('/proc/meminfo')

        values = {'total' : int(re.findall('^MemTotal:\s*([0-9]*)',data, re.M)[0])/1024,
                  'free' : int(re.findall('^MemFree:\s*([0-9]*)',data, re.M)[0])/1024,
                  'buffers' : int(re.findall('^Buffers:\s*([0-9]*)',data, re.M)[0])/1024,
                  'cached' : int(re.findall('^Cached:\s*([0-9]*)',data, re.M)[0])/1024,
                  'used' : 0,
                  'active' : int(re.findall('^Active:\s*([0-9]*)',data, re.M)[0])/1024,
                  'inactive' : int(re.findall('^Inactive:\s*([0-9]*)',data, re.M)[0])/1024,
                  'cached' : int(re.findall('^Cached:\s*([0-9]*)',data, re.M)[0])/1024
                  }
        values['free'] = values['free'] + values['buffers'] + values['cached']
        values['used'] = values['total'] - values['free']

        return values

    def cpuclock(self, core):
        info = self.readfile("/proc/cpuinfo")

        return re.findall("cpu MHz\s*:\s*(.*)",info)[core] + ' MHz'

class CPUG:
    """Description"""

    def __init__(self):
        self.gladefile = "/usr/share/cpug/cpu-g.glade"
        self.wTree = gtk.Builder()
        self.wTree.add_from_file(self.gladefile)

        dic = {
                "on_close_clicked" : self.kill,
                "on_mainwindow_destroy" : self.kill,
                "on_core_move_active" : self.core_change
        }
        self.wTree.connect_signals(dic)

	self.ram_update()
        gobject.timeout_add(1000, self.ram_update) # Update Free & Used RAM every 1 second

        # Processor core selection combobox
        self.box = self.wTree.get_object("coreselection")
        add = gtk.ListStore(str)

        for i in range(int(main().cpuinfo("coresnum"))):
            add.append(["Core #" + str(i)])


        self.box.set_model(add)
        cell = gtk.CellRendererText()
        self.box.pack_start(cell)
        self.box.add_attribute(cell,'text',0)
        self.box.set_active(0)

        # Motherboard tab
        # board_vendor, board_name, bios_vendor, bios_version, bios_date, chassis_type
        self.wTree.get_object("chipset").set_from_file(main().chipsetlogo())
        self.wTree.get_object("mobovendor").set_text(main().mobo('board_vendor'))
        self.wTree.get_object("moboname").set_text(main().mobo('board_name'))
        self.wTree.get_object("mobochipset").set_text(main().mobochipset())
        self.wTree.get_object("biosvendor").set_text(main().mobo('bios_vendor'))
        self.wTree.get_object("biosversion").set_text(main().mobo('bios_version'))
        self.wTree.get_object("biosdate").set_text(main().mobo('bios_date'))

        # System tab
        # os.uname()[0]=OS(Linux) [1]=hostname [2]=kernel version [4]=architecture
        self.wTree.get_object("distro_logo").set_from_file(main().distro_logos())
        self.wTree.get_object("gcc").set_text(main().gccver())
        self.uptime_update()
        gobject.timeout_add(1000 * 60, self.uptime_update)
        self.wTree.get_object("hostname").set_text(os.uname()[1])
        self.wTree.get_object("arch").set_text(os.uname()[4])
        self.wTree.get_object("kernel").set_text(os.uname()[0]+" "+os.uname()[2])
        self.wTree.get_object("distro").set_text(main().distro())
        self.wTree.get_object("xorg").set_text(main().xver())

        #Graphic Tab
        self.wTree.get_object("graphic_logo").set_from_file(main().graphic_logo())
        self.wTree.get_object("VGA_compatible_controller").set_text(main().open_gl("VGA"))
        self.wTree.get_object("open_gl_vendor").set_text(main().open_gl("vendor"))
        self.wTree.get_object("open_gl_renderer").set_text(main().open_gl("renderer"))
        self.wTree.get_object("open_gl_version").set_text(main().open_gl("version"))

    def uptime_update(self):

        self.wTree.get_object("uptime").set_text(main().uptime())

        return True


    def cpu_czestotliwosc(self):

        index = self.wTree.get_object("coreselection").get_active()

        self.wTree.get_object("corespeed").set_text(main().cpuclock(index))

        return True


    def core_change(self, widget):

        index = self.wTree.get_object("coreselection").get_active()

        print "core set to #" + str(index)

        # Processor tab
        self.cpu_czestotliwosc()
        gobject.timeout_add(1000, self.cpu_czestotliwosc)
        self.wTree.get_object("vendor").set_text(main().cpuinfo("vendor"))
        self.wTree.get_object("extensions").set_text(main().cpuinfo("extensions"))
        self.wTree.get_object("coresnum").set_text(main().cpuinfo("realcoresnum"))
        self.wTree.get_object("threads").set_text(main().cpuinfo("threads"))
        self.wTree.get_object("model").set_text(main().cpuinfo("model"))
        self.wTree.get_object("bogomips").set_text(main().bogomips(index))
        self.wTree.get_object("modelnumber").set_text(main().cpuinfo("modelnumber"))
        self.wTree.get_object("family").set_text(main().cpuinfo("familynum"))
        self.wTree.get_object("stepping").set_text(main().cpuinfo("stepping"))
        self.wTree.get_object("proclogo").set_from_file(main().cpulogo())
        self.wTree.get_object("check_64").set_from_file(main().amd64())
        self.wTree.get_object("check_hwv").set_from_file(main().hwv())
        self.wTree.get_object("l1data").set_text(main().sysdevcpu(index, 1, 'Data'))
        self.wTree.get_object("l1inst").set_text(main().sysdevcpu(index, 1, 'Instruction'))
        self.wTree.get_object("l2").set_text(main().sysdevcpu(index, 2, 'Unified'))
        self.wTree.get_object("l3").set_text(main().sysdevcpu(index, 3, 'Unified'))

    def ram_update(self):
        # RAM tab
        values = main().raminfo()
        totalram = values['total']
        usedram = values['used']
        freeram = values['free']

        self.wTree.get_object("ramtotal").set_text(str(totalram) + ' MBytes')
        self.wTree.get_object("ramused").set_text(str(usedram) + ' MBytes')
        self.wTree.get_object("ramfree").set_text(str(freeram) + ' MBytes')

        # RAM progress bars
        usedfraction = (usedram * 1.00) / totalram
        usedpercentage = str(int(round(usedram * 100.0 / totalram))) + '%'
        self.wTree.get_object("ramusedprogbar").set_fraction(usedfraction)
        self.wTree.get_object("ramusedprogbar").set_text(usedpercentage)

        freefraction = (freeram * 1.00) / totalram
        freepercentage = str(int(round(freeram * 100.0 / totalram))) + '%'
        self.wTree.get_object("ramfreeprogbar").set_fraction(freefraction)
        self.wTree.get_object("ramfreeprogbar").set_text(freepercentage)

        self.wTree.get_object("ramactive").set_text(str(values['active']) + ' MBytes')
        self.wTree.get_object("raminactive").set_text(str(values['inactive']) + ' MBytes')
        self.wTree.get_object("ramcached").set_text(str(values['cached']) + ' MBytes')

	return True



    def kill(self, widget):
        print "Quit"
        sys.exit(0)


if __name__ == '__main__':
    CPUG()
    gtk.main()
