/*  This file is part of libtweetlength
 *  Copyright (C) 2017 Timm Bäder, 2020 IBBoard
 *
 *  libtweetlength is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  libtweetlength is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libtweetlength.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __TL_DATA_H__
#define __TL_DATA_H__

#define PUNCTUATION   "!'#%&\"()*+,\\-./:;<=>?@[]^_{|}~$`"
#define SPACES        " \0x0020\0085\00A0"
#define INVALID_CHARS "\0xFFFE\0xFEFF\0xFFFF"

#define INVALID_URL_CHARS       (PUNCTUATION SPACES INVALID_CHARS)
#define INVALID_AFTER_URL_CHARS "?,!`~&*^%\\|"

#define INVALID_BEFORE_NON_PROTOCOL_URL_CHARS (".@_-)/")
#define INVALID_BEFORE_URL_CHARS              ("$")

#define VALID_BEFORE_HASHTAG_CHARS   "{}!<>()[]\\/?`~:;.,%*"
#define INVALID_BEFORE_HASHTAG_CHARS "_&"
#define INVALID_HASHTAG_CHARS        "!'#%&\"()*+,\\-./:;<=>?@[]^{|}~$`"

#define INVALID_BEFORE_MENTION_CHARS "!_$&#*"
#define VALID_BEFORE_MENTION_CHARS   ";,`=+"
#define INVALID_MENTION_CHARS        "!'#%&\"()*+,\\-./:;<=>?@[]^{|}~$`"


// List from twitter-text
static const struct {
  size_t length;
  const char *str;
} GTLDS[] = {
  {2, "삼성"},
  {2, "닷컴"},
  {2, "닷넷"},
  {2, "コム"},
  {2, "世界"},
  {2, "中信"},
  {2, "企业"},
  {2, "佛山"},
  {2, "信息"},
  {2, "健康"},
  {2, "八卦"},
  {2, "公司"},
  {2, "公益"},
  {2, "商城"},
  {2, "商店"},
  {2, "商标"},
  {2, "嘉里"},
  {2, "在线"},
  {2, "大拿"},
  {2, "娱乐"},
  {2, "家電"},
  {2, "工行"},
  {2, "广东"},
  {2, "微博"},
  {2, "慈善"},
  {2, "手机"},
  {2, "手表"},
  {2, "招聘"},
  {2, "政务"},
  {2, "政府"},
  {2, "新闻"},
  {2, "时尚"},
  {2, "書籍"},
  {2, "机构"},
  {2, "游戏"},
  {2, "点看"},
  {2, "珠宝"},
  {2, "移动"},
  {2, "网址"},
  {2, "网店"},
  {2, "网站"},
  {2, "网络"},
  {2, "联通"},
  {2, "谷歌"},
  {2, "购物"},
  {2, "通販"},
  {2, "集团"},
  {2, "食品"},
  {2, "餐厅"},
  {3, "aaa"},
  {3, "abb"},
  {3, "abc"},
  {3, "aco"},
  {3, "ads"},
  {3, "aeg"},
  {3, "afl"},
  {3, "aig"},
  {3, "anz"},
  {3, "aol"},
  {3, "app"},
  {3, "art"},
  {3, "aws"},
  {3, "axa"},
  {3, "bar"},
  {3, "bbc"},
  {3, "bbt"},
  {3, "bcg"},
  {3, "bcn"},
  {3, "bet"},
  {3, "bid"},
  {3, "bio"},
  {3, "biz"},
  {3, "bms"},
  {3, "bmw"},
  {3, "bnl"},
  {3, "bom"},
  {3, "boo"},
  {3, "bot"},
  {3, "box"},
  {3, "buy"},
  {3, "bzh"},
  {3, "cab"},
  {3, "cal"},
  {3, "cam"},
  {3, "car"},
  {3, "cat"},
  {3, "cba"},
  {3, "cbn"},
  {3, "cbs"},
  {3, "ceb"},
  {3, "ceo"},
  {3, "cfa"},
  {3, "cfd"},
  {3, "com"},
  {3, "cpa"},
  {3, "crs"},
  {3, "csc"},
  {3, "dad"},
  {3, "day"},
  {3, "dds"},
  {3, "dev"},
  {3, "dhl"},
  {3, "diy"},
  {3, "dnp"},
  {3, "dog"},
  {3, "dot"},
  {3, "dtv"},
  {3, "dvr"},
  {3, "eat"},
  {3, "eco"},
  {3, "edu"},
  {3, "esq"},
  {3, "eus"},
  {3, "fan"},
  {3, "fit"},
  {3, "fly"},
  {3, "foo"},
  {3, "fox"},
  {3, "frl"},
  {3, "ftr"},
  {3, "fun"},
  {3, "fyi"},
  {3, "gal"},
  {3, "gap"},
  {3, "gay"},
  {3, "gdn"},
  {3, "gea"},
  {3, "gle"},
  {3, "gmo"},
  {3, "gmx"},
  {3, "goo"},
  {3, "gop"},
  {3, "got"},
  {3, "gov"},
  {3, "hbo"},
  {3, "hiv"},
  {3, "hkt"},
  {3, "hot"},
  {3, "how"},
  {3, "htc"},
  {3, "ibm"},
  {3, "ice"},
  {3, "icu"},
  {3, "ifm"},
  {3, "inc"},
  {3, "ing"},
  {3, "ink"},
  {3, "int"},
  {3, "ist"},
  {3, "itv"},
  {3, "iwc"},
  {3, "jcb"},
  {3, "jcp"},
  {3, "jio"},
  {3, "jlc"},
  {3, "jll"},
  {3, "jmp"},
  {3, "jnj"},
  {3, "jot"},
  {3, "joy"},
  {3, "kfh"},
  {3, "kia"},
  {3, "kim"},
  {3, "kpn"},
  {3, "krd"},
  {3, "lat"},
  {3, "law"},
  {3, "lds"},
  {3, "llc"},
  {3, "llp"},
  {3, "lol"},
  {3, "lpl"},
  {3, "ltd"},
  {3, "man"},
  {3, "map"},
  {3, "mba"},
  {3, "mcd"},
  {3, "med"},
  {3, "men"},
  {3, "meo"},
  {3, "mil"},
  {3, "mit"},
  {3, "mlb"},
  {3, "mls"},
  {3, "mma"},
  {3, "moe"},
  {3, "moi"},
  {3, "mom"},
  {3, "mov"},
  {3, "msd"},
  {3, "mtn"},
  {3, "mtr"},
  {3, "nab"},
  {3, "nba"},
  {3, "nec"},
  {3, "net"},
  {3, "new"},
  {3, "nfl"},
  {3, "ngo"},
  {3, "nhk"},
  {3, "now"},
  {3, "nra"},
  {3, "nrw"},
  {3, "ntt"},
  {3, "nyc"},
  {3, "obi"},
  {3, "off"},
  {3, "one"},
  {3, "ong"},
  {3, "onl"},
  {3, "ooo"},
  {3, "org"},
  {3, "ott"},
  {3, "ovh"},
  {3, "pay"},
  {3, "pet"},
  {3, "phd"},
  {3, "pid"},
  {3, "pin"},
  {3, "pnc"},
  {3, "pro"},
  {3, "pru"},
  {3, "pub"},
  {3, "pwc"},
  {3, "qvc"},
  {3, "red"},
  {3, "ren"},
  {3, "ril"},
  {3, "rio"},
  {3, "rip"},
  {3, "run"},
  {3, "rwe"},
  {3, "sap"},
  {3, "sas"},
  {3, "sbi"},
  {3, "sbs"},
  {3, "sca"},
  {3, "scb"},
  {3, "ses"},
  {3, "sew"},
  {3, "sex"},
  {3, "sfr"},
  {3, "ski"},
  {3, "sky"},
  {3, "soy"},
  {3, "srl"},
  {3, "srt"},
  {3, "stc"},
  {3, "tab"},
  {3, "tax"},
  {3, "tci"},
  {3, "tdk"},
  {3, "tel"},
  {3, "thd"},
  {3, "tjx"},
  {3, "top"},
  {3, "trv"},
  {3, "tui"},
  {3, "tvs"},
  {3, "ubs"},
  {3, "uno"},
  {3, "uol"},
  {3, "ups"},
  {3, "vet"},
  {3, "vig"},
  {3, "vin"},
  {3, "vip"},
  {3, "wed"},
  {3, "win"},
  {3, "wme"},
  {3, "wow"},
  {3, "wtc"},
  {3, "wtf"},
  {3, "xin"},
  {3, "xxx"},
  {3, "xyz"},
  {3, "you"},
  {3, "yun"},
  {3, "zip"},
  {3, "ком"},
  {3, "орг"},
  {3, "рус"},
  {3, "קום"},
  {3, "عرب"},
  {3, "كوم"},
  {3, "कॉम"},
  {3, "नेट"},
  {3, "คอม"},
  {3, "ストア"},
  {3, "セール"},
  {3, "みんな"},
  {3, "中文网"},
  {3, "天主教"},
  {3, "我爱你"},
  {3, "淡马锡"},
  {3, "诺基亚"},
  {3, "飞利浦"},
  {4, "aarp"},
  {4, "able"},
  {4, "adac"},
  {4, "aero"},
  {4, "aigo"},
  {4, "akdn"},
  {4, "ally"},
  {4, "amex"},
  {4, "arab"},
  {4, "army"},
  {4, "arpa"},
  {4, "arte"},
  {4, "asda"},
  {4, "asia"},
  {4, "audi"},
  {4, "auto"},
  {4, "baby"},
  {4, "band"},
  {4, "bank"},
  {4, "bbva"},
  {4, "beer"},
  {4, "best"},
  {4, "bike"},
  {4, "bing"},
  {4, "blog"},
  {4, "blue"},
  {4, "bofa"},
  {4, "bond"},
  {4, "book"},
  {4, "buzz"},
  {4, "cafe"},
  {4, "call"},
  {4, "camp"},
  {4, "care"},
  {4, "cars"},
  {4, "casa"},
  {4, "case"},
  {4, "cash"},
  {4, "cbre"},
  {4, "cern"},
  {4, "chat"},
  {4, "citi"},
  {4, "city"},
  {4, "club"},
  {4, "cool"},
  {4, "coop"},
  {4, "cyou"},
  {4, "data"},
  {4, "date"},
  {4, "dclk"},
  {4, "deal"},
  {4, "dell"},
  {4, "desi"},
  {4, "diet"},
  {4, "dish"},
  {4, "docs"},
  {4, "doha"},
  {4, "duck"},
  {4, "duns"},
  {4, "dvag"},
  {4, "erni"},
  {4, "fage"},
  {4, "fail"},
  {4, "fans"},
  {4, "farm"},
  {4, "fast"},
  {4, "fiat"},
  {4, "fido"},
  {4, "film"},
  {4, "fire"},
  {4, "fish"},
  {4, "flir"},
  {4, "food"},
  {4, "ford"},
  {4, "free"},
  {4, "fund"},
  {4, "game"},
  {4, "gbiz"},
  {4, "gent"},
  {4, "ggee"},
  {4, "gift"},
  {4, "gmbh"},
  {4, "gold"},
  {4, "golf"},
  {4, "goog"},
  {4, "guge"},
  {4, "guru"},
  {4, "hair"},
  {4, "haus"},
  {4, "hdfc"},
  {4, "help"},
  {4, "here"},
  {4, "hgtv"},
  {4, "host"},
  {4, "hsbc"},
  {4, "icbc"},
  {4, "ieee"},
  {4, "imdb"},
  {4, "immo"},
  {4, "info"},
  {4, "itau"},
  {4, "java"},
  {4, "jeep"},
  {4, "jobs"},
  {4, "jprs"},
  {4, "kddi"},
  {4, "kiwi"},
  {4, "kpmg"},
  {4, "kred"},
  {4, "land"},
  {4, "lego"},
  {4, "lgbt"},
  {4, "lidl"},
  {4, "life"},
  {4, "like"},
  {4, "limo"},
  {4, "link"},
  {4, "live"},
  {4, "loan"},
  {4, "loft"},
  {4, "love"},
  {4, "ltda"},
  {4, "luxe"},
  {4, "maif"},
  {4, "meet"},
  {4, "meme"},
  {4, "menu"},
  {4, "mini"},
  {4, "mint"},
  {4, "mobi"},
  {4, "moda"},
  {4, "moto"},
  {4, "mtpc"},
  {4, "name"},
  {4, "navy"},
  {4, "news"},
  {4, "next"},
  {4, "nico"},
  {4, "nike"},
  {4, "ollo"},
  {4, "open"},
  {4, "page"},
  {4, "pars"},
  {4, "pccw"},
  {4, "pics"},
  {4, "ping"},
  {4, "pink"},
  {4, "play"},
  {4, "plus"},
  {4, "pohl"},
  {4, "porn"},
  {4, "post"},
  {4, "prod"},
  {4, "prof"},
  {4, "qpon"},
  {4, "raid"},
  {4, "read"},
  {4, "reit"},
  {4, "rent"},
  {4, "rest"},
  {4, "rich"},
  {4, "rmit"},
  {4, "room"},
  {4, "rsvp"},
  {4, "ruhr"},
  {4, "safe"},
  {4, "sale"},
  {4, "sapo"},
  {4, "sarl"},
  {4, "save"},
  {4, "saxo"},
  {4, "scor"},
  {4, "scot"},
  {4, "seat"},
  {4, "seek"},
  {4, "sexy"},
  {4, "shaw"},
  {4, "shia"},
  {4, "shop"},
  {4, "show"},
  {4, "silk"},
  {4, "sina"},
  {4, "site"},
  {4, "skin"},
  {4, "sncf"},
  {4, "sohu"},
  {4, "song"},
  {4, "sony"},
  {4, "spot"},
  {4, "star"},
  {4, "surf"},
  {4, "talk"},
  {4, "taxi"},
  {4, "team"},
  {4, "tech"},
  {4, "teva"},
  {4, "tiaa"},
  {4, "tips"},
  {4, "town"},
  {4, "toys"},
  {4, "tube"},
  {4, "vana"},
  {4, "visa"},
  {4, "viva"},
  {4, "vivo"},
  {4, "vote"},
  {4, "voto"},
  {4, "wang"},
  {4, "weir"},
  {4, "wien"},
  {4, "wiki"},
  {4, "wine"},
  {4, "work"},
  {4, "xbox"},
  {4, "yoga"},
  {4, "zara"},
  {4, "zero"},
  {4, "zone"},
  {4, "дети"},
  {4, "сайт"},
  {4, "بيتك"},
  {4, "شبكة"},
  {4, "موقع"},
  {4, "グーグル"},
  {4, "クラウド"},
  {4, "ポイント"},
  {4, "大众汽车"},
  {4, "组织机构"},
  {4, "電訊盈科"},
  {4, "香格里拉"},
  {5, "actor"},
  {5, "adult"},
  {5, "aetna"},
  {5, "amfam"},
  {5, "amica"},
  {5, "apple"},
  {5, "archi"},
  {5, "audio"},
  {5, "autos"},
  {5, "azure"},
  {5, "baidu"},
  {5, "beats"},
  {5, "bible"},
  {5, "bingo"},
  {5, "black"},
  {5, "boats"},
  {5, "boots"},
  {5, "bosch"},
  {5, "build"},
  {5, "canon"},
  {5, "cards"},
  {5, "chase"},
  {5, "cheap"},
  {5, "chloe"},
  {5, "cisco"},
  {5, "citic"},
  {5, "click"},
  {5, "cloud"},
  {5, "coach"},
  {5, "codes"},
  {5, "crown"},
  {5, "cymru"},
  {5, "dabur"},
  {5, "dance"},
  {5, "deals"},
  {5, "delta"},
  {5, "dodge"},
  {5, "drive"},
  {5, "dubai"},
  {5, "earth"},
  {5, "edeka"},
  {5, "email"},
  {5, "epost"},
  {5, "epson"},
  {5, "faith"},
  {5, "fedex"},
  {5, "final"},
  {5, "forex"},
  {5, "forum"},
  {5, "gallo"},
  {5, "games"},
  {5, "gifts"},
  {5, "gives"},
  {5, "glade"},
  {5, "glass"},
  {5, "globo"},
  {5, "gmail"},
  {5, "green"},
  {5, "gripe"},
  {5, "group"},
  {5, "gucci"},
  {5, "guide"},
  {5, "homes"},
  {5, "honda"},
  {5, "horse"},
  {5, "house"},
  {5, "hyatt"},
  {5, "iinet"},
  {5, "ikano"},
  {5, "intel"},
  {5, "irish"},
  {5, "iveco"},
  {5, "jetzt"},
  {5, "koeln"},
  {5, "kyoto"},
  {5, "lamer"},
  {5, "lease"},
  {5, "legal"},
  {5, "lexus"},
  {5, "lilly"},
  {5, "linde"},
  {5, "lipsy"},
  {5, "lixil"},
  {5, "loans"},
  {5, "locus"},
  {5, "lotte"},
  {5, "lotto"},
  {5, "lupin"},
  {5, "macys"},
  {5, "mango"},
  {5, "media"},
  {5, "miami"},
  {5, "money"},
  {5, "mopar"},
  {5, "movie"},
  {5, "nadex"},
  {5, "nexus"},
  {5, "nikon"},
  {5, "ninja"},
  {5, "nokia"},
  {5, "nowtv"},
  {5, "omega"},
  {5, "onion"},
  {5, "osaka"},
  {5, "paris"},
  {5, "parts"},
  {5, "party"},
  {5, "phone"},
  {5, "photo"},
  {5, "pizza"},
  {5, "place"},
  {5, "poker"},
  {5, "praxi"},
  {5, "press"},
  {5, "prime"},
  {5, "promo"},
  {5, "quest"},
  {5, "radio"},
  {5, "rehab"},
  {5, "reise"},
  {5, "ricoh"},
  {5, "rocks"},
  {5, "rodeo"},
  {5, "rugby"},
  {5, "salon"},
  {5, "sener"},
  {5, "seven"},
  {5, "sharp"},
  {5, "shell"},
  {5, "shoes"},
  {5, "skype"},
  {5, "sling"},
  {5, "smart"},
  {5, "smile"},
  {5, "solar"},
  {5, "space"},
  {5, "sport"},
  {5, "stada"},
  {5, "store"},
  {5, "study"},
  {5, "style"},
  {5, "sucks"},
  {5, "swiss"},
  {5, "tatar"},
  {5, "tires"},
  {5, "tirol"},
  {5, "tmall"},
  {5, "today"},
  {5, "tokyo"},
  {5, "tools"},
  {5, "toray"},
  {5, "total"},
  {5, "tours"},
  {5, "trade"},
  {5, "trust"},
  {5, "tunes"},
  {5, "tushu"},
  {5, "ubank"},
  {5, "vegas"},
  {5, "video"},
  {5, "vista"},
  {5, "vodka"},
  {5, "volvo"},
  {5, "wales"},
  {5, "watch"},
  {5, "weber"},
  {5, "weibo"},
  {5, "works"},
  {5, "world"},
  {5, "xerox"},
  {5, "yahoo"},
  {5, "zippo"},
  {5, "بازار"},
  {5, "همراه"},
  {5, "संगठन"},
  {5, "嘉里大酒店"},
  {6, "abarth"},
  {6, "abbott"},
  {6, "abbvie"},
  {6, "active"},
  {6, "africa"},
  {6, "agency"},
  {6, "airbus"},
  {6, "airtel"},
  {6, "alipay"},
  {6, "alsace"},
  {6, "alstom"},
  {6, "anquan"},
  {6, "aramco"},
  {6, "author"},
  {6, "bayern"},
  {6, "beauty"},
  {6, "berlin"},
  {6, "bharti"},
  {6, "blanco"},
  {6, "bostik"},
  {6, "boston"},
  {6, "broker"},
  {6, "camera"},
  {6, "career"},
  {6, "caseih"},
  {6, "casino"},
  {6, "center"},
  {6, "chanel"},
  {6, "chrome"},
  {6, "church"},
  {6, "circle"},
  {6, "claims"},
  {6, "clinic"},
  {6, "coffee"},
  {6, "comsec"},
  {6, "condos"},
  {6, "coupon"},
  {6, "credit"},
  {6, "cruise"},
  {6, "dating"},
  {6, "datsun"},
  {6, "dealer"},
  {6, "degree"},
  {6, "dental"},
  {6, "design"},
  {6, "direct"},
  {6, "doctor"},
  {6, "doosan"},
  {6, "dunlop"},
  {6, "dupont"},
  {6, "durban"},
  {6, "emerck"},
  {6, "energy"},
  {6, "estate"},
  {6, "events"},
  {6, "expert"},
  {6, "family"},
  {6, "flickr"},
  {6, "futbol"},
  {6, "gallup"},
  {6, "garden"},
  {6, "george"},
  {6, "giving"},
  {6, "global"},
  {6, "google"},
  {6, "gratis"},
  {6, "health"},
  {6, "hermes"},
  {6, "hiphop"},
  {6, "hockey"},
  {6, "hotels"},
  {6, "hughes"},
  {6, "imamat"},
  {6, "insure"},
  {6, "intuit"},
  {6, "jaguar"},
  {6, "joburg"},
  {6, "juegos"},
  {6, "kaufen"},
  {6, "kinder"},
  {6, "kindle"},
  {6, "kosher"},
  {6, "lancia"},
  {6, "latino"},
  {6, "lawyer"},
  {6, "lefrak"},
  {6, "living"},
  {6, "locker"},
  {6, "london"},
  {6, "luxury"},
  {6, "madrid"},
  {6, "maison"},
  {6, "makeup"},
  {6, "market"},
  {6, "mattel"},
  {6, "mobile"},
  {6, "mobily"},
  {6, "monash"},
  {6, "mormon"},
  {6, "moscow"},
  {6, "museum"},
  {6, "mutual"},
  {6, "nagoya"},
  {6, "natura"},
  {6, "nissan"},
  {6, "nissay"},
  {6, "norton"},
  {6, "nowruz"},
  {6, "office"},
  {6, "olayan"},
  {6, "online"},
  {6, "oracle"},
  {6, "orange"},
  {6, "otsuka"},
  {6, "pfizer"},
  {6, "photos"},
  {6, "physio"},
  {6, "piaget"},
  {6, "pictet"},
  {6, "quebec"},
  {6, "racing"},
  {6, "realty"},
  {6, "reisen"},
  {6, "repair"},
  {6, "report"},
  {6, "review"},
  {6, "rocher"},
  {6, "rogers"},
  {6, "ryukyu"},
  {6, "safety"},
  {6, "sakura"},
  {6, "sanofi"},
  {6, "school"},
  {6, "schule"},
  {6, "search"},
  {6, "secure"},
  {6, "select"},
  {6, "shouji"},
  {6, "soccer"},
  {6, "social"},
  {6, "stream"},
  {6, "studio"},
  {6, "supply"},
  {6, "suzuki"},
  {6, "swatch"},
  {6, "sydney"},
  {6, "taipei"},
  {6, "taobao"},
  {6, "target"},
  {6, "tattoo"},
  {6, "tennis"},
  {6, "tienda"},
  {6, "tjmaxx"},
  {6, "tkmaxx"},
  {6, "toyota"},
  {6, "travel"},
  {6, "unicom"},
  {6, "viajes"},
  {6, "viking"},
  {6, "villas"},
  {6, "virgin"},
  {6, "vision"},
  {6, "voting"},
  {6, "voyage"},
  {6, "vuelos"},
  {6, "walter"},
  {6, "warman"},
  {6, "webcam"},
  {6, "xihuan"},
  {6, "xperia"},
  {6, "yachts"},
  {6, "yandex"},
  {6, "zappos"},
  {6, "москва"},
  {6, "онлайн"},
  {6, "ابوظبي"},
  {6, "ارامكو"},
  {6, "ファッション"},
  {7, "abogado"},
  {7, "academy"},
  {7, "agakhan"},
  {7, "alibaba"},
  {7, "android"},
  {7, "athleta"},
  {7, "auction"},
  {7, "audible"},
  {7, "auspost"},
  {7, "avianca"},
  {7, "banamex"},
  {7, "bauhaus"},
  {7, "bentley"},
  {7, "bestbuy"},
  {7, "booking"},
  {7, "brother"},
  {7, "bugatti"},
  {7, "capital"},
  {7, "caravan"},
  {7, "careers"},
  {7, "cartier"},
  {7, "channel"},
  {7, "charity"},
  {7, "chintai"},
  {7, "citadel"},
  {7, "clubmed"},
  {7, "college"},
  {7, "cologne"},
  {7, "comcast"},
  {7, "company"},
  {7, "compare"},
  {7, "contact"},
  {7, "cooking"},
  {7, "corsica"},
  {7, "country"},
  {7, "coupons"},
  {7, "courses"},
  {7, "cricket"},
  {7, "cruises"},
  {7, "dentist"},
  {7, "digital"},
  {7, "domains"},
  {7, "exposed"},
  {7, "express"},
  {7, "farmers"},
  {7, "fashion"},
  {7, "ferrari"},
  {7, "ferrero"},
  {7, "finance"},
  {7, "fishing"},
  {7, "fitness"},
  {7, "flights"},
  {7, "florist"},
  {7, "flowers"},
  {7, "forsale"},
  {7, "frogans"},
  {7, "fujitsu"},
  {7, "gallery"},
  {7, "genting"},
  {7, "godaddy"},
  {7, "grocery"},
  {7, "guitars"},
  {7, "hamburg"},
  {7, "hangout"},
  {7, "hitachi"},
  {7, "holiday"},
  {7, "hosting"},
  {7, "hoteles"},
  {7, "hotmail"},
  {7, "hyundai"},
  {7, "iselect"},
  {7, "ismaili"},
  {7, "jewelry"},
  {7, "juniper"},
  {7, "kitchen"},
  {7, "komatsu"},
  {7, "lacaixa"},
  {7, "lancome"},
  {7, "lanxess"},
  {7, "lasalle"},
  {7, "latrobe"},
  {7, "leclerc"},
  {7, "liaison"},
  {7, "limited"},
  {7, "lincoln"},
  {7, "markets"},
  {7, "metlife"},
  {7, "monster"},
  {7, "netbank"},
  {7, "netflix"},
  {7, "network"},
  {7, "neustar"},
  {7, "okinawa"},
  {7, "oldnavy"},
  {7, "organic"},
  {7, "origins"},
  {7, "panerai"},
  {7, "philips"},
  {7, "pioneer"},
  {7, "politie"},
  {7, "realtor"},
  {7, "recipes"},
  {7, "rentals"},
  {7, "reviews"},
  {7, "rexroth"},
  {7, "samsung"},
  {7, "sandvik"},
  {7, "schmidt"},
  {7, "schwarz"},
  {7, "science"},
  {7, "shiksha"},
  {7, "shriram"},
  {7, "singles"},
  {7, "spiegel"},
  {7, "staples"},
  {7, "starhub"},
  {7, "statoil"},
  {7, "storage"},
  {7, "support"},
  {7, "surgery"},
  {7, "systems"},
  {7, "temasek"},
  {7, "theater"},
  {7, "theatre"},
  {7, "tickets"},
  {7, "tiffany"},
  {7, "toshiba"},
  {7, "trading"},
  {7, "walmart"},
  {7, "wanggou"},
  {7, "watches"},
  {7, "weather"},
  {7, "website"},
  {7, "wedding"},
  {7, "whoswho"},
  {7, "windows"},
  {7, "winners"},
  {7, "xfinity"},
  {7, "yamaxun"},
  {7, "youtube"},
  {7, "zuerich"},
  {7, "католик"},
  {7, "اتصالات"},
  {7, "العليان"},
  {7, "كاثوليك"},
  {7, "موبايلي"},
  {8, "abudhabi"},
  {8, "airforce"},
  {8, "allstate"},
  {8, "attorney"},
  {8, "barclays"},
  {8, "barefoot"},
  {8, "bargains"},
  {8, "baseball"},
  {8, "boutique"},
  {8, "bradesco"},
  {8, "broadway"},
  {8, "brussels"},
  {8, "budapest"},
  {8, "builders"},
  {8, "business"},
  {8, "capetown"},
  {8, "catering"},
  {8, "catholic"},
  {8, "chrysler"},
  {8, "cipriani"},
  {8, "cityeats"},
  {8, "cleaning"},
  {8, "clinique"},
  {8, "clothing"},
  {8, "commbank"},
  {8, "computer"},
  {8, "delivery"},
  {8, "deloitte"},
  {8, "democrat"},
  {8, "diamonds"},
  {8, "discount"},
  {8, "discover"},
  {8, "download"},
  {8, "engineer"},
  {8, "ericsson"},
  {8, "esurance"},
  {8, "etisalat"},
  {8, "everbank"},
  {8, "exchange"},
  {8, "feedback"},
  {8, "fidelity"},
  {8, "firmdale"},
  {8, "flsmidth"},
  {8, "football"},
  {8, "frontier"},
  {8, "goodyear"},
  {8, "grainger"},
  {8, "graphics"},
  {8, "guardian"},
  {8, "hdfcbank"},
  {8, "helsinki"},
  {8, "holdings"},
  {8, "hospital"},
  {8, "infiniti"},
  {8, "ipiranga"},
  {8, "istanbul"},
  {8, "jpmorgan"},
  {8, "lighting"},
  {8, "lundbeck"},
  {8, "marriott"},
  {8, "maserati"},
  {8, "mckinsey"},
  {8, "memorial"},
  {8, "merckmsd"},
  {8, "mortgage"},
  {8, "movistar"},
  {8, "mutuelle"},
  {8, "observer"},
  {8, "partners"},
  {8, "pharmacy"},
  {8, "pictures"},
  {8, "plumbing"},
  {8, "property"},
  {8, "redstone"},
  {8, "reliance"},
  {8, "saarland"},
  {8, "samsclub"},
  {8, "security"},
  {8, "services"},
  {8, "shopping"},
  {8, "showtime"},
  {8, "softbank"},
  {8, "software"},
  {8, "stcgroup"},
  {8, "supplies"},
  {8, "symantec"},
  {8, "telecity"},
  {8, "training"},
  {8, "uconnect"},
  {8, "vanguard"},
  {8, "ventures"},
  {8, "verisign"},
  {8, "woodside"},
  {8, "yokohama"},
  {9, "accenture"},
  {9, "alfaromeo"},
  {9, "allfinanz"},
  {9, "amsterdam"},
  {9, "analytics"},
  {9, "aquarelle"},
  {9, "barcelona"},
  {9, "bloomberg"},
  {9, "christmas"},
  {9, "community"},
  {9, "directory"},
  {9, "education"},
  {9, "equipment"},
  {9, "fairwinds"},
  {9, "financial"},
  {9, "firestone"},
  {9, "fresenius"},
  {9, "frontdoor"},
  {9, "fujixerox"},
  {9, "furniture"},
  {9, "goldpoint"},
  {9, "goodhands"},
  {9, "hisamitsu"},
  {9, "homedepot"},
  {9, "homegoods"},
  {9, "homesense"},
  {9, "honeywell"},
  {9, "institute"},
  {9, "insurance"},
  {9, "kuokgroup"},
  {9, "ladbrokes"},
  {9, "lancaster"},
  {9, "landrover"},
  {9, "lifestyle"},
  {9, "marketing"},
  {9, "marshalls"},
  {9, "mcdonalds"},
  {9, "melbourne"},
  {9, "microsoft"},
  {9, "montblanc"},
  {9, "panasonic"},
  {9, "passagens"},
  {9, "pramerica"},
  {9, "richardli"},
  {9, "scjohnson"},
  {9, "shangrila"},
  {9, "solutions"},
  {9, "statebank"},
  {9, "statefarm"},
  {9, "stockholm"},
  {9, "travelers"},
  {9, "vacations"},
  {9, "yodobashi"},
  {10, "accountant"},
  {10, "apartments"},
  {10, "associates"},
  {10, "basketball"},
  {10, "bnpparibas"},
  {10, "boehringer"},
  {10, "capitalone"},
  {10, "consulting"},
  {10, "creditcard"},
  {10, "cuisinella"},
  {10, "eurovision"},
  {10, "extraspace"},
  {10, "foundation"},
  {10, "healthcare"},
  {10, "immobilien"},
  {10, "industries"},
  {10, "management"},
  {10, "mitsubishi"},
  {10, "nationwide"},
  {10, "newholland"},
  {10, "nextdirect"},
  {10, "onyourside"},
  {10, "properties"},
  {10, "protection"},
  {10, "prudential"},
  {10, "realestate"},
  {10, "republican"},
  {10, "restaurant"},
  {10, "schaeffler"},
  {10, "swiftcover"},
  {10, "tatamotors"},
  {10, "technology"},
  {10, "telefonica"},
  {10, "university"},
  {10, "vistaprint"},
  {10, "vlaanderen"},
  {10, "volkswagen"},
  {11, "accountants"},
  {11, "barclaycard"},
  {11, "blackfriday"},
  {11, "blockbuster"},
  {11, "bridgestone"},
  {11, "calvinklein"},
  {11, "contractors"},
  {11, "creditunion"},
  {11, "engineering"},
  {11, "enterprises"},
  {11, "foodnetwork"},
  {11, "investments"},
  {11, "kerryhotels"},
  {11, "lamborghini"},
  {11, "motorcycles"},
  {11, "olayangroup"},
  {11, "photography"},
  {11, "playstation"},
  {11, "productions"},
  {11, "progressive"},
  {11, "redumbrella"},
  {11, "rightathome"},
  {11, "williamhill"},
  {12, "construction"},
  {12, "lplfinancial"},
  {12, "pamperedchef"},
  {12, "scholarships"},
  {12, "versicherung"},
  {13, "international"},
  {13, "lifeinsurance"},
  {13, "orientexpress"},
  {13, "spreadbetting"},
  {13, "travelchannel"},
  {13, "wolterskluwer"},
  {14, "afamilycompany"},
  {14, "americanfamily"},
  {14, "bananarepublic"},
  {14, "cancerresearch"},
  {14, "cookingchannel"},
  {14, "kerrylogistics"},
  {14, "weatherchannel"},
  {15, "americanexpress"},
  {15, "kerryproperties"},
  {15, "sandvikcoromant"},
  {16, "vermögensberater"},
  {17, "vermögensberatung"},
  {18, "northwesternmutual"},
  {18, "travelersinsurance"},
};

static const struct {
  size_t length;
  const char *str;
} CCTLDS[] = {  {2, "한국"},
  {2, "ac"},
  {2, "ad"},
  {2, "ae"},
  {2, "af"},
  {2, "ag"},
  {2, "ai"},
  {2, "al"},
  {2, "am"},
  {2, "an"},
  {2, "ao"},
  {2, "aq"},
  {2, "ar"},
  {2, "as"},
  {2, "at"},
  {2, "au"},
  {2, "aw"},
  {2, "ax"},
  {2, "az"},
  {2, "ba"},
  {2, "bb"},
  {2, "bd"},
  {2, "be"},
  {2, "bf"},
  {2, "bg"},
  {2, "bh"},
  {2, "bi"},
  {2, "bj"},
  {2, "bl"},
  {2, "bm"},
  {2, "bn"},
  {2, "bo"},
  {2, "bq"},
  {2, "br"},
  {2, "bs"},
  {2, "bt"},
  {2, "bv"},
  {2, "bw"},
  {2, "by"},
  {2, "bz"},
  {2, "ca"},
  {2, "cc"},
  {2, "cd"},
  {2, "cf"},
  {2, "cg"},
  {2, "ch"},
  {2, "ci"},
  {2, "ck"},
  {2, "cl"},
  {2, "cm"},
  {2, "cn"},
  {2, "co"},
  {2, "cr"},
  {2, "cu"},
  {2, "cv"},
  {2, "cw"},
  {2, "cx"},
  {2, "cy"},
  {2, "cz"},
  {2, "de"},
  {2, "dj"},
  {2, "dk"},
  {2, "dm"},
  {2, "do"},
  {2, "dz"},
  {2, "ec"},
  {2, "ee"},
  {2, "eg"},
  {2, "eh"},
  {2, "er"},
  {2, "es"},
  {2, "et"},
  {2, "eu"},
  {2, "fi"},
  {2, "fj"},
  {2, "fk"},
  {2, "fm"},
  {2, "fo"},
  {2, "fr"},
  {2, "ga"},
  {2, "gb"},
  {2, "gd"},
  {2, "ge"},
  {2, "gf"},
  {2, "gg"},
  {2, "gh"},
  {2, "gi"},
  {2, "gl"},
  {2, "gm"},
  {2, "gn"},
  {2, "gp"},
  {2, "gq"},
  {2, "gr"},
  {2, "gs"},
  {2, "gt"},
  {2, "gu"},
  {2, "gw"},
  {2, "gy"},
  {2, "hk"},
  {2, "hm"},
  {2, "hn"},
  {2, "hr"},
  {2, "ht"},
  {2, "hu"},
  {2, "id"},
  {2, "ie"},
  {2, "il"},
  {2, "im"},
  {2, "in"},
  {2, "io"},
  {2, "iq"},
  {2, "ir"},
  {2, "is"},
  {2, "it"},
  {2, "je"},
  {2, "jm"},
  {2, "jo"},
  {2, "jp"},
  {2, "ke"},
  {2, "kg"},
  {2, "kh"},
  {2, "ki"},
  {2, "km"},
  {2, "kn"},
  {2, "kp"},
  {2, "kr"},
  {2, "kw"},
  {2, "ky"},
  {2, "kz"},
  {2, "la"},
  {2, "lb"},
  {2, "lc"},
  {2, "li"},
  {2, "lk"},
  {2, "lr"},
  {2, "ls"},
  {2, "lt"},
  {2, "lu"},
  {2, "lv"},
  {2, "ly"},
  {2, "ma"},
  {2, "mc"},
  {2, "md"},
  {2, "me"},
  {2, "mf"},
  {2, "mg"},
  {2, "mh"},
  {2, "mk"},
  {2, "ml"},
  {2, "mm"},
  {2, "mn"},
  {2, "mo"},
  {2, "mp"},
  {2, "mq"},
  {2, "mr"},
  {2, "ms"},
  {2, "mt"},
  {2, "mu"},
  {2, "mv"},
  {2, "mw"},
  {2, "mx"},
  {2, "my"},
  {2, "mz"},
  {2, "na"},
  {2, "nc"},
  {2, "ne"},
  {2, "nf"},
  {2, "ng"},
  {2, "ni"},
  {2, "nl"},
  {2, "no"},
  {2, "np"},
  {2, "nr"},
  {2, "nu"},
  {2, "nz"},
  {2, "om"},
  {2, "pa"},
  {2, "pe"},
  {2, "pf"},
  {2, "pg"},
  {2, "ph"},
  {2, "pk"},
  {2, "pl"},
  {2, "pm"},
  {2, "pn"},
  {2, "pr"},
  {2, "ps"},
  {2, "pt"},
  {2, "pw"},
  {2, "py"},
  {2, "qa"},
  {2, "re"},
  {2, "ro"},
  {2, "rs"},
  {2, "ru"},
  {2, "rw"},
  {2, "sa"},
  {2, "sb"},
  {2, "sc"},
  {2, "sd"},
  {2, "se"},
  {2, "sg"},
  {2, "sh"},
  {2, "si"},
  {2, "sj"},
  {2, "sk"},
  {2, "sl"},
  {2, "sm"},
  {2, "sn"},
  {2, "so"},
  {2, "sr"},
  {2, "ss"},
  {2, "st"},
  {2, "su"},
  {2, "sv"},
  {2, "sx"},
  {2, "sy"},
  {2, "sz"},
  {2, "tc"},
  {2, "td"},
  {2, "tf"},
  {2, "tg"},
  {2, "th"},
  {2, "tj"},
  {2, "tk"},
  {2, "tl"},
  {2, "tm"},
  {2, "tn"},
  {2, "to"},
  {2, "tp"},
  {2, "tr"},
  {2, "tt"},
  {2, "tv"},
  {2, "tw"},
  {2, "tz"},
  {2, "ua"},
  {2, "ug"},
  {2, "uk"},
  {2, "um"},
  {2, "us"},
  {2, "uy"},
  {2, "uz"},
  {2, "va"},
  {2, "vc"},
  {2, "ve"},
  {2, "vg"},
  {2, "vi"},
  {2, "vn"},
  {2, "vu"},
  {2, "wf"},
  {2, "ws"},
  {2, "ye"},
  {2, "yt"},
  {2, "za"},
  {2, "zm"},
  {2, "zw"},
  {2, "ελ"},
  {2, "ευ"},
  {2, "бг"},
  {2, "ею"},
  {2, "рф"},
  {2, "გე"},
  {2, "中国"},
  {2, "中國"},
  {2, "台湾"},
  {2, "台灣"},
  {2, "澳門"},
  {2, "香港"},
  {3, "бел"},
  {3, "қаз"},
  {3, "мкд"},
  {3, "мон"},
  {3, "срб"},
  {3, "укр"},
  {3, "հայ"},
  {3, "قطر"},
  {3, "مصر"},
  {3, "ไทย"},
  {3, "ລາວ"},
  {3, "新加坡"},
  {4, "بارت"},
  {4, "ڀارت"},
  {4, "تونس"},
  {4, "عراق"},
  {4, "عمان"},
  {4, "भारत"},
  {4, "ভারত"},
  {4, "ভাৰত"},
  {4, "ਭਾਰਤ"},
  {4, "ભારત"},
  {4, "ଭାରତ"},
  {4, "ಭಾರತ"},
  {4, "ලංකා"},
  {5, "ایران"},
  {5, "بھارت"},
  {5, "سودان"},
  {5, "سورية"},
  {5, "भारोत"},
  {5, "বাংলা"},
  {5, "భారత్"},
  {5, "ഭാരതം"},
  {6, "الاردن"},
  {6, "المغرب"},
  {6, "امارات"},
  {6, "فلسطين"},
  {6, "مليسيا"},
  {6, "भारतम्"},
  {6, "இலங்கை"},
  {7, "البحرين"},
  {7, "الجزائر"},
  {7, "پاکستان"},
  {7, "இந்தியா"},
  {8, "السعودية"},
  {9, "موريتانيا"},
  {11, "சிங்கப்பூர்"},
};

#endif