Object.defineProperty(exports, '__esModule', {
  value: true
});

var updateProcessEnv = _asyncToGenerator(function* (launchEnv) {
  var envToAssign = undefined;
  if (launchEnv) {
    if (shouldGetEnvFromShell(launchEnv)) {
      envToAssign = yield getEnvFromShell(launchEnv);
    } else if (launchEnv.PWD) {
      envToAssign = launchEnv;
    }
  }

  if (envToAssign) {
    for (var key in process.env) {
      if (!ENVIRONMENT_VARIABLES_TO_PRESERVE.has(key)) {
        delete process.env[key];
      }
    }

    for (var key in envToAssign) {
      if (!ENVIRONMENT_VARIABLES_TO_PRESERVE.has(key) || !process.env[key] && envToAssign[key]) {
        process.env[key] = envToAssign[key];
      }
    }

    if (envToAssign.ATOM_HOME && _fs2['default'].existsSync(envToAssign.ATOM_HOME)) {
      process.env.ATOM_HOME = envToAssign.ATOM_HOME;
    }
  }
});

var getEnvFromShell = _asyncToGenerator(function* (env) {
  var _ref = yield new Promise(function (resolve) {
    var child = undefined;
    var error = undefined;
    var stdout = '';
    var done = false;
    var cleanup = function cleanup() {
      if (!done && child) {
        child.kill();
        done = true;
      }
    };
    process.once('exit', cleanup);
    setTimeout(function () {
      cleanup();
    }, 5000);
    child = _child_process2['default'].spawn(env.SHELL, ['-ilc', 'command env'], { encoding: 'utf8', detached: true, stdio: ['ignore', 'pipe', process.stderr] });
    var buffers = [];
    child.on('error', function (e) {
      done = true;
      error = e;
    });
    child.stdout.on('data', function (data) {
      buffers.push(data);
    });
    child.on('close', function (code, signal) {
      done = true;
      process.removeListener('exit', cleanup);
      if (buffers.length) {
        stdout = Buffer.concat(buffers).toString('utf8');
      }

      resolve({ stdout: stdout, error: error });
    });
  });

  var stdout = _ref.stdout;
  var error = _ref.error;

  if (error) {
    if (error.handle) {
      error.handle();
    }
    console.log('warning: ' + env.SHELL + ' -ilc "command env" failed with signal (' + error.signal + ')');
    console.log(error);
  }

  if (!stdout || stdout.trim() === '') {
    return null;
  }

  var result = {};
  for (var line of stdout.split('\n')) {
    if (line.includes('=')) {
      var components = line.split('=');
      var key = components.shift();
      var value = components.join('=');
      result[key] = value;
    }
  }
  return result;
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _child_process = require('child_process');

var _child_process2 = _interopRequireDefault(_child_process);

var ENVIRONMENT_VARIABLES_TO_PRESERVE = new Set(['NODE_ENV', 'NODE_PATH', 'ATOM_HOME', 'ATOM_DISABLE_SHELLING_OUT_FOR_ENVIRONMENT']);

var PLATFORMS_KNOWN_TO_WORK = new Set(['darwin', 'linux']);

function shouldGetEnvFromShell(env) {
  if (!PLATFORMS_KNOWN_TO_WORK.has(process.platform)) {
    return false;
  }

  if (!env || !env.SHELL || env.SHELL.trim() === '') {
    return false;
  }

  if (env.ATOM_DISABLE_SHELLING_OUT_FOR_ENVIRONMENT || process.env.ATOM_DISABLE_SHELLING_OUT_FOR_ENVIRONMENT) {
    return false;
  }

  return true;
}

exports['default'] = { updateProcessEnv: updateProcessEnv, shouldGetEnvFromShell: shouldGetEnvFromShell };
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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