(function() {
  var CompositeDisposable, Dialog, Disposable, Emitter, Point, Range, TextEditor, path, ref;

  ref = require('atom'), TextEditor = ref.TextEditor, CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable, Emitter = ref.Emitter, Range = ref.Range, Point = ref.Point;

  path = require('path');

  module.exports = Dialog = (function() {
    function Dialog(arg) {
      var baseName, blurHandler, extension, iconClass, initialPath, prompt, ref1, select, selectionEnd, selectionStart;
      ref1 = arg != null ? arg : {}, initialPath = ref1.initialPath, select = ref1.select, iconClass = ref1.iconClass, prompt = ref1.prompt;
      this.emitter = new Emitter();
      this.disposables = new CompositeDisposable();
      this.element = document.createElement('div');
      this.element.classList.add('tree-view-dialog');
      this.promptText = document.createElement('label');
      this.promptText.classList.add('icon');
      if (iconClass) {
        this.promptText.classList.add(iconClass);
      }
      this.promptText.textContent = prompt;
      this.element.appendChild(this.promptText);
      this.miniEditor = new TextEditor({
        mini: true
      });
      blurHandler = (function(_this) {
        return function() {
          if (document.hasFocus()) {
            return _this.close();
          }
        };
      })(this);
      this.miniEditor.element.addEventListener('blur', blurHandler);
      this.disposables.add(new Disposable((function(_this) {
        return function() {
          return _this.miniEditor.element.removeEventListener('blur', blurHandler);
        };
      })(this)));
      this.disposables.add(this.miniEditor.onDidChange((function(_this) {
        return function() {
          return _this.showError();
        };
      })(this)));
      this.element.appendChild(this.miniEditor.element);
      this.errorMessage = document.createElement('div');
      this.errorMessage.classList.add('error-message');
      this.element.appendChild(this.errorMessage);
      atom.commands.add(this.element, {
        'core:confirm': (function(_this) {
          return function() {
            return _this.onConfirm(_this.miniEditor.getText());
          };
        })(this),
        'core:cancel': (function(_this) {
          return function() {
            return _this.cancel();
          };
        })(this)
      });
      this.miniEditor.setText(initialPath);
      if (select) {
        extension = path.extname(initialPath);
        baseName = path.basename(initialPath);
        selectionStart = initialPath.length - baseName.length;
        if (baseName === extension) {
          selectionEnd = initialPath.length;
        } else {
          selectionEnd = initialPath.length - extension.length;
        }
        this.miniEditor.setSelectedBufferRange(Range(Point(0, selectionStart), Point(0, selectionEnd)));
      }
    }

    Dialog.prototype.attach = function() {
      this.panel = atom.workspace.addModalPanel({
        item: this
      });
      this.miniEditor.element.focus();
      return this.miniEditor.scrollToCursorPosition();
    };

    Dialog.prototype.close = function() {
      var activePane, panel;
      panel = this.panel;
      this.panel = null;
      if (panel != null) {
        panel.destroy();
      }
      this.emitter.dispose();
      this.disposables.dispose();
      this.miniEditor.destroy();
      activePane = atom.workspace.getCenter().getActivePane();
      if (!activePane.isDestroyed()) {
        return activePane.activate();
      }
    };

    Dialog.prototype.cancel = function() {
      var ref1;
      this.close();
      return (ref1 = document.querySelector('.tree-view')) != null ? ref1.focus() : void 0;
    };

    Dialog.prototype.showError = function(message) {
      if (message == null) {
        message = '';
      }
      this.errorMessage.textContent = message;
      if (message) {
        this.element.classList.add('error');
        return window.setTimeout(((function(_this) {
          return function() {
            return _this.element.classList.remove('error');
          };
        })(this)), 300);
      }
    };

    return Dialog;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
