Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _highlights = require('highlights');

var _highlights2 = _interopRequireDefault(_highlights);

var CodeBlock = (function () {
  function CodeBlock(props) {
    _classCallCheck(this, CodeBlock);

    this.highlighter = new _highlights2['default']({ registry: atom.grammars, scopePrefix: 'syntax--' });
    this.wrapperElement = document.createElement('div');
    this.update(props);
  }

  _createClass(CodeBlock, [{
    key: 'update',
    value: function update(_ref) {
      var cssClass = _ref.cssClass;
      var grammarScopeName = _ref.grammarScopeName;
      var code = _ref.code;

      this.wrapperElement.innerHTML = this.highlighter.highlightSync({ fileContents: code, scopeName: grammarScopeName });
      this.element = this.wrapperElement.children[0];
      this.element.classList.remove('editor'); // The `editor` class messes things up as `.editor` has absolutely positioned lines
      this.element.classList.add(cssClass);
      var fontFamily = atom.config.get('editor.fontFamily');
      if (fontFamily) {
        this.element.style.fontFamily = fontFamily;
      }
    }
  }]);

  return CodeBlock;
})();

exports['default'] = CodeBlock;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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