(function() {
  var SelectionCountView, _;

  _ = require('underscore-plus');

  module.exports = SelectionCountView = (function() {
    function SelectionCountView() {
      var ref;
      this.element = document.createElement('status-bar-selection');
      this.element.classList.add('selection-count', 'inline-block');
      this.tooltipElement = document.createElement('div');
      this.tooltipDisposable = atom.tooltips.add(this.element, {
        item: this.tooltipElement
      });
      this.formatString = (ref = atom.config.get('status-bar.selectionCountFormat')) != null ? ref : '(%L, %C)';
      if (atom.workspace.onDidChangeActiveTextEditor) {
        this.activeItemSubscription = atom.workspace.onDidChangeActiveTextEditor((function(_this) {
          return function() {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      } else {
        this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
          return function() {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      }
      this.subscribeToConfig();
      this.subscribeToActiveTextEditor();
    }

    SelectionCountView.prototype.destroy = function() {
      var ref, ref1;
      this.activeItemSubscription.dispose();
      if ((ref = this.selectionSubscription) != null) {
        ref.dispose();
      }
      if ((ref1 = this.configSubscription) != null) {
        ref1.dispose();
      }
      return this.tooltipDisposable.dispose();
    };

    SelectionCountView.prototype.subscribeToConfig = function() {
      var ref;
      if ((ref = this.configSubscription) != null) {
        ref.dispose();
      }
      return this.configSubscription = atom.config.observe('status-bar.selectionCountFormat', (function(_this) {
        return function(value) {
          _this.formatString = value != null ? value : '(%L, %C)';
          return _this.scheduleUpdateCount();
        };
      })(this));
    };

    SelectionCountView.prototype.subscribeToActiveTextEditor = function() {
      var activeEditor, ref, selectionsMarkerLayer;
      if ((ref = this.selectionSubscription) != null) {
        ref.dispose();
      }
      activeEditor = this.getActiveTextEditor();
      selectionsMarkerLayer = activeEditor != null ? activeEditor.selectionsMarkerLayer : void 0;
      this.selectionSubscription = selectionsMarkerLayer != null ? selectionsMarkerLayer.onDidUpdate(this.scheduleUpdateCount.bind(this)) : void 0;
      return this.scheduleUpdateCount();
    };

    SelectionCountView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    SelectionCountView.prototype.scheduleUpdateCount = function() {
      if (!this.scheduledUpdate) {
        this.scheduledUpdate = true;
        return atom.views.updateDocument((function(_this) {
          return function() {
            _this.updateCount();
            return _this.scheduledUpdate = false;
          };
        })(this));
      }
    };

    SelectionCountView.prototype.updateCount = function() {
      var count, lineCount, range, ref, ref1;
      count = (ref = this.getActiveTextEditor()) != null ? ref.getSelectedText().length : void 0;
      range = (ref1 = this.getActiveTextEditor()) != null ? ref1.getSelectedBufferRange() : void 0;
      lineCount = range != null ? range.getRowCount() : void 0;
      if ((range != null ? range.end.column : void 0) === 0) {
        lineCount -= 1;
      }
      if (count > 0) {
        this.element.textContent = this.formatString.replace('%L', lineCount).replace('%C', count);
        return this.tooltipElement.textContent = (_.pluralize(lineCount, 'line')) + ", " + (_.pluralize(count, 'character')) + " selected";
      } else {
        this.element.textContent = '';
        return this.tooltipElement.textContent = '';
      }
    };

    return SelectionCountView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
