PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE adjpositions (synsetid integer not null, wordid integer not null, position varchar(2) not null, primary key (synsetid, wordid));
CREATE TABLE adjpositiontypes (position varchar(2) not null, positionname varchar(24) not null, primary key (position));
CREATE TABLE casedwords (casedwordid integer not null, wordid integer not null, cased varchar(80) not null unique, primary key (casedwordid));
CREATE TABLE lexdomains (lexdomainid smallint not null, lexdomainname varchar(32), pos char, primary key (lexdomainid));
CREATE TABLE lexlinks (word1id integer not null, synset1id integer not null, word2id integer not null, synset2id integer not null, linkid smallint not null, primary key (word1id, synset1id, word2id, synset2id, linkid));
CREATE TABLE linktypes (linkid smallint not null, link varchar(50), recurses integer not null, primary key (linkid));
CREATE TABLE morphmaps (morphid integer not null, pos char not null, wordid integer not null, primary key (morphid, pos, wordid));
CREATE TABLE morphs (morphid integer not null, morph varchar(70) not null unique, primary key (morphid));
CREATE TABLE postypes (pos char not null, posname varchar(20) not null, primary key (pos));
CREATE TABLE samples (synsetid integer not null, sampleid smallint not null, sample longvarchar not null, primary key (synsetid, sampleid));
CREATE TABLE semlinks (synset1id integer not null, synset2id integer not null, linkid smallint not null, primary key (synset1id, synset2id, linkid));
CREATE TABLE senses (wordid integer not null, synsetid integer not null, casedwordid integer, senseid integer unique, sensenum smallint not null, lexid smallint not null, tagcount integer, sensekey varchar(100) unique, primary key (wordid, synsetid));
INSERT INTO "senses" VALUES(138336,300491511,NULL,194444,4,0,0,'unique%5:00:00:unusual:00');
INSERT INTO "senses" VALUES(138336,300505853,NULL,194441,1,0,10,'unique%5:00:00:incomparable:00');
INSERT INTO "senses" VALUES(138336,301105042,NULL,194443,2,0,2,'unique%5:00:00:specific:00');
INSERT INTO "senses" VALUES(138336,302215087,NULL,194442,3,0,0,'unique%5:00:00:single:05');
INSERT INTO "senses" VALUES(138337,400175490,NULL,194445,1,0,4,'uniquely%4:02:00::');
INSERT INTO "senses" VALUES(138338,104763650,NULL,194446,1,0,3,'uniqueness%1:07:00::');
INSERT INTO "senses" VALUES(58843,103076708,NULL,81518,4,0,0,'good%1:06:00::');
INSERT INTO "senses" VALUES(58843,104849241,NULL,81520,2,1,9,'good%1:07:01::');
INSERT INTO "senses" VALUES(58843,105142180,NULL,81521,3,2,6,'good%1:07:02::');
INSERT INTO "senses" VALUES(58843,105159725,NULL,81519,1,0,11,'good%1:07:00::');
INSERT INTO "senses" VALUES(58843,300064787,NULL,81526,5,0,5,'good%5:00:00:advantageous:00');
INSERT INTO "senses" VALUES(58843,300106020,NULL,81527,2,0,22,'good%5:00:00:ample:00');
INSERT INTO "senses" VALUES(58843,300452883,NULL,81528,10,0,2,'good%5:00:00:close:02');
INSERT INTO "senses" VALUES(58843,300523364,NULL,81529,9,0,2,'good%5:00:00:complete:00');
INSERT INTO "senses" VALUES(58843,300775611,NULL,81530,21,0,0,'good%5:00:00:discriminating:00');
INSERT INTO "senses" VALUES(58843,300832784,NULL,81538,14,0,1,'good%5:00:00:operative:00');
INSERT INTO "senses" VALUES(58843,301048762,NULL,81531,13,0,1,'good%5:00:00:fortunate:00');
INSERT INTO "senses" VALUES(58843,301068306,NULL,81532,20,0,0,'good%5:00:00:fresh:01');
INSERT INTO "senses" VALUES(58843,301116026,NULL,81533,19,0,0,'good%5:00:00:genuine:00');
INSERT INTO "senses" VALUES(58843,301123148,NULL,81522,1,1,190,'good%3:00:01::');
INSERT INTO "senses" VALUES(58843,301129977,NULL,81523,3,2,12,'good%3:00:02::');
INSERT INTO "senses" VALUES(58843,301166413,NULL,81534,18,0,0,'good%5:00:00:healthful:00');
INSERT INTO "senses" VALUES(58843,301171213,NULL,81535,17,0,0,'good%5:00:00:healthy:00');
INSERT INTO "senses" VALUES(58843,301333477,NULL,81536,16,0,0,'good%5:00:00:intellectual:00');
INSERT INTO "senses" VALUES(58843,301586752,NULL,81537,6,0,4,'good%5:00:00:nice:00');
INSERT INTO "senses" VALUES(58843,301661289,NULL,81539,12,0,1,'good%5:00:00:opportune:00');
INSERT INTO "senses" VALUES(58843,301808329,NULL,81540,15,0,0,'good%5:00:00:pleasing:00');
INSERT INTO "senses" VALUES(58843,301983162,NULL,81541,4,0,10,'good%5:00:00:reputable:00');
INSERT INTO "senses" VALUES(58843,302036934,NULL,81542,7,0,3,'good%5:00:00:righteous:00');
INSERT INTO "senses" VALUES(58843,302226162,NULL,81543,8,0,2,'good%5:00:00:skilled:00');
INSERT INTO "senses" VALUES(58843,302273643,NULL,81544,11,1,1,'good%5:00:01:sound:00');
INSERT INTO "senses" VALUES(58843,400011093,NULL,81524,1,0,9,'good%4:02:00::');
INSERT INTO "senses" VALUES(58843,400057388,NULL,81525,2,1,4,'good%4:02:01::');
INSERT INTO "senses" VALUES(27771,103076708,NULL,38135,1,0,4,'commodity%1:06:00::');
INSERT INTO "senses" VALUES(134408,103076708,NULL,188782,1,0,0,'trade_good%1:06:00::');
CREATE TABLE synsets (synsetid integer not null, pos char, lexdomainid smallint not null, definition longvarchar, primary key (synsetid));
INSERT INTO "synsets" VALUES(103076708,'n',6,'articles of commerce');
INSERT INTO "synsets" VALUES(104763650,'n',7,'the quality of being one of a kind');
INSERT INTO "synsets" VALUES(104849241,'n',7,'moral excellence or admirableness');
INSERT INTO "synsets" VALUES(105142180,'n',7,'that which is pleasing or valuable or useful');
INSERT INTO "synsets" VALUES(105159725,'n',7,'benefit');
INSERT INTO "synsets" VALUES(300064787,'s',0,'promoting or enhancing well-being');
INSERT INTO "synsets" VALUES(300106020,'s',0,'having the normally expected amount');
INSERT INTO "synsets" VALUES(300452883,'s',0,'with or in a close or intimate relationship');
INSERT INTO "synsets" VALUES(300491511,'s',0,'highly unusual or rare but not the single instance');
INSERT INTO "synsets" VALUES(300505853,'s',0,'radically distinctive and without equal');
INSERT INTO "synsets" VALUES(300523364,'s',0,'thorough');
INSERT INTO "synsets" VALUES(300775611,'s',0,'generally admired');
INSERT INTO "synsets" VALUES(300832784,'s',0,'exerting force or influence');
INSERT INTO "synsets" VALUES(301048762,'s',0,'resulting favorably');
INSERT INTO "synsets" VALUES(301068306,'s',0,'not left to spoil');
INSERT INTO "synsets" VALUES(301105042,'s',0,'(followed by `to'') applying exclusively to a given category or condition or locality');
INSERT INTO "synsets" VALUES(301116026,'s',0,'not forged');
INSERT INTO "synsets" VALUES(301123148,'a',0,'having desirable or positive qualities especially those suitable for a thing specified');
INSERT INTO "synsets" VALUES(301129977,'a',0,'morally admirable');
INSERT INTO "synsets" VALUES(301166413,'s',0,'tending to promote physical well-being; beneficial to health');
INSERT INTO "synsets" VALUES(301171213,'s',0,'in excellent physical condition');
INSERT INTO "synsets" VALUES(301333477,'s',0,'appealing to the mind');
INSERT INTO "synsets" VALUES(301586752,'s',0,'agreeable or pleasing');
INSERT INTO "synsets" VALUES(301661289,'s',0,'most suitable or right for a particular purpose');
INSERT INTO "synsets" VALUES(301808329,'s',0,'capable of pleasing');
INSERT INTO "synsets" VALUES(301983162,'s',0,'deserving of esteem and respect');
INSERT INTO "synsets" VALUES(302036934,'s',0,'of moral excellence');
INSERT INTO "synsets" VALUES(302215087,'s',0,'the single one of its kind');
INSERT INTO "synsets" VALUES(302226162,'s',0,'having or showing knowledge and skill and aptitude');
INSERT INTO "synsets" VALUES(302273643,'s',0,'financially sound');
INSERT INTO "synsets" VALUES(400011093,'r',2,'(often used as a combining form) in a good or proper or satisfactory manner or to a high standard (`good'' is a nonstandard dialectal variant for `well'')');
INSERT INTO "synsets" VALUES(400057388,'r',2,'completely and absolutely (`good'' is sometimes used informally for `thoroughly'')');
INSERT INTO "synsets" VALUES(400175490,'r',2,'so as to be unique');
CREATE TABLE vframemaps (synsetid integer not null, wordid integer not null, frameid smallint not null, primary key (synsetid, wordid, frameid));
CREATE TABLE vframes (frameid smallint not null, frame varchar(50), primary key (frameid));
CREATE TABLE vframesentencemaps (synsetid integer not null, wordid integer not null, sentenceid smallint not null, primary key (synsetid, wordid, sentenceid));
CREATE TABLE vframesentences (sentenceid smallint not null, sentence longvarchar, primary key (sentenceid));
CREATE TABLE words (wordid integer not null, lemma varchar(80) not null unique, primary key (wordid));
INSERT INTO "words" VALUES(27771,'commodity');
INSERT INTO "words" VALUES(58843,'good');
INSERT INTO "words" VALUES(134408,'trade good');
INSERT INTO "words" VALUES(138336,'unique');
INSERT INTO "words" VALUES(138337,'uniquely');
INSERT INTO "words" VALUES(138338,'uniqueness');
COMMIT;
