(function() {
  var CompositeDisposable, SnippetExpansion;

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = SnippetExpansion = (function() {
    SnippetExpansion.prototype.settingTabStop = false;

    function SnippetExpansion(snippet1, editor, cursor, snippets) {
      var startPosition;
      this.snippet = snippet1;
      this.editor = editor;
      this.cursor = cursor;
      this.snippets = snippets;
      this.subscriptions = new CompositeDisposable;
      this.tabStopMarkers = [];
      this.selections = [this.cursor.selection];
      startPosition = this.cursor.selection.getBufferRange().start;
      this.editor.transact((function(_this) {
        return function() {
          var newRange;
          newRange = _this.editor.transact(function() {
            return _this.cursor.selection.insertText(_this.snippet.body, {
              autoIndent: false
            });
          });
          if (_this.snippet.tabStops.length > 0) {
            _this.subscriptions.add(_this.cursor.onDidChangePosition(function(event) {
              return _this.cursorMoved(event);
            }));
            _this.subscriptions.add(_this.cursor.onDidDestroy(function() {
              return _this.cursorDestroyed();
            }));
            _this.placeTabStopMarkers(startPosition, _this.snippet.tabStops);
            _this.snippets.addExpansion(_this.editor, _this);
            _this.editor.normalizeTabsInBufferRange(newRange);
          }
          if (_this.snippet.lineCount > 1) {
            return _this.indentSubsequentLines(startPosition.row, _this.snippet);
          }
        };
      })(this));
    }

    SnippetExpansion.prototype.cursorMoved = function(arg) {
      var newBufferPosition, oldBufferPosition, textChanged;
      oldBufferPosition = arg.oldBufferPosition, newBufferPosition = arg.newBufferPosition, textChanged = arg.textChanged;
      if (this.settingTabStop || textChanged) {
        return;
      }
      if (!this.tabStopMarkers[this.tabStopIndex].some(function(marker) {
        return marker.getBufferRange().containsPoint(newBufferPosition);
      })) {
        return this.destroy();
      }
    };

    SnippetExpansion.prototype.cursorDestroyed = function() {
      if (!this.settingTabStop) {
        return this.destroy();
      }
    };

    SnippetExpansion.prototype.placeTabStopMarkers = function(startPosition, tabStopRanges) {
      var j, len, ranges;
      for (j = 0, len = tabStopRanges.length; j < len; j++) {
        ranges = tabStopRanges[j];
        this.tabStopMarkers.push(ranges.map((function(_this) {
          return function(arg) {
            var end, start;
            start = arg.start, end = arg.end;
            return _this.editor.markBufferRange([startPosition.traverse(start), startPosition.traverse(end)]);
          };
        })(this)));
      }
      return this.setTabStopIndex(0);
    };

    SnippetExpansion.prototype.indentSubsequentLines = function(startRow, snippet) {
      var initialIndent, j, ref, ref1, results, row;
      initialIndent = this.editor.lineTextForBufferRow(startRow).match(/^\s*/)[0];
      results = [];
      for (row = j = ref = startRow + 1, ref1 = startRow + snippet.lineCount; ref <= ref1 ? j < ref1 : j > ref1; row = ref <= ref1 ? ++j : --j) {
        results.push(this.editor.buffer.insert([row, 0], initialIndent));
      }
      return results;
    };

    SnippetExpansion.prototype.goToNextTabStop = function() {
      var nextIndex;
      nextIndex = this.tabStopIndex + 1;
      if (nextIndex < this.tabStopMarkers.length) {
        if (this.setTabStopIndex(nextIndex)) {
          return true;
        } else {
          return this.goToNextTabStop();
        }
      } else {
        this.destroy();
        return false;
      }
    };

    SnippetExpansion.prototype.goToPreviousTabStop = function() {
      if (this.tabStopIndex > 0) {
        return this.setTabStopIndex(this.tabStopIndex - 1);
      }
    };

    SnippetExpansion.prototype.setTabStopIndex = function(tabStopIndex) {
      var i, j, k, l, len, len1, len2, marker, markerSelected, newSelection, range, ranges, ref, ref1, selection;
      this.tabStopIndex = tabStopIndex;
      this.settingTabStop = true;
      markerSelected = false;
      ranges = [];
      ref = this.tabStopMarkers[this.tabStopIndex];
      for (j = 0, len = ref.length; j < len; j++) {
        marker = ref[j];
        if (marker.isValid()) {
          ranges.push(marker.getBufferRange());
        }
      }
      if (ranges.length > 0) {
        ref1 = this.selections.slice(ranges.length);
        for (k = 0, len1 = ref1.length; k < len1; k++) {
          selection = ref1[k];
          selection.destroy();
        }
        this.selections = this.selections.slice(0, ranges.length);
        for (i = l = 0, len2 = ranges.length; l < len2; i = ++l) {
          range = ranges[i];
          if (this.selections[i]) {
            this.selections[i].setBufferRange(range);
          } else {
            newSelection = this.editor.addSelectionForBufferRange(range);
            this.subscriptions.add(newSelection.cursor.onDidChangePosition((function(_this) {
              return function(event) {
                return _this.cursorMoved(event);
              };
            })(this)));
            this.subscriptions.add(newSelection.cursor.onDidDestroy((function(_this) {
              return function() {
                return _this.cursorDestroyed();
              };
            })(this)));
            this.selections.push(newSelection);
          }
        }
        markerSelected = true;
      }
      this.settingTabStop = false;
      return markerSelected;
    };

    SnippetExpansion.prototype.destroy = function() {
      var j, k, len, len1, marker, markers, ref;
      this.subscriptions.dispose();
      ref = this.tabStopMarkers;
      for (j = 0, len = ref.length; j < len; j++) {
        markers = ref[j];
        for (k = 0, len1 = markers.length; k < len1; k++) {
          marker = markers[k];
          marker.destroy();
        }
      }
      this.tabStopMarkers = [];
      return this.snippets.clearExpansions(this.editor);
    };

    SnippetExpansion.prototype.restore = function(editor) {
      this.editor = editor;
      return this.snippets.addExpansion(this.editor, this);
    };

    return SnippetExpansion;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
