Object.defineProperty(exports, '__esModule', {
  value: true
});
var _bind = Function.prototype.bind;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _richDescription = require('./rich-description');

var SCOPED_SETTINGS = ['autoIndent', 'autoIndentOnPaste', 'invisibles', 'nonWordCharacters', 'preferredLineLength', 'scrollPastEnd', 'showIndentGuide', 'showInvisibles', 'softWrap', 'softWrapAtPreferredLineLength', 'softWrapHangingIndent', 'tabLength'];

var SettingsPanel = (function (_CollapsibleSectionPanel) {
  _inherits(SettingsPanel, _CollapsibleSectionPanel);

  function SettingsPanel() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, SettingsPanel);

    _get(Object.getPrototypeOf(SettingsPanel.prototype), 'constructor', this).call(this);
    var namespace = options.namespace;
    this.element = document.createElement('section');
    this.element.classList.add('section', 'settings-panel');
    this.options = options;
    this.disposables = new _atom.CompositeDisposable();
    var settings = undefined;
    if (this.options.scopeName) {
      namespace = 'editor';
      settings = {};
      for (var _name of SCOPED_SETTINGS) {
        settings[_name] = atom.config.get(_name, { scope: [this.options.scopeName] });
      }
    } else {
      settings = atom.config.get(namespace);
    }

    this.element.appendChild(this.elementForSettings(namespace, settings));

    this.disposables.add(this.bindInputFields());
    this.disposables.add(this.bindSelectFields());
    this.disposables.add(this.bindEditors());
    this.disposables.add(this.bindTooltips());
    this.disposables.add(this.handleEvents());
  }

  /*
   * Space Pen Helpers
   */

  _createClass(SettingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'elementForSettings',
    value: function elementForSettings(namespace, settings) {
      if (_underscorePlus2['default'].isEmpty(settings)) {
        return document.createDocumentFragment();
      }

      var title = this.options.title;

      var includeTitle = this.options.includeTitle != null ? this.options.includeTitle : true;
      if (includeTitle) {
        if (title == null) {
          title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(namespace)) + ' Settings';
        }
      } else {
        if (title == null) {
          title = "Settings";
        }
      }

      var icon = this.options.icon != null ? this.options.icon : 'gear';
      var note = this.options.note;

      var sortedSettings = this.sortSettings(namespace, settings);

      var container = document.createElement('div');
      container.classList.add('section-container');

      var heading = document.createElement('div');
      heading.classList.add('block', 'section-heading', 'icon', 'icon-' + icon);
      heading.textContent = title;
      container.appendChild(heading);

      if (note) {
        container.insertAdjacentHTML('beforeend', note);
      }

      var body = document.createElement('div');
      body.classList.add('section-body');
      for (var _name2 of sortedSettings) {
        body.appendChild(elementForSetting(namespace, _name2, settings[_name2]));
      }
      container.appendChild(body);

      return container;
    }
  }, {
    key: 'sortSettings',
    value: function sortSettings(namespace, settings) {
      return _sortSettings(namespace, settings);
    }
  }, {
    key: 'bindInputFields',
    value: function bindInputFields() {
      var _this = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id]')).map(function (input) {
        var name = input.id;
        var type = input.type;

        _this.observe(name, function (value) {
          if (type === 'checkbox') {
            input.checked = value;
          } else {
            if (type === 'color') {
              if (value && value.toHexString && value.toHexString()) {
                value = value.toHexString();
              }
            }

            if (value) {
              input.value = value;
            }
          }
        });

        var changeHandler = function changeHandler() {
          var value = input.value;
          if (type === 'checkbox') {
            value = input.checked;
          } else {
            value = _this.parseValue(type, value);
          }

          if (type === 'color') {
            // This is debounced since the color wheel fires lots of events
            // as you are dragging it around
            clearTimeout(_this.colorDebounceTimeout);
            _this.colorDebounceTimeout = setTimeout(function () {
              _this.set(name, value);
            }, 100);
          } else {
            _this.set(name, value);
          }
        };

        input.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return input.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'observe',
    value: function observe(name, callback) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      this.disposables.add(atom.config.observe(name, params, callback));
    }
  }, {
    key: 'isDefault',
    value: function isDefault(name) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      var defaultValue = this.getDefault(name);
      var value = atom.config.get(name, params);
      return value == null || defaultValue === value;
    }
  }, {
    key: 'getDefault',
    value: function getDefault(name) {
      if (this.options.scopeName != null) {
        return atom.config.get(name);
      } else {
        var params = { excludeSources: [atom.config.getUserConfigPath()] };
        if (this.options.scopeName != null) {
          params.scope = [this.options.scopeName];
        }
        return atom.config.get(name, params);
      }
    }
  }, {
    key: 'set',
    value: function set(name, value) {
      if (this.options.scopeName) {
        if (value === undefined) {
          atom.config.unset(name, { scopeSelector: this.options.scopeName });
        } else {
          atom.config.set(name, value, { scopeSelector: this.options.scopeName });
        }
      } else {
        atom.config.set(name, value);
      }
    }
  }, {
    key: 'bindSelectFields',
    value: function bindSelectFields() {
      var _this2 = this;

      var disposables = Array.from(this.element.querySelectorAll('select[id]')).map(function (select) {
        var name = select.id;
        _this2.observe(name, function (value) {
          return select.value = value;
        });
        var changeHandler = function changeHandler() {
          _this2.set(name, select.value);
        };
        select.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return select.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindEditors',
    value: function bindEditors() {
      var _this3 = this;

      var disposables = Array.from(this.element.querySelectorAll('atom-text-editor')).map(function (editorElement) {
        var defaultValue = undefined,
            left = undefined;
        var editor = editorElement.getModel();
        var name = editorElement.id;
        var type = editorElement.getAttribute('type');

        if (defaultValue = _this3.valueToString(_this3.getDefault(name))) {
          if (_this3.options.scopeName != null) {
            editor.setPlaceholderText('Unscoped value: ' + defaultValue);
          } else {
            editor.setPlaceholderText('Default: ' + defaultValue);
          }
        }

        var subscriptions = new _atom.CompositeDisposable();

        var focusHandler = function focusHandler() {
          if (_this3.isDefault(name)) {
            editor.setText((left = _this3.valueToString(_this3.getDefault(name))) != null ? left : '');
          }
        };
        editorElement.addEventListener('focus', focusHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('focus', focusHandler);
        }));

        var blurHandler = function blurHandler() {
          if (_this3.isDefault(name)) {
            editor.setText('');
          }
        };
        editorElement.addEventListener('blur', blurHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('blur', blurHandler);
        }));

        _this3.observe(name, function (value) {
          var stringValue = undefined;
          if (_this3.isDefault(name)) {
            stringValue = '';
          } else {
            stringValue = (left = _this3.valueToString(value)) != null ? left : '';
          }

          if (stringValue === editor.getText() || _underscorePlus2['default'].isEqual(value, _this3.parseValue(type, editor.getText()))) {
            return;
          }

          editor.setText(stringValue);
        });

        subscriptions.add(editor.onDidStopChanging(function () {
          _this3.set(name, _this3.parseValue(type, editor.getText()));
        }));

        return subscriptions;
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindTooltips',
    value: function bindTooltips() {
      var _this4 = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id], select[id], atom-text-editor[id]')).map(function (element) {
        var defaultValue = _this4.valueToString(_this4.getDefault(element.id));
        if (defaultValue) {
          return atom.tooltips.add(element, {
            title: 'Default: ' + defaultValue,
            delay: { show: 100 },
            placement: 'auto left'
          });
        } else {
          return new _atom.Disposable(function () {}); // no-op
        }
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'valueToString',
    value: function valueToString(value) {
      if (Array.isArray(value)) {
        return value.join(', ');
      } else if (value) {
        return value.toString();
      } else {
        return null;
      }
    }
  }, {
    key: 'parseValue',
    value: function parseValue(type, value) {
      if (value === '') {
        return undefined;
      } else if (type === 'number') {
        var floatValue = parseFloat(value);
        if (isNaN(floatValue)) {
          return value;
        } else {
          return floatValue;
        }
      } else if (type === 'array') {
        var arrayValue = (value || '').split(',');
        return arrayValue.filter(function (val) {
          return val;
        }).map(function (val) {
          return val.trim();
        });
      } else {
        return value;
      }
    }
  }]);

  return SettingsPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = SettingsPanel;
var isEditableArray = function isEditableArray(array) {
  for (var item of array) {
    if (!_underscorePlus2['default'].isString(item)) {
      return false;
    }
  }
  return true;
};

function _sortSettings(namespace, settings) {
  return _underscorePlus2['default'].chain(settings).keys().sortBy(function (name) {
    return name;
  }).sortBy(function (name) {
    var schema = atom.config.getSchema(namespace + '.' + name);
    return schema ? schema.order : null;
  }).value();
}

function elementForSetting(namespace, name, value) {
  if (namespace === 'core') {
    if (name === 'themes') {
      return document.createDocumentFragment();
    } // Handled in the Themes panel
    if (name === 'disabledPackages') {
      return document.createDocumentFragment();
    } // Handled in the Packages panel
    if (name === 'customFileTypes') {
      return document.createDocumentFragment();
    }
  }

  if (namespace === 'editor') {
    // There's no global default for these, they are defined by language packages
    if (['commentStart', 'commentEnd', 'increaseIndentPattern', 'decreaseIndentPattern', 'foldEndPattern'].includes(name)) {
      return document.createDocumentFragment();
    }
  }

  var controlGroup = document.createElement('div');
  controlGroup.classList.add('control-group');

  var controls = document.createElement('div');
  controls.classList.add('controls');
  controlGroup.appendChild(controls);

  var schema = atom.config.getSchema(namespace + '.' + name);
  if (schema && schema['enum']) {
    controls.appendChild(elementForOptions(namespace, name, value));
  } else if (schema && schema.type === 'color') {
    controls.appendChild(elementForColor(namespace, name, value));
  } else if (_underscorePlus2['default'].isBoolean(value) || schema && schema.type === 'boolean') {
    controls.appendChild(elementForCheckbox(namespace, name, value));
  } else if (_underscorePlus2['default'].isArray(value) || schema && schema.type === 'array') {
    if (isEditableArray(value)) {
      controls.appendChild(elementForArray(namespace, name, value));
    }
  } else if (_underscorePlus2['default'].isObject(value) || schema && schema.type === 'object') {
    controls.appendChild(elementForObject(namespace, name, value));
  } else {
    controls.appendChild(elementForEditor(namespace, name, value));
  }

  return controlGroup;
}

function getSettingTitle(keyPath, name) {
  if (name == null) {
    name = '';
  }
  var schema = atom.config.getSchema(keyPath);
  var title = schema != null ? schema.title : null;
  return title || _underscorePlus2['default'].uncamelcase(name).split('.').map(_underscorePlus2['default'].capitalize).join(' ');
}

function elementForOptions(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var schema = atom.config.getSchema(keyPath);
  var options = schema && schema['enum'] ? schema['enum'] : [];

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);

  fragment.appendChild(label);

  var select = document.createElement('select');
  select.id = keyPath;
  select.classList.add('form-control');
  for (var option of options) {
    var optionElement = document.createElement('option');
    if (option.hasOwnProperty('value')) {
      optionElement.value = option.value;
      optionElement.textContent = option.description;
    } else {
      optionElement.value = option;
      optionElement.textContent = option;
    }
    select.appendChild(optionElement);
  }

  fragment.appendChild(select);

  return fragment;
}

function elementForCheckbox(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('checkbox');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'checkbox';
  input.classList.add('input-checkbox');
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForColor(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('color');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'color';
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForEditor(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var type = _underscorePlus2['default'].isNumber(value) ? 'number' : 'string';

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', type);
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForArray(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', 'array');
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForObject(namespace, name, value) {
  if (_underscorePlus2['default'].keys(value).length === 0) {
    return document.createDocumentFragment();
  } else {
    var keyPath = namespace + '.' + name;
    var schema = atom.config.getSchema(keyPath);
    var isCollapsed = schema.collapsed === true;

    var section = document.createElement('section');
    section.classList.add('sub-section');
    if (isCollapsed) {
      section.classList.add('collapsed');
    }

    var h3 = document.createElement('h3');
    h3.classList.add('sub-section-heading', 'has-items');
    h3.textContent = getSettingTitle(keyPath, name);
    section.appendChild(h3);

    var div = document.createElement('div');
    div.classList.add('sub-section-body');
    for (var key of _sortSettings(keyPath, value)) {
      div.appendChild(elementForSetting(namespace, name + '.' + key, value[key]));
    }
    section.appendChild(div);

    return section;
  }
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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