Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

// View to display the snippets that a package has registered.

var PackageSnippetsView = (function () {
  function PackageSnippetsView(packagePath, snippetsProvider) {
    _classCallCheck(this, PackageSnippetsView);

    this.snippetsProvider = snippetsProvider;
    this.packagePath = _path2['default'].join(packagePath, _path2['default'].sep);
    _etch2['default'].initialize(this);
    this.element.style.display = 'none';
    this.addSnippets();
  }

  _createClass(PackageSnippetsView, [{
    key: 'destroy',
    value: function destroy() {
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-code' },
          'Snippets'
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-snippets-table table native-key-bindings text', tabIndex: -1 },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Trigger'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Name'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Body'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'snippets' })
        )
      );
    }
  }, {
    key: 'getSnippetProperties',
    value: function getSnippetProperties() {
      var packageProperties = {};
      for (var _ref2 of this.snippetsProvider.getSnippets()) {
        var _name = _ref2.name;
        var properties = _ref2.properties;

        if (_name && _name.indexOf && _name.indexOf(this.packagePath) === 0) {
          var object = properties.snippets != null ? properties.snippets : {};
          for (var key in object) {
            var snippet = object[key];
            if (snippet != null) {
              if (packageProperties[key] == null) {
                packageProperties[_name] = snippet;
              }
            }
          }
        }
      }

      return _underscorePlus2['default'].values(packageProperties).sort(function (snippet1, snippet2) {
        var prefix1 = snippet1.prefix != null ? snippet1.prefix : '';
        var prefix2 = snippet2.prefix != null ? snippet2.prefix : '';
        return prefix1.localeCompare(prefix2);
      });
    }
  }, {
    key: 'getSnippets',
    value: function getSnippets(callback) {
      var _this = this;

      var snippetsPackage = atom.packages.getLoadedPackage('snippets');
      var snippetsModule = snippetsPackage ? snippetsPackage.mainModule : null;
      if (snippetsModule) {
        if (snippetsModule.loaded) {
          callback(this.getSnippetProperties());
        } else {
          snippetsModule.onDidLoadSnippets(function () {
            return callback(_this.getSnippetProperties());
          });
        }
      } else {
        callback([]);
      }
    }
  }, {
    key: 'addSnippets',
    value: function addSnippets() {
      var _this2 = this;

      this.getSnippets(function (snippets) {
        _this2.refs.snippets.innerHTML = '';

        for (var _ref32 of snippets) {
          var body = _ref32.body;
          var bodyText = _ref32.bodyText;
          var _name2 = _ref32.name;
          var prefix = _ref32.prefix;

          if (_name2 == null) {
            _name2 = '';
          }

          if (prefix == null) {
            prefix = '';
          }

          if (body == null) {
            body = bodyText;
          }

          if (body) {
            body = body.replace(/\t/g, '\\t').replace(/\n/g, '\\n');
          } else {
            body = '';
          }

          var row = document.createElement('tr');

          var prefixTd = document.createElement('td');
          prefixTd.classList.add('snippet-prefix');
          prefixTd.textContent = prefix;
          row.appendChild(prefixTd);

          var nameTd = document.createElement('td');
          nameTd.textContent = _name2;
          row.appendChild(nameTd);

          var bodyTd = document.createElement('td');
          bodyTd.classList.add('snippet-body');
          bodyTd.textContent = body;
          row.appendChild(bodyTd);

          _this2.refs.snippets.appendChild(row);
        }

        if (_this2.refs.snippets.children.length > 0) {
          _this2.refs.snippets.style.display = '';
        } else {
          _this2.refs.snippets.style.display = 'none';
        }
      });
    }
  }]);

  return PackageSnippetsView;
})();

exports['default'] = PackageSnippetsView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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