(function() {
  var PackageManager, SettingsView, SnippetsProvider, configUri, openPanel, packageManager, settingsView, statusView, uriRegex;

  SettingsView = null;

  settingsView = null;

  statusView = null;

  PackageManager = require('./package-manager');

  packageManager = null;

  SnippetsProvider = {
    getSnippets: function() {
      return atom.config.scopedSettingsStore.propertySets;
    }
  };

  configUri = 'atom://config';

  uriRegex = /config\/([a-z]+)\/?([a-zA-Z0-9_-]+)?/i;

  openPanel = function(settingsView, panelName, uri) {
    var detail, match, options, panel;
    match = uriRegex.exec(uri);
    panel = match != null ? match[1] : void 0;
    detail = match != null ? match[2] : void 0;
    options = {
      uri: uri
    };
    if (panel === "packages" && (detail != null)) {
      panelName = detail;
      options.pack = {
        name: detail
      };
      if (atom.packages.getLoadedPackage(detail)) {
        options.back = 'Packages';
      }
    }
    return settingsView.showPanel(panelName, options);
  };

  module.exports = {
    activate: function() {
      atom.workspace.addOpener((function(_this) {
        return function(uri) {
          var match, panelName;
          if (uri.startsWith(configUri)) {
            if ((settingsView == null) || settingsView.destroyed) {
              settingsView = _this.createSettingsView({
                uri: uri
              });
            }
            if (match = uriRegex.exec(uri)) {
              panelName = match[1];
              panelName = panelName[0].toUpperCase() + panelName.slice(1);
              openPanel(settingsView, panelName, uri);
            }
            return settingsView;
          }
        };
      })(this));
      atom.commands.add('atom-workspace', {
        'settings-view:open': function() {
          return atom.workspace.open(configUri);
        },
        'settings-view:core': function() {
          return atom.workspace.open(configUri + "/core");
        },
        'settings-view:editor': function() {
          return atom.workspace.open(configUri + "/editor");
        },
        'settings-view:show-keybindings': function() {
          return atom.workspace.open(configUri + "/keybindings");
        },
        'settings-view:change-themes': function() {
          return atom.workspace.open(configUri + "/themes");
        },
        'settings-view:install-packages-and-themes': function() {
          return atom.workspace.open(configUri + "/install");
        },
        'settings-view:view-installed-themes': function() {
          return atom.workspace.open(configUri + "/themes");
        },
        'settings-view:uninstall-themes': function() {
          return atom.workspace.open(configUri + "/themes");
        },
        'settings-view:view-installed-packages': function() {
          return atom.workspace.open(configUri + "/packages");
        },
        'settings-view:uninstall-packages': function() {
          return atom.workspace.open(configUri + "/packages");
        },
        'settings-view:check-for-package-updates': function() {
          return atom.workspace.open(configUri + "/updates");
        }
      });
      if (process.platform === 'win32' && (require('atom').WinShell != null)) {
        atom.commands.add('atom-workspace', {
          'settings-view:system': function() {
            return atom.workspace.open(configUri + "/system");
          }
        });
      }
      if (!localStorage.getItem('hasSeenDeprecatedNotification')) {
        if (packageManager == null) {
          packageManager = new PackageManager();
        }
        return packageManager.getInstalled().then((function(_this) {
          return function(packages) {
            var ref;
            if ((ref = packages.user) != null ? ref.length : void 0) {
              return _this.showDeprecatedNotification(packages);
            }
          };
        })(this));
      }
    },
    deactivate: function() {
      if (settingsView != null) {
        settingsView.destroy();
      }
      if (statusView != null) {
        statusView.destroy();
      }
      settingsView = null;
      packageManager = null;
      return statusView = null;
    },
    consumeStatusBar: function(statusBar) {
      if (packageManager == null) {
        packageManager = new PackageManager();
      }
      return packageManager.getOutdated().then(function(updates) {
        var PackageUpdatesStatusView;
        if (packageManager != null) {
          PackageUpdatesStatusView = require('./package-updates-status-view');
          statusView = new PackageUpdatesStatusView();
          return statusView.initialize(statusBar, packageManager, updates);
        }
      });
    },
    consumeSnippets: function(snippets) {
      if (typeof snippets.getUnparsedSnippets === "function") {
        return SnippetsProvider.getSnippets = snippets.getUnparsedSnippets.bind(snippets);
      }
    },
    createSettingsView: function(params) {
      if (SettingsView == null) {
        SettingsView = require('./settings-view');
      }
      if (packageManager == null) {
        packageManager = new PackageManager();
      }
      params.packageManager = packageManager;
      params.snippetsProvider = SnippetsProvider;
      return settingsView = new SettingsView(params);
    },
    showDeprecatedNotification: function(packages) {
      var deprecatedPackages, have, notification, pack, packageText, were;
      localStorage.setItem('hasSeenDeprecatedNotification', true);
      deprecatedPackages = packages.user.filter(function(arg) {
        var name, version;
        name = arg.name, version = arg.version;
        return atom.packages.isDeprecatedPackage(name, version);
      });
      if (!deprecatedPackages.length) {
        return;
      }
      were = 'were';
      have = 'have';
      packageText = 'packages';
      if (packages.length === 1) {
        packageText = 'package';
        were = 'was';
        have = 'has';
      }
      return notification = atom.notifications.addWarning(deprecatedPackages.length + " " + packageText + " " + have + " deprecations and " + were + " not loaded.", {
        description: 'This message will show only one time. Deprecated packages can be viewed in the settings view.',
        detail: ((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = deprecatedPackages.length; i < len; i++) {
            pack = deprecatedPackages[i];
            results.push(pack.name);
          }
          return results;
        })()).join(', '),
        dismissable: true,
        buttons: [
          {
            text: 'View Deprecated Packages',
            onDidClick: function() {
              atom.commands.dispatch(atom.views.getView(atom.workspace), 'settings-view:view-installed-packages');
              return notification.dismiss();
            }
          }
        ]
      });
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
