Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeybindingsPanel = (function () {
  function KeybindingsPanel() {
    var _this = this;

    _classCallCheck(this, KeybindingsPanel);

    _etch2['default'].initialize(this);
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.platformPattern = new RegExp('\\.platform-' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b');

    this.disposables.add(this.refs.searchEditor.onDidStopChanging(function () {
      _this.filterKeyBindings(_this.keyBindings, _this.refs.searchEditor.getText());
    }));

    this.disposables.add(atom.keymaps.onDidReloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.disposables.add(atom.keymaps.onDidUnloadKeymap(function () {
      _this.loadKeyBindings();
    }));
    this.loadKeyBindings();
  }

  _createClass(KeybindingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'keybinding-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-heading icon icon-keyboard' },
            'Keybindings'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'text native-key-bindings', tabIndex: '-1' },
            _etch2['default'].dom('span', { className: 'icon icon-question' }),
            _etch2['default'].dom(
              'span',
              null,
              'You can override these keybindings by copying '
            ),
            _etch2['default'].dom('span', { className: 'icon icon-clippy' }),
            _etch2['default'].dom(
              'span',
              null,
              'and pasting them into '
            ),
            _etch2['default'].dom(
              'a',
              { className: 'link', onclick: this.didClickOpenKeymapFile },
              'your keymap file'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'editor-container' },
            _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor', placeholderText: 'Search keybindings' })
          ),
          _etch2['default'].dom(
            'table',
            { className: 'native-key-bindings table text', tabIndex: '-1' },
            _etch2['default'].dom('col', { className: 'keystroke' }),
            _etch2['default'].dom('col', { className: 'command' }),
            _etch2['default'].dom('col', { className: 'source' }),
            _etch2['default'].dom('col', { className: 'selector' }),
            _etch2['default'].dom(
              'thead',
              null,
              _etch2['default'].dom(
                'tr',
                null,
                _etch2['default'].dom(
                  'th',
                  { className: 'keystroke' },
                  'Keystroke'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'command' },
                  'Command'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'source' },
                  'Source'
                ),
                _etch2['default'].dom(
                  'th',
                  { className: 'selector' },
                  'Selector'
                )
              )
            ),
            _etch2['default'].dom('tbody', { ref: 'keybindingRows' })
          )
        )
      );
    }
  }, {
    key: 'loadKeyBindings',
    value: function loadKeyBindings() {
      this.refs.keybindingRows.innerHTML = '';
      this.keyBindings = _underscorePlus2['default'].sortBy(atom.keymaps.getKeyBindings(), 'keystrokes');
      this.appendKeyBindings(this.keyBindings);
      this.filterKeyBindings(this.keyBindings, this.refs.searchEditor.getText());
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'filterKeyBindings',
    value: function filterKeyBindings(keyBindings, filterString) {
      this.refs.keybindingRows.innerHTML = '';
      for (var keyBinding of keyBindings) {
        var selector = keyBinding.selector;
        var keystrokes = keyBinding.keystrokes;
        var command = keyBinding.command;
        var source = keyBinding.source;

        source = KeybindingsPanel.determineSource(source);
        var searchString = ('' + selector + keystrokes + command + source).toLowerCase();
        if (!searchString) {
          continue;
        }

        var keywords = filterString.trim().toLowerCase().split(' ');
        if (keywords.every(function (keyword) {
          return searchString.indexOf(keyword) !== -1;
        })) {
          this.appendKeyBinding(keyBinding);
        }
      }
    }
  }, {
    key: 'appendKeyBindings',
    value: function appendKeyBindings(keyBindings) {
      for (var keyBinding of keyBindings) {
        this.appendKeyBinding(keyBinding);
      }
    }
  }, {
    key: 'appendKeyBinding',
    value: function appendKeyBinding(keyBinding) {
      if (!this.showSelector(keyBinding.selector)) {
        return;
      }

      var element = this.elementForKeyBinding(keyBinding);
      element.dataset.keyBinding = keyBinding;
      this.refs.keybindingRows.appendChild(element);
    }
  }, {
    key: 'showSelector',
    value: function showSelector(selector) {
      var _this2 = this;

      var segments = undefined;
      if (selector) {
        segments = selector.split(',') || [];
      } else {
        segments = [];
      }

      return segments.some(function (s) {
        return _this2.platformPattern.test(s) || !_this2.otherPlatformPattern.test(s);
      });
    }
  }, {
    key: 'elementForKeyBinding',
    value: function elementForKeyBinding(keyBinding) {
      var selector = keyBinding.selector;
      var keystrokes = keyBinding.keystrokes;
      var command = keyBinding.command;
      var source = keyBinding.source;

      source = KeybindingsPanel.determineSource(source);

      var tr = document.createElement('tr');
      if (source === 'User') {
        tr.classList.add('is-user');
      }

      var keystrokeTd = document.createElement('td');
      keystrokeTd.classList.add('keystroke');

      var copyIcon = document.createElement('span');
      copyIcon.classList.add('icon', 'icon-clippy', 'copy-icon');
      copyIcon.onclick = function () {
        var content = undefined;
        var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
        if (keymapExtension === '.cson') {
          content = '\'' + selector + '\':\n  \'' + keystrokes + '\': \'' + command + '\'';
        } else {
          content = '"' + selector + '": {\n  "' + keystrokes + '": "' + command + '"\n}';
        }
        return atom.clipboard.write(content);
      };
      keystrokeTd.appendChild(copyIcon);

      var keystrokesSpan = document.createElement('span');
      keystrokesSpan.textContent = keystrokes;
      keystrokeTd.appendChild(keystrokesSpan);
      tr.appendChild(keystrokeTd);

      var commandTd = document.createElement('td');
      commandTd.classList.add('command');
      commandTd.textContent = command;
      tr.appendChild(commandTd);

      var sourceTd = document.createElement('td');
      sourceTd.classList.add('source');
      sourceTd.textContent = source;
      tr.appendChild(sourceTd);

      var selectorTd = document.createElement('td');
      selectorTd.classList.add('selector');
      selectorTd.textContent = selector;
      tr.appendChild(selectorTd);

      return tr;
    }
  }, {
    key: 'didClickOpenKeymapFile',
    value: function didClickOpenKeymapFile(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-keymap');
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }

    // Private: Returns a user friendly description of where a keybinding was
    // loaded from.
    //
    // * filePath:
    //   The absolute path from which the keymap was loaded
    //
    // Returns one of:
    // * `Core` indicates it comes from a bundled package.
    // * `User` indicates that it was defined by a user.
    // * `<package-name>` the package which defined it.
    // * `Unknown` if an invalid path was passed in.
  }], [{
    key: 'determineSource',
    value: function determineSource(filePath) {
      if (!filePath) {
        return 'Unknown';
      }

      if (filePath.indexOf(_path2['default'].join(atom.getLoadSettings().resourcePath, 'keymaps')) === 0) {
        return 'Core';
      } else if (filePath === atom.keymaps.getUserKeymapPath()) {
        return 'User';
      } else {
        var pathParts = filePath.split(_path2['default'].sep);
        var packageNameIndex = pathParts.length - 3;
        var packageName = pathParts[packageNameIndex] != null ? pathParts[packageNameIndex] : '';
        return _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(packageName));
      }
    }
  }]);

  return KeybindingsPanel;
})();

exports['default'] = KeybindingsPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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