(function() {
  var scopesByFenceName;

  scopesByFenceName = {
    'sh': 'source.shell',
    'bash': 'source.shell',
    'c': 'source.c',
    'c++': 'source.cpp',
    'cpp': 'source.cpp',
    'coffee': 'source.coffee',
    'coffeescript': 'source.coffee',
    'coffee-script': 'source.coffee',
    'cs': 'source.cs',
    'csharp': 'source.cs',
    'css': 'source.css',
    'scss': 'source.css.scss',
    'sass': 'source.sass',
    'erlang': 'source.erl',
    'go': 'source.go',
    'html': 'text.html.basic',
    'java': 'source.java',
    'js': 'source.js',
    'javascript': 'source.js',
    'json': 'source.json',
    'less': 'source.less',
    'mustache': 'text.html.mustache',
    'objc': 'source.objc',
    'objective-c': 'source.objc',
    'php': 'text.html.php',
    'py': 'source.python',
    'python': 'source.python',
    'rb': 'source.ruby',
    'ruby': 'source.ruby',
    'text': 'text.plain',
    'toml': 'source.toml',
    'xml': 'text.xml',
    'yaml': 'source.yaml',
    'yml': 'source.yaml'
  };

  module.exports = {
    scopeForFenceName: function(fenceName) {
      var ref;
      fenceName = fenceName.toLowerCase();
      return (ref = scopesByFenceName[fenceName]) != null ? ref : "source." + fenceName;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
