(function() {
  var KeyBindingResolverView;

  KeyBindingResolverView = require('./keybinding-resolver-view');

  module.exports = {
    keybindingResolverView: null,
    activate: function(arg) {
      var attached;
      attached = (arg != null ? arg : {}).attached;
      if (attached) {
        this.createView().toggle();
      }
      return atom.commands.add('atom-workspace', {
        'key-binding-resolver:toggle': (function(_this) {
          return function() {
            return _this.createView().toggle();
          };
        })(this),
        'core:cancel': (function(_this) {
          return function() {
            return _this.createView().detach();
          };
        })(this),
        'core:close': (function(_this) {
          return function() {
            return _this.createView().detach();
          };
        })(this)
      });
    },
    createView: function() {
      return this.keybindingResolverView != null ? this.keybindingResolverView : this.keybindingResolverView = new KeyBindingResolverView();
    },
    deactivate: function() {
      var ref;
      return (ref = this.keybindingResolverView) != null ? ref.destroy() : void 0;
    },
    serialize: function() {
      var ref;
      return (ref = this.keybindingResolverView) != null ? ref.serialize() : void 0;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
