(function() {
  var GrammarListView, GrammarStatusView, commandDisposable, createGrammarListView, grammarListView, grammarStatusView;

  GrammarListView = require('./grammar-list-view');

  GrammarStatusView = require('./grammar-status-view');

  commandDisposable = null;

  grammarListView = null;

  grammarStatusView = null;

  module.exports = {
    activate: function() {
      return commandDisposable = atom.commands.add('atom-text-editor', 'grammar-selector:show', createGrammarListView);
    },
    deactivate: function() {
      if (commandDisposable != null) {
        commandDisposable.dispose();
      }
      commandDisposable = null;
      if (grammarStatusView != null) {
        grammarStatusView.destroy();
      }
      grammarStatusView = null;
      if (grammarListView != null) {
        grammarListView.destroy();
      }
      return grammarListView = null;
    },
    consumeStatusBar: function(statusBar) {
      grammarStatusView = new GrammarStatusView(statusBar);
      return grammarStatusView.attach();
    }
  };

  createGrammarListView = function() {
    if (grammarListView == null) {
      grammarListView = new GrammarListView();
    }
    return grammarListView.toggle();
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
