Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var GrammarStatusView = (function () {
  function GrammarStatusView(statusBar) {
    var _this = this;

    _classCallCheck(this, GrammarStatusView);

    this.statusBar = statusBar;
    this.element = document.createElement('grammar-selector-status');
    this.element.classList.add('grammar-status', 'inline-block');
    this.grammarLink = document.createElement('a');
    this.grammarLink.classList.add('inline-block');
    this.element.appendChild(this.grammarLink);

    // TODO[v1.19]: Remove conditional once atom.workspace.observeActiveTextEditor ships in Atom v1.19
    if (atom.workspace.observeActiveTextEditor) {
      this.activeItemSubscription = atom.workspace.observeActiveTextEditor(this.subscribeToActiveTextEditor.bind(this));
    } else {
      this.activeItemSubscription = atom.workspace.observeActivePaneItem(this.subscribeToActiveTextEditor.bind(this));
    }

    this.configSubscription = atom.config.observe('grammar-selector.showOnRightSideOfStatusBar', this.attach.bind(this));
    var clickHandler = function clickHandler(event) {
      event.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace.getActiveTextEditor()), 'grammar-selector:show');
    };
    this.element.addEventListener('click', clickHandler);
    this.clickSubscription = new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(GrammarStatusView, [{
    key: 'attach',
    value: function attach() {
      if (this.statusBarTile) {
        this.statusBarTile.destroy();
      }

      this.statusBarTile = atom.config.get('grammar-selector.showOnRightSideOfStatusBar') ? this.statusBar.addRightTile({ item: this.element, priority: 10 }) : this.statusBar.addLeftTile({ item: this.element, priority: 10 });
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.activeItemSubscription) {
        this.activeItemSubscription.dispose();
      }

      if (this.grammarSubscription) {
        this.grammarSubscription.dispose();
      }

      if (this.clickSubscription) {
        this.clickSubscription.dispose();
      }

      if (this.configSubscription) {
        this.configSubscription.dispose();
      }

      if (this.statusBarTile) {
        this.statusBarTile.destroy();
      }
    }
  }, {
    key: 'subscribeToActiveTextEditor',
    value: function subscribeToActiveTextEditor() {
      if (this.grammarSubscription) {
        this.grammarSubscription.dispose();
        this.grammarSubscription = null;
      }

      var editor = atom.workspace.getActiveTextEditor();
      if (editor) {
        this.grammarSubscription = editor.onDidChangeGrammar(this.updateGrammarText.bind(this));
      }
      this.updateGrammarText();
    }
  }, {
    key: 'updateGrammarText',
    value: function updateGrammarText() {
      var _this2 = this;

      atom.views.updateDocument(function () {
        var editor = atom.workspace.getActiveTextEditor();
        var grammar = editor ? editor.getGrammar() : null;
        if (grammar) {
          var grammarName = null;
          if (grammar === atom.grammars.nullGrammar) {
            grammarName = 'Plain Text';
          } else {
            grammarName = grammar.name || grammar.scopeName;
          }

          _this2.grammarLink.textContent = grammarName;
          _this2.grammarLink.dataset.grammar = grammarName;
          _this2.element.style.display = '';
        } else {
          _this2.element.style.display = 'none';
        }
      });
    }
  }]);

  return GrammarStatusView;
})();

exports['default'] = GrammarStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9ncmFtbWFyLXNlbGVjdG9yL2xpYi9ncmFtbWFyLXN0YXR1cy12aWV3LmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7b0JBRXlCLE1BQU07O0lBRVYsaUJBQWlCO0FBQ3hCLFdBRE8saUJBQWlCLENBQ3ZCLFNBQVMsRUFBRTs7OzBCQURMLGlCQUFpQjs7QUFFbEMsUUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUE7QUFDMUIsUUFBSSxDQUFDLE9BQU8sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLHlCQUF5QixDQUFDLENBQUE7QUFDaEUsUUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLGNBQWMsQ0FBQyxDQUFBO0FBQzVELFFBQUksQ0FBQyxXQUFXLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxHQUFHLENBQUMsQ0FBQTtBQUM5QyxRQUFJLENBQUMsV0FBVyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUE7QUFDOUMsUUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFBOzs7QUFHMUMsUUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLHVCQUF1QixFQUFFO0FBQzFDLFVBQUksQ0FBQyxzQkFBc0IsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLHVCQUF1QixDQUFDLElBQUksQ0FBQywyQkFBMkIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQTtLQUNsSCxNQUFNO0FBQ0wsVUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMscUJBQXFCLENBQUMsSUFBSSxDQUFDLDJCQUEyQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFBO0tBQ2hIOztBQUVELFFBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyw2Q0FBNkMsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFBO0FBQ3BILFFBQU0sWUFBWSxHQUFHLFNBQWYsWUFBWSxDQUFJLEtBQUssRUFBSztBQUM5QixXQUFLLENBQUMsY0FBYyxFQUFFLENBQUE7QUFDdEIsVUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsRUFBRSxDQUFDLEVBQUUsdUJBQXVCLENBQUMsQ0FBQTtLQUMxRyxDQUFBO0FBQ0QsUUFBSSxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7QUFDcEQsUUFBSSxDQUFDLGlCQUFpQixHQUFHLHFCQUFlLFlBQU07QUFBRSxZQUFLLE9BQU8sQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUE7S0FBRSxDQUFDLENBQUE7R0FDM0c7O2VBdkJrQixpQkFBaUI7O1dBeUI3QixrQkFBRztBQUNSLFVBQUksSUFBSSxDQUFDLGFBQWEsRUFBRTtBQUN0QixZQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRSxDQUFBO09BQzdCOztBQUVELFVBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsNkNBQTZDLENBQUMsR0FDakYsSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsRUFBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLE9BQU8sRUFBRSxRQUFRLEVBQUUsRUFBRSxFQUFDLENBQUMsR0FDL0QsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsRUFBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLE9BQU8sRUFBRSxRQUFRLEVBQUUsRUFBRSxFQUFDLENBQUMsQ0FBQTtLQUNqRTs7O1dBRU8sbUJBQUc7QUFDVCxVQUFJLElBQUksQ0FBQyxzQkFBc0IsRUFBRTtBQUMvQixZQUFJLENBQUMsc0JBQXNCLENBQUMsT0FBTyxFQUFFLENBQUE7T0FDdEM7O0FBRUQsVUFBSSxJQUFJLENBQUMsbUJBQW1CLEVBQUU7QUFDNUIsWUFBSSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxDQUFBO09BQ25DOztBQUVELFVBQUksSUFBSSxDQUFDLGlCQUFpQixFQUFFO0FBQzFCLFlBQUksQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtPQUNqQzs7QUFFRCxVQUFJLElBQUksQ0FBQyxrQkFBa0IsRUFBRTtBQUMzQixZQUFJLENBQUMsa0JBQWtCLENBQUMsT0FBTyxFQUFFLENBQUE7T0FDbEM7O0FBRUQsVUFBSSxJQUFJLENBQUMsYUFBYSxFQUFFO0FBQ3RCLFlBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxFQUFFLENBQUE7T0FDN0I7S0FDRjs7O1dBRzJCLHVDQUFHO0FBQzdCLFVBQUksSUFBSSxDQUFDLG1CQUFtQixFQUFFO0FBQzVCLFlBQUksQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtBQUNsQyxZQUFJLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFBO09BQ2hDOztBQUVELFVBQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsbUJBQW1CLEVBQUUsQ0FBQTtBQUNuRCxVQUFJLE1BQU0sRUFBRTtBQUNWLFlBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFBO09BQ3hGO0FBQ0QsVUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUE7S0FDekI7OztXQUVpQiw2QkFBRzs7O0FBQ25CLFVBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLFlBQU07QUFDOUIsWUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsRUFBRSxDQUFBO0FBQ25ELFlBQU0sT0FBTyxHQUFHLE1BQU0sR0FBRyxNQUFNLENBQUMsVUFBVSxFQUFFLEdBQUcsSUFBSSxDQUFBO0FBQ25ELFlBQUksT0FBTyxFQUFFO0FBQ1gsY0FBSSxXQUFXLEdBQUcsSUFBSSxDQUFBO0FBQ3RCLGNBQUksT0FBTyxLQUFLLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxFQUFFO0FBQ3pDLHVCQUFXLEdBQUcsWUFBWSxDQUFBO1dBQzNCLE1BQU07QUFDTCx1QkFBVyxHQUFHLE9BQU8sQ0FBQyxJQUFJLElBQUksT0FBTyxDQUFDLFNBQVMsQ0FBQTtXQUNoRDs7QUFFRCxpQkFBSyxXQUFXLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQTtBQUMxQyxpQkFBSyxXQUFXLENBQUMsT0FBTyxDQUFDLE9BQU8sR0FBRyxXQUFXLENBQUE7QUFDOUMsaUJBQUssT0FBTyxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsRUFBRSxDQUFBO1NBQ2hDLE1BQU07QUFDTCxpQkFBSyxPQUFPLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUE7U0FDcEM7T0FDRixDQUFDLENBQUE7S0FDSDs7O1NBMUZrQixpQkFBaUI7OztxQkFBakIsaUJBQWlCIiwiZmlsZSI6Ii9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9ncmFtbWFyLXNlbGVjdG9yL2xpYi9ncmFtbWFyLXN0YXR1cy12aWV3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuXG5pbXBvcnQge0Rpc3Bvc2FibGV9IGZyb20gJ2F0b20nXG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEdyYW1tYXJTdGF0dXNWaWV3IHtcbiAgY29uc3RydWN0b3IgKHN0YXR1c0Jhcikge1xuICAgIHRoaXMuc3RhdHVzQmFyID0gc3RhdHVzQmFyXG4gICAgdGhpcy5lbGVtZW50ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnZ3JhbW1hci1zZWxlY3Rvci1zdGF0dXMnKVxuICAgIHRoaXMuZWxlbWVudC5jbGFzc0xpc3QuYWRkKCdncmFtbWFyLXN0YXR1cycsICdpbmxpbmUtYmxvY2snKVxuICAgIHRoaXMuZ3JhbW1hckxpbmsgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdhJylcbiAgICB0aGlzLmdyYW1tYXJMaW5rLmNsYXNzTGlzdC5hZGQoJ2lubGluZS1ibG9jaycpXG4gICAgdGhpcy5lbGVtZW50LmFwcGVuZENoaWxkKHRoaXMuZ3JhbW1hckxpbmspXG5cbiAgICAvLyBUT0RPW3YxLjE5XTogUmVtb3ZlIGNvbmRpdGlvbmFsIG9uY2UgYXRvbS53b3Jrc3BhY2Uub2JzZXJ2ZUFjdGl2ZVRleHRFZGl0b3Igc2hpcHMgaW4gQXRvbSB2MS4xOVxuICAgIGlmIChhdG9tLndvcmtzcGFjZS5vYnNlcnZlQWN0aXZlVGV4dEVkaXRvcikge1xuICAgICAgdGhpcy5hY3RpdmVJdGVtU3Vic2NyaXB0aW9uID0gYXRvbS53b3Jrc3BhY2Uub2JzZXJ2ZUFjdGl2ZVRleHRFZGl0b3IodGhpcy5zdWJzY3JpYmVUb0FjdGl2ZVRleHRFZGl0b3IuYmluZCh0aGlzKSlcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5hY3RpdmVJdGVtU3Vic2NyaXB0aW9uID0gYXRvbS53b3Jrc3BhY2Uub2JzZXJ2ZUFjdGl2ZVBhbmVJdGVtKHRoaXMuc3Vic2NyaWJlVG9BY3RpdmVUZXh0RWRpdG9yLmJpbmQodGhpcykpXG4gICAgfVxuXG4gICAgdGhpcy5jb25maWdTdWJzY3JpcHRpb24gPSBhdG9tLmNvbmZpZy5vYnNlcnZlKCdncmFtbWFyLXNlbGVjdG9yLnNob3dPblJpZ2h0U2lkZU9mU3RhdHVzQmFyJywgdGhpcy5hdHRhY2guYmluZCh0aGlzKSlcbiAgICBjb25zdCBjbGlja0hhbmRsZXIgPSAoZXZlbnQpID0+IHtcbiAgICAgIGV2ZW50LnByZXZlbnREZWZhdWx0KClcbiAgICAgIGF0b20uY29tbWFuZHMuZGlzcGF0Y2goYXRvbS52aWV3cy5nZXRWaWV3KGF0b20ud29ya3NwYWNlLmdldEFjdGl2ZVRleHRFZGl0b3IoKSksICdncmFtbWFyLXNlbGVjdG9yOnNob3cnKVxuICAgIH1cbiAgICB0aGlzLmVsZW1lbnQuYWRkRXZlbnRMaXN0ZW5lcignY2xpY2snLCBjbGlja0hhbmRsZXIpXG4gICAgdGhpcy5jbGlja1N1YnNjcmlwdGlvbiA9IG5ldyBEaXNwb3NhYmxlKCgpID0+IHsgdGhpcy5lbGVtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKSB9KVxuICB9XG5cbiAgYXR0YWNoICgpIHtcbiAgICBpZiAodGhpcy5zdGF0dXNCYXJUaWxlKSB7XG4gICAgICB0aGlzLnN0YXR1c0JhclRpbGUuZGVzdHJveSgpXG4gICAgfVxuXG4gICAgdGhpcy5zdGF0dXNCYXJUaWxlID0gYXRvbS5jb25maWcuZ2V0KCdncmFtbWFyLXNlbGVjdG9yLnNob3dPblJpZ2h0U2lkZU9mU3RhdHVzQmFyJykgP1xuICAgICAgdGhpcy5zdGF0dXNCYXIuYWRkUmlnaHRUaWxlKHtpdGVtOiB0aGlzLmVsZW1lbnQsIHByaW9yaXR5OiAxMH0pIDpcbiAgICAgIHRoaXMuc3RhdHVzQmFyLmFkZExlZnRUaWxlKHtpdGVtOiB0aGlzLmVsZW1lbnQsIHByaW9yaXR5OiAxMH0pXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICBpZiAodGhpcy5hY3RpdmVJdGVtU3Vic2NyaXB0aW9uKSB7XG4gICAgICB0aGlzLmFjdGl2ZUl0ZW1TdWJzY3JpcHRpb24uZGlzcG9zZSgpXG4gICAgfVxuXG4gICAgaWYgKHRoaXMuZ3JhbW1hclN1YnNjcmlwdGlvbikge1xuICAgICAgdGhpcy5ncmFtbWFyU3Vic2NyaXB0aW9uLmRpc3Bvc2UoKVxuICAgIH1cblxuICAgIGlmICh0aGlzLmNsaWNrU3Vic2NyaXB0aW9uKSB7XG4gICAgICB0aGlzLmNsaWNrU3Vic2NyaXB0aW9uLmRpc3Bvc2UoKVxuICAgIH1cblxuICAgIGlmICh0aGlzLmNvbmZpZ1N1YnNjcmlwdGlvbikge1xuICAgICAgdGhpcy5jb25maWdTdWJzY3JpcHRpb24uZGlzcG9zZSgpXG4gICAgfVxuXG4gICAgaWYgKHRoaXMuc3RhdHVzQmFyVGlsZSkge1xuICAgICAgdGhpcy5zdGF0dXNCYXJUaWxlLmRlc3Ryb3koKVxuICAgIH1cbiAgfVxuXG5cbiAgc3Vic2NyaWJlVG9BY3RpdmVUZXh0RWRpdG9yICgpIHtcbiAgICBpZiAodGhpcy5ncmFtbWFyU3Vic2NyaXB0aW9uKSB7XG4gICAgICB0aGlzLmdyYW1tYXJTdWJzY3JpcHRpb24uZGlzcG9zZSgpXG4gICAgICB0aGlzLmdyYW1tYXJTdWJzY3JpcHRpb24gPSBudWxsXG4gICAgfVxuXG4gICAgY29uc3QgZWRpdG9yID0gYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpXG4gICAgaWYgKGVkaXRvcikge1xuICAgICAgdGhpcy5ncmFtbWFyU3Vic2NyaXB0aW9uID0gZWRpdG9yLm9uRGlkQ2hhbmdlR3JhbW1hcih0aGlzLnVwZGF0ZUdyYW1tYXJUZXh0LmJpbmQodGhpcykpXG4gICAgfVxuICAgIHRoaXMudXBkYXRlR3JhbW1hclRleHQoKVxuICB9XG5cbiAgdXBkYXRlR3JhbW1hclRleHQgKCkge1xuICAgIGF0b20udmlld3MudXBkYXRlRG9jdW1lbnQoKCkgPT4ge1xuICAgICAgY29uc3QgZWRpdG9yID0gYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpXG4gICAgICBjb25zdCBncmFtbWFyID0gZWRpdG9yID8gZWRpdG9yLmdldEdyYW1tYXIoKSA6IG51bGxcbiAgICAgIGlmIChncmFtbWFyKSB7XG4gICAgICAgIGxldCBncmFtbWFyTmFtZSA9IG51bGxcbiAgICAgICAgaWYgKGdyYW1tYXIgPT09IGF0b20uZ3JhbW1hcnMubnVsbEdyYW1tYXIpIHtcbiAgICAgICAgICBncmFtbWFyTmFtZSA9ICdQbGFpbiBUZXh0J1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGdyYW1tYXJOYW1lID0gZ3JhbW1hci5uYW1lIHx8IGdyYW1tYXIuc2NvcGVOYW1lXG4gICAgICAgIH1cblxuICAgICAgICB0aGlzLmdyYW1tYXJMaW5rLnRleHRDb250ZW50ID0gZ3JhbW1hck5hbWVcbiAgICAgICAgdGhpcy5ncmFtbWFyTGluay5kYXRhc2V0LmdyYW1tYXIgPSBncmFtbWFyTmFtZVxuICAgICAgICB0aGlzLmVsZW1lbnQuc3R5bGUuZGlzcGxheSA9ICcnXG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLmVsZW1lbnQuc3R5bGUuZGlzcGxheSA9ICdub25lJ1xuICAgICAgfVxuICAgIH0pXG4gIH1cbn1cbiJdfQ==