Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var GrammarListView = (function () {
  function GrammarListView() {
    var _this = this;

    _classCallCheck(this, GrammarListView);

    this.autoDetect = { name: 'Auto Detect' };
    this.selectListView = new _atomSelectList2['default']({
      itemsClassList: ['mark-active'],
      items: [],
      filterKeyForItem: function filterKeyForItem(grammar) {
        return grammar.name;
      },
      elementForItem: function elementForItem(grammar) {
        var grammarName = grammar.name || grammar.scopeName;
        var element = document.createElement('li');
        if (grammar === _this.currentGrammar) {
          element.classList.add('active');
        }
        element.textContent = grammarName;
        element.dataset.grammar = grammarName;
        return element;
      },
      didConfirmSelection: function didConfirmSelection(grammar) {
        _this.cancel();
        if (grammar === _this.autoDetect) {
          atom.textEditors.clearGrammarOverride(_this.editor);
        } else {
          atom.textEditors.setGrammarOverride(_this.editor, grammar.scopeName);
        }
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('grammar-selector');
  }

  _createClass(GrammarListView, [{
    key: 'destroy',
    value: function destroy() {
      this.cancel();
      return this.selectListView.destroy();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      if (this.panel != null) {
        this.panel.destroy();
      }
      this.panel = null;
      this.currentGrammar = null;
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }
      this.selectListView.focus();
      this.selectListView.reset();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel != null) {
        this.cancel();
      } else if (atom.workspace.getActiveTextEditor()) {
        this.editor = atom.workspace.getActiveTextEditor();
        this.currentGrammar = this.editor.getGrammar();
        if (this.currentGrammar === atom.grammars.nullGrammar) {
          this.currentGrammar = this.autoDetect;
        }

        var grammars = atom.grammars.getGrammars().filter(function (grammar) {
          return grammar !== atom.grammars.nullGrammar;
        });
        grammars.sort(function (a, b) {
          if (a.scopeName === 'text.plain') {
            return -1;
          } else if (b.scopeName === 'text.plain') {
            return 1;
          } else if (a.name) {
            return a.name.localeCompare(b.name);
          } else if (a.scopeName) {
            return a.scopeName.localeCompare(b.scopeName);
          } else {
            return 1;
          }
        });
        grammars.unshift(this.autoDetect);
        yield this.selectListView.update({ items: grammars });
        this.attach();
      }
    })
  }]);

  return GrammarListView;
})();

exports['default'] = GrammarListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9ob21lL2FuZHJlaS9hdG9tLTEuMTkuMi9vdXQvYXBwL25vZGVfbW9kdWxlcy9ncmFtbWFyLXNlbGVjdG9yL2xpYi9ncmFtbWFyLWxpc3Qtdmlldy5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs4QkFFMkIsa0JBQWtCOzs7O0lBRXhCLGVBQWU7QUFDdEIsV0FETyxlQUFlLEdBQ25COzs7MEJBREksZUFBZTs7QUFFaEMsUUFBSSxDQUFDLFVBQVUsR0FBRyxFQUFDLElBQUksRUFBRSxhQUFhLEVBQUMsQ0FBQTtBQUN2QyxRQUFJLENBQUMsY0FBYyxHQUFHLGdDQUFtQjtBQUN2QyxvQkFBYyxFQUFFLENBQUMsYUFBYSxDQUFDO0FBQy9CLFdBQUssRUFBRSxFQUFFO0FBQ1Qsc0JBQWdCLEVBQUUsMEJBQUMsT0FBTztlQUFLLE9BQU8sQ0FBQyxJQUFJO09BQUE7QUFDM0Msb0JBQWMsRUFBRSx3QkFBQyxPQUFPLEVBQUs7QUFDM0IsWUFBTSxXQUFXLEdBQUcsT0FBTyxDQUFDLElBQUksSUFBSSxPQUFPLENBQUMsU0FBUyxDQUFBO0FBQ3JELFlBQU0sT0FBTyxHQUFHLFFBQVEsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUE7QUFDNUMsWUFBSSxPQUFPLEtBQUssTUFBSyxjQUFjLEVBQUU7QUFDbkMsaUJBQU8sQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFBO1NBQ2hDO0FBQ0QsZUFBTyxDQUFDLFdBQVcsR0FBRyxXQUFXLENBQUE7QUFDakMsZUFBTyxDQUFDLE9BQU8sQ0FBQyxPQUFPLEdBQUcsV0FBVyxDQUFBO0FBQ3JDLGVBQU8sT0FBTyxDQUFBO09BQ2Y7QUFDRCx5QkFBbUIsRUFBRSw2QkFBQyxPQUFPLEVBQUs7QUFDaEMsY0FBSyxNQUFNLEVBQUUsQ0FBQTtBQUNiLFlBQUksT0FBTyxLQUFLLE1BQUssVUFBVSxFQUFFO0FBQy9CLGNBQUksQ0FBQyxXQUFXLENBQUMsb0JBQW9CLENBQUMsTUFBSyxNQUFNLENBQUMsQ0FBQTtTQUNuRCxNQUFNO0FBQ0wsY0FBSSxDQUFDLFdBQVcsQ0FBQyxrQkFBa0IsQ0FBQyxNQUFLLE1BQU0sRUFBRSxPQUFPLENBQUMsU0FBUyxDQUFDLENBQUE7U0FDcEU7T0FDRjtBQUNELHdCQUFrQixFQUFFLDhCQUFNO0FBQ3hCLGNBQUssTUFBTSxFQUFFLENBQUE7T0FDZDtLQUNGLENBQUMsQ0FBQTtBQUNGLFFBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsa0JBQWtCLENBQUMsQ0FBQTtHQUM5RDs7ZUE5QmtCLGVBQWU7O1dBZ0MxQixtQkFBRztBQUNULFVBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQTtBQUNiLGFBQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPLEVBQUUsQ0FBQTtLQUNyQzs7O1dBRU0sa0JBQUc7QUFDUixVQUFJLElBQUksQ0FBQyxLQUFLLElBQUksSUFBSSxFQUFFO0FBQ3RCLFlBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLENBQUE7T0FDckI7QUFDRCxVQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQTtBQUNqQixVQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQTtBQUMxQixVQUFJLElBQUksQ0FBQyx3QkFBd0IsRUFBRTtBQUNqQyxZQUFJLENBQUMsd0JBQXdCLENBQUMsS0FBSyxFQUFFLENBQUE7QUFDckMsWUFBSSxDQUFDLHdCQUF3QixHQUFHLElBQUksQ0FBQTtPQUNyQztLQUNGOzs7V0FFTSxrQkFBRztBQUNSLFVBQUksQ0FBQyx3QkFBd0IsR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFBO0FBQ3RELFVBQUksSUFBSSxDQUFDLEtBQUssSUFBSSxJQUFJLEVBQUU7QUFDdEIsWUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQyxFQUFDLElBQUksRUFBRSxJQUFJLENBQUMsY0FBYyxFQUFDLENBQUMsQ0FBQTtPQUN2RTtBQUNELFVBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLENBQUE7QUFDM0IsVUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLEVBQUUsQ0FBQTtLQUM1Qjs7OzZCQUVZLGFBQUc7QUFDZCxVQUFJLElBQUksQ0FBQyxLQUFLLElBQUksSUFBSSxFQUFFO0FBQ3RCLFlBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQTtPQUNkLE1BQU0sSUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLEVBQUU7QUFDL0MsWUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLG1CQUFtQixFQUFFLENBQUE7QUFDbEQsWUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFBO0FBQzlDLFlBQUksSUFBSSxDQUFDLGNBQWMsS0FBSyxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsRUFBRTtBQUNyRCxjQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUE7U0FDdEM7O0FBRUQsWUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxNQUFNLENBQUMsVUFBQyxPQUFPO2lCQUFLLE9BQU8sS0FBSyxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVc7U0FBQSxDQUFDLENBQUE7QUFDdkcsZ0JBQVEsQ0FBQyxJQUFJLENBQUMsVUFBQyxDQUFDLEVBQUUsQ0FBQyxFQUFLO0FBQ3RCLGNBQUksQ0FBQyxDQUFDLFNBQVMsS0FBSyxZQUFZLEVBQUU7QUFDaEMsbUJBQU8sQ0FBQyxDQUFDLENBQUE7V0FDVixNQUFNLElBQUksQ0FBQyxDQUFDLFNBQVMsS0FBSyxZQUFZLEVBQUU7QUFDdkMsbUJBQU8sQ0FBQyxDQUFBO1dBQ1QsTUFBTSxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUU7QUFDakIsbUJBQU8sQ0FBQyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFBO1dBQ3BDLE1BQU0sSUFBSSxDQUFDLENBQUMsU0FBUyxFQUFFO0FBQ3RCLG1CQUFPLENBQUMsQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQTtXQUM5QyxNQUFNO0FBQ0wsbUJBQU8sQ0FBQyxDQUFBO1dBQ1Q7U0FDRixDQUFDLENBQUE7QUFDRixnQkFBUSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUE7QUFDakMsY0FBTSxJQUFJLENBQUMsY0FBYyxDQUFDLE1BQU0sQ0FBQyxFQUFDLEtBQUssRUFBRSxRQUFRLEVBQUMsQ0FBQyxDQUFBO0FBQ25ELFlBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQTtPQUNkO0tBQ0Y7OztTQXRGa0IsZUFBZTs7O3FCQUFmLGVBQWUiLCJmaWxlIjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dyYW1tYXItc2VsZWN0b3IvbGliL2dyYW1tYXItbGlzdC12aWV3LmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqIEBiYWJlbCAqL1xuXG5pbXBvcnQgU2VsZWN0TGlzdFZpZXcgZnJvbSAnYXRvbS1zZWxlY3QtbGlzdCdcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgR3JhbW1hckxpc3RWaWV3IHtcbiAgY29uc3RydWN0b3IgKCkge1xuICAgIHRoaXMuYXV0b0RldGVjdCA9IHtuYW1lOiAnQXV0byBEZXRlY3QnfVxuICAgIHRoaXMuc2VsZWN0TGlzdFZpZXcgPSBuZXcgU2VsZWN0TGlzdFZpZXcoe1xuICAgICAgaXRlbXNDbGFzc0xpc3Q6IFsnbWFyay1hY3RpdmUnXSxcbiAgICAgIGl0ZW1zOiBbXSxcbiAgICAgIGZpbHRlcktleUZvckl0ZW06IChncmFtbWFyKSA9PiBncmFtbWFyLm5hbWUsXG4gICAgICBlbGVtZW50Rm9ySXRlbTogKGdyYW1tYXIpID0+IHtcbiAgICAgICAgY29uc3QgZ3JhbW1hck5hbWUgPSBncmFtbWFyLm5hbWUgfHwgZ3JhbW1hci5zY29wZU5hbWVcbiAgICAgICAgY29uc3QgZWxlbWVudCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2xpJylcbiAgICAgICAgaWYgKGdyYW1tYXIgPT09IHRoaXMuY3VycmVudEdyYW1tYXIpIHtcbiAgICAgICAgICBlbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2FjdGl2ZScpXG4gICAgICAgIH1cbiAgICAgICAgZWxlbWVudC50ZXh0Q29udGVudCA9IGdyYW1tYXJOYW1lXG4gICAgICAgIGVsZW1lbnQuZGF0YXNldC5ncmFtbWFyID0gZ3JhbW1hck5hbWVcbiAgICAgICAgcmV0dXJuIGVsZW1lbnRcbiAgICAgIH0sXG4gICAgICBkaWRDb25maXJtU2VsZWN0aW9uOiAoZ3JhbW1hcikgPT4ge1xuICAgICAgICB0aGlzLmNhbmNlbCgpXG4gICAgICAgIGlmIChncmFtbWFyID09PSB0aGlzLmF1dG9EZXRlY3QpIHtcbiAgICAgICAgICBhdG9tLnRleHRFZGl0b3JzLmNsZWFyR3JhbW1hck92ZXJyaWRlKHRoaXMuZWRpdG9yKVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIGF0b20udGV4dEVkaXRvcnMuc2V0R3JhbW1hck92ZXJyaWRlKHRoaXMuZWRpdG9yLCBncmFtbWFyLnNjb3BlTmFtZSlcbiAgICAgICAgfVxuICAgICAgfSxcbiAgICAgIGRpZENhbmNlbFNlbGVjdGlvbjogKCkgPT4ge1xuICAgICAgICB0aGlzLmNhbmNlbCgpXG4gICAgICB9XG4gICAgfSlcbiAgICB0aGlzLnNlbGVjdExpc3RWaWV3LmVsZW1lbnQuY2xhc3NMaXN0LmFkZCgnZ3JhbW1hci1zZWxlY3RvcicpXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICB0aGlzLmNhbmNlbCgpXG4gICAgcmV0dXJuIHRoaXMuc2VsZWN0TGlzdFZpZXcuZGVzdHJveSgpXG4gIH1cblxuICBjYW5jZWwgKCkge1xuICAgIGlmICh0aGlzLnBhbmVsICE9IG51bGwpIHtcbiAgICAgIHRoaXMucGFuZWwuZGVzdHJveSgpXG4gICAgfVxuICAgIHRoaXMucGFuZWwgPSBudWxsXG4gICAgdGhpcy5jdXJyZW50R3JhbW1hciA9IG51bGxcbiAgICBpZiAodGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQpIHtcbiAgICAgIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50LmZvY3VzKClcbiAgICAgIHRoaXMucHJldmlvdXNseUZvY3VzZWRFbGVtZW50ID0gbnVsbFxuICAgIH1cbiAgfVxuXG4gIGF0dGFjaCAoKSB7XG4gICAgdGhpcy5wcmV2aW91c2x5Rm9jdXNlZEVsZW1lbnQgPSBkb2N1bWVudC5hY3RpdmVFbGVtZW50XG4gICAgaWYgKHRoaXMucGFuZWwgPT0gbnVsbCkge1xuICAgICAgdGhpcy5wYW5lbCA9IGF0b20ud29ya3NwYWNlLmFkZE1vZGFsUGFuZWwoe2l0ZW06IHRoaXMuc2VsZWN0TGlzdFZpZXd9KVxuICAgIH1cbiAgICB0aGlzLnNlbGVjdExpc3RWaWV3LmZvY3VzKClcbiAgICB0aGlzLnNlbGVjdExpc3RWaWV3LnJlc2V0KClcbiAgfVxuXG4gIGFzeW5jIHRvZ2dsZSAoKSB7XG4gICAgaWYgKHRoaXMucGFuZWwgIT0gbnVsbCkge1xuICAgICAgdGhpcy5jYW5jZWwoKVxuICAgIH0gZWxzZSBpZiAoYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpKSB7XG4gICAgICB0aGlzLmVkaXRvciA9IGF0b20ud29ya3NwYWNlLmdldEFjdGl2ZVRleHRFZGl0b3IoKVxuICAgICAgdGhpcy5jdXJyZW50R3JhbW1hciA9IHRoaXMuZWRpdG9yLmdldEdyYW1tYXIoKVxuICAgICAgaWYgKHRoaXMuY3VycmVudEdyYW1tYXIgPT09IGF0b20uZ3JhbW1hcnMubnVsbEdyYW1tYXIpIHtcbiAgICAgICAgdGhpcy5jdXJyZW50R3JhbW1hciA9IHRoaXMuYXV0b0RldGVjdFxuICAgICAgfVxuXG4gICAgICBjb25zdCBncmFtbWFycyA9IGF0b20uZ3JhbW1hcnMuZ2V0R3JhbW1hcnMoKS5maWx0ZXIoKGdyYW1tYXIpID0+IGdyYW1tYXIgIT09IGF0b20uZ3JhbW1hcnMubnVsbEdyYW1tYXIpXG4gICAgICBncmFtbWFycy5zb3J0KChhLCBiKSA9PiB7XG4gICAgICAgIGlmIChhLnNjb3BlTmFtZSA9PT0gJ3RleHQucGxhaW4nKSB7XG4gICAgICAgICAgcmV0dXJuIC0xXG4gICAgICAgIH0gZWxzZSBpZiAoYi5zY29wZU5hbWUgPT09ICd0ZXh0LnBsYWluJykge1xuICAgICAgICAgIHJldHVybiAxXG4gICAgICAgIH0gZWxzZSBpZiAoYS5uYW1lKSB7XG4gICAgICAgICAgcmV0dXJuIGEubmFtZS5sb2NhbGVDb21wYXJlKGIubmFtZSlcbiAgICAgICAgfSBlbHNlIGlmIChhLnNjb3BlTmFtZSkge1xuICAgICAgICAgIHJldHVybiBhLnNjb3BlTmFtZS5sb2NhbGVDb21wYXJlKGIuc2NvcGVOYW1lKVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHJldHVybiAxXG4gICAgICAgIH1cbiAgICAgIH0pXG4gICAgICBncmFtbWFycy51bnNoaWZ0KHRoaXMuYXV0b0RldGVjdClcbiAgICAgIGF3YWl0IHRoaXMuc2VsZWN0TGlzdFZpZXcudXBkYXRlKHtpdGVtczogZ3JhbW1hcnN9KVxuICAgICAgdGhpcy5hdHRhY2goKVxuICAgIH1cbiAgfVxufVxuIl19