'use strict';

const qs = require('querystring');

var _require = require('electron');

const remote = _require.remote,
      ipc = _require.ipcRenderer;

var _require2 = require('dugite');

const GitProcess = _require2.GitProcess;
let AverageTracker = class AverageTracker {
  constructor() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { limit: 10 };

    let limit = _ref.limit;

    // for now this serves a dual purpose - # of values tracked AND # discarded prior to starting avg calculation
    this.limit = limit;
    this.sum = 0;
    this.values = [];
  }

  addValue(value) {
    if (this.values.length >= this.limit) {
      const discardedValue = this.values.shift();
      this.sum -= discardedValue;
    }
    this.values.push(value);
    this.sum += value;
  }

  getAverage() {
    if (this.enoughData()) {
      return this.sum / this.limit;
    } else {
      return null;
    }
  }

  getLimit() {
    return this.limit;
  }

  enoughData() {
    return this.values.length === this.limit;
  }
};


const query = qs.parse(window.location.search.substr(1));
const sourceWebContentsId = remote.getCurrentWindow().webContents.id;
const operationCountLimit = parseInt(query.operationCountLimit, 10);
const averageTracker = new AverageTracker({ limit: operationCountLimit });
const childPidsById = new Map();

const destroyRenderer = () => {
  if (!managerWebContents.isDestroyed()) {
    managerWebContents.removeListener('crashed', destroyRenderer);
    managerWebContents.removeListener('destroyed', destroyRenderer);
  }
  const win = remote.BrowserWindow.fromWebContents(remote.getCurrentWebContents());
  if (win && !win.isDestroyed()) {
    win.destroy();
  }
};
const managerWebContentsId = parseInt(query.managerWebContentsId, 10);
const managerWebContents = remote.webContents.fromId(managerWebContentsId);
if (managerWebContents && !managerWebContents.isDestroyed()) {
  managerWebContents.on('crashed', destroyRenderer);
  managerWebContents.on('destroyed', destroyRenderer);
  window.onbeforeunload = () => {
    managerWebContents.removeListener('crashed', destroyRenderer);
    managerWebContents.removeListener('destroyed', destroyRenderer);
  };
}

const channelName = query.channelName;
ipc.on(channelName, (event, _ref2) => {
  let type = _ref2.type,
      data = _ref2.data;

  if (type === 'git-exec') {
    const args = data.args,
          workingDir = data.workingDir,
          options = data.options,
          id = data.id;

    if (args) {
      document.getElementById('command').textContent = `git ${args.join(' ')}`;
    }

    options.processCallback = child => {
      childPidsById.set(id, child.pid);

      child.on('error', err => {
        event.sender.sendTo(managerWebContentsId, channelName, {
          sourceWebContentsId,
          type: 'git-spawn-error',
          data: { id, err }
        });
      });

      child.stdin.on('error', err => {
        event.sender.sendTo(managerWebContentsId, channelName, {
          sourceWebContentsId,
          type: 'git-stdin-error',
          data: { id, stdin: options.stdin, err }
        });
      });
    };

    const spawnStart = performance.now();
    GitProcess.exec(args, workingDir, options).then((_ref3) => {
      let stdout = _ref3.stdout,
          stderr = _ref3.stderr,
          exitCode = _ref3.exitCode;

      const timing = {
        spawnTime: spawnEnd - spawnStart,
        execTime: performance.now() - spawnEnd
      };
      childPidsById.delete(id);
      event.sender.sendTo(managerWebContentsId, channelName, {
        sourceWebContentsId,
        type: 'git-data',
        data: {
          id,
          average: averageTracker.getAverage(),
          results: { stdout, stderr, exitCode, timing }
        }
      });
    });
    const spawnEnd = performance.now();
    averageTracker.addValue(spawnEnd - spawnStart);

    // TODO: consider using this to avoid duplicate write operations upon crashing.
    // For now we won't do this to avoid clogging up ipc channel
    // event.sender.sendTo(managerWebContentsId, channelName, {sourceWebContentsId, type: 'exec-started', data: {id}});

    if (averageTracker.enoughData() && averageTracker.getAverage() > 20) {
      event.sender.sendTo(managerWebContentsId, channelName, { type: 'slow-spawns' });
    }
  } else if (type === 'git-cancel') {
    const id = data.id;

    const childPid = childPidsById.get(id);
    if (childPid !== undefined) {
      require('tree-kill')(childPid, 'SIGINT', () => {
        event.sender.sendTo(managerWebContentsId, channelName, {
          sourceWebContentsId,
          type: 'git-cancelled',
          data: { id, childPid }
        });
      });
      childPidsById.delete(id);
    }
  } else {
    throw new Error(`Could not identify type ${type}`);
  }
});

ipc.sendTo(managerWebContentsId, channelName, { sourceWebContentsId, type: 'renderer-ready', data: { pid: process.pid } });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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