'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * `PaneItem` adds its child to the current Atom pane when rendered.
 * When the pane is closed, the component's `onDidCloseItem` is called.
 * You should use this callback to set state so that the `PaneItem` is no
 * longer rendered; you will get an error in your console if you forget.
 *
 * You may pass a `getItem` function that takes an object with `portal` and
 * `subtree` properties. `getItem` should return an item to be added to the
 * Panel. `portal` is an instance of th Portal component, and `subtree` is the
 * rendered subtree component built from the `children` prop. The default
 * implementation simply returns the Portal instance, which contains a
 * `getElement` method (to be compatible with Atom's view system).
 *
 * Unmounting the component when the item is open will close the item.
 */
let PaneItem = (_temp = _class = class PaneItem extends _react2.default.Component {

  componentDidMount() {
    this.setupPaneItem();
  }

  componentWillReceiveProps() {
    if (this.didCloseItem) {
      // eslint-disable-next-line no-console
      console.error('Unexpected update in `PaneItem`: the contained item has been closed');
    }
  }

  render() {
    return _react2.default.createElement(
      _portal2.default,
      { ref: c => {
          this.portal = c;
        } },
      this.props.children
    );
  }

  setupPaneItem() {
    if (this.paneItem) {
      return;
    }

    const itemToAdd = this.props.getItem({ portal: this.portal, subtree: this.portal.getRenderedSubtree() });
    this.subscriptions = new _eventKit.CompositeDisposable();
    if (itemToAdd.wasActivated) {
      this.subscriptions.add(this.props.workspace.onDidChangeActivePaneItem(activeItem => {
        if (activeItem === this.paneItem) {
          itemToAdd.wasActivated();
        }
      }));
    }

    let paneContainer = this.props.workspace;
    // TODO[v1.17]: remove this once bundled in v1.17
    if (this.props.workspace.getCenter) {
      paneContainer = this.props.workspace.getCenter();
    }
    this.paneItem = paneContainer.getActivePane().addItem(itemToAdd);
    this.subscriptions = this.props.workspace.onDidDestroyPaneItem((_ref) => {
      let item = _ref.item;

      if (item === this.paneItem) {
        this.didCloseItem = true;
        this.props.onDidCloseItem(this.paneItem);
      }
    });
  }

  getPaneItem() {
    return this.paneItem;
  }

  componentWillUnmount() {
    this.subscriptions && this.subscriptions.dispose();
    if (this.paneItem && !this.didCloseItem) {
      this.paneItem.destroy();
    }
  }

  activate() {
    setTimeout(() => {
      if (!this.paneItem) {
        return;
      }

      const pane = this.props.workspace.paneForItem(this.paneItem);
      if (pane) {
        pane.activateItem(this.paneItem);
      } else {
        throw new Error('Cannot find pane for item in `PaneItem#activate`');
      }
    });
  }
}, _class.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  children: _propTypes2.default.element.isRequired,
  getItem: _propTypes2.default.func,
  onDidCloseItem: _propTypes2.default.func
}, _class.defaultProps = {
  getItem: (_ref2) => {
    let portal = _ref2.portal,
        subtree = _ref2.subtree;
    return portal.getView();
  },
  onDidCloseItem: paneItem => {}
}, _temp);
exports.default = PaneItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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