'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _modelObserver = require('../models/model-observer');

var _modelObserver2 = _interopRequireDefault(_modelObserver);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let ObserveModel = (_class = (_temp = _class2 = class ObserveModel extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = { data: null };
    this.modelObserver = new _modelObserver2.default({ fetchData: this.fetchData, didUpdate: this.didUpdate });
  }

  componentWillMount() {
    this.mounted = true;
    this.modelObserver.setActiveModel(this.props.model);
  }

  componentWillReceiveProps(nextProps) {
    this.modelObserver.setActiveModel(nextProps.model);
  }

  fetchData(model) {
    return this.props.fetchData(model);
  }

  didUpdate(model) {
    if (this.mounted) {
      const data = this.modelObserver.getActiveModelData();
      this.setState({ data });
    }
  }

  render() {
    return this.props.children(this.state.data);
  }

  componentWillUnmount() {
    this.mounted = false;
    this.modelObserver.destroy();
  }
}, _class2.propTypes = {
  model: _propTypes2.default.shape({
    onDidUpdate: _propTypes2.default.func.isRequired
  }),
  fetchData: _propTypes2.default.func.isRequired,
  children: _propTypes2.default.func.isRequired
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'fetchData', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetchData'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didUpdate', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didUpdate'), _class.prototype)), _class);
exports.default = ObserveModel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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