'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class;

var _coreDecorators = require('core-decorators');

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const COPY = {};

let ListSelection = (_class = class ListSelection {
  constructor() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (options._copy !== COPY) {
      this.options = {
        isItemSelectable: options.isItemSelectable || (item => true)
      };
      this.setItems(options.items || []);
    } else {
      this.options = {
        isItemSelectable: options.isItemSelectable
      };
      this.items = options.items;
      this.selections = options.selections;
    }
  }

  copy() {
    // Deep-copy selections because it will be modified.
    // (That's temporary, until ListSelection is changed to be immutable, too.)
    return new ListSelection({
      _copy: COPY,
      isItemSelectable: this.options.isItemSelectable,
      items: this.items,
      selections: this.selections.map((_ref) => {
        let head = _ref.head,
            tail = _ref.tail,
            negate = _ref.negate;
        return { head, tail, negate };
      })
    });
  }

  isItemSelectable(item) {
    return this.options.isItemSelectable(item);
  }

  setItems(items) {
    let newSelectionIndex;
    if (this.selections && this.selections.length > 0) {
      var _selections = _slicedToArray(this.selections, 1),
          _selections$ = _selections[0];

      const head = _selections$.head,
            tail = _selections$.tail;

      newSelectionIndex = Math.min(head, tail, items.length - 1);
    } else {
      newSelectionIndex = 0;
    }

    this.items = items;
    if (items.length > 0) {
      this.selections = [{ head: newSelectionIndex, tail: newSelectionIndex }];
    } else {
      this.selections = [];
    }
  }

  getItems() {
    return this.items;
  }

  getLastItem() {
    return this.items[this.items.length - 1];
  }

  selectFirstItem(preserveTail) {
    for (let i = 0; i < this.items.length; i++) {
      const item = this.items[i];
      if (this.isItemSelectable(item)) {
        this.selectItem(item, preserveTail);
        break;
      }
    }
  }

  selectLastItem(preserveTail) {
    for (let i = this.items.length - 1; i > 0; i--) {
      const item = this.items[i];
      if (this.isItemSelectable(item)) {
        this.selectItem(item, preserveTail);
        break;
      }
    }
  }

  selectAllItems() {
    this.selectFirstItem();
    this.selectLastItem(true);
  }

  selectNextItem(preserveTail) {
    if (this.selections.length === 0) {
      this.selectFirstItem();
      return;
    }

    let itemIndex = this.selections[0].head;
    let nextItemIndex = itemIndex;
    while (itemIndex < this.items.length - 1) {
      itemIndex++;
      if (this.isItemSelectable(this.items[itemIndex])) {
        nextItemIndex = itemIndex;
        break;
      }
    }

    this.selectItem(this.items[nextItemIndex], preserveTail);
  }

  selectPreviousItem(preserveTail) {
    if (this.selections.length === 0) {
      this.selectLastItem();
      return;
    }

    let itemIndex = this.selections[0].head;
    let previousItemIndex = itemIndex;

    while (itemIndex > 0) {
      itemIndex--;
      if (this.isItemSelectable(this.items[itemIndex])) {
        previousItemIndex = itemIndex;
        break;
      }
    }

    this.selectItem(this.items[previousItemIndex], preserveTail);
  }

  selectItem(item, preserveTail, addOrSubtract) {
    if (addOrSubtract && preserveTail) {
      throw new Error('addOrSubtract and preserveTail cannot both be true at the same time');
    }

    const itemIndex = this.items.indexOf(item);
    if (preserveTail && this.selections[0]) {
      this.selections[0].head = itemIndex;
    } else {
      const selection = { head: itemIndex, tail: itemIndex };
      if (addOrSubtract) {
        if (this.getSelectedItems().has(item)) {
          selection.negate = true;
        }
        this.selections.unshift(selection);
      } else {
        this.selections = [selection];
      }
    }
  }

  addOrSubtractSelection(item) {
    this.selectItem(item, false, true);
  }

  coalesce() {
    if (this.selections.length === 0) {
      return;
    }

    const mostRecent = this.selections[0];
    let mostRecentStart = Math.min(mostRecent.head, mostRecent.tail);
    let mostRecentEnd = Math.max(mostRecent.head, mostRecent.tail);
    while (mostRecentStart > 0 && !this.isItemSelectable(this.items[mostRecentStart - 1])) {
      mostRecentStart--;
    }
    while (mostRecentEnd < this.items.length - 1 && !this.isItemSelectable(this.items[mostRecentEnd + 1])) {
      mostRecentEnd++;
    }

    for (let i = 1; i < this.selections.length;) {
      const current = this.selections[i];
      const currentStart = Math.min(current.head, current.tail);
      const currentEnd = Math.max(current.head, current.tail);
      if (mostRecentStart <= currentEnd + 1 && currentStart - 1 <= mostRecentEnd) {
        if (mostRecent.negate) {
          const truncatedSelections = [];
          if (current.head > current.tail) {
            if (currentEnd > mostRecentEnd) {
              // suffix
              truncatedSelections.push({ tail: mostRecentEnd + 1, head: currentEnd });
            }
            if (currentStart < mostRecentStart) {
              // prefix
              truncatedSelections.push({ tail: currentStart, head: mostRecentStart - 1 });
            }
          } else {
            if (currentStart < mostRecentStart) {
              // prefix
              truncatedSelections.push({ head: currentStart, tail: mostRecentStart - 1 });
            }
            if (currentEnd > mostRecentEnd) {
              // suffix
              truncatedSelections.push({ head: mostRecentEnd + 1, tail: currentEnd });
            }
          }
          this.selections.splice(i, 1, ...truncatedSelections);
          i += truncatedSelections.length;
        } else {
          mostRecentStart = Math.min(mostRecentStart, currentStart);
          mostRecentEnd = Math.max(mostRecentEnd, currentEnd);
          if (mostRecent.head >= mostRecent.tail) {
            mostRecent.head = mostRecentEnd;
            mostRecent.tail = mostRecentStart;
          } else {
            mostRecent.head = mostRecentStart;
            mostRecent.tail = mostRecentEnd;
          }
          this.selections.splice(i, 1);
        }
      } else {
        i++;
      }
    }

    if (mostRecent.negate) {
      this.selections.shift();
    }
  }

  getSelectedItems() {
    const selectedItems = new Set();
    for (const _ref2 of this.selections.slice().reverse()) {
      const head = _ref2.head,
            tail = _ref2.tail,
            negate = _ref2.negate;

      const start = Math.min(head, tail);
      const end = Math.max(head, tail);
      for (let i = start; i <= end; i++) {
        const item = this.items[i];
        if (this.isItemSelectable(item)) {
          if (negate) {
            selectedItems.delete(item);
          } else {
            selectedItems.add(item);
          }
        }
      }
    }
    return selectedItems;
  }

  getHeadItem() {
    return this.selections.length > 0 ? this.items[this.selections[0].head] : null;
  }

  getMostRecentSelectionStartIndex() {
    const selection = this.selections[0];
    return Math.min(selection.head, selection.tail);
  }

  getTailIndex() {
    return this.selections[0] ? this.selections[0].tail : null;
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'isItemSelectable', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'isItemSelectable'), _class.prototype)), _class);
exports.default = ListSelection;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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