'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _eventKit = require('event-kit');

var _commands = require('./commands');

var _commands2 = _interopRequireDefault(_commands);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let InitDialog = (_class = (_temp = _class2 = class InitDialog extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.state = {
      initDisabled: false
    };

    this.projectHome = this.props.config.get('core.projectHome');
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    if (this.projectPathEditor) {
      this.projectPathEditor.setText(this.props.config.get('core.projectHome'));
      this.projectPathModified = false;
    }

    if (this.projectPathElement) {
      setTimeout(() => this.projectPathElement.focus());
    }
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-Dialog github-Init modal' },
      _react2.default.createElement(
        _commands2.default,
        { registry: this.props.commandRegistry, target: '.github-Init' },
        _react2.default.createElement(_commands.Command, { command: 'core:cancel', callback: this.cancel }),
        _react2.default.createElement(_commands.Command, { command: 'core:confirm', callback: this.init })
      ),
      _react2.default.createElement(
        'main',
        { className: 'github-DialogInputs' },
        _react2.default.createElement(
          'label',
          { className: 'github-DialogLabel github-ProjectPath' },
          'Initialize git repository in directory',
          _react2.default.createElement('atom-text-editor', { mini: true, ref: this.editorRef(), tabIndex: '2' })
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-DialogButtons' },
        _react2.default.createElement(
          'button',
          { className: 'btn github-CancelButton', onClick: this.cancel, tabIndex: '3' },
          'Cancel'
        ),
        _react2.default.createElement(
          'button',
          {
            className: 'btn btn-primary icon icon-repo-create',
            onClick: this.init,
            disabled: this.state.initDisabled,
            tabIndex: '4' },
          'Init'
        )
      )
    );
  }

  init() {
    if (this.getProjectPath().length === 0) {
      return;
    }

    this.props.didAccept(this.getProjectPath());
  }

  cancel() {
    this.props.didCancel();
  }

  editorRef() {
    return element => {
      if (!element) {
        return;
      }

      this.projectPathElement = element;
      const editor = element.getModel();
      if (this.projectPathEditor !== editor) {
        this.projectPathEditor = editor;

        if (this.projectPathSubs) {
          this.projectPathSubs.dispose();
          this.subs.remove(this.projectPathSubs);
        }

        this.projectPathSubs = editor.onDidChange(this.setInitEnablement);
        this.subs.add(this.projectPathSubs);
      }
    };
  }

  getProjectPath() {
    return this.projectPathEditor ? this.projectPathEditor.getText() : '';
  }

  getRemoteUrl() {
    return this.remoteUrlEditor ? this.remoteUrlEditor.getText() : '';
  }

  setInitEnablement() {
    this.setState({ initDisabled: this.getProjectPath().length === 0 });
  }
}, _class2.propTypes = {
  config: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  didAccept: _propTypes2.default.func,
  didCancel: _propTypes2.default.func
}, _class2.defaultProps = {
  didAccept: () => {},
  didCancel: () => {}
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'init', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'init'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'cancel', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'cancel'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'editorRef', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'editorRef'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setInitEnablement', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'setInitEnablement'), _class.prototype)), _class);
exports.default = InitDialog;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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