'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp, _desc, _value, _class2, _class3, _temp2, _desc2, _value2, _class4, _class5, _temp3, _desc3, _value3, _class6, _class7, _temp4, _desc4, _value4, _class8, _class9, _temp5;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _atom = require('atom');

var _eventKit = require('event-kit');

var _electron = require('electron');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _lodash = require('lodash.memoize');

var _lodash2 = _interopRequireDefault(_lodash);

var _helpers = require('../helpers');

var _octicon = require('./octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

const dialog = _electron.remote.dialog;


const genArray = (0, _lodash2.default)(function genArray(interval, count) {
  const arr = [];
  for (let i = 1; i <= count; i++) {
    arr.push(interval * i);
  }
  return arr;
}, (interval, count) => `${interval}:${count}`);

let Marker = class Marker {
  static deserialize(data) {
    const marker = new Marker(data.label, () => {});
    marker.end = data.end;
    marker.markers = data.markers;
    return marker;
  }

  constructor(label, didUpdate) {
    this.label = label;
    this.didUpdate = didUpdate;
    this.end = null;
    this.markers = [];
  }

  getStart() {
    return this.markers.length ? this.markers[0].start : null;
  }

  getEnd() {
    return this.end;
  }

  mark(sectionName, start) {
    this.markers.push({ name: sectionName, start: start || performance.now() });
  }

  finalize() {
    this.end = performance.now();
    this.didUpdate();
  }

  getTimings() {
    return this.markers.map((timing, idx, ary) => {
      const next = ary[idx + 1];
      const end = next ? next.start : this.getEnd();
      return _extends({}, timing, { end });
    });
  }

  serialize() {
    return {
      label: this.label,
      end: this.end,
      markers: this.markers.slice()
    };
  }
};
let MarkerTooltip = (_temp = _class = class MarkerTooltip extends _react2.default.Component {

  render() {
    const marker = this.props.marker;

    const timings = marker.getTimings();

    return _react2.default.createElement(
      'div',
      { style: { textAlign: 'left', maxWidth: 300, whiteSpace: 'initial' } },
      _react2.default.createElement(
        'strong',
        null,
        _react2.default.createElement(
          'tt',
          null,
          marker.label
        )
      ),
      _react2.default.createElement(
        'ul',
        { style: { paddingLeft: 20, marginTop: 10 } },
        timings.map((_ref) => {
          let name = _ref.name,
              start = _ref.start,
              end = _ref.end;

          const duration = end - start;
          return _react2.default.createElement(
            'li',
            { key: name },
            name,
            ': ',
            Math.floor(duration * 100) / 100,
            'ms'
          );
        })
      )
    );
  }
}, _class.propTypes = {
  marker: _propTypes2.default.instanceOf(Marker).isRequired
}, _temp);


const COLORS = {
  queued: 'red',
  prepare: 'cyan',
  nexttick: 'yellow',
  execute: 'green',
  ipc: 'pink'
};
let MarkerSpan = (_class2 = (_temp2 = _class3 = class MarkerSpan extends _react2.default.Component {

  render() {
    var _props = this.props;

    const marker = _props.marker,
          others = _objectWithoutProperties(_props, ['marker']);

    const timings = marker.getTimings();
    const totalTime = marker.getEnd() - marker.getStart();
    const percentages = timings.map((_ref2) => {
      let name = _ref2.name,
          start = _ref2.start,
          end = _ref2.end;

      const duration = end - start;
      return { color: COLORS[name], percent: duration / totalTime * 100 };
    });
    return _react2.default.createElement(
      'span',
      _extends({}, others, {
        ref: c => {
          this.element = c;
        },
        onMouseOver: this.handleMouseOver,
        onMouseOut: this.handleMouseOut }),
      percentages.map((_ref3, i) => {
        let color = _ref3.color,
            percent = _ref3.percent;

        const style = {
          width: `${percent}%`,
          background: color
        };
        return _react2.default.createElement('span', { className: 'waterfall-marker-section', key: i, style: style });
      })
    );
  }

  handleMouseOver(e) {
    const elem = document.createElement('div');
    _reactDom2.default.render(_react2.default.createElement(MarkerTooltip, { marker: this.props.marker }), elem);
    this.tooltipDisposable = atom.tooltips.add(this.element, {
      item: elem,
      placement: 'auto bottom',
      trigger: 'manual'
    });
  }

  closeTooltip() {
    this.tooltipDisposable && this.tooltipDisposable.dispose();
    this.tooltipDisposable = null;
  }

  handleMouseOut(e) {
    this.closeTooltip();
  }

  componentWillUnmount() {
    this.closeTooltip();
  }
}, _class3.propTypes = {
  marker: _propTypes2.default.instanceOf(Marker).isRequired
}, _temp2), (_applyDecoratedDescriptor(_class2.prototype, 'handleMouseOver', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleMouseOver'), _class2.prototype), _applyDecoratedDescriptor(_class2.prototype, 'handleMouseOut', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class2.prototype, 'handleMouseOut'), _class2.prototype)), _class2);
let Waterfall = (_class4 = (_temp3 = _class5 = class Waterfall extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = this.getNextState(props);
  }

  componentWillReceiveProps(nextProps) {
    this.setState(this.getNextState(nextProps));
  }

  getNextState(props) {
    const markers = props.markers;

    const firstMarker = markers[0];
    const lastMarker = markers[markers.length - 1];

    const startTime = firstMarker.getStart();
    const endTime = lastMarker.getEnd();
    const totalDuration = endTime - startTime;
    let timelineMarkInterval = null;
    if (props.zoomFactor <= 0.15) {
      timelineMarkInterval = 1000;
    } else if (props.zoomFactor <= 0.3) {
      timelineMarkInterval = 500;
    } else if (props.zoomFactor <= 0.6) {
      timelineMarkInterval = 250;
    } else {
      timelineMarkInterval = 100;
    }
    const timelineMarks = genArray(timelineMarkInterval, Math.ceil(totalDuration / timelineMarkInterval));

    return { firstMarker, lastMarker, startTime, endTime, totalDuration, timelineMarks };
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'waterfall-scroller' },
      _react2.default.createElement(
        'div',
        { className: 'waterfall-container' },
        this.renderTimeMarkers(),
        this.renderTimeline(),
        this.props.markers.map(this.renderMarker)
      )
    );
  }

  renderTimeline() {
    return _react2.default.createElement(
      'div',
      { className: 'waterfall-timeline' },
      '\xA0',
      this.state.timelineMarks.map(time => {
        const leftPos = time * this.props.zoomFactor;
        const style = {
          left: leftPos
        };
        return _react2.default.createElement(
          'span',
          { className: 'waterfall-timeline-label', style: style, key: `tl:${time}` },
          time,
          'ms'
        );
      })
    );
  }

  renderTimeMarkers() {
    return _react2.default.createElement(
      'div',
      { className: 'waterfall-time-markers' },
      this.state.timelineMarks.map(time => {
        const leftPos = time * this.props.zoomFactor;
        const style = {
          left: leftPos
        };
        return _react2.default.createElement('span', { className: 'waterfall-time-marker', style: style, key: `tm:${time}` });
      })
    );
  }

  renderMarker(marker, i) {
    if (marker.getStart() === null || marker.getEnd() === null) {
      return _react2.default.createElement('div', { key: i });
    }

    const startOffset = marker.getStart() - this.state.startTime;
    const duration = marker.getEnd() - marker.getStart();
    const markerStyle = {
      left: startOffset * this.props.zoomFactor,
      width: duration * this.props.zoomFactor
    };

    return _react2.default.createElement(
      'div',
      { className: 'waterfall-row', key: i },
      _react2.default.createElement(
        'span',
        {
          className: 'waterfall-row-label',
          style: { paddingLeft: markerStyle.left + markerStyle.width } },
        marker.label
      ),
      _react2.default.createElement(MarkerSpan, { className: 'waterfall-marker', style: markerStyle, marker: marker })
    );
  }
}, _class5.propTypes = {
  markers: _propTypes2.default.arrayOf(_propTypes2.default.instanceOf(Marker)).isRequired,
  zoomFactor: _propTypes2.default.number.isRequired
}, _temp3), (_applyDecoratedDescriptor(_class4.prototype, 'renderMarker', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class4.prototype, 'renderMarker'), _class4.prototype)), _class4);
let WaterfallWidget = (_class6 = (_temp4 = _class7 = class WaterfallWidget extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);
    this.state = {
      zoomFactor: 0.3,
      collapsed: false
    };
  }

  render() {
    const markers = this.props.markers;

    const firstMarker = markers[0];
    const lastMarker = markers[markers.length - 1];

    const startTime = firstMarker.getStart();
    const endTime = lastMarker.getEnd();
    const duration = endTime - startTime;

    return _react2.default.createElement(
      'div',
      { className: 'waterfall-widget inset-pannel' },
      _react2.default.createElement(
        'div',
        { className: 'waterfall-header' },
        _react2.default.createElement(
          'div',
          { className: 'waterfall-header-text' },
          _react2.default.createElement(
            'span',
            { onClick: this.handleCollapseClick, className: 'collapse-toggle' },
            this.state.collapsed ? '\u25b6' : '\u25bc'
          ),
          this.props.markers.length,
          ' event(s) over ',
          Math.floor(duration),
          'ms'
        ),
        _react2.default.createElement(
          'div',
          { className: 'waterfall-header-controls' },
          _react2.default.createElement(
            'button',
            {
              className: 'waterfall-export-button btn btn-sm',
              onClick: this.handleExportClick },
            'Export'
          ),
          _react2.default.createElement(_octicon2.default, { icon: 'search' }),
          _react2.default.createElement('input', {
            type: 'range',
            className: 'input-range',
            min: 0.1,
            max: 1,
            step: 0.01,
            value: this.state.zoomFactor,
            onChange: this.handleZoomFactorChange
          })
        )
      ),
      this.state.collapsed ? null : _react2.default.createElement(Waterfall, { markers: this.props.markers, zoomFactor: this.state.zoomFactor })
    );
  }

  handleZoomFactorChange(e) {
    this.setState({ zoomFactor: parseFloat(e.target.value) });
  }

  handleCollapseClick(e) {
    this.setState(s => ({ collapsed: !s.collapsed }));
  }

  handleExportClick(e) {
    e.preventDefault();
    const json = JSON.stringify(this.props.markers.map(m => m.serialize()), null, '  ');
    const buffer = new _atom.TextBuffer({ text: json });
    dialog.showSaveDialog({
      defaultPath: 'git-timings.json'
    }, filename => {
      if (!filename) {
        return;
      }
      buffer.saveAs(filename);
    });
  }
}, _class7.propTypes = {
  markers: _propTypes2.default.arrayOf(_propTypes2.default.instanceOf(Marker)).isRequired
}, _temp4), (_applyDecoratedDescriptor(_class6.prototype, 'handleZoomFactorChange', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class6.prototype, 'handleZoomFactorChange'), _class6.prototype), _applyDecoratedDescriptor(_class6.prototype, 'handleCollapseClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class6.prototype, 'handleCollapseClick'), _class6.prototype), _applyDecoratedDescriptor(_class6.prototype, 'handleExportClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class6.prototype, 'handleExportClick'), _class6.prototype)), _class6);


let markers = null;
let groupId = 0;
const groups = [];
let lastMarkerTime = null;
let updateTimer = null;

let GitTimingsView = (_class8 = (_temp5 = _class9 = class GitTimingsView extends _react2.default.Component {

  static createPaneItem() {
    let element;
    return {
      serialize() {
        return { deserializer: 'GitTimingsView' };
      },
      getURI() {
        return 'atom-github://debug/markers';
      },
      getTitle() {
        return 'GitHub Package Timings View';
      },
      get element() {
        if (!element) {
          element = document.createElement('div');
          _reactDom2.default.render(_react2.default.createElement(GitTimingsView, { container: element }), element);
        }
        return element;
      }
    };
  }

  static deserialize() {
    return this.createPaneItem();
  }

  static generateMarker(label) {
    const marker = new Marker(label, () => {
      GitTimingsView.scheduleUpdate();
    });
    const now = performance.now();
    if (!markers || lastMarkerTime && Math.abs(now - lastMarkerTime) >= 5000) {
      groupId++;
      markers = [];
      groups.unshift({ id: groupId, markers });
      if (groups.length > 100) {
        groups.pop();
      }
    }
    lastMarkerTime = now;
    markers.push(marker);
    GitTimingsView.scheduleUpdate();
    return marker;
  }

  static restoreGroup(group) {
    groupId++;
    groups.unshift({ id: groupId, markers: group });
    GitTimingsView.scheduleUpdate(true);
  }

  static scheduleUpdate() {
    let immediate = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    if (updateTimer) {
      clearTimeout(updateTimer);
    }

    updateTimer = setTimeout(() => {
      GitTimingsView.emitter.emit('did-update');
    }, immediate ? 0 : 1000);
  }

  static onDidUpdate(callback) {
    return GitTimingsView.emitter.on('did-update', callback);
  }

  componentDidMount() {
    this.subscriptions = new _eventKit.CompositeDisposable(GitTimingsView.onDidUpdate(() => this.forceUpdate()), atom.workspace.onDidDestroyPaneItem((_ref4) => {
      let item = _ref4.item;

      if (item.element === this.props.container) {
        // we just got closed
        _reactDom2.default.unmountComponentAtNode(this.props.container);
      }
    }));
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-GitTimingsView' },
      _react2.default.createElement(
        'div',
        { className: 'github-GitTimingsView-header' },
        _react2.default.createElement(
          'button',
          { className: 'import-button btn', onClick: this.handleImportClick },
          'Import'
        )
      ),
      groups.map((group, idx) => _react2.default.createElement(WaterfallWidget, { key: group.id, markers: group.markers }))
    );
  }

  handleImportClick(e) {
    e.preventDefault();
    dialog.showOpenDialog({
      properties: ['openFile']
    }, (() => {
      var _ref5 = _asyncToGenerator(function* (filenames) {
        if (!filenames) {
          return;
        }
        const filename = filenames[0];
        try {
          const contents = yield (0, _helpers.readFile)(filename);
          const data = JSON.parse(contents);
          const restoredMarkers = data.map(function (item) {
            return Marker.deserialize(item);
          });
          GitTimingsView.restoreGroup(restoredMarkers);
        } catch (_err) {
          atom.notifications.addError(`Could not import timings from ${filename}`);
        }
      });

      return function (_x2) {
        return _ref5.apply(this, arguments);
      };
    })());
  }
}, _class9.propTypes = {
  container: _propTypes2.default.any.isRequired
}, _class9.emitter = new _eventKit.Emitter(), _temp5), (_applyDecoratedDescriptor(_class8.prototype, 'handleImportClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class8.prototype, 'handleImportClick'), _class8.prototype)), _class8);
exports.default = GitTimingsView;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdpdC10aW1pbmdzLXZpZXcuanMiXSwibmFtZXMiOlsiZGlhbG9nIiwiZ2VuQXJyYXkiLCJpbnRlcnZhbCIsImNvdW50IiwiYXJyIiwiaSIsInB1c2giLCJNYXJrZXIiLCJkZXNlcmlhbGl6ZSIsImRhdGEiLCJtYXJrZXIiLCJsYWJlbCIsImVuZCIsIm1hcmtlcnMiLCJjb25zdHJ1Y3RvciIsImRpZFVwZGF0ZSIsImdldFN0YXJ0IiwibGVuZ3RoIiwic3RhcnQiLCJnZXRFbmQiLCJtYXJrIiwic2VjdGlvbk5hbWUiLCJuYW1lIiwicGVyZm9ybWFuY2UiLCJub3ciLCJmaW5hbGl6ZSIsImdldFRpbWluZ3MiLCJtYXAiLCJ0aW1pbmciLCJpZHgiLCJhcnkiLCJuZXh0Iiwic2VyaWFsaXplIiwic2xpY2UiLCJNYXJrZXJUb29sdGlwIiwiQ29tcG9uZW50IiwicmVuZGVyIiwicHJvcHMiLCJ0aW1pbmdzIiwidGV4dEFsaWduIiwibWF4V2lkdGgiLCJ3aGl0ZVNwYWNlIiwicGFkZGluZ0xlZnQiLCJtYXJnaW5Ub3AiLCJkdXJhdGlvbiIsIk1hdGgiLCJmbG9vciIsInByb3BUeXBlcyIsImluc3RhbmNlT2YiLCJpc1JlcXVpcmVkIiwiQ09MT1JTIiwicXVldWVkIiwicHJlcGFyZSIsIm5leHR0aWNrIiwiZXhlY3V0ZSIsImlwYyIsIk1hcmtlclNwYW4iLCJvdGhlcnMiLCJ0b3RhbFRpbWUiLCJwZXJjZW50YWdlcyIsImNvbG9yIiwicGVyY2VudCIsImMiLCJlbGVtZW50IiwiaGFuZGxlTW91c2VPdmVyIiwiaGFuZGxlTW91c2VPdXQiLCJzdHlsZSIsIndpZHRoIiwiYmFja2dyb3VuZCIsImUiLCJlbGVtIiwiZG9jdW1lbnQiLCJjcmVhdGVFbGVtZW50IiwidG9vbHRpcERpc3Bvc2FibGUiLCJhdG9tIiwidG9vbHRpcHMiLCJhZGQiLCJpdGVtIiwicGxhY2VtZW50IiwidHJpZ2dlciIsImNsb3NlVG9vbHRpcCIsImRpc3Bvc2UiLCJjb21wb25lbnRXaWxsVW5tb3VudCIsIldhdGVyZmFsbCIsImNvbnRleHQiLCJzdGF0ZSIsImdldE5leHRTdGF0ZSIsImNvbXBvbmVudFdpbGxSZWNlaXZlUHJvcHMiLCJuZXh0UHJvcHMiLCJzZXRTdGF0ZSIsImZpcnN0TWFya2VyIiwibGFzdE1hcmtlciIsInN0YXJ0VGltZSIsImVuZFRpbWUiLCJ0b3RhbER1cmF0aW9uIiwidGltZWxpbmVNYXJrSW50ZXJ2YWwiLCJ6b29tRmFjdG9yIiwidGltZWxpbmVNYXJrcyIsImNlaWwiLCJyZW5kZXJUaW1lTWFya2VycyIsInJlbmRlclRpbWVsaW5lIiwicmVuZGVyTWFya2VyIiwidGltZSIsImxlZnRQb3MiLCJsZWZ0Iiwic3RhcnRPZmZzZXQiLCJtYXJrZXJTdHlsZSIsImFycmF5T2YiLCJudW1iZXIiLCJXYXRlcmZhbGxXaWRnZXQiLCJjb2xsYXBzZWQiLCJoYW5kbGVDb2xsYXBzZUNsaWNrIiwiaGFuZGxlRXhwb3J0Q2xpY2siLCJoYW5kbGVab29tRmFjdG9yQ2hhbmdlIiwicGFyc2VGbG9hdCIsInRhcmdldCIsInZhbHVlIiwicyIsInByZXZlbnREZWZhdWx0IiwianNvbiIsIkpTT04iLCJzdHJpbmdpZnkiLCJtIiwiYnVmZmVyIiwidGV4dCIsInNob3dTYXZlRGlhbG9nIiwiZGVmYXVsdFBhdGgiLCJmaWxlbmFtZSIsInNhdmVBcyIsImdyb3VwSWQiLCJncm91cHMiLCJsYXN0TWFya2VyVGltZSIsInVwZGF0ZVRpbWVyIiwiR2l0VGltaW5nc1ZpZXciLCJjcmVhdGVQYW5lSXRlbSIsImRlc2VyaWFsaXplciIsImdldFVSSSIsImdldFRpdGxlIiwiZ2VuZXJhdGVNYXJrZXIiLCJzY2hlZHVsZVVwZGF0ZSIsImFicyIsInVuc2hpZnQiLCJpZCIsInBvcCIsInJlc3RvcmVHcm91cCIsImdyb3VwIiwiaW1tZWRpYXRlIiwiY2xlYXJUaW1lb3V0Iiwic2V0VGltZW91dCIsImVtaXR0ZXIiLCJlbWl0Iiwib25EaWRVcGRhdGUiLCJjYWxsYmFjayIsIm9uIiwiY29tcG9uZW50RGlkTW91bnQiLCJzdWJzY3JpcHRpb25zIiwiZm9yY2VVcGRhdGUiLCJ3b3Jrc3BhY2UiLCJvbkRpZERlc3Ryb3lQYW5lSXRlbSIsImNvbnRhaW5lciIsInVubW91bnRDb21wb25lbnRBdE5vZGUiLCJoYW5kbGVJbXBvcnRDbGljayIsInNob3dPcGVuRGlhbG9nIiwicHJvcGVydGllcyIsImZpbGVuYW1lcyIsImNvbnRlbnRzIiwicGFyc2UiLCJyZXN0b3JlZE1hcmtlcnMiLCJfZXJyIiwibm90aWZpY2F0aW9ucyIsImFkZEVycm9yIiwiYW55Il0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUdBOzs7O0FBQ0E7Ozs7QUFDQTs7OztBQUNBOztBQUNBOzs7O0FBRUE7O0FBQ0E7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztNQVRPQSxNLG9CQUFBQSxNOzs7QUFXUCxNQUFNQyxXQUFXLHNCQUFRLFNBQVNBLFFBQVQsQ0FBa0JDLFFBQWxCLEVBQTRCQyxLQUE1QixFQUFtQztBQUMxRCxRQUFNQyxNQUFNLEVBQVo7QUFDQSxPQUFLLElBQUlDLElBQUksQ0FBYixFQUFnQkEsS0FBS0YsS0FBckIsRUFBNEJFLEdBQTVCLEVBQWlDO0FBQy9CRCxRQUFJRSxJQUFKLENBQVNKLFdBQVdHLENBQXBCO0FBQ0Q7QUFDRCxTQUFPRCxHQUFQO0FBQ0QsQ0FOZ0IsRUFNZCxDQUFDRixRQUFELEVBQVdDLEtBQVgsS0FBc0IsR0FBRUQsUUFBUyxJQUFHQyxLQUFNLEVBTjVCLENBQWpCOztJQVFNSSxNLEdBQU4sTUFBTUEsTUFBTixDQUFhO0FBQ1gsU0FBT0MsV0FBUCxDQUFtQkMsSUFBbkIsRUFBeUI7QUFDdkIsVUFBTUMsU0FBUyxJQUFJSCxNQUFKLENBQVdFLEtBQUtFLEtBQWhCLEVBQXVCLE1BQU0sQ0FBRSxDQUEvQixDQUFmO0FBQ0FELFdBQU9FLEdBQVAsR0FBYUgsS0FBS0csR0FBbEI7QUFDQUYsV0FBT0csT0FBUCxHQUFpQkosS0FBS0ksT0FBdEI7QUFDQSxXQUFPSCxNQUFQO0FBQ0Q7O0FBRURJLGNBQVlILEtBQVosRUFBbUJJLFNBQW5CLEVBQThCO0FBQzVCLFNBQUtKLEtBQUwsR0FBYUEsS0FBYjtBQUNBLFNBQUtJLFNBQUwsR0FBaUJBLFNBQWpCO0FBQ0EsU0FBS0gsR0FBTCxHQUFXLElBQVg7QUFDQSxTQUFLQyxPQUFMLEdBQWUsRUFBZjtBQUNEOztBQUVERyxhQUFXO0FBQ1QsV0FBTyxLQUFLSCxPQUFMLENBQWFJLE1BQWIsR0FBc0IsS0FBS0osT0FBTCxDQUFhLENBQWIsRUFBZ0JLLEtBQXRDLEdBQThDLElBQXJEO0FBQ0Q7O0FBRURDLFdBQVM7QUFDUCxXQUFPLEtBQUtQLEdBQVo7QUFDRDs7QUFFRFEsT0FBS0MsV0FBTCxFQUFrQkgsS0FBbEIsRUFBeUI7QUFDdkIsU0FBS0wsT0FBTCxDQUFhUCxJQUFiLENBQWtCLEVBQUNnQixNQUFNRCxXQUFQLEVBQW9CSCxPQUFPQSxTQUFTSyxZQUFZQyxHQUFaLEVBQXBDLEVBQWxCO0FBQ0Q7O0FBRURDLGFBQVc7QUFDVCxTQUFLYixHQUFMLEdBQVdXLFlBQVlDLEdBQVosRUFBWDtBQUNBLFNBQUtULFNBQUw7QUFDRDs7QUFFRFcsZUFBYTtBQUNYLFdBQU8sS0FBS2IsT0FBTCxDQUFhYyxHQUFiLENBQWlCLENBQUNDLE1BQUQsRUFBU0MsR0FBVCxFQUFjQyxHQUFkLEtBQXNCO0FBQzVDLFlBQU1DLE9BQU9ELElBQUlELE1BQU0sQ0FBVixDQUFiO0FBQ0EsWUFBTWpCLE1BQU1tQixPQUFPQSxLQUFLYixLQUFaLEdBQW9CLEtBQUtDLE1BQUwsRUFBaEM7QUFDQSwwQkFBV1MsTUFBWCxJQUFtQmhCLEdBQW5CO0FBQ0QsS0FKTSxDQUFQO0FBS0Q7O0FBRURvQixjQUFZO0FBQ1YsV0FBTztBQUNMckIsYUFBTyxLQUFLQSxLQURQO0FBRUxDLFdBQUssS0FBS0EsR0FGTDtBQUdMQyxlQUFTLEtBQUtBLE9BQUwsQ0FBYW9CLEtBQWI7QUFISixLQUFQO0FBS0Q7QUE5Q1UsQztJQWtEUEMsYSxxQkFBTixNQUFNQSxhQUFOLFNBQTRCLGdCQUFNQyxTQUFsQyxDQUE0Qzs7QUFLMUNDLFdBQVM7QUFBQSxVQUNBMUIsTUFEQSxHQUNVLEtBQUsyQixLQURmLENBQ0EzQixNQURBOztBQUVQLFVBQU00QixVQUFVNUIsT0FBT2dCLFVBQVAsRUFBaEI7O0FBRUEsV0FDRTtBQUFBO0FBQUEsUUFBSyxPQUFPLEVBQUNhLFdBQVcsTUFBWixFQUFvQkMsVUFBVSxHQUE5QixFQUFtQ0MsWUFBWSxTQUEvQyxFQUFaO0FBQ0U7QUFBQTtBQUFBO0FBQVE7QUFBQTtBQUFBO0FBQUsvQixpQkFBT0M7QUFBWjtBQUFSLE9BREY7QUFFRTtBQUFBO0FBQUEsVUFBSSxPQUFPLEVBQUMrQixhQUFhLEVBQWQsRUFBa0JDLFdBQVcsRUFBN0IsRUFBWDtBQUNHTCxnQkFBUVgsR0FBUixDQUFZLFVBQXdCO0FBQUEsY0FBdEJMLElBQXNCLFFBQXRCQSxJQUFzQjtBQUFBLGNBQWhCSixLQUFnQixRQUFoQkEsS0FBZ0I7QUFBQSxjQUFUTixHQUFTLFFBQVRBLEdBQVM7O0FBQ25DLGdCQUFNZ0MsV0FBV2hDLE1BQU1NLEtBQXZCO0FBQ0EsaUJBQU87QUFBQTtBQUFBLGNBQUksS0FBS0ksSUFBVDtBQUFnQkEsZ0JBQWhCO0FBQUE7QUFBd0J1QixpQkFBS0MsS0FBTCxDQUFXRixXQUFXLEdBQXRCLElBQTZCLEdBQXJEO0FBQUE7QUFBQSxXQUFQO0FBQ0QsU0FIQTtBQURIO0FBRkYsS0FERjtBQVdEO0FBcEJ5QyxDLFNBQ25DRyxTLEdBQVk7QUFDakJyQyxVQUFRLG9CQUFVc0MsVUFBVixDQUFxQnpDLE1BQXJCLEVBQTZCMEM7QUFEcEIsQzs7O0FBc0JyQixNQUFNQyxTQUFTO0FBQ2JDLFVBQVEsS0FESztBQUViQyxXQUFTLE1BRkk7QUFHYkMsWUFBVSxRQUhHO0FBSWJDLFdBQVMsT0FKSTtBQUtiQyxPQUFLO0FBTFEsQ0FBZjtJQU9NQyxVLGtDQUFOLE1BQU1BLFVBQU4sU0FBeUIsZ0JBQU1yQixTQUEvQixDQUF5Qzs7QUFLdkNDLFdBQVM7QUFBQSxpQkFDcUIsS0FBS0MsS0FEMUI7O0FBQUEsVUFDQTNCLE1BREEsVUFDQUEsTUFEQTtBQUFBLFVBQ1crQyxNQURYOztBQUVQLFVBQU1uQixVQUFVNUIsT0FBT2dCLFVBQVAsRUFBaEI7QUFDQSxVQUFNZ0MsWUFBWWhELE9BQU9TLE1BQVAsS0FBa0JULE9BQU9NLFFBQVAsRUFBcEM7QUFDQSxVQUFNMkMsY0FBY3JCLFFBQVFYLEdBQVIsQ0FBWSxXQUF3QjtBQUFBLFVBQXRCTCxJQUFzQixTQUF0QkEsSUFBc0I7QUFBQSxVQUFoQkosS0FBZ0IsU0FBaEJBLEtBQWdCO0FBQUEsVUFBVE4sR0FBUyxTQUFUQSxHQUFTOztBQUN0RCxZQUFNZ0MsV0FBV2hDLE1BQU1NLEtBQXZCO0FBQ0EsYUFBTyxFQUFDMEMsT0FBT1YsT0FBTzVCLElBQVAsQ0FBUixFQUFzQnVDLFNBQVNqQixXQUFXYyxTQUFYLEdBQXVCLEdBQXRELEVBQVA7QUFDRCxLQUhtQixDQUFwQjtBQUlBLFdBQ0U7QUFBQTtBQUFBLG1CQUNNRCxNQUROO0FBRUUsYUFBS0ssS0FBSztBQUFFLGVBQUtDLE9BQUwsR0FBZUQsQ0FBZjtBQUFtQixTQUZqQztBQUdFLHFCQUFhLEtBQUtFLGVBSHBCO0FBSUUsb0JBQVksS0FBS0MsY0FKbkI7QUFLR04sa0JBQVloQyxHQUFaLENBQWdCLFFBQW1CdEIsQ0FBbkIsS0FBeUI7QUFBQSxZQUF2QnVELEtBQXVCLFNBQXZCQSxLQUF1QjtBQUFBLFlBQWhCQyxPQUFnQixTQUFoQkEsT0FBZ0I7O0FBQ3hDLGNBQU1LLFFBQVE7QUFDWkMsaUJBQVEsR0FBRU4sT0FBUSxHQUROO0FBRVpPLHNCQUFZUjtBQUZBLFNBQWQ7QUFJQSxlQUFPLHdDQUFNLFdBQVUsMEJBQWhCLEVBQTJDLEtBQUt2RCxDQUFoRCxFQUFtRCxPQUFPNkQsS0FBMUQsR0FBUDtBQUNELE9BTkE7QUFMSCxLQURGO0FBZUQ7O0FBR0RGLGtCQUFnQkssQ0FBaEIsRUFBbUI7QUFDakIsVUFBTUMsT0FBT0MsU0FBU0MsYUFBVCxDQUF1QixLQUF2QixDQUFiO0FBQ0EsdUJBQVNwQyxNQUFULENBQWdCLDhCQUFDLGFBQUQsSUFBZSxRQUFRLEtBQUtDLEtBQUwsQ0FBVzNCLE1BQWxDLEdBQWhCLEVBQThENEQsSUFBOUQ7QUFDQSxTQUFLRyxpQkFBTCxHQUF5QkMsS0FBS0MsUUFBTCxDQUFjQyxHQUFkLENBQWtCLEtBQUtiLE9BQXZCLEVBQWdDO0FBQ3ZEYyxZQUFNUCxJQURpRDtBQUV2RFEsaUJBQVcsYUFGNEM7QUFHdkRDLGVBQVM7QUFIOEMsS0FBaEMsQ0FBekI7QUFLRDs7QUFFREMsaUJBQWU7QUFDYixTQUFLUCxpQkFBTCxJQUEwQixLQUFLQSxpQkFBTCxDQUF1QlEsT0FBdkIsRUFBMUI7QUFDQSxTQUFLUixpQkFBTCxHQUF5QixJQUF6QjtBQUNEOztBQUdEUixpQkFBZUksQ0FBZixFQUFrQjtBQUNoQixTQUFLVyxZQUFMO0FBQ0Q7O0FBRURFLHlCQUF1QjtBQUNyQixTQUFLRixZQUFMO0FBQ0Q7QUFyRHNDLEMsVUFDaENqQyxTLEdBQVk7QUFDakJyQyxVQUFRLG9CQUFVc0MsVUFBVixDQUFxQnpDLE1BQXJCLEVBQTZCMEM7QUFEcEIsQztJQXdEZmtDLFMsa0NBQU4sTUFBTUEsU0FBTixTQUF3QixnQkFBTWhELFNBQTlCLENBQXdDOztBQU10Q3JCLGNBQVl1QixLQUFaLEVBQW1CK0MsT0FBbkIsRUFBNEI7QUFDMUIsVUFBTS9DLEtBQU4sRUFBYStDLE9BQWI7QUFDQSxTQUFLQyxLQUFMLEdBQWEsS0FBS0MsWUFBTCxDQUFrQmpELEtBQWxCLENBQWI7QUFDRDs7QUFFRGtELDRCQUEwQkMsU0FBMUIsRUFBcUM7QUFDbkMsU0FBS0MsUUFBTCxDQUFjLEtBQUtILFlBQUwsQ0FBa0JFLFNBQWxCLENBQWQ7QUFDRDs7QUFFREYsZUFBYWpELEtBQWIsRUFBb0I7QUFBQSxVQUNYeEIsT0FEVyxHQUNBd0IsS0FEQSxDQUNYeEIsT0FEVzs7QUFFbEIsVUFBTTZFLGNBQWM3RSxRQUFRLENBQVIsQ0FBcEI7QUFDQSxVQUFNOEUsYUFBYTlFLFFBQVFBLFFBQVFJLE1BQVIsR0FBaUIsQ0FBekIsQ0FBbkI7O0FBRUEsVUFBTTJFLFlBQVlGLFlBQVkxRSxRQUFaLEVBQWxCO0FBQ0EsVUFBTTZFLFVBQVVGLFdBQVd4RSxNQUFYLEVBQWhCO0FBQ0EsVUFBTTJFLGdCQUFnQkQsVUFBVUQsU0FBaEM7QUFDQSxRQUFJRyx1QkFBdUIsSUFBM0I7QUFDQSxRQUFJMUQsTUFBTTJELFVBQU4sSUFBb0IsSUFBeEIsRUFBOEI7QUFDNUJELDZCQUF1QixJQUF2QjtBQUNELEtBRkQsTUFFTyxJQUFJMUQsTUFBTTJELFVBQU4sSUFBb0IsR0FBeEIsRUFBNkI7QUFDbENELDZCQUF1QixHQUF2QjtBQUNELEtBRk0sTUFFQSxJQUFJMUQsTUFBTTJELFVBQU4sSUFBb0IsR0FBeEIsRUFBNkI7QUFDbENELDZCQUF1QixHQUF2QjtBQUNELEtBRk0sTUFFQTtBQUNMQSw2QkFBdUIsR0FBdkI7QUFDRDtBQUNELFVBQU1FLGdCQUFnQmhHLFNBQVM4RixvQkFBVCxFQUErQmxELEtBQUtxRCxJQUFMLENBQVVKLGdCQUFnQkMsb0JBQTFCLENBQS9CLENBQXRCOztBQUVBLFdBQU8sRUFBQ0wsV0FBRCxFQUFjQyxVQUFkLEVBQTBCQyxTQUExQixFQUFxQ0MsT0FBckMsRUFBOENDLGFBQTlDLEVBQTZERyxhQUE3RCxFQUFQO0FBQ0Q7O0FBRUQ3RCxXQUFTO0FBQ1AsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLG9CQUFmO0FBQ0U7QUFBQTtBQUFBLFVBQUssV0FBVSxxQkFBZjtBQUNHLGFBQUsrRCxpQkFBTCxFQURIO0FBRUcsYUFBS0MsY0FBTCxFQUZIO0FBR0csYUFBSy9ELEtBQUwsQ0FBV3hCLE9BQVgsQ0FBbUJjLEdBQW5CLENBQXVCLEtBQUswRSxZQUE1QjtBQUhIO0FBREYsS0FERjtBQVNEOztBQUVERCxtQkFBaUI7QUFDZixXQUNFO0FBQUE7QUFBQSxRQUFLLFdBQVUsb0JBQWY7QUFBQTtBQUVHLFdBQUtmLEtBQUwsQ0FBV1ksYUFBWCxDQUF5QnRFLEdBQXpCLENBQTZCMkUsUUFBUTtBQUNwQyxjQUFNQyxVQUFVRCxPQUFPLEtBQUtqRSxLQUFMLENBQVcyRCxVQUFsQztBQUNBLGNBQU05QixRQUFRO0FBQ1pzQyxnQkFBTUQ7QUFETSxTQUFkO0FBR0EsZUFBTztBQUFBO0FBQUEsWUFBTSxXQUFVLDBCQUFoQixFQUEyQyxPQUFPckMsS0FBbEQsRUFBeUQsS0FBTSxNQUFLb0MsSUFBSyxFQUF6RTtBQUE2RUEsY0FBN0U7QUFBQTtBQUFBLFNBQVA7QUFDRCxPQU5BO0FBRkgsS0FERjtBQVlEOztBQUVESCxzQkFBb0I7QUFDbEIsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLHdCQUFmO0FBQ0csV0FBS2QsS0FBTCxDQUFXWSxhQUFYLENBQXlCdEUsR0FBekIsQ0FBNkIyRSxRQUFRO0FBQ3BDLGNBQU1DLFVBQVVELE9BQU8sS0FBS2pFLEtBQUwsQ0FBVzJELFVBQWxDO0FBQ0EsY0FBTTlCLFFBQVE7QUFDWnNDLGdCQUFNRDtBQURNLFNBQWQ7QUFHQSxlQUFPLHdDQUFNLFdBQVUsdUJBQWhCLEVBQXdDLE9BQU9yQyxLQUEvQyxFQUFzRCxLQUFNLE1BQUtvQyxJQUFLLEVBQXRFLEdBQVA7QUFDRCxPQU5BO0FBREgsS0FERjtBQVdEOztBQUdERCxlQUFhM0YsTUFBYixFQUFxQkwsQ0FBckIsRUFBd0I7QUFDdEIsUUFBSUssT0FBT00sUUFBUCxPQUFzQixJQUF0QixJQUE4Qk4sT0FBT1MsTUFBUCxPQUFvQixJQUF0RCxFQUE0RDtBQUFFLGFBQU8sdUNBQUssS0FBS2QsQ0FBVixHQUFQO0FBQXlCOztBQUV2RixVQUFNb0csY0FBYy9GLE9BQU9NLFFBQVAsS0FBb0IsS0FBS3FFLEtBQUwsQ0FBV08sU0FBbkQ7QUFDQSxVQUFNaEQsV0FBV2xDLE9BQU9TLE1BQVAsS0FBa0JULE9BQU9NLFFBQVAsRUFBbkM7QUFDQSxVQUFNMEYsY0FBYztBQUNsQkYsWUFBTUMsY0FBYyxLQUFLcEUsS0FBTCxDQUFXMkQsVUFEYjtBQUVsQjdCLGFBQU92QixXQUFXLEtBQUtQLEtBQUwsQ0FBVzJEO0FBRlgsS0FBcEI7O0FBS0EsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLGVBQWYsRUFBK0IsS0FBSzNGLENBQXBDO0FBQ0U7QUFBQTtBQUFBO0FBQ0UscUJBQVUscUJBRFo7QUFFRSxpQkFBTyxFQUFDcUMsYUFBYWdFLFlBQVlGLElBQVosR0FBbUJFLFlBQVl2QyxLQUE3QyxFQUZUO0FBRStEekQsZUFBT0M7QUFGdEUsT0FERjtBQUlFLG9DQUFDLFVBQUQsSUFBWSxXQUFVLGtCQUF0QixFQUF5QyxPQUFPK0YsV0FBaEQsRUFBNkQsUUFBUWhHLE1BQXJFO0FBSkYsS0FERjtBQVFEO0FBbEdxQyxDLFVBQy9CcUMsUyxHQUFZO0FBQ2pCbEMsV0FBUyxvQkFBVThGLE9BQVYsQ0FBa0Isb0JBQVUzRCxVQUFWLENBQXFCekMsTUFBckIsQ0FBbEIsRUFBZ0QwQyxVQUR4QztBQUVqQitDLGNBQVksb0JBQVVZLE1BQVYsQ0FBaUIzRDtBQUZaLEM7SUFxR2Y0RCxlLGtDQUFOLE1BQU1BLGVBQU4sU0FBOEIsZ0JBQU0xRSxTQUFwQyxDQUE4Qzs7QUFLNUNyQixjQUFZdUIsS0FBWixFQUFtQitDLE9BQW5CLEVBQTRCO0FBQzFCLFVBQU0vQyxLQUFOLEVBQWErQyxPQUFiO0FBQ0EsU0FBS0MsS0FBTCxHQUFhO0FBQ1hXLGtCQUFZLEdBREQ7QUFFWGMsaUJBQVc7QUFGQSxLQUFiO0FBSUQ7O0FBR0QxRSxXQUFTO0FBQUEsVUFDQXZCLE9BREEsR0FDVyxLQUFLd0IsS0FEaEIsQ0FDQXhCLE9BREE7O0FBRVAsVUFBTTZFLGNBQWM3RSxRQUFRLENBQVIsQ0FBcEI7QUFDQSxVQUFNOEUsYUFBYTlFLFFBQVFBLFFBQVFJLE1BQVIsR0FBaUIsQ0FBekIsQ0FBbkI7O0FBRUEsVUFBTTJFLFlBQVlGLFlBQVkxRSxRQUFaLEVBQWxCO0FBQ0EsVUFBTTZFLFVBQVVGLFdBQVd4RSxNQUFYLEVBQWhCO0FBQ0EsVUFBTXlCLFdBQVdpRCxVQUFVRCxTQUEzQjs7QUFFQSxXQUNFO0FBQUE7QUFBQSxRQUFLLFdBQVUsK0JBQWY7QUFDRTtBQUFBO0FBQUEsVUFBSyxXQUFVLGtCQUFmO0FBQ0U7QUFBQTtBQUFBLFlBQUssV0FBVSx1QkFBZjtBQUNFO0FBQUE7QUFBQSxjQUFNLFNBQVMsS0FBS21CLG1CQUFwQixFQUF5QyxXQUFVLGlCQUFuRDtBQUNHLGlCQUFLMUIsS0FBTCxDQUFXeUIsU0FBWCxHQUF1QixRQUF2QixHQUFrQztBQURyQyxXQURGO0FBSUcsZUFBS3pFLEtBQUwsQ0FBV3hCLE9BQVgsQ0FBbUJJLE1BSnRCO0FBQUE7QUFJNkM0QixlQUFLQyxLQUFMLENBQVdGLFFBQVgsQ0FKN0M7QUFBQTtBQUFBLFNBREY7QUFPRTtBQUFBO0FBQUEsWUFBSyxXQUFVLDJCQUFmO0FBQ0U7QUFBQTtBQUFBO0FBQ0UseUJBQVUsb0NBRFo7QUFFRSx1QkFBUyxLQUFLb0UsaUJBRmhCO0FBQUE7QUFBQSxXQURGO0FBSUUsNkRBQVMsTUFBSyxRQUFkLEdBSkY7QUFLRTtBQUNFLGtCQUFLLE9BRFA7QUFFRSx1QkFBVSxhQUZaO0FBR0UsaUJBQUssR0FIUDtBQUlFLGlCQUFLLENBSlA7QUFLRSxrQkFBTSxJQUxSO0FBTUUsbUJBQU8sS0FBSzNCLEtBQUwsQ0FBV1csVUFOcEI7QUFPRSxzQkFBVSxLQUFLaUI7QUFQakI7QUFMRjtBQVBGLE9BREY7QUF3QkcsV0FBSzVCLEtBQUwsQ0FBV3lCLFNBQVgsR0FBdUIsSUFBdkIsR0FBOEIsOEJBQUMsU0FBRCxJQUFXLFNBQVMsS0FBS3pFLEtBQUwsQ0FBV3hCLE9BQS9CLEVBQXdDLFlBQVksS0FBS3dFLEtBQUwsQ0FBV1csVUFBL0Q7QUF4QmpDLEtBREY7QUE0QkQ7O0FBR0RpQix5QkFBdUI1QyxDQUF2QixFQUEwQjtBQUN4QixTQUFLb0IsUUFBTCxDQUFjLEVBQUNPLFlBQVlrQixXQUFXN0MsRUFBRThDLE1BQUYsQ0FBU0MsS0FBcEIsQ0FBYixFQUFkO0FBQ0Q7O0FBR0RMLHNCQUFvQjFDLENBQXBCLEVBQXVCO0FBQ3JCLFNBQUtvQixRQUFMLENBQWM0QixNQUFNLEVBQUNQLFdBQVcsQ0FBQ08sRUFBRVAsU0FBZixFQUFOLENBQWQ7QUFDRDs7QUFHREUsb0JBQWtCM0MsQ0FBbEIsRUFBcUI7QUFDbkJBLE1BQUVpRCxjQUFGO0FBQ0EsVUFBTUMsT0FBT0MsS0FBS0MsU0FBTCxDQUFlLEtBQUtwRixLQUFMLENBQVd4QixPQUFYLENBQW1CYyxHQUFuQixDQUF1QitGLEtBQUtBLEVBQUUxRixTQUFGLEVBQTVCLENBQWYsRUFBMkQsSUFBM0QsRUFBaUUsSUFBakUsQ0FBYjtBQUNBLFVBQU0yRixTQUFTLHFCQUFlLEVBQUNDLE1BQU1MLElBQVAsRUFBZixDQUFmO0FBQ0F2SCxXQUFPNkgsY0FBUCxDQUFzQjtBQUNwQkMsbUJBQWE7QUFETyxLQUF0QixFQUVHQyxZQUFZO0FBQ2IsVUFBSSxDQUFDQSxRQUFMLEVBQWU7QUFBRTtBQUFTO0FBQzFCSixhQUFPSyxNQUFQLENBQWNELFFBQWQ7QUFDRCxLQUxEO0FBTUQ7QUExRTJDLEMsVUFDckNoRixTLEdBQVk7QUFDakJsQyxXQUFTLG9CQUFVOEYsT0FBVixDQUFrQixvQkFBVTNELFVBQVYsQ0FBcUJ6QyxNQUFyQixDQUFsQixFQUFnRDBDO0FBRHhDLEM7OztBQTZFckIsSUFBSXBDLFVBQVUsSUFBZDtBQUNBLElBQUlvSCxVQUFVLENBQWQ7QUFDQSxNQUFNQyxTQUFTLEVBQWY7QUFDQSxJQUFJQyxpQkFBaUIsSUFBckI7QUFDQSxJQUFJQyxjQUFjLElBQWxCOztJQUVxQkMsYyxrQ0FBTixNQUFNQSxjQUFOLFNBQTZCLGdCQUFNbEcsU0FBbkMsQ0FBNkM7O0FBTzFELFNBQU9tRyxjQUFQLEdBQXdCO0FBQ3RCLFFBQUl2RSxPQUFKO0FBQ0EsV0FBTztBQUNML0Isa0JBQVk7QUFBRSxlQUFPLEVBQUN1RyxjQUFjLGdCQUFmLEVBQVA7QUFBMEMsT0FEbkQ7QUFFTEMsZUFBUztBQUFFLGVBQU8sNkJBQVA7QUFBdUMsT0FGN0M7QUFHTEMsaUJBQVc7QUFBRSxlQUFPLDZCQUFQO0FBQXVDLE9BSC9DO0FBSUwsVUFBSTFFLE9BQUosR0FBYztBQUNaLFlBQUksQ0FBQ0EsT0FBTCxFQUFjO0FBQ1pBLG9CQUFVUSxTQUFTQyxhQUFULENBQXVCLEtBQXZCLENBQVY7QUFDQSw2QkFBU3BDLE1BQVQsQ0FBZ0IsOEJBQUMsY0FBRCxJQUFnQixXQUFXMkIsT0FBM0IsR0FBaEIsRUFBd0RBLE9BQXhEO0FBQ0Q7QUFDRCxlQUFPQSxPQUFQO0FBQ0Q7QUFWSSxLQUFQO0FBWUQ7O0FBRUQsU0FBT3ZELFdBQVAsR0FBcUI7QUFDbkIsV0FBTyxLQUFLOEgsY0FBTCxFQUFQO0FBQ0Q7O0FBRUQsU0FBT0ksY0FBUCxDQUFzQi9ILEtBQXRCLEVBQTZCO0FBQzNCLFVBQU1ELFNBQVMsSUFBSUgsTUFBSixDQUFXSSxLQUFYLEVBQWtCLE1BQU07QUFDckMwSCxxQkFBZU0sY0FBZjtBQUNELEtBRmMsQ0FBZjtBQUdBLFVBQU1uSCxNQUFNRCxZQUFZQyxHQUFaLEVBQVo7QUFDQSxRQUFJLENBQUNYLE9BQUQsSUFBYXNILGtCQUFrQnRGLEtBQUsrRixHQUFMLENBQVNwSCxNQUFNMkcsY0FBZixLQUFrQyxJQUFyRSxFQUE0RTtBQUMxRUY7QUFDQXBILGdCQUFVLEVBQVY7QUFDQXFILGFBQU9XLE9BQVAsQ0FBZSxFQUFDQyxJQUFJYixPQUFMLEVBQWNwSCxPQUFkLEVBQWY7QUFDQSxVQUFJcUgsT0FBT2pILE1BQVAsR0FBZ0IsR0FBcEIsRUFBeUI7QUFDdkJpSCxlQUFPYSxHQUFQO0FBQ0Q7QUFDRjtBQUNEWixxQkFBaUIzRyxHQUFqQjtBQUNBWCxZQUFRUCxJQUFSLENBQWFJLE1BQWI7QUFDQTJILG1CQUFlTSxjQUFmO0FBQ0EsV0FBT2pJLE1BQVA7QUFDRDs7QUFFRCxTQUFPc0ksWUFBUCxDQUFvQkMsS0FBcEIsRUFBMkI7QUFDekJoQjtBQUNBQyxXQUFPVyxPQUFQLENBQWUsRUFBQ0MsSUFBSWIsT0FBTCxFQUFjcEgsU0FBU29JLEtBQXZCLEVBQWY7QUFDQVosbUJBQWVNLGNBQWYsQ0FBOEIsSUFBOUI7QUFDRDs7QUFFRCxTQUFPQSxjQUFQLEdBQXlDO0FBQUEsUUFBbkJPLFNBQW1CLHVFQUFQLEtBQU87O0FBQ3ZDLFFBQUlkLFdBQUosRUFBaUI7QUFDZmUsbUJBQWFmLFdBQWI7QUFDRDs7QUFFREEsa0JBQWNnQixXQUFXLE1BQU07QUFDN0JmLHFCQUFlZ0IsT0FBZixDQUF1QkMsSUFBdkIsQ0FBNEIsWUFBNUI7QUFDRCxLQUZhLEVBRVhKLFlBQVksQ0FBWixHQUFnQixJQUZMLENBQWQ7QUFHRDs7QUFFRCxTQUFPSyxXQUFQLENBQW1CQyxRQUFuQixFQUE2QjtBQUMzQixXQUFPbkIsZUFBZWdCLE9BQWYsQ0FBdUJJLEVBQXZCLENBQTBCLFlBQTFCLEVBQXdDRCxRQUF4QyxDQUFQO0FBQ0Q7O0FBRURFLHNCQUFvQjtBQUNsQixTQUFLQyxhQUFMLEdBQXFCLGtDQUNuQnRCLGVBQWVrQixXQUFmLENBQTJCLE1BQU0sS0FBS0ssV0FBTCxFQUFqQyxDQURtQixFQUVuQmxGLEtBQUttRixTQUFMLENBQWVDLG9CQUFmLENBQW9DLFdBQVk7QUFBQSxVQUFWakYsSUFBVSxTQUFWQSxJQUFVOztBQUM5QyxVQUFJQSxLQUFLZCxPQUFMLEtBQWlCLEtBQUsxQixLQUFMLENBQVcwSCxTQUFoQyxFQUEyQztBQUN6QztBQUNBLDJCQUFTQyxzQkFBVCxDQUFnQyxLQUFLM0gsS0FBTCxDQUFXMEgsU0FBM0M7QUFDRDtBQUNGLEtBTEQsQ0FGbUIsQ0FBckI7QUFTRDs7QUFFRDdFLHlCQUF1QjtBQUNyQixTQUFLeUUsYUFBTCxDQUFtQjFFLE9BQW5CO0FBQ0Q7O0FBRUQ3QyxXQUFTO0FBQ1AsV0FDRTtBQUFBO0FBQUEsUUFBSyxXQUFVLHVCQUFmO0FBQ0U7QUFBQTtBQUFBLFVBQUssV0FBVSw4QkFBZjtBQUNFO0FBQUE7QUFBQSxZQUFRLFdBQVUsbUJBQWxCLEVBQXNDLFNBQVMsS0FBSzZILGlCQUFwRDtBQUFBO0FBQUE7QUFERixPQURGO0FBSUcvQixhQUFPdkcsR0FBUCxDQUFXLENBQUNzSCxLQUFELEVBQVFwSCxHQUFSLEtBQ1YsOEJBQUMsZUFBRCxJQUFpQixLQUFLb0gsTUFBTUgsRUFBNUIsRUFBZ0MsU0FBU0csTUFBTXBJLE9BQS9DLEdBREQ7QUFKSCxLQURGO0FBVUQ7O0FBR0RvSixvQkFBa0I1RixDQUFsQixFQUFxQjtBQUNuQkEsTUFBRWlELGNBQUY7QUFDQXRILFdBQU9rSyxjQUFQLENBQXNCO0FBQ3BCQyxrQkFBWSxDQUFDLFVBQUQ7QUFEUSxLQUF0QjtBQUFBLG9DQUVHLFdBQU1DLFNBQU4sRUFBbUI7QUFDcEIsWUFBSSxDQUFDQSxTQUFMLEVBQWdCO0FBQUU7QUFBUztBQUMzQixjQUFNckMsV0FBV3FDLFVBQVUsQ0FBVixDQUFqQjtBQUNBLFlBQUk7QUFDRixnQkFBTUMsV0FBVyxNQUFNLHVCQUFTdEMsUUFBVCxDQUF2QjtBQUNBLGdCQUFNdEgsT0FBTytHLEtBQUs4QyxLQUFMLENBQVdELFFBQVgsQ0FBYjtBQUNBLGdCQUFNRSxrQkFBa0I5SixLQUFLa0IsR0FBTCxDQUFTO0FBQUEsbUJBQVFwQixPQUFPQyxXQUFQLENBQW1CcUUsSUFBbkIsQ0FBUjtBQUFBLFdBQVQsQ0FBeEI7QUFDQXdELHlCQUFlVyxZQUFmLENBQTRCdUIsZUFBNUI7QUFDRCxTQUxELENBS0UsT0FBT0MsSUFBUCxFQUFhO0FBQ2I5RixlQUFLK0YsYUFBTCxDQUFtQkMsUUFBbkIsQ0FBNkIsaUNBQWdDM0MsUUFBUyxFQUF0RTtBQUNEO0FBQ0YsT0FiRDs7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQWNEO0FBaEh5RCxDLFVBQ25EaEYsUyxHQUFZO0FBQ2pCZ0gsYUFBVyxvQkFBVVksR0FBVixDQUFjMUg7QUFEUixDLFVBSVpvRyxPLEdBQVUsdUI7a0JBTEVoQixjIiwiZmlsZSI6ImdpdC10aW1pbmdzLXZpZXcuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7VGV4dEJ1ZmZlcn0gZnJvbSAnYXRvbSc7XG5pbXBvcnQge0VtaXR0ZXIsIENvbXBvc2l0ZURpc3Bvc2FibGV9IGZyb20gJ2V2ZW50LWtpdCc7XG5pbXBvcnQge3JlbW90ZX0gZnJvbSAnZWxlY3Ryb24nO1xuY29uc3Qge2RpYWxvZ30gPSByZW1vdGU7XG5cbmltcG9ydCBSZWFjdCBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUmVhY3REb20gZnJvbSAncmVhY3QtZG9tJztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICdjb3JlLWRlY29yYXRvcnMnO1xuaW1wb3J0IG1lbW9pemUgZnJvbSAnbG9kYXNoLm1lbW9pemUnO1xuXG5pbXBvcnQge3JlYWRGaWxlfSBmcm9tICcuLi9oZWxwZXJzJztcbmltcG9ydCBPY3RpY29uIGZyb20gJy4vb2N0aWNvbic7XG5cbmNvbnN0IGdlbkFycmF5ID0gbWVtb2l6ZShmdW5jdGlvbiBnZW5BcnJheShpbnRlcnZhbCwgY291bnQpIHtcbiAgY29uc3QgYXJyID0gW107XG4gIGZvciAobGV0IGkgPSAxOyBpIDw9IGNvdW50OyBpKyspIHtcbiAgICBhcnIucHVzaChpbnRlcnZhbCAqIGkpO1xuICB9XG4gIHJldHVybiBhcnI7XG59LCAoaW50ZXJ2YWwsIGNvdW50KSA9PiBgJHtpbnRlcnZhbH06JHtjb3VudH1gKTtcblxuY2xhc3MgTWFya2VyIHtcbiAgc3RhdGljIGRlc2VyaWFsaXplKGRhdGEpIHtcbiAgICBjb25zdCBtYXJrZXIgPSBuZXcgTWFya2VyKGRhdGEubGFiZWwsICgpID0+IHt9KTtcbiAgICBtYXJrZXIuZW5kID0gZGF0YS5lbmQ7XG4gICAgbWFya2VyLm1hcmtlcnMgPSBkYXRhLm1hcmtlcnM7XG4gICAgcmV0dXJuIG1hcmtlcjtcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKGxhYmVsLCBkaWRVcGRhdGUpIHtcbiAgICB0aGlzLmxhYmVsID0gbGFiZWw7XG4gICAgdGhpcy5kaWRVcGRhdGUgPSBkaWRVcGRhdGU7XG4gICAgdGhpcy5lbmQgPSBudWxsO1xuICAgIHRoaXMubWFya2VycyA9IFtdO1xuICB9XG5cbiAgZ2V0U3RhcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWFya2Vycy5sZW5ndGggPyB0aGlzLm1hcmtlcnNbMF0uc3RhcnQgOiBudWxsO1xuICB9XG5cbiAgZ2V0RW5kKCkge1xuICAgIHJldHVybiB0aGlzLmVuZDtcbiAgfVxuXG4gIG1hcmsoc2VjdGlvbk5hbWUsIHN0YXJ0KSB7XG4gICAgdGhpcy5tYXJrZXJzLnB1c2goe25hbWU6IHNlY3Rpb25OYW1lLCBzdGFydDogc3RhcnQgfHwgcGVyZm9ybWFuY2Uubm93KCl9KTtcbiAgfVxuXG4gIGZpbmFsaXplKCkge1xuICAgIHRoaXMuZW5kID0gcGVyZm9ybWFuY2Uubm93KCk7XG4gICAgdGhpcy5kaWRVcGRhdGUoKTtcbiAgfVxuXG4gIGdldFRpbWluZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMubWFya2Vycy5tYXAoKHRpbWluZywgaWR4LCBhcnkpID0+IHtcbiAgICAgIGNvbnN0IG5leHQgPSBhcnlbaWR4ICsgMV07XG4gICAgICBjb25zdCBlbmQgPSBuZXh0ID8gbmV4dC5zdGFydCA6IHRoaXMuZ2V0RW5kKCk7XG4gICAgICByZXR1cm4gey4uLnRpbWluZywgZW5kfTtcbiAgICB9KTtcbiAgfVxuXG4gIHNlcmlhbGl6ZSgpIHtcbiAgICByZXR1cm4ge1xuICAgICAgbGFiZWw6IHRoaXMubGFiZWwsXG4gICAgICBlbmQ6IHRoaXMuZW5kLFxuICAgICAgbWFya2VyczogdGhpcy5tYXJrZXJzLnNsaWNlKCksXG4gICAgfTtcbiAgfVxufVxuXG5cbmNsYXNzIE1hcmtlclRvb2x0aXAgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIG1hcmtlcjogUHJvcFR5cGVzLmluc3RhbmNlT2YoTWFya2VyKS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHttYXJrZXJ9ID0gdGhpcy5wcm9wcztcbiAgICBjb25zdCB0aW1pbmdzID0gbWFya2VyLmdldFRpbWluZ3MoKTtcblxuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IHN0eWxlPXt7dGV4dEFsaWduOiAnbGVmdCcsIG1heFdpZHRoOiAzMDAsIHdoaXRlU3BhY2U6ICdpbml0aWFsJ319PlxuICAgICAgICA8c3Ryb25nPjx0dD57bWFya2VyLmxhYmVsfTwvdHQ+PC9zdHJvbmc+XG4gICAgICAgIDx1bCBzdHlsZT17e3BhZGRpbmdMZWZ0OiAyMCwgbWFyZ2luVG9wOiAxMH19PlxuICAgICAgICAgIHt0aW1pbmdzLm1hcCgoe25hbWUsIHN0YXJ0LCBlbmR9KSA9PiB7XG4gICAgICAgICAgICBjb25zdCBkdXJhdGlvbiA9IGVuZCAtIHN0YXJ0O1xuICAgICAgICAgICAgcmV0dXJuIDxsaSBrZXk9e25hbWV9PntuYW1lfToge01hdGguZmxvb3IoZHVyYXRpb24gKiAxMDApIC8gMTAwfW1zPC9saT47XG4gICAgICAgICAgfSl9XG4gICAgICAgIDwvdWw+XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG59XG5cbmNvbnN0IENPTE9SUyA9IHtcbiAgcXVldWVkOiAncmVkJyxcbiAgcHJlcGFyZTogJ2N5YW4nLFxuICBuZXh0dGljazogJ3llbGxvdycsXG4gIGV4ZWN1dGU6ICdncmVlbicsXG4gIGlwYzogJ3BpbmsnLFxufTtcbmNsYXNzIE1hcmtlclNwYW4gZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIG1hcmtlcjogUHJvcFR5cGVzLmluc3RhbmNlT2YoTWFya2VyKS5pc1JlcXVpcmVkLFxuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIGNvbnN0IHttYXJrZXIsIC4uLm90aGVyc30gPSB0aGlzLnByb3BzO1xuICAgIGNvbnN0IHRpbWluZ3MgPSBtYXJrZXIuZ2V0VGltaW5ncygpO1xuICAgIGNvbnN0IHRvdGFsVGltZSA9IG1hcmtlci5nZXRFbmQoKSAtIG1hcmtlci5nZXRTdGFydCgpO1xuICAgIGNvbnN0IHBlcmNlbnRhZ2VzID0gdGltaW5ncy5tYXAoKHtuYW1lLCBzdGFydCwgZW5kfSkgPT4ge1xuICAgICAgY29uc3QgZHVyYXRpb24gPSBlbmQgLSBzdGFydDtcbiAgICAgIHJldHVybiB7Y29sb3I6IENPTE9SU1tuYW1lXSwgcGVyY2VudDogZHVyYXRpb24gLyB0b3RhbFRpbWUgKiAxMDB9O1xuICAgIH0pO1xuICAgIHJldHVybiAoXG4gICAgICA8c3BhblxuICAgICAgICB7Li4ub3RoZXJzfVxuICAgICAgICByZWY9e2MgPT4geyB0aGlzLmVsZW1lbnQgPSBjOyB9fVxuICAgICAgICBvbk1vdXNlT3Zlcj17dGhpcy5oYW5kbGVNb3VzZU92ZXJ9XG4gICAgICAgIG9uTW91c2VPdXQ9e3RoaXMuaGFuZGxlTW91c2VPdXR9PlxuICAgICAgICB7cGVyY2VudGFnZXMubWFwKCh7Y29sb3IsIHBlcmNlbnR9LCBpKSA9PiB7XG4gICAgICAgICAgY29uc3Qgc3R5bGUgPSB7XG4gICAgICAgICAgICB3aWR0aDogYCR7cGVyY2VudH0lYCxcbiAgICAgICAgICAgIGJhY2tncm91bmQ6IGNvbG9yLFxuICAgICAgICAgIH07XG4gICAgICAgICAgcmV0dXJuIDxzcGFuIGNsYXNzTmFtZT1cIndhdGVyZmFsbC1tYXJrZXItc2VjdGlvblwiIGtleT17aX0gc3R5bGU9e3N0eWxlfSAvPjtcbiAgICAgICAgfSl9XG4gICAgICA8L3NwYW4+XG4gICAgKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVNb3VzZU92ZXIoZSkge1xuICAgIGNvbnN0IGVsZW0gPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcbiAgICBSZWFjdERvbS5yZW5kZXIoPE1hcmtlclRvb2x0aXAgbWFya2VyPXt0aGlzLnByb3BzLm1hcmtlcn0gLz4sIGVsZW0pO1xuICAgIHRoaXMudG9vbHRpcERpc3Bvc2FibGUgPSBhdG9tLnRvb2x0aXBzLmFkZCh0aGlzLmVsZW1lbnQsIHtcbiAgICAgIGl0ZW06IGVsZW0sXG4gICAgICBwbGFjZW1lbnQ6ICdhdXRvIGJvdHRvbScsXG4gICAgICB0cmlnZ2VyOiAnbWFudWFsJyxcbiAgICB9KTtcbiAgfVxuXG4gIGNsb3NlVG9vbHRpcCgpIHtcbiAgICB0aGlzLnRvb2x0aXBEaXNwb3NhYmxlICYmIHRoaXMudG9vbHRpcERpc3Bvc2FibGUuZGlzcG9zZSgpO1xuICAgIHRoaXMudG9vbHRpcERpc3Bvc2FibGUgPSBudWxsO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhbmRsZU1vdXNlT3V0KGUpIHtcbiAgICB0aGlzLmNsb3NlVG9vbHRpcCgpO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5jbG9zZVRvb2x0aXAoKTtcbiAgfVxufVxuXG5cbmNsYXNzIFdhdGVyZmFsbCBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgbWFya2VyczogUHJvcFR5cGVzLmFycmF5T2YoUHJvcFR5cGVzLmluc3RhbmNlT2YoTWFya2VyKSkuaXNSZXF1aXJlZCxcbiAgICB6b29tRmFjdG9yOiBQcm9wVHlwZXMubnVtYmVyLmlzUmVxdWlyZWQsXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcywgY29udGV4dCkge1xuICAgIHN1cGVyKHByb3BzLCBjb250ZXh0KTtcbiAgICB0aGlzLnN0YXRlID0gdGhpcy5nZXROZXh0U3RhdGUocHJvcHMpO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFJlY2VpdmVQcm9wcyhuZXh0UHJvcHMpIHtcbiAgICB0aGlzLnNldFN0YXRlKHRoaXMuZ2V0TmV4dFN0YXRlKG5leHRQcm9wcykpO1xuICB9XG5cbiAgZ2V0TmV4dFN0YXRlKHByb3BzKSB7XG4gICAgY29uc3Qge21hcmtlcnN9ID0gcHJvcHM7XG4gICAgY29uc3QgZmlyc3RNYXJrZXIgPSBtYXJrZXJzWzBdO1xuICAgIGNvbnN0IGxhc3RNYXJrZXIgPSBtYXJrZXJzW21hcmtlcnMubGVuZ3RoIC0gMV07XG5cbiAgICBjb25zdCBzdGFydFRpbWUgPSBmaXJzdE1hcmtlci5nZXRTdGFydCgpO1xuICAgIGNvbnN0IGVuZFRpbWUgPSBsYXN0TWFya2VyLmdldEVuZCgpO1xuICAgIGNvbnN0IHRvdGFsRHVyYXRpb24gPSBlbmRUaW1lIC0gc3RhcnRUaW1lO1xuICAgIGxldCB0aW1lbGluZU1hcmtJbnRlcnZhbCA9IG51bGw7XG4gICAgaWYgKHByb3BzLnpvb21GYWN0b3IgPD0gMC4xNSkge1xuICAgICAgdGltZWxpbmVNYXJrSW50ZXJ2YWwgPSAxMDAwO1xuICAgIH0gZWxzZSBpZiAocHJvcHMuem9vbUZhY3RvciA8PSAwLjMpIHtcbiAgICAgIHRpbWVsaW5lTWFya0ludGVydmFsID0gNTAwO1xuICAgIH0gZWxzZSBpZiAocHJvcHMuem9vbUZhY3RvciA8PSAwLjYpIHtcbiAgICAgIHRpbWVsaW5lTWFya0ludGVydmFsID0gMjUwO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aW1lbGluZU1hcmtJbnRlcnZhbCA9IDEwMDtcbiAgICB9XG4gICAgY29uc3QgdGltZWxpbmVNYXJrcyA9IGdlbkFycmF5KHRpbWVsaW5lTWFya0ludGVydmFsLCBNYXRoLmNlaWwodG90YWxEdXJhdGlvbiAvIHRpbWVsaW5lTWFya0ludGVydmFsKSk7XG5cbiAgICByZXR1cm4ge2ZpcnN0TWFya2VyLCBsYXN0TWFya2VyLCBzdGFydFRpbWUsIGVuZFRpbWUsIHRvdGFsRHVyYXRpb24sIHRpbWVsaW5lTWFya3N9O1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cIndhdGVyZmFsbC1zY3JvbGxlclwiPlxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cIndhdGVyZmFsbC1jb250YWluZXJcIj5cbiAgICAgICAgICB7dGhpcy5yZW5kZXJUaW1lTWFya2VycygpfVxuICAgICAgICAgIHt0aGlzLnJlbmRlclRpbWVsaW5lKCl9XG4gICAgICAgICAge3RoaXMucHJvcHMubWFya2Vycy5tYXAodGhpcy5yZW5kZXJNYXJrZXIpfVxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICByZW5kZXJUaW1lbGluZSgpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtdGltZWxpbmVcIj5cbiAgICAgICAgJm5ic3A7XG4gICAgICAgIHt0aGlzLnN0YXRlLnRpbWVsaW5lTWFya3MubWFwKHRpbWUgPT4ge1xuICAgICAgICAgIGNvbnN0IGxlZnRQb3MgPSB0aW1lICogdGhpcy5wcm9wcy56b29tRmFjdG9yO1xuICAgICAgICAgIGNvbnN0IHN0eWxlID0ge1xuICAgICAgICAgICAgbGVmdDogbGVmdFBvcyxcbiAgICAgICAgICB9O1xuICAgICAgICAgIHJldHVybiA8c3BhbiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtdGltZWxpbmUtbGFiZWxcIiBzdHlsZT17c3R5bGV9IGtleT17YHRsOiR7dGltZX1gfT57dGltZX1tczwvc3Bhbj47XG4gICAgICAgIH0pfVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlclRpbWVNYXJrZXJzKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cIndhdGVyZmFsbC10aW1lLW1hcmtlcnNcIj5cbiAgICAgICAge3RoaXMuc3RhdGUudGltZWxpbmVNYXJrcy5tYXAodGltZSA9PiB7XG4gICAgICAgICAgY29uc3QgbGVmdFBvcyA9IHRpbWUgKiB0aGlzLnByb3BzLnpvb21GYWN0b3I7XG4gICAgICAgICAgY29uc3Qgc3R5bGUgPSB7XG4gICAgICAgICAgICBsZWZ0OiBsZWZ0UG9zLFxuICAgICAgICAgIH07XG4gICAgICAgICAgcmV0dXJuIDxzcGFuIGNsYXNzTmFtZT1cIndhdGVyZmFsbC10aW1lLW1hcmtlclwiIHN0eWxlPXtzdHlsZX0ga2V5PXtgdG06JHt0aW1lfWB9IC8+O1xuICAgICAgICB9KX1cbiAgICAgIDwvZGl2PlxuICAgICk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgcmVuZGVyTWFya2VyKG1hcmtlciwgaSkge1xuICAgIGlmIChtYXJrZXIuZ2V0U3RhcnQoKSA9PT0gbnVsbCB8fCBtYXJrZXIuZ2V0RW5kKCkgPT09IG51bGwpIHsgcmV0dXJuIDxkaXYga2V5PXtpfSAvPjsgfVxuXG4gICAgY29uc3Qgc3RhcnRPZmZzZXQgPSBtYXJrZXIuZ2V0U3RhcnQoKSAtIHRoaXMuc3RhdGUuc3RhcnRUaW1lO1xuICAgIGNvbnN0IGR1cmF0aW9uID0gbWFya2VyLmdldEVuZCgpIC0gbWFya2VyLmdldFN0YXJ0KCk7XG4gICAgY29uc3QgbWFya2VyU3R5bGUgPSB7XG4gICAgICBsZWZ0OiBzdGFydE9mZnNldCAqIHRoaXMucHJvcHMuem9vbUZhY3RvcixcbiAgICAgIHdpZHRoOiBkdXJhdGlvbiAqIHRoaXMucHJvcHMuem9vbUZhY3RvcixcbiAgICB9O1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxkaXYgY2xhc3NOYW1lPVwid2F0ZXJmYWxsLXJvd1wiIGtleT17aX0+XG4gICAgICAgIDxzcGFuXG4gICAgICAgICAgY2xhc3NOYW1lPVwid2F0ZXJmYWxsLXJvdy1sYWJlbFwiXG4gICAgICAgICAgc3R5bGU9e3twYWRkaW5nTGVmdDogbWFya2VyU3R5bGUubGVmdCArIG1hcmtlclN0eWxlLndpZHRofX0+e21hcmtlci5sYWJlbH08L3NwYW4+XG4gICAgICAgIDxNYXJrZXJTcGFuIGNsYXNzTmFtZT1cIndhdGVyZmFsbC1tYXJrZXJcIiBzdHlsZT17bWFya2VyU3R5bGV9IG1hcmtlcj17bWFya2VyfSAvPlxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxufVxuXG5cbmNsYXNzIFdhdGVyZmFsbFdpZGdldCBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgbWFya2VyczogUHJvcFR5cGVzLmFycmF5T2YoUHJvcFR5cGVzLmluc3RhbmNlT2YoTWFya2VyKSkuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzLCBjb250ZXh0KSB7XG4gICAgc3VwZXIocHJvcHMsIGNvbnRleHQpO1xuICAgIHRoaXMuc3RhdGUgPSB7XG4gICAgICB6b29tRmFjdG9yOiAwLjMsXG4gICAgICBjb2xsYXBzZWQ6IGZhbHNlLFxuICAgIH07XG4gIH1cblxuXG4gIHJlbmRlcigpIHtcbiAgICBjb25zdCB7bWFya2Vyc30gPSB0aGlzLnByb3BzO1xuICAgIGNvbnN0IGZpcnN0TWFya2VyID0gbWFya2Vyc1swXTtcbiAgICBjb25zdCBsYXN0TWFya2VyID0gbWFya2Vyc1ttYXJrZXJzLmxlbmd0aCAtIDFdO1xuXG4gICAgY29uc3Qgc3RhcnRUaW1lID0gZmlyc3RNYXJrZXIuZ2V0U3RhcnQoKTtcbiAgICBjb25zdCBlbmRUaW1lID0gbGFzdE1hcmtlci5nZXRFbmQoKTtcbiAgICBjb25zdCBkdXJhdGlvbiA9IGVuZFRpbWUgLSBzdGFydFRpbWU7XG5cbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtd2lkZ2V0IGluc2V0LXBhbm5lbFwiPlxuICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cIndhdGVyZmFsbC1oZWFkZXJcIj5cbiAgICAgICAgICA8ZGl2IGNsYXNzTmFtZT1cIndhdGVyZmFsbC1oZWFkZXItdGV4dFwiPlxuICAgICAgICAgICAgPHNwYW4gb25DbGljaz17dGhpcy5oYW5kbGVDb2xsYXBzZUNsaWNrfSBjbGFzc05hbWU9XCJjb2xsYXBzZS10b2dnbGVcIj5cbiAgICAgICAgICAgICAge3RoaXMuc3RhdGUuY29sbGFwc2VkID8gJ1xcdTI1YjYnIDogJ1xcdTI1YmMnfVxuICAgICAgICAgICAgPC9zcGFuPlxuICAgICAgICAgICAge3RoaXMucHJvcHMubWFya2Vycy5sZW5ndGh9IGV2ZW50KHMpIG92ZXIge01hdGguZmxvb3IoZHVyYXRpb24pfW1zXG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJ3YXRlcmZhbGwtaGVhZGVyLWNvbnRyb2xzXCI+XG4gICAgICAgICAgICA8YnV0dG9uXG4gICAgICAgICAgICAgIGNsYXNzTmFtZT1cIndhdGVyZmFsbC1leHBvcnQtYnV0dG9uIGJ0biBidG4tc21cIlxuICAgICAgICAgICAgICBvbkNsaWNrPXt0aGlzLmhhbmRsZUV4cG9ydENsaWNrfT5FeHBvcnQ8L2J1dHRvbj5cbiAgICAgICAgICAgIDxPY3RpY29uIGljb249XCJzZWFyY2hcIiAvPlxuICAgICAgICAgICAgPGlucHV0XG4gICAgICAgICAgICAgIHR5cGU9XCJyYW5nZVwiXG4gICAgICAgICAgICAgIGNsYXNzTmFtZT1cImlucHV0LXJhbmdlXCJcbiAgICAgICAgICAgICAgbWluPXswLjF9XG4gICAgICAgICAgICAgIG1heD17MX1cbiAgICAgICAgICAgICAgc3RlcD17MC4wMX1cbiAgICAgICAgICAgICAgdmFsdWU9e3RoaXMuc3RhdGUuem9vbUZhY3Rvcn1cbiAgICAgICAgICAgICAgb25DaGFuZ2U9e3RoaXMuaGFuZGxlWm9vbUZhY3RvckNoYW5nZX1cbiAgICAgICAgICAgIC8+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgICB7dGhpcy5zdGF0ZS5jb2xsYXBzZWQgPyBudWxsIDogPFdhdGVyZmFsbCBtYXJrZXJzPXt0aGlzLnByb3BzLm1hcmtlcnN9IHpvb21GYWN0b3I9e3RoaXMuc3RhdGUuem9vbUZhY3Rvcn0gLz59XG4gICAgICA8L2Rpdj5cbiAgICApO1xuICB9XG5cbiAgQGF1dG9iaW5kXG4gIGhhbmRsZVpvb21GYWN0b3JDaGFuZ2UoZSkge1xuICAgIHRoaXMuc2V0U3RhdGUoe3pvb21GYWN0b3I6IHBhcnNlRmxvYXQoZS50YXJnZXQudmFsdWUpfSk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlQ29sbGFwc2VDbGljayhlKSB7XG4gICAgdGhpcy5zZXRTdGF0ZShzID0+ICh7Y29sbGFwc2VkOiAhcy5jb2xsYXBzZWR9KSk7XG4gIH1cblxuICBAYXV0b2JpbmRcbiAgaGFuZGxlRXhwb3J0Q2xpY2soZSkge1xuICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICBjb25zdCBqc29uID0gSlNPTi5zdHJpbmdpZnkodGhpcy5wcm9wcy5tYXJrZXJzLm1hcChtID0+IG0uc2VyaWFsaXplKCkpLCBudWxsLCAnICAnKTtcbiAgICBjb25zdCBidWZmZXIgPSBuZXcgVGV4dEJ1ZmZlcih7dGV4dDoganNvbn0pO1xuICAgIGRpYWxvZy5zaG93U2F2ZURpYWxvZyh7XG4gICAgICBkZWZhdWx0UGF0aDogJ2dpdC10aW1pbmdzLmpzb24nLFxuICAgIH0sIGZpbGVuYW1lID0+IHtcbiAgICAgIGlmICghZmlsZW5hbWUpIHsgcmV0dXJuOyB9XG4gICAgICBidWZmZXIuc2F2ZUFzKGZpbGVuYW1lKTtcbiAgICB9KTtcbiAgfVxufVxuXG5cbmxldCBtYXJrZXJzID0gbnVsbDtcbmxldCBncm91cElkID0gMDtcbmNvbnN0IGdyb3VwcyA9IFtdO1xubGV0IGxhc3RNYXJrZXJUaW1lID0gbnVsbDtcbmxldCB1cGRhdGVUaW1lciA9IG51bGw7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEdpdFRpbWluZ3NWaWV3IGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICBjb250YWluZXI6IFByb3BUeXBlcy5hbnkuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHN0YXRpYyBlbWl0dGVyID0gbmV3IEVtaXR0ZXIoKTtcblxuICBzdGF0aWMgY3JlYXRlUGFuZUl0ZW0oKSB7XG4gICAgbGV0IGVsZW1lbnQ7XG4gICAgcmV0dXJuIHtcbiAgICAgIHNlcmlhbGl6ZSgpIHsgcmV0dXJuIHtkZXNlcmlhbGl6ZXI6ICdHaXRUaW1pbmdzVmlldyd9OyB9LFxuICAgICAgZ2V0VVJJKCkgeyByZXR1cm4gJ2F0b20tZ2l0aHViOi8vZGVidWcvbWFya2Vycyc7IH0sXG4gICAgICBnZXRUaXRsZSgpIHsgcmV0dXJuICdHaXRIdWIgUGFja2FnZSBUaW1pbmdzIFZpZXcnOyB9LFxuICAgICAgZ2V0IGVsZW1lbnQoKSB7XG4gICAgICAgIGlmICghZWxlbWVudCkge1xuICAgICAgICAgIGVsZW1lbnQgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdkaXYnKTtcbiAgICAgICAgICBSZWFjdERvbS5yZW5kZXIoPEdpdFRpbWluZ3NWaWV3IGNvbnRhaW5lcj17ZWxlbWVudH0gLz4sIGVsZW1lbnQpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBlbGVtZW50O1xuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgc3RhdGljIGRlc2VyaWFsaXplKCkge1xuICAgIHJldHVybiB0aGlzLmNyZWF0ZVBhbmVJdGVtKCk7XG4gIH1cblxuICBzdGF0aWMgZ2VuZXJhdGVNYXJrZXIobGFiZWwpIHtcbiAgICBjb25zdCBtYXJrZXIgPSBuZXcgTWFya2VyKGxhYmVsLCAoKSA9PiB7XG4gICAgICBHaXRUaW1pbmdzVmlldy5zY2hlZHVsZVVwZGF0ZSgpO1xuICAgIH0pO1xuICAgIGNvbnN0IG5vdyA9IHBlcmZvcm1hbmNlLm5vdygpO1xuICAgIGlmICghbWFya2VycyB8fCAobGFzdE1hcmtlclRpbWUgJiYgTWF0aC5hYnMobm93IC0gbGFzdE1hcmtlclRpbWUpID49IDUwMDApKSB7XG4gICAgICBncm91cElkKys7XG4gICAgICBtYXJrZXJzID0gW107XG4gICAgICBncm91cHMudW5zaGlmdCh7aWQ6IGdyb3VwSWQsIG1hcmtlcnN9KTtcbiAgICAgIGlmIChncm91cHMubGVuZ3RoID4gMTAwKSB7XG4gICAgICAgIGdyb3Vwcy5wb3AoKTtcbiAgICAgIH1cbiAgICB9XG4gICAgbGFzdE1hcmtlclRpbWUgPSBub3c7XG4gICAgbWFya2Vycy5wdXNoKG1hcmtlcik7XG4gICAgR2l0VGltaW5nc1ZpZXcuc2NoZWR1bGVVcGRhdGUoKTtcbiAgICByZXR1cm4gbWFya2VyO1xuICB9XG5cbiAgc3RhdGljIHJlc3RvcmVHcm91cChncm91cCkge1xuICAgIGdyb3VwSWQrKztcbiAgICBncm91cHMudW5zaGlmdCh7aWQ6IGdyb3VwSWQsIG1hcmtlcnM6IGdyb3VwfSk7XG4gICAgR2l0VGltaW5nc1ZpZXcuc2NoZWR1bGVVcGRhdGUodHJ1ZSk7XG4gIH1cblxuICBzdGF0aWMgc2NoZWR1bGVVcGRhdGUoaW1tZWRpYXRlID0gZmFsc2UpIHtcbiAgICBpZiAodXBkYXRlVGltZXIpIHtcbiAgICAgIGNsZWFyVGltZW91dCh1cGRhdGVUaW1lcik7XG4gICAgfVxuXG4gICAgdXBkYXRlVGltZXIgPSBzZXRUaW1lb3V0KCgpID0+IHtcbiAgICAgIEdpdFRpbWluZ3NWaWV3LmVtaXR0ZXIuZW1pdCgnZGlkLXVwZGF0ZScpO1xuICAgIH0sIGltbWVkaWF0ZSA/IDAgOiAxMDAwKTtcbiAgfVxuXG4gIHN0YXRpYyBvbkRpZFVwZGF0ZShjYWxsYmFjaykge1xuICAgIHJldHVybiBHaXRUaW1pbmdzVmlldy5lbWl0dGVyLm9uKCdkaWQtdXBkYXRlJywgY2FsbGJhY2spO1xuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgdGhpcy5zdWJzY3JpcHRpb25zID0gbmV3IENvbXBvc2l0ZURpc3Bvc2FibGUoXG4gICAgICBHaXRUaW1pbmdzVmlldy5vbkRpZFVwZGF0ZSgoKSA9PiB0aGlzLmZvcmNlVXBkYXRlKCkpLFxuICAgICAgYXRvbS53b3Jrc3BhY2Uub25EaWREZXN0cm95UGFuZUl0ZW0oKHtpdGVtfSkgPT4ge1xuICAgICAgICBpZiAoaXRlbS5lbGVtZW50ID09PSB0aGlzLnByb3BzLmNvbnRhaW5lcikge1xuICAgICAgICAgIC8vIHdlIGp1c3QgZ290IGNsb3NlZFxuICAgICAgICAgIFJlYWN0RG9tLnVubW91bnRDb21wb25lbnRBdE5vZGUodGhpcy5wcm9wcy5jb250YWluZXIpO1xuICAgICAgICB9XG4gICAgICB9KSxcbiAgICApO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5zdWJzY3JpcHRpb25zLmRpc3Bvc2UoKTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItR2l0VGltaW5nc1ZpZXdcIj5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItR2l0VGltaW5nc1ZpZXctaGVhZGVyXCI+XG4gICAgICAgICAgPGJ1dHRvbiBjbGFzc05hbWU9XCJpbXBvcnQtYnV0dG9uIGJ0blwiIG9uQ2xpY2s9e3RoaXMuaGFuZGxlSW1wb3J0Q2xpY2t9PkltcG9ydDwvYnV0dG9uPlxuICAgICAgICA8L2Rpdj5cbiAgICAgICAge2dyb3Vwcy5tYXAoKGdyb3VwLCBpZHgpID0+IChcbiAgICAgICAgICA8V2F0ZXJmYWxsV2lkZ2V0IGtleT17Z3JvdXAuaWR9IG1hcmtlcnM9e2dyb3VwLm1hcmtlcnN9IC8+XG4gICAgICAgICkpfVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIEBhdXRvYmluZFxuICBoYW5kbGVJbXBvcnRDbGljayhlKSB7XG4gICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgIGRpYWxvZy5zaG93T3BlbkRpYWxvZyh7XG4gICAgICBwcm9wZXJ0aWVzOiBbJ29wZW5GaWxlJ10sXG4gICAgfSwgYXN5bmMgZmlsZW5hbWVzID0+IHtcbiAgICAgIGlmICghZmlsZW5hbWVzKSB7IHJldHVybjsgfVxuICAgICAgY29uc3QgZmlsZW5hbWUgPSBmaWxlbmFtZXNbMF07XG4gICAgICB0cnkge1xuICAgICAgICBjb25zdCBjb250ZW50cyA9IGF3YWl0IHJlYWRGaWxlKGZpbGVuYW1lKTtcbiAgICAgICAgY29uc3QgZGF0YSA9IEpTT04ucGFyc2UoY29udGVudHMpO1xuICAgICAgICBjb25zdCByZXN0b3JlZE1hcmtlcnMgPSBkYXRhLm1hcChpdGVtID0+IE1hcmtlci5kZXNlcmlhbGl6ZShpdGVtKSk7XG4gICAgICAgIEdpdFRpbWluZ3NWaWV3LnJlc3RvcmVHcm91cChyZXN0b3JlZE1hcmtlcnMpO1xuICAgICAgfSBjYXRjaCAoX2Vycikge1xuICAgICAgICBhdG9tLm5vdGlmaWNhdGlvbnMuYWRkRXJyb3IoYENvdWxkIG5vdCBpbXBvcnQgdGltaW5ncyBmcm9tICR7ZmlsZW5hbWV9YCk7XG4gICAgICB9XG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==