'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

/**
 * `EtchWrapper` is a React component that renders Etch components
 * and correctly manages their lifecycles as the application progresses.
 *
 *    <EtchWrapper type="span" reattachDomNode={true} className="wrapper">
 *      <EtchComponent etchProp={stuff} />
 *    </EtchWrapper>
 *
 * The `type` property specifies the DOM node type to wrap around the
 * Etch component's element, and defaults to 'div'. Any other props you
 * pass to the wrapper component will be applied to the DOM node.
 *
 * `reattachDomNode` determines whether or not to place the wrapped component
 * element back in the React component's DOM node if we find it's missing;
 * this could happen due to changing the `type` property. If you pass the
 * wrapped component element into a method that moves the element, you should
 * specify `false` for this option.
 *
 * The component takes a single JSX child, which describes the type and props
 * of the Etch component to render. Any time this changes, the wrapper will
 * update (or destroy and recreate) the Etch component as necessary.
 *
 * Note that the component cleans up its own DOM node, and calls
 * `component.destroy(false)` (if your component has a `destroy` method)
 * and you should pass the `false` as the second argument to
 * `etch.destroy(this)` (e.g. `etch.destroy(this, false)`) inside your
 * component instance.
 *
 * The component instance is available at `this.getWrappedComponent` if you need
 * to call methods on it from the outside (though you should really consider
 * setting a prop instead. ;)
 */
let EtchWrapper = (_temp = _class = class EtchWrapper extends _react2.default.Component {

  componentDidMount() {
    this.createComponent(this.getWrappedComponentDetails(this.props.children));
  }

  componentWillReceiveProps(newProps) {
    const oldDetails = this.getWrappedComponentDetails(this.props.children);
    const newDetails = this.getWrappedComponentDetails(newProps.children);
    if (oldDetails.type !== newDetails.type) {
      // The wrapped component type changed, so we need to destroy the old
      // component and create a new one of the new type.
      this.destroyComponent();
      this.createComponent(newDetails);
    }
  }

  componentDidUpdate(prevProps) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const oldDetails = _this.getWrappedComponentDetails(prevProps.children);
      const newDetails = _this.getWrappedComponentDetails(_this.props.children);

      if (oldDetails.type === newDetails.type) {
        // We didn't change the wrapped (Etch) component type,
        // so we need to update the instance with the new props.
        yield _this.updateComponent(_this.getWrappedComponentDetails(_this.props.children));
      }

      // If we just recreated our DOM node by changing the node type, we
      // need to reattach the wrapped component's element.
      if (_this.props.reattachDomNode && _this.container && !_this.container.contains(_this.component.element)) {
        _this.container.appendChild(_this.component.element);
      }
    })();
  }

  render() {
    const Type = this.props.type;
    var _props = this.props;

    const type = _props.type,
          children = _props.children,
          reattachDomNode = _props.reattachDomNode,
          props = _objectWithoutProperties(_props, ['type', 'children', 'reattachDomNode']); // eslint-disable-line no-unused-vars


    return _react2.default.createElement(Type, _extends({}, props, { ref: c => {
        this.container = c;
      } }));
  }

  componentWillUnmount() {
    this.destroyComponent();
  }

  getWrappedComponentDetails(ourChildren) {
    // e.g. <EtchWrapper><EtchChild prop={1} other={2}>Hi</EtchChild></EtchWrapper>
    const etchElement = _react2.default.Children.toArray(ourChildren)[0];
    // etchElement === {type: EtchChild, props: {prop: 1, other: 2, children: 'Hi'}}
    const type = etchElement.type,
          props = etchElement.props;
    // type === EtchChild, props === {prop: 1, other: 2, children: 'Hi'}

    const children = props.children,
          remainingProps = _objectWithoutProperties(props, ['children']);
    // children === 'Hi', remainingProps === {prop: 1, other: 2}


    return { type, children, props: remainingProps };
  }

  // For compatability with Atom's ViewProvider
  getElement() {
    return this.container;
  }

  // Etch component interactions

  getWrappedComponent() {
    return this.component;
  }

  createComponent(_ref) {
    let type = _ref.type,
        props = _ref.props,
        children = _ref.children;

    this.component = new type(props, children);
    this.container.appendChild(this.component.element);
  }

  updateComponent(_ref2) {
    let props = _ref2.props,
        children = _ref2.children;

    return this.component.update(props, children);
  }

  destroyComponent() {
    if (this.container.contains(this.component.element)) {
      this.container.removeChild(this.component.element);
    }
    this.component.destroy && this.component.destroy(false);
    delete this.component;
  }
}, _class.propTypes = {
  children: _propTypes2.default.element.isRequired,
  type: _propTypes2.default.string,
  reattachDomNode: _propTypes2.default.bool
}, _class.defaultProps = {
  type: 'div',
  reattachDomNode: true
}, _temp);
exports.default = EtchWrapper;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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