'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _desc, _value, _class;

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let StyleCalculator = (_class = class StyleCalculator {
  constructor(styles, config) {
    this.styles = styles;
    this.config = config;
  }

  startWatching(sourcePath, configsToWatch, getStylesheetFn) {
    const subscriptions = new _eventKit.CompositeDisposable();
    const updateStyles = () => {
      this.updateStyles(sourcePath, getStylesheetFn);
    };
    configsToWatch.forEach(configToWatch => {
      subscriptions.add(this.config.onDidChange(configToWatch, updateStyles));
    });
    updateStyles();
    return subscriptions;
  }

  updateStyles(sourcePath, getStylesheetFn) {
    const stylesheet = getStylesheetFn(this.config);
    this.styles.addStyleSheet(stylesheet, { sourcePath });
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'updateStyles', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'updateStyles'), _class.prototype)), _class);
exports.default = StyleCalculator;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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