'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _dec17, _desc, _value, _class;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

var _helpers = require('../../helpers');

var _workspaceChangeObserver = require('../workspace-change-observer');

var _filePatch = require('../file-patch');

var _filePatch2 = _interopRequireDefault(_filePatch);

var _hunk = require('../hunk');

var _hunk2 = _interopRequireDefault(_hunk);

var _hunkLine = require('../hunk-line');

var _hunkLine2 = _interopRequireDefault(_hunkLine);

var _discardHistory = require('../discard-history');

var _discardHistory2 = _interopRequireDefault(_discardHistory);

var _branch = require('../branch');

var _branch2 = _interopRequireDefault(_branch);

var _remote = require('../remote');

var _remote2 = _interopRequireDefault(_remote);

var _commit = require('../commit');

var _commit2 = _interopRequireDefault(_commit);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

/**
 * Decorator for an async method that invalidates the cache after execution (regardless of success or failure).
 * Optionally parameterized by a function that accepts the same arguments as the function that returns the list of cache
 * keys to invalidate.
 */
function invalidate(spec) {
  return function (target, name, descriptor) {
    const original = descriptor.value;
    descriptor.value = function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return original.apply(this, args).then(result => {
        this.acceptInvalidation(spec, args);
        return result;
      }, err => {
        this.acceptInvalidation(spec, args);
        return Promise.reject(err);
      });
    };
    return descriptor;
  };
}

/**
 * State used when the working directory contains a valid git repository and can be interacted with. Performs
 * actual git operations, caching the results, and broadcasts `onDidUpdate` events when write actions are
 * performed.
 */
let Present = (_dec = invalidate(paths => Keys.cacheOperationKeys(paths)), _dec2 = invalidate(paths => Keys.cacheOperationKeys(paths)), _dec3 = invalidate(paths => Keys.cacheOperationKeys(paths)), _dec4 = invalidate(filePatch => Keys.cacheOperationKeys([filePatch.getOldPath(), filePatch.getNewPath()])), _dec5 = invalidate(filePatch => Keys.workdirOperationKeys([filePatch.getOldPath(), filePatch.getNewPath()])), _dec6 = invalidate(() => [...Keys.headOperationKeys(), ...Keys.filePatch.eachWithOpts({ staged: true }), Keys.headDescription]), _dec7 = invalidate(() => [...Keys.headOperationKeys(), Keys.index.all, Keys.headDescription]), _dec8 = invalidate(() => [Keys.statusBundle, Keys.stagedChangesSinceParentCommit, Keys.filePatch.all, Keys.index.all]), _dec9 = invalidate(filePath => [Keys.statusBundle, Keys.stagedChangesSinceParentCommit, ...Keys.filePatch.eachWithFileOpts([filePath], [{ staged: false }, { staged: true }, { staged: true, amending: true }]), Keys.index.oneWith(filePath)]), _dec10 = invalidate(() => [Keys.stagedChangesSinceParentCommit, Keys.lastCommit, Keys.statusBundle, Keys.index.all, ...Keys.filePatch.eachWithOpts({ staged: true, amending: true }), Keys.headDescription]), _dec11 = invalidate(paths => [Keys.statusBundle, Keys.stagedChangesSinceParentCommit, ...paths.map(fileName => Keys.index.oneWith(fileName)), ...Keys.filePatch.eachWithFileOpts(paths, [{ staged: true }, { staged: true, amending: true }])]), _dec12 = invalidate(branchName => [Keys.statusBundle, Keys.headDescription]), _dec13 = invalidate(() => [...Keys.headOperationKeys(), Keys.index.all, Keys.headDescription]), _dec14 = invalidate(function (branchName) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  const keys = [Keys.statusBundle, Keys.headDescription];

  if (options.setUpstream) {
    keys.push(...Keys.config.eachWithSetting(`branch.${branchName}.remote`));
  }

  return keys;
}), _dec15 = invalidate(setting => Keys.config.eachWithSetting(setting)), _dec16 = invalidate(setting => Keys.config.eachWithSetting(setting)), _dec17 = invalidate(paths => [Keys.statusBundle, ...paths.map(filePath => Keys.filePatch.oneWith(filePath, { staged: false }))]), (_class = class Present extends _state2.default {
  constructor(repository, history) {
    super(repository);

    this.cache = new Cache();

    this.discardHistory = new _discardHistory2.default(this.createBlob.bind(this), this.expandBlobToFile.bind(this), this.mergeFile.bind(this), this.workdir(), { maxHistoryLength: 60 });
  }

  isPresent() {
    return true;
  }

  showStatusBarTiles() {
    return true;
  }

  acceptInvalidation(spec, args) {
    const keys = spec(...args);
    this.cache.invalidate(keys);
    this.didUpdate();
  }

  observeFilesystemChange(paths) {
    const keys = new Set();
    for (let i = 0; i < paths.length; i++) {
      const fullPath = paths[i];

      if (fullPath === _workspaceChangeObserver.FOCUS) {
        keys.add(Keys.statusBundle);
        for (const k of Keys.filePatch.eachWithOpts({ staged: false })) {
          keys.add(k);
        }
        continue;
      }

      const endsWith = function () {
        return fullPath.endsWith(_path2.default.join(...arguments));
      };
      const includes = function () {
        return fullPath.includes(_path2.default.join(...arguments));
      };

      if (endsWith('.git', 'index')) {
        keys.add(Keys.stagedChangesSinceParentCommit);
        keys.add(Keys.filePatch.all);
        keys.add(Keys.index.all);
        keys.add(Keys.statusBundle);
        continue;
      }

      if (endsWith('.git', 'HEAD')) {
        keys.add(Keys.lastCommit);
        keys.add(Keys.statusBundle);
        keys.add(Keys.headDescription);
        continue;
      }

      if (includes('.git', 'refs', 'heads')) {
        keys.add(Keys.branches);
        keys.add(Keys.lastCommit);
        keys.add(Keys.headDescription);
        continue;
      }

      if (includes('.git', 'refs', 'remotes')) {
        keys.add(Keys.remotes);
        keys.add(Keys.statusBundle);
        keys.add(Keys.headDescription);
        continue;
      }

      if (endsWith('.git', 'config')) {
        keys.add(Keys.config.all);
        keys.add(Keys.statusBundle);
        continue;
      }

      // File change within the working directory
      const relativePath = _path2.default.relative(this.workdir(), fullPath);
      keys.add(Keys.filePatch.oneWith(relativePath, { staged: false }));
      keys.add(Keys.statusBundle);
    }

    if (keys.size > 0) {
      this.cache.invalidate(Array.from(keys));
      this.didUpdate();
    }
  }

  refresh() {
    this.cache.clear();
    this.didUpdate();
  }

  init() {
    return super.init().catch(e => {
      e.stdErr = 'This directory already contains a git repository';
      return Promise.reject(e);
    });
  }

  clone() {
    return super.clone().catch(e => {
      e.stdErr = 'This directory already contains a git repository';
      return Promise.reject(e);
    });
  }

  // Git operations ////////////////////////////////////////////////////////////////////////////////////////////////////

  // Staging and unstaging

  stageFiles(paths) {
    return this.git().stageFiles(paths);
  }

  unstageFiles(paths) {
    return this.git().unstageFiles(paths);
  }

  stageFilesFromParentCommit(paths) {
    return this.git().unstageFiles(paths, 'HEAD~');
  }

  applyPatchToIndex(filePatch) {
    const patchStr = filePatch.getHeaderString() + filePatch.toString();
    return this.git().applyPatch(patchStr, { index: true });
  }

  applyPatchToWorkdir(filePatch) {
    const patchStr = filePatch.getHeaderString() + filePatch.toString();
    return this.git().applyPatch(patchStr);
  }

  // Committing

  commit(message, options) {
    return this.git().commit(formatCommitMessage(message), options);
  }

  // Merging

  merge(branchName) {
    return this.git().merge(branchName);
  }

  abortMerge() {
    return this.git().abortMerge();
  }

  checkoutSide(side, paths) {
    return this.git().checkoutSide(side, paths);
  }

  mergeFile(oursPath, commonBasePath, theirsPath, resultPath) {
    return this.git().mergeFile(oursPath, commonBasePath, theirsPath, resultPath);
  }

  writeMergeConflictToIndex(filePath, commonBaseSha, oursSha, theirsSha) {
    return this.git().writeMergeConflictToIndex(filePath, commonBaseSha, oursSha, theirsSha);
  }

  // Checkout

  checkout(revision) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    return this.git().checkout(revision, options);
  }

  checkoutPathsAtRevision(paths) {
    let revision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'HEAD';

    return this.git().checkoutFiles(paths, revision);
  }

  // Remote interactions

  fetch(branchName) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const remote = yield _this.getRemoteForBranch(branchName);
      if (!remote.isPresent()) {
        return;
      }
      yield _this.git().fetch(remote.getName(), branchName);
    })();
  }

  pull(branchName) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      const remote = yield _this2.getRemoteForBranch(branchName);
      if (!remote.isPresent()) {
        return;
      }
      yield _this2.git().pull(remote.getName(), branchName);
    })();
  }

  push(branchName, options) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const remote = yield _this3.getRemoteForBranch(branchName);
      return _this3.git().push(remote.getNameOr('origin'), branchName, options);
    })();
  }

  // Configuration

  setConfig(setting, value, options) {
    return this.git().setConfig(setting, value, options);
  }

  unsetConfig(setting) {
    return this.git().unsetConfig(setting);
  }

  // Direct blob interactions

  createBlob(options) {
    return this.git().createBlob(options);
  }

  expandBlobToFile(absFilePath, sha) {
    return this.git().expandBlobToFile(absFilePath, sha);
  }

  // Discard history

  createDiscardHistoryBlob() {
    return this.discardHistory.createHistoryBlob();
  }

  updateDiscardHistory() {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const history = yield _this4.loadHistoryPayload();
      _this4.discardHistory.updateHistory(history);
    })();
  }

  storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction) {
    var _this5 = this;

    let partialDiscardFilePath = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
    return _asyncToGenerator(function* () {
      const snapshots = yield _this5.discardHistory.storeBeforeAndAfterBlobs(filePaths, isSafe, destructiveAction, partialDiscardFilePath);
      if (snapshots) {
        yield _this5.saveDiscardHistory();
      }
      return snapshots;
    })();
  }

  restoreLastDiscardInTempFiles(isSafe) {
    let partialDiscardFilePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    return this.discardHistory.restoreLastDiscardInTempFiles(isSafe, partialDiscardFilePath);
  }

  popDiscardHistory() {
    var _this6 = this;

    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    return _asyncToGenerator(function* () {
      const removed = yield _this6.discardHistory.popHistory(partialDiscardFilePath);
      if (removed) {
        yield _this6.saveDiscardHistory();
      }
    })();
  }

  clearDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    this.discardHistory.clearHistory(partialDiscardFilePath);
    return this.saveDiscardHistory();
  }

  discardWorkDirChangesForPaths(paths) {
    var _this7 = this;

    return _asyncToGenerator(function* () {
      const untrackedFiles = yield _this7.git().getUntrackedFiles();

      var _partition = partition(paths, function (f) {
        return untrackedFiles.includes(f);
      }),
          _partition2 = _slicedToArray(_partition, 2);

      const filesToRemove = _partition2[0],
            filesToCheckout = _partition2[1];

      yield _this7.git().checkoutFiles(filesToCheckout);
      yield Promise.all(filesToRemove.map(function (filePath) {
        const absPath = _path2.default.join(_this7.workdir(), filePath);
        return (0, _helpers.deleteFileOrFolder)(absPath);
      }));
    })();
  }

  // Accessors /////////////////////////////////////////////////////////////////////////////////////////////////////////

  // Index queries

  getStatusBundle() {
    var _this8 = this;

    return this.cache.getOrSet(Keys.statusBundle, _asyncToGenerator(function* () {
      const bundle = yield _this8.git().getStatusBundle();
      const results = yield _this8.formatChangedFiles(bundle);
      results.branch = bundle.branch;
      if (!results.branch.aheadBehind) {
        results.branch.aheadBehind = { ahead: null, behind: null };
      }
      return results;
    }));
  }

  formatChangedFiles(_ref2) {
    var _this9 = this;

    let changedEntries = _ref2.changedEntries,
        untrackedEntries = _ref2.untrackedEntries,
        renamedEntries = _ref2.renamedEntries,
        unmergedEntries = _ref2.unmergedEntries;
    return _asyncToGenerator(function* () {
      const statusMap = {
        A: 'added',
        M: 'modified',
        D: 'deleted',
        U: 'modified'
      };

      const stagedFiles = {};
      const unstagedFiles = {};
      const mergeConflictFiles = {};

      changedEntries.forEach(function (entry) {
        if (entry.stagedStatus) {
          stagedFiles[entry.filePath] = statusMap[entry.stagedStatus];
        }
        if (entry.unstagedStatus) {
          unstagedFiles[entry.filePath] = statusMap[entry.unstagedStatus];
        }
      });

      untrackedEntries.forEach(function (entry) {
        unstagedFiles[entry.filePath] = statusMap.A;
      });

      renamedEntries.forEach(function (entry) {
        if (entry.stagedStatus === 'R') {
          stagedFiles[entry.filePath] = statusMap.A;
          stagedFiles[entry.origFilePath] = statusMap.D;
        }
        if (entry.unstagedStatus === 'R') {
          unstagedFiles[entry.filePath] = statusMap.A;
          unstagedFiles[entry.origFilePath] = statusMap.D;
        }
        if (entry.stagedStatus === 'C') {
          stagedFiles[entry.filePath] = statusMap.A;
        }
        if (entry.unstagedStatus === 'C') {
          unstagedFiles[entry.filePath] = statusMap.A;
        }
      });

      let statusToHead;

      for (let i = 0; i < unmergedEntries.length; i++) {
        var _unmergedEntries$i = unmergedEntries[i];
        const stagedStatus = _unmergedEntries$i.stagedStatus,
              unstagedStatus = _unmergedEntries$i.unstagedStatus,
              filePath = _unmergedEntries$i.filePath;

        if (stagedStatus === 'U' || unstagedStatus === 'U' || stagedStatus === 'A' && unstagedStatus === 'A') {
          // Skipping this check here because we only run a single `await`
          // and we only run it in the main, synchronous body of the for loop.
          // eslint-disable-next-line no-await-in-loop
          if (!statusToHead) {
            statusToHead = yield _this9.git().diffFileStatus({ target: 'HEAD' });
          }
          mergeConflictFiles[filePath] = {
            ours: statusMap[stagedStatus],
            theirs: statusMap[unstagedStatus],
            file: statusToHead[filePath] || 'equivalent'
          };
        }
      }

      return { stagedFiles, unstagedFiles, mergeConflictFiles };
    })();
  }

  getStatusesForChangedFiles() {
    var _this10 = this;

    return _asyncToGenerator(function* () {
      var _ref3 = yield _this10.getStatusBundle();

      const stagedFiles = _ref3.stagedFiles,
            unstagedFiles = _ref3.unstagedFiles,
            mergeConflictFiles = _ref3.mergeConflictFiles;

      return { stagedFiles, unstagedFiles, mergeConflictFiles };
    })();
  }

  getStagedChangesSinceParentCommit() {
    var _this11 = this;

    return this.cache.getOrSet(Keys.stagedChangesSinceParentCommit, _asyncToGenerator(function* () {
      try {
        const stagedFiles = yield _this11.git().diffFileStatus({ staged: true, target: 'HEAD~' });
        return Object.keys(stagedFiles).map(function (filePath) {
          return { filePath, status: stagedFiles[filePath] };
        });
      } catch (e) {
        if (e.message.includes('ambiguous argument \'HEAD~\'')) {
          return [];
        } else {
          throw e;
        }
      }
    }));
  }

  getFilePatchForPath(filePath) {
    var _this12 = this;

    var _ref5 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { staged: false, amending: false };

    let staged = _ref5.staged,
        amending = _ref5.amending;

    return this.cache.getOrSet(Keys.filePatch.oneWith(filePath, { staged, amending }), _asyncToGenerator(function* () {
      const options = { staged, amending };
      if (amending) {
        options.baseCommit = 'HEAD~';
      }

      const rawDiff = yield _this12.git().getDiffForFilePath(filePath, options);
      if (rawDiff) {
        var _buildFilePatchesFrom = buildFilePatchesFromRawDiffs([rawDiff]),
            _buildFilePatchesFrom2 = _slicedToArray(_buildFilePatchesFrom, 1);

        const filePatch = _buildFilePatchesFrom2[0];

        return filePatch;
      } else {
        return null;
      }
    }));
  }

  readFileFromIndex(filePath) {
    return this.cache.getOrSet(Keys.index.oneWith(filePath), () => {
      return this.git().readFileFromIndex(filePath);
    });
  }

  // Commit access

  getLastCommit() {
    var _this13 = this;

    return this.cache.getOrSet(Keys.lastCommit, _asyncToGenerator(function* () {
      var _ref8 = yield _this13.git().getHeadCommit();

      const sha = _ref8.sha,
            message = _ref8.message,
            unbornRef = _ref8.unbornRef;

      return unbornRef ? _commit2.default.createUnborn() : new _commit2.default(sha, message);
    }));
  }

  // Branches

  getBranches() {
    var _this14 = this;

    return this.cache.getOrSet(Keys.branches, _asyncToGenerator(function* () {
      const branchNames = yield _this14.git().getBranches();
      return branchNames.map(function (branchName) {
        return new _branch2.default(branchName);
      });
    }));
  }

  getCurrentBranch() {
    var _this15 = this;

    return _asyncToGenerator(function* () {
      var _ref10 = yield _this15.getStatusBundle();

      const branch = _ref10.branch;

      if (branch.head === '(detached)') {
        const description = yield _this15.getHeadDescription();
        return _branch2.default.createDetached(description);
      } else {
        return new _branch2.default(branch.head);
      }
    })();
  }

  getHeadDescription() {
    return this.cache.getOrSet(Keys.headDescription, () => {
      return this.git().describeHead();
    });
  }

  // Merging and rebasing status

  isMerging() {
    return this.git().isMerging(this.repository.getGitDirectoryPath());
  }

  isRebasing() {
    return this.git().isRebasing(this.repository.getGitDirectoryPath());
  }

  // Remotes

  getRemotes() {
    var _this16 = this;

    return this.cache.getOrSet(Keys.remotes, _asyncToGenerator(function* () {
      const remotesInfo = yield _this16.git().getRemotes();
      return remotesInfo.map(function (_ref12) {
        let name = _ref12.name,
            url = _ref12.url;
        return new _remote2.default(name, url);
      });
    }));
  }

  getAheadCount(branchName) {
    var _this17 = this;

    return _asyncToGenerator(function* () {
      const bundle = yield _this17.getStatusBundle();
      return bundle.branch.aheadBehind.ahead;
    })();
  }

  getBehindCount(branchName) {
    var _this18 = this;

    return _asyncToGenerator(function* () {
      const bundle = yield _this18.getStatusBundle();
      return bundle.branch.aheadBehind.behind;
    })();
  }

  getConfig(option) {
    var _ref13 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { local: false };

    let local = _ref13.local;

    return this.cache.getOrSet(Keys.config.oneWith(option, { local }), () => {
      return this.git().getConfig(option, { local });
    });
  }

  // Direct blob access

  getBlobContents(sha) {
    return this.cache.getOrSet(Keys.blob(sha), () => {
      return this.git().getBlobContents(sha);
    });
  }

  // Discard history

  hasDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return this.discardHistory.hasHistory(partialDiscardFilePath);
  }

  getDiscardHistory() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return this.discardHistory.getHistory(partialDiscardFilePath);
  }

  getLastHistorySnapshots() {
    let partialDiscardFilePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    return this.discardHistory.getLastSnapshots(partialDiscardFilePath);
  }
}, (_applyDecoratedDescriptor(_class.prototype, 'stageFiles', [_dec], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unstageFiles', [_dec2], Object.getOwnPropertyDescriptor(_class.prototype, 'unstageFiles'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'stageFilesFromParentCommit', [_dec3], Object.getOwnPropertyDescriptor(_class.prototype, 'stageFilesFromParentCommit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToIndex', [_dec4], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'applyPatchToWorkdir', [_dec5], Object.getOwnPropertyDescriptor(_class.prototype, 'applyPatchToWorkdir'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'commit', [_dec6], Object.getOwnPropertyDescriptor(_class.prototype, 'commit'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'merge', [_dec7], Object.getOwnPropertyDescriptor(_class.prototype, 'merge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'abortMerge', [_dec8], Object.getOwnPropertyDescriptor(_class.prototype, 'abortMerge'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'writeMergeConflictToIndex', [_dec9], Object.getOwnPropertyDescriptor(_class.prototype, 'writeMergeConflictToIndex'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkout', [_dec10], Object.getOwnPropertyDescriptor(_class.prototype, 'checkout'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'checkoutPathsAtRevision', [_dec11], Object.getOwnPropertyDescriptor(_class.prototype, 'checkoutPathsAtRevision'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'fetch', [_dec12], Object.getOwnPropertyDescriptor(_class.prototype, 'fetch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'pull', [_dec13], Object.getOwnPropertyDescriptor(_class.prototype, 'pull'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'push', [_dec14], Object.getOwnPropertyDescriptor(_class.prototype, 'push'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'setConfig', [_dec15], Object.getOwnPropertyDescriptor(_class.prototype, 'setConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'unsetConfig', [_dec16], Object.getOwnPropertyDescriptor(_class.prototype, 'unsetConfig'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'discardWorkDirChangesForPaths', [_dec17], Object.getOwnPropertyDescriptor(_class.prototype, 'discardWorkDirChangesForPaths'), _class.prototype)), _class));
exports.default = Present;


_state2.default.register(Present);

function partition(array, predicate) {
  const matches = [];
  const nonmatches = [];
  array.forEach(item => {
    if (predicate(item)) {
      matches.push(item);
    } else {
      nonmatches.push(item);
    }
  });
  return [matches, nonmatches];
}

function formatCommitMessage(message) {
  // strip out comments
  const messageWithoutComments = message.replace(/^#.*$/mg, '').trim();

  // hard wrap message (except for first line) at 72 characters
  let results = [];
  messageWithoutComments.split('\n').forEach((line, index) => {
    if (line.length <= 72 || index === 0) {
      results.push(line);
    } else {
      const matches = line.match(/.{1,72}(\s|$)|\S+?(\s|$)/g).map(match => {
        return match.endsWith('\n') ? match.substr(0, match.length - 1) : match;
      });
      results = results.concat(matches);
    }
  });

  return results.join('\n');
}

function buildFilePatchesFromRawDiffs(rawDiffs) {
  let diffLineNumber = 0;
  return rawDiffs.map(patch => {
    const hunks = patch.hunks.map(hunk => {
      let oldLineNumber = hunk.oldStartLine;
      let newLineNumber = hunk.newStartLine;
      const hunkLines = hunk.lines.map(line => {
        const status = _hunkLine2.default.statusMap[line[0]];
        const text = line.slice(1);
        let hunkLine;
        if (status === 'unchanged') {
          hunkLine = new _hunkLine2.default(text, status, oldLineNumber, newLineNumber, diffLineNumber++);
          oldLineNumber++;
          newLineNumber++;
        } else if (status === 'added') {
          hunkLine = new _hunkLine2.default(text, status, -1, newLineNumber, diffLineNumber++);
          newLineNumber++;
        } else if (status === 'deleted') {
          hunkLine = new _hunkLine2.default(text, status, oldLineNumber, -1, diffLineNumber++);
          oldLineNumber++;
        } else if (status === 'nonewline') {
          hunkLine = new _hunkLine2.default(text.substr(1), status, -1, -1, diffLineNumber++);
        } else {
          throw new Error(`unknow status type: ${status}`);
        }
        return hunkLine;
      });
      return new _hunk2.default(hunk.oldStartLine, hunk.newStartLine, hunk.oldLineCount, hunk.newLineCount, hunk.heading, hunkLines);
    });
    return new _filePatch2.default(patch.oldPath, patch.newPath, patch.status, hunks);
  });
}

let Cache = class Cache {
  constructor() {
    this.storage = new Map();
    this.byGroup = new Map();
  }

  getOrSet(key, operation) {
    const primary = key.getPrimary();
    const existing = this.storage.get(primary);
    if (existing !== undefined) {
      return existing;
    }

    const created = operation();

    this.storage.set(primary, created);

    const groups = key.getGroups();
    for (let i = 0; i < groups.length; i++) {
      const group = groups[i];
      let groupSet = this.byGroup.get(group);
      if (groupSet === undefined) {
        groupSet = new Set();
        this.byGroup.set(group, groupSet);
      }
      groupSet.add(key);
    }

    return created;
  }

  invalidate(keys) {
    for (let i = 0; i < keys.length; i++) {
      keys[i].removeFromCache(this);
    }
  }

  keysInGroup(group) {
    return this.byGroup.get(group) || [];
  }

  removePrimary(primary) {
    this.storage.delete(primary);
  }

  removeFromGroup(group, key) {
    const groupSet = this.byGroup.get(group);
    groupSet && groupSet.delete(key);
  }

  clear() {
    this.storage.clear();
    this.byGroup.clear();
  }
};
let CacheKey = class CacheKey {
  constructor(primary) {
    let groups = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

    this.primary = primary;
    this.groups = groups;
  }

  getPrimary() {
    return this.primary;
  }

  getGroups() {
    return this.groups;
  }

  removeFromCache(cache) {
    let withoutGroup = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    cache.removePrimary(this.getPrimary());

    const groups = this.getGroups();
    for (let i = 0; i < groups.length; i++) {
      const group = groups[i];
      if (group === withoutGroup) {
        continue;
      }

      cache.removeFromGroup(group, this);
    }
  }
};
let GroupKey = class GroupKey {
  constructor(group) {
    this.group = group;
  }

  removeFromCache(cache) {
    for (const matchingKey of cache.keysInGroup(this.group)) {
      matchingKey.removeFromCache(cache, this.group);
    }
  }
};


const Keys = {
  statusBundle: new CacheKey('status-bundle'),

  stagedChangesSinceParentCommit: new CacheKey('staged-changes-since-parent-commit'),

  filePatch: {
    _optKey: (_ref14) => {
      let staged = _ref14.staged,
          amending = _ref14.amending;

      if (staged && amending) {
        return 'a';
      } else if (staged) {
        return 's';
      } else {
        return 'u';
      }
    },

    oneWith: (fileName, options) => {
      // <-- Keys.filePatch
      const optKey = Keys.filePatch._optKey(options);
      return new CacheKey(`file-patch:${optKey}:${fileName}`, ['file-patch', `file-patch:${optKey}`]);
    },

    eachWithFileOpts: (fileNames, opts) => {
      const keys = [];
      for (let i = 0; i < fileNames.length; i++) {
        for (let j = 0; j < opts.length; j++) {
          keys.push(Keys.filePatch.oneWith(fileNames[i], opts[j]));
        }
      }
      return keys;
    },

    eachWithOpts: function () {
      for (var _len2 = arguments.length, opts = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        opts[_key2] = arguments[_key2];
      }

      return opts.map(opt => new GroupKey(`file-patch:${Keys.filePatch._optKey(opt)}`));
    },

    all: new GroupKey('file-patch')
  },

  index: {
    oneWith: fileName => new CacheKey(`index:${fileName}`, ['index']),

    all: new GroupKey('index')
  },

  lastCommit: new CacheKey('last-commit'),

  branches: new CacheKey('branches'),

  headDescription: new CacheKey('head-description'),

  remotes: new CacheKey('remotes'),

  config: {
    _optKey: options => options.local ? 'l' : '',

    oneWith: (setting, options) => {
      const optKey = Keys.config._optKey(options);
      return new CacheKey(`config:${optKey}:${setting}`, ['config', `config:${optKey}`]);
    },

    eachWithSetting: setting => [Keys.config.oneWith(setting, { local: true }), Keys.config.oneWith(setting, { local: false })],

    all: new GroupKey('config')
  },

  blob: {
    oneWith: sha => `blob:${sha}`
  },

  // Common collections of keys and patterns for use with @invalidate().

  workdirOperationKeys: fileNames => [Keys.statusBundle, ...Keys.filePatch.eachWithFileOpts(fileNames, [{ staged: false }])],

  cacheOperationKeys: fileNames => [...Keys.workdirOperationKeys(fileNames), ...Keys.filePatch.eachWithFileOpts(fileNames, [{ staged: true }, { staged: true, amending: true }]), ...fileNames.map(Keys.index.oneWith), Keys.stagedChangesSinceParentCommit],

  headOperationKeys: () => [...Keys.filePatch.eachWithOpts({ staged: true, amending: true }), Keys.stagedChangesSinceParentCommit, Keys.lastCommit, Keys.statusBundle]
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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