'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _state = require('./state');

var _state2 = _interopRequireDefault(_state);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initial state to be used when we anticipate that the workspace will contain a single project once bootstrapping
 * has completed. Presents in the UI like the Loading state.
 */
let LoadingGuess = class LoadingGuess extends _state2.default {
  isLoadingGuess() {
    return true;
  }

  isUndetermined() {
    return true;
  }

  showGitTabLoading() {
    return true;
  }

  showGitTabInit() {
    return false;
  }

  hasDirectory() {
    return false;
  }
};
exports.default = LoadingGuess;


_state2.default.register(LoadingGuess);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvYWRpbmctZ3Vlc3MuanMiXSwibmFtZXMiOlsiTG9hZGluZ0d1ZXNzIiwiaXNMb2FkaW5nR3Vlc3MiLCJpc1VuZGV0ZXJtaW5lZCIsInNob3dHaXRUYWJMb2FkaW5nIiwic2hvd0dpdFRhYkluaXQiLCJoYXNEaXJlY3RvcnkiLCJyZWdpc3RlciJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBOzs7Ozs7QUFFQTs7OztJQUlxQkEsWSxHQUFOLE1BQU1BLFlBQU4seUJBQWlDO0FBQzlDQyxtQkFBaUI7QUFDZixXQUFPLElBQVA7QUFDRDs7QUFFREMsbUJBQWlCO0FBQ2YsV0FBTyxJQUFQO0FBQ0Q7O0FBRURDLHNCQUFvQjtBQUNsQixXQUFPLElBQVA7QUFDRDs7QUFFREMsbUJBQWlCO0FBQ2YsV0FBTyxLQUFQO0FBQ0Q7O0FBRURDLGlCQUFlO0FBQ2IsV0FBTyxLQUFQO0FBQ0Q7QUFuQjZDLEM7a0JBQTNCTCxZOzs7QUFzQnJCLGdCQUFNTSxRQUFOLENBQWVOLFlBQWYiLCJmaWxlIjoibG9hZGluZy1ndWVzcy5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS9hbmRyZWkvYXRvbS0xLjE5LjIvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0YXRlIGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIEluaXRpYWwgc3RhdGUgdG8gYmUgdXNlZCB3aGVuIHdlIGFudGljaXBhdGUgdGhhdCB0aGUgd29ya3NwYWNlIHdpbGwgY29udGFpbiBhIHNpbmdsZSBwcm9qZWN0IG9uY2UgYm9vdHN0cmFwcGluZ1xuICogaGFzIGNvbXBsZXRlZC4gUHJlc2VudHMgaW4gdGhlIFVJIGxpa2UgdGhlIExvYWRpbmcgc3RhdGUuXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIExvYWRpbmdHdWVzcyBleHRlbmRzIFN0YXRlIHtcbiAgaXNMb2FkaW5nR3Vlc3MoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBpc1VuZGV0ZXJtaW5lZCgpIHtcbiAgICByZXR1cm4gdHJ1ZTtcbiAgfVxuXG4gIHNob3dHaXRUYWJMb2FkaW5nKCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgc2hvd0dpdFRhYkluaXQoKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbiAgaGFzRGlyZWN0b3J5KCkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfVxufVxuXG5TdGF0ZS5yZWdpc3RlcihMb2FkaW5nR3Vlc3MpO1xuIl19