'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
let Remote = class Remote {
  constructor(name, url) {
    this.name = name;
    this.url = url;

    var _githubInfoFromRemote = githubInfoFromRemote(url);

    const isGithubRepo = _githubInfoFromRemote.isGithubRepo,
          owner = _githubInfoFromRemote.owner,
          repo = _githubInfoFromRemote.repo;

    this.githubRepo = isGithubRepo;
    this.owner = owner;
    this.repo = repo;
  }

  getName() {
    return this.name;
  }

  getUrl() {
    return this.url;
  }

  isGithubRepo() {
    return this.githubRepo;
  }

  getOwner() {
    return this.owner;
  }

  getRepo() {
    return this.repo;
  }

  getNameOr(fallback) {
    return this.getName();
  }

  isPresent() {
    return true;
  }
};
exports.default = Remote;


function githubInfoFromRemote(remoteUrl) {
  if (!remoteUrl) {
    return {
      isGithubRepo: false,
      owner: null,
      repo: null
    };
  }

  //             proto       login   domain         owner    repo
  const regex = /(?:.+:\/\/)?(?:.+@)?github\.com[:/]([^/]+)\/(.+)/;
  const match = remoteUrl.match(regex);
  if (match) {
    return {
      isGithubRepo: true,
      owner: match[1],
      repo: match[2].replace(/\.git$/, '')
    };
  } else {
    return {
      isGithubRepo: false,
      owner: null,
      repo: null
    };
  }
}

const nullRemote = exports.nullRemote = {
  getName() {
    return '';
  },

  getUrl() {
    return '';
  },

  isGithubRepo() {
    return false;
  },

  getOwner() {
    return null;
  },

  getRepo() {
    return null;
  },

  getNameOr(fallback) {
    return fallback;
  },

  isPresent() {
    return false;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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