'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
let Hunk = class Hunk {
  constructor(oldStartRow, newStartRow, oldRowCount, newRowCount, sectionHeading, lines) {
    this.oldStartRow = oldStartRow;
    this.newStartRow = newStartRow;
    this.oldRowCount = oldRowCount;
    this.newRowCount = newRowCount;
    this.sectionHeading = sectionHeading;
    this.lines = lines;
  }

  copy() {
    return new Hunk(this.getOldStartRow(), this.getNewStartRow(), this.getOldRowCount(), this.getNewRowCount(), this.getSectionHeading(), this.getLines().map(l => l.copy()));
  }

  getOldStartRow() {
    return this.oldStartRow;
  }

  getNewStartRow() {
    return this.newStartRow;
  }

  getOldRowCount() {
    return this.oldRowCount;
  }

  getNewRowCount() {
    return this.newRowCount;
  }

  getLines() {
    return this.lines;
  }

  getHeader() {
    return `@@ -${this.oldStartRow},${this.oldRowCount} +${this.newStartRow},${this.newRowCount} @@\n`;
  }

  getSectionHeading() {
    return this.sectionHeading;
  }

  invert() {
    const invertedLines = [];
    let addedLines = [];
    for (const line of this.getLines()) {
      const invertedLine = line.invert();
      if (invertedLine.getStatus() === 'added') {
        addedLines.push(invertedLine);
      } else if (invertedLine.getStatus() === 'deleted') {
        invertedLines.push(invertedLine);
      } else {
        invertedLines.push(...addedLines);
        invertedLines.push(invertedLine);
        addedLines = [];
      }
    }
    invertedLines.push(...addedLines);
    return new Hunk(this.getNewStartRow(), this.getOldStartRow(), this.getNewRowCount(), this.getOldRowCount(), this.getSectionHeading(), invertedLines);
  }

  toString() {
    return this.getLines().reduce((a, b) => a + b.toString() + '\n', this.getHeader());
  }
};
exports.default = Hunk;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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