'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.InMemoryStrategy = exports.SecurityBinaryStrategy = exports.KeytarStrategy = exports.UNAUTHENTICATED = undefined;

var _child_process = require('child_process');

var _keytar = require('keytar');

var _keytar2 = _interopRequireDefault(_keytar);

var _eventKit = require('event-kit');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

const UNAUTHENTICATED = exports.UNAUTHENTICATED = Symbol('UNAUTHENTICATED');

let KeytarStrategy = exports.KeytarStrategy = class KeytarStrategy {
  static isValid() {
    return _asyncToGenerator(function* () {
      try {
        const rand = Math.floor(Math.random() * 10e20).toString(16);
        yield _keytar2.default.setPassword('atom-test-service', rand, rand);
        const pass = yield _keytar2.default.getPassword('atom-test-service', rand);
        const success = pass === rand;
        _keytar2.default.deletePassword('atom-test-service', rand);
        return success;
      } catch (err) {
        return false;
      }
    })();
  }

  getPassword(service, account) {
    return _keytar2.default.getPassword(service, account);
  }

  replacePassword(service, account, password) {
    return _keytar2.default.setPassword(service, account, password);
  }

  deletePassword(service, account) {
    return _keytar2.default.deletePassword(service, account);
  }
};
let SecurityBinaryStrategy = exports.SecurityBinaryStrategy = class SecurityBinaryStrategy {
  static isValid() {
    return process.platform === 'darwin';
  }

  getPassword(service, account) {
    var _this = this;

    return _asyncToGenerator(function* () {
      try {
        const password = yield _this.exec(['find-generic-password', '-s', service, '-a', account, '-w']);
        return password.trim() || UNAUTHENTICATED;
      } catch (err) {
        return UNAUTHENTICATED;
      }
    })();
  }

  replacePassword(service, account, newPassword) {
    return this.exec(['add-generic-password', '-s', service, '-a', account, '-w', newPassword, '-U']);
  }

  deletePassword(service, account) {
    return this.exec(['delete-generic-password', '-s', service, '-a', account]);
  }

  exec(securityArgs) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { binary: 'security' };

    let binary = _ref.binary;

    return new Promise((resolve, reject) => {
      (0, _child_process.execFile)(binary, securityArgs, (error, stdout) => {
        if (error) {
          return reject(error);
        }
        return resolve(stdout);
      });
    });
  }
};
let InMemoryStrategy = exports.InMemoryStrategy = class InMemoryStrategy {
  static isValid() {
    return true;
  }

  constructor() {
    if (!atom.inSpecMode()) {
      // eslint-disable-next-line no-console
      console.warn('Using an InMemoryStrategy strategy for storing tokens. ' + 'The tokens will only be stored for the current window.');
    }
    this.passwordsByService = new Map();
  }

  getPassword(service, account) {
    const passwords = this.passwordsByService.get(service) || new Map();
    const password = passwords.get(account);
    return password || UNAUTHENTICATED;
  }

  replacePassword(service, account, newPassword) {
    const passwords = this.passwordsByService.get(service) || new Map();
    passwords.set(account, newPassword);
    this.passwordsByService.set(service, passwords);
  }

  deletePassword(service, account) {
    const passwords = this.passwordsByService.get(service);
    if (passwords) {
      passwords.delete(account);
    }
  }
};


let instance = null;
const strategies = [KeytarStrategy, SecurityBinaryStrategy, InMemoryStrategy];
let GithubLoginModel = class GithubLoginModel {
  static get() {
    if (!instance) {
      instance = new GithubLoginModel();
    }
    return instance;
  }

  constructor(Strategy) {
    this._Strategy = Strategy;
    this._strategy = null;
    this.emitter = new _eventKit.Emitter();
  }

  getStrategy() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (_this2._strategy) {
        return _this2._strategy;
      }

      if (_this2._Strategy) {
        _this2._strategy = new _this2._Strategy();
        return _this2._strategy;
      }

      let Strategy;
      for (let i = 0; i < strategies.length; i++) {
        const strat = strategies[i];
        const isValid = yield strat.isValid();
        if (isValid) {
          Strategy = strat;
          break;
        }
      }
      // const Strategy = this._Strategy || strategies.find(strat => strat.isValid());
      if (!Strategy) {
        throw new Error('None of the listed GithubLoginModel strategies returned true for `isValid`');
      }
      _this2._strategy = new Strategy();
      return _this2._strategy;
    })();
  }

  getToken(account) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      const strategy = yield _this3.getStrategy();
      let password = yield strategy.getPassword('atom-github', account);
      if (!password) {
        // User is not logged in
        password = UNAUTHENTICATED;
      }
      return password;
    })();
  }

  setToken(account, token) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      const strategy = yield _this4.getStrategy();
      yield strategy.replacePassword('atom-github', account, token);
      _this4.didUpdate();
    })();
  }

  removeToken(account) {
    var _this5 = this;

    return _asyncToGenerator(function* () {
      const strategy = yield _this5.getStrategy();
      yield strategy.deletePassword('atom-github', account);
      _this5.didUpdate();
    })();
  }

  didUpdate() {
    this.emitter.emit('did-update');
  }

  onDidUpdate(cb) {
    return this.emitter.on('did-update', cb);
  }

  destroy() {
    this.emitter.dispose();
  }
};
exports.default = GithubLoginModel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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