'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
const DETACHED = {};

let Branch = class Branch {
  constructor(name) {
    let detached = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    this.name = name;
    this.detached = detached === DETACHED;
  }

  static createDetached(describe) {
    return new Branch(describe, DETACHED);
  }

  getName() {
    return this.name;
  }

  isDetached() {
    return this.detached;
  }

  isPresent() {
    return true;
  }
};
exports.default = Branch;
const nullBranch = exports.nullBranch = {
  getName() {
    return '';
  },

  isDetached() {
    return false;
  },

  isPresent() {
    return false;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJyYW5jaC5qcyJdLCJuYW1lcyI6WyJERVRBQ0hFRCIsIkJyYW5jaCIsImNvbnN0cnVjdG9yIiwibmFtZSIsImRldGFjaGVkIiwiY3JlYXRlRGV0YWNoZWQiLCJkZXNjcmliZSIsImdldE5hbWUiLCJpc0RldGFjaGVkIiwiaXNQcmVzZW50IiwibnVsbEJyYW5jaCJdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxNQUFNQSxXQUFXLEVBQWpCOztJQUVxQkMsTSxHQUFOLE1BQU1BLE1BQU4sQ0FBYTtBQUMxQkMsY0FBWUMsSUFBWixFQUFtQztBQUFBLFFBQWpCQyxRQUFpQix1RUFBTixJQUFNOztBQUNqQyxTQUFLRCxJQUFMLEdBQVlBLElBQVo7QUFDQSxTQUFLQyxRQUFMLEdBQWdCQSxhQUFhSixRQUE3QjtBQUNEOztBQUVELFNBQU9LLGNBQVAsQ0FBc0JDLFFBQXRCLEVBQWdDO0FBQzlCLFdBQU8sSUFBSUwsTUFBSixDQUFXSyxRQUFYLEVBQXFCTixRQUFyQixDQUFQO0FBQ0Q7O0FBRURPLFlBQVU7QUFDUixXQUFPLEtBQUtKLElBQVo7QUFDRDs7QUFFREssZUFBYTtBQUNYLFdBQU8sS0FBS0osUUFBWjtBQUNEOztBQUVESyxjQUFZO0FBQ1YsV0FBTyxJQUFQO0FBQ0Q7QUFwQnlCLEM7a0JBQVBSLE07QUF1QmQsTUFBTVMsa0NBQWE7QUFDeEJILFlBQVU7QUFDUixXQUFPLEVBQVA7QUFDRCxHQUh1Qjs7QUFLeEJDLGVBQWE7QUFDWCxXQUFPLEtBQVA7QUFDRCxHQVB1Qjs7QUFTeEJDLGNBQVk7QUFDVixXQUFPLEtBQVA7QUFDRDtBQVh1QixDQUFuQiIsImZpbGUiOiJicmFuY2guanMiLCJzb3VyY2VSb290IjoiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IERFVEFDSEVEID0ge307XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEJyYW5jaCB7XG4gIGNvbnN0cnVjdG9yKG5hbWUsIGRldGFjaGVkID0gbnVsbCkge1xuICAgIHRoaXMubmFtZSA9IG5hbWU7XG4gICAgdGhpcy5kZXRhY2hlZCA9IGRldGFjaGVkID09PSBERVRBQ0hFRDtcbiAgfVxuXG4gIHN0YXRpYyBjcmVhdGVEZXRhY2hlZChkZXNjcmliZSkge1xuICAgIHJldHVybiBuZXcgQnJhbmNoKGRlc2NyaWJlLCBERVRBQ0hFRCk7XG4gIH1cblxuICBnZXROYW1lKCkge1xuICAgIHJldHVybiB0aGlzLm5hbWU7XG4gIH1cblxuICBpc0RldGFjaGVkKCkge1xuICAgIHJldHVybiB0aGlzLmRldGFjaGVkO1xuICB9XG5cbiAgaXNQcmVzZW50KCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG59XG5cbmV4cG9ydCBjb25zdCBudWxsQnJhbmNoID0ge1xuICBnZXROYW1lKCkge1xuICAgIHJldHVybiAnJztcbiAgfSxcblxuICBpc0RldGFjaGVkKCkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfSxcblxuICBpc1ByZXNlbnQoKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9LFxufTtcbiJdfQ==