'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.classNameForStatus = exports.isFileExecutable = undefined;

let isFileExecutable = exports.isFileExecutable = (() => {
  var _ref = _asyncToGenerator(function* (absoluteFilePath) {
    const stat = yield fsStat(absoluteFilePath);
    return stat.mode & _fsExtra2.default.constants.S_IXUSR; // eslint-disable-line no-bitwise
  });

  return function isFileExecutable(_x3) {
    return _ref.apply(this, arguments);
  };
})();

exports.getPackageRoot = getPackageRoot;
exports.getDugitePath = getDugitePath;
exports.isBinary = isBinary;
exports.firstImplementer = firstImplementer;
exports.readFile = readFile;
exports.fileExists = fileExists;
exports.writeFile = writeFile;
exports.deleteFileOrFolder = deleteFileOrFolder;
exports.copyFile = copyFile;
exports.getTempDir = getTempDir;
exports.fsStat = fsStat;
exports.mkdirs = mkdirs;
exports.shortenSha = shortenSha;
exports.normalizeGitHelperPath = normalizeGitHelperPath;
exports.toNativePathSep = toNativePathSep;
exports.toGitPathSep = toGitPathSep;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsExtra = require('fs-extra');

var _fsExtra2 = _interopRequireDefault(_fsExtra);

var _temp = require('temp');

var _temp2 = _interopRequireDefault(_temp);

var _ncp = require('ncp');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function getPackageRoot() {
  var _atom$getLoadSettings = atom.getLoadSettings();

  const resourcePath = _atom$getLoadSettings.resourcePath;

  const currentFileWasRequiredFromSnapshot = !_path2.default.isAbsolute(__dirname);
  if (currentFileWasRequiredFromSnapshot) {
    return _path2.default.join(resourcePath, 'node_modules', 'github');
  } else {
    const packageRoot = _path2.default.resolve(__dirname, '..');
    if (_path2.default.extname(resourcePath) === '.asar') {
      if (packageRoot.indexOf(resourcePath) === 0) {
        return _path2.default.join(`${resourcePath}.unpacked`, 'node_modules', 'github');
      }
    }
    return packageRoot;
  }
}

let DUGITE_PATH;
function getDugitePath() {
  if (!DUGITE_PATH) {
    DUGITE_PATH = require.resolve('dugite');
    if (!_path2.default.isAbsolute(DUGITE_PATH)) {
      // Assume we're snapshotted
      var _atom$getLoadSettings2 = atom.getLoadSettings();

      const resourcePath = _atom$getLoadSettings2.resourcePath;

      if (_path2.default.extname(resourcePath) === '.asar') {
        DUGITE_PATH = _path2.default.join(`${resourcePath}.unpacked`, 'node_modules', 'dugite');
      } else {
        DUGITE_PATH = _path2.default.join(resourcePath, 'node_modules', 'dugite');
      }
    }
  }

  return DUGITE_PATH;
}

function isBinary(data) {
  for (let i = 0; i < 50; i++) {
    const code = data.charCodeAt(i);
    // Char code 65533 is the "replacement character";
    // 8 and below are control characters.
    if (code === 65533 || code < 9) {
      return true;
    }
  }

  return false;
}

function descriptorsFromProto(proto) {
  return Object.getOwnPropertyNames(proto).reduce((acc, name) => {
    Object.assign(acc, {
      [name]: Reflect.getOwnPropertyDescriptor(proto, name)
    });
    return acc;
  }, {});
}

/**
 * Takes an array of targets and returns a proxy. The proxy intercepts property accessor calls and
 * returns the value of that property on the first object in `targets` where the target implements that property.
 */
function firstImplementer() {
  for (var _len = arguments.length, targets = Array(_len), _key = 0; _key < _len; _key++) {
    targets[_key] = arguments[_key];
  }

  return new Proxy({ __implementations: targets }, {
    get(target, name) {
      if (name === 'getImplementers') {
        return () => targets;
      }

      if (Reflect.has(target, name)) {
        return target[name];
      }

      const firstValidTarget = targets.find(t => Reflect.has(t, name));
      if (firstValidTarget) {
        return firstValidTarget[name];
      } else {
        return undefined;
      }
    },

    set(target, name, value) {
      const firstValidTarget = targets.find(t => Reflect.has(t, name));
      if (firstValidTarget) {
        // eslint-disable-next-line no-return-assign
        return firstValidTarget[name] = value;
      } else {
        // eslint-disable-next-line no-return-assign
        return target[name] = value;
      }
    },

    // Used by sinon
    getOwnPropertyDescriptor(target, name) {
      const firstValidTarget = targets.find(t => Reflect.getOwnPropertyDescriptor(t, name));
      const compositeOwnPropertyDescriptor = Reflect.getOwnPropertyDescriptor(target, name);
      if (firstValidTarget) {
        return Reflect.getOwnPropertyDescriptor(firstValidTarget, name);
      } else if (compositeOwnPropertyDescriptor) {
        return compositeOwnPropertyDescriptor;
      } else {
        return undefined;
      }
    },

    // Used by sinon
    getPrototypeOf(target) {
      return targets.reduceRight((acc, t) => {
        return Object.create(acc, descriptorsFromProto(Object.getPrototypeOf(t)));
      }, Object.prototype);
    }
  });
}

function readFile(absoluteFilePath) {
  let encoding = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'utf8';

  return new Promise((resolve, reject) => {
    _fsExtra2.default.readFile(absoluteFilePath, encoding, (err, contents) => {
      if (err) {
        reject(err);
      } else {
        resolve(contents);
      }
    });
  });
}

function fileExists(absoluteFilePath) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.access(absoluteFilePath, err => {
      if (err) {
        if (err.code === 'ENOENT') {
          resolve(false);
        } else {
          reject(err);
        }
      } else {
        resolve(true);
      }
    });
  });
}

function writeFile(absoluteFilePath, contents) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.writeFile(absoluteFilePath, contents, err => {
      if (err) {
        return reject(err);
      } else {
        return resolve();
      }
    });
  });
}

function deleteFileOrFolder(fileOrFolder) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.remove(fileOrFolder, err => {
      if (err) {
        return reject(err);
      } else {
        return resolve();
      }
    });
  });
}

function copyFile(source, target) {
  return new Promise((resolve, reject) => {
    (0, _ncp.ncp)(source, target, err => {
      if (err) {
        return reject(err);
      } else {
        return resolve(target);
      }
    });
  });
}

function getTempDir() {
  let prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

  return new Promise((resolve, reject) => {
    _temp2.default.mkdir(prefix, (tempError, folder) => {
      if (tempError) {
        reject(tempError);
        return;
      }

      _fsExtra2.default.realpath(folder, (realError, rpath) => realError ? reject(realError) : resolve(rpath));
    });
  });
}

function fsStat(absoluteFilePath) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.stat(absoluteFilePath, (err, stats) => {
      if (err) {
        reject(err);
      } else {
        resolve(stats);
      }
    });
  });
}

function mkdirs(directory) {
  return new Promise((resolve, reject) => {
    _fsExtra2.default.mkdirs(directory, err => err ? reject(err) : resolve());
  });
}

function shortenSha(sha) {
  return sha.slice(0, 8);
}

const classNameForStatus = exports.classNameForStatus = {
  added: 'added',
  deleted: 'removed',
  modified: 'modified',
  equivalent: 'ignored'
};

/*
 * Apply any platform-specific munging to a path before presenting it as
 * a git environment variable or option.
 *
 * Convert a Windows-style "C:\foo\bar\baz" path to a "/c/foo/bar/baz" UNIX-y
 * path that the sh.exe used to execute git's credential helpers will
 * understand.
 */
function normalizeGitHelperPath(inPath) {
  if (process.platform === 'win32') {
    return inPath.replace(/\\/g, '/').replace(/^([^:]+):/, '/$1');
  } else {
    return inPath;
  }
}

/*
 * On Windows, git commands report paths with / delimiters. Convert them to \-delimited paths
 * so that Atom unifromly treats paths with native path separators.
 */
function toNativePathSep(rawPath) {
  if (process.platform !== 'win32') {
    return rawPath;
  } else {
    return rawPath.split('/').join(_path2.default.sep);
  }
}

/*
 * Convert Windows paths back to /-delimited paths to be presented to git.
 */
function toGitPathSep(rawPath) {
  if (process.platform !== 'win32') {
    return rawPath;
  } else {
    return rawPath.split(_path2.default.sep).join('/');
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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