'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _net = require('net');

var _net2 = _interopRequireDefault(_net);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _eventKit = require('event-kit');

var _helpers = require('./helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function getAtomHelperPath() {
  if (process.platform === 'darwin') {
    const beta = atom.appVersion.match(/-beta/);
    const appName = beta ? 'Atom Beta Helper' : 'Atom Helper';
    return _path2.default.resolve(process.resourcesPath, '..', 'Frameworks', `${appName}.app`, 'Contents', 'MacOS', appName);
  } else {
    return process.execPath;
  }
}

let GitPromptServer = class GitPromptServer {
  constructor() {
    this.emitter = new _eventKit.Emitter();
  }

  start(promptForInput) {
    var _this = this;

    return _asyncToGenerator(function* () {
      // TODO: [mkt] Windows?? yes.
      _this.promptForInput = promptForInput;
      const windows = process.platform === 'win32';
      _this.tmpFolderPath = yield (0, _helpers.getTempDir)('github-');

      const credentialHelper = {};
      const askPass = {};
      const sshWrapper = {};

      const sourceFiles = {
        'git-credential-atom.js': function (outfile) {
          return credentialHelper.script = outfile;
        },
        'git-credential-atom.sh': function (outfile) {
          return credentialHelper.launcher = outfile;
        },
        'git-askpass-atom.js': function (outfile) {
          return askPass.script = outfile;
        },
        'git-askpass-atom.sh': function (outfile) {
          return askPass.launcher = outfile;
        },
        'linux-ssh-wrapper.sh': function (outfile) {
          return sshWrapper.script = outfile;
        }
      };

      yield Promise.all(Object.keys(sourceFiles).map(function (filename) {
        return (0, _helpers.copyFile)(_path2.default.resolve((0, _helpers.getPackageRoot)(), 'bin', filename), _path2.default.join(_this.tmpFolderPath, filename)).then(sourceFiles[filename]);
      }));

      const socketPath = _path2.default.join(_this.tmpFolderPath, 'helper.sock');
      const namedPipePath = _path2.default.join('\\\\?\\pipe\\', 'gh-' + require('crypto').randomBytes(8).toString('hex'), 'helper.sock');
      _this.server = yield _this.startListening(windows ? namedPipePath : socketPath);

      return {
        socket: windows ? namedPipePath : socketPath,
        electron: getAtomHelperPath(),
        credentialHelper,
        askPass,
        sshWrapper
      };
    })();
  }

  startListening(socketPath) {
    return new Promise(resolve => {
      const server = _net2.default.createServer(connection => {
        connection.setEncoding('utf8');

        const parts = [];

        connection.on('data', data => {
          const nullIndex = data.indexOf('\u0000');
          if (nullIndex === -1) {
            parts.push(data);
          } else {
            parts.push(data.substring(0, nullIndex));
            this.handleData(connection, parts.join(''));
          }
        });
      });

      server.listen(socketPath, () => resolve(server));
    });
  }

  handleData(connection, data) {
    let query;
    try {
      query = JSON.parse(data);
    } catch (e) {
      this.emitter.emit('did-cancel');
    }

    Promise.resolve(this.promptForInput(query)).then(answer => connection.end(JSON.stringify(answer), 'utf-8')).catch(() => this.emitter.emit('did-cancel', { handlerPid: query.pid }));
  }

  onDidCancel(cb) {
    return this.emitter.on('did-cancel', cb);
  }

  terminate() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      yield new Promise(function (resolve) {
        return _this2.server.close(resolve);
      });
      yield (0, _helpers.deleteFileOrFolder)(_this2.tmpFolderPath);
      _this2.emitter.dispose();
    })();
  }
};
exports.default = GitPromptServer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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