'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _desc, _value, _class, _class2, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _yubikiri = require('yubikiri');

var _yubikiri2 = _interopRequireDefault(_yubikiri);

var _coreDecorators = require('core-decorators');

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

var _relayRootContainer = require('../containers/relay-root-container');

var _relayRootContainer2 = _interopRequireDefault(_relayRootContainer);

var _githubLoginModel = require('../models/github-login-model');

var _githubLoginModel2 = _interopRequireDefault(_githubLoginModel);

var _githubLoginView = require('../views/github-login-view');

var _githubLoginView2 = _interopRequireDefault(_githubLoginView);

var _observeModel = require('../views/observe-model');

var _observeModel2 = _interopRequireDefault(_observeModel);

var _issueishInfoByNumberRoute = require('../routes/issueish-info-by-number-route');

var _issueishInfoByNumberRoute2 = _interopRequireDefault(_issueishInfoByNumberRoute);

var _issueishLookupByNumberContainer = require('../containers/issueish-lookup-by-number-container');

var _issueishLookupByNumberContainer2 = _interopRequireDefault(_issueishLookupByNumberContainer);

var _relayEnvironment = require('../views/relay-environment');

var _relayEnvironment2 = _interopRequireDefault(_relayEnvironment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let IssueishPaneItemController = (_class = (_temp = _class2 = class IssueishPaneItemController extends _react2.default.Component {
  fetchData(loginModel) {
    return (0, _yubikiri2.default)({
      token: loginModel.getToken(this.props.host)
    });
  }

  render() {
    return _react2.default.createElement(
      _observeModel2.default,
      { model: this.props.loginModel, fetchData: this.fetchData },
      this.renderWithToken
    );
  }

  renderWithToken(data) {
    if (!data) {
      return null;
    }
    if (data.token === _githubLoginModel.UNAUTHENTICATED) {
      return _react2.default.createElement(_githubLoginView2.default, { onLogin: this.handleLogin });
    }

    const route = new _issueishInfoByNumberRoute2.default({
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      issueishNumber: this.props.issueishNumber
    });

    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.host, data.token);

    const Component = _issueishLookupByNumberContainer2.default;
    return _react2.default.createElement(
      _relayEnvironment2.default,
      { environment: environment },
      _react2.default.createElement(_relayRootContainer2.default, {
        Component: Component,
        route: route,
        environment: environment,
        renderFetched: props => {
          return _react2.default.createElement(Component, _extends({}, props, { onTitleChange: this.props.onTitleChange }));
        },
        renderLoading: () => {
          return _react2.default.createElement(
            'div',
            { className: 'github-Loader' },
            _react2.default.createElement('span', { className: 'github-Spinner' })
          );
        },
        renderFailure: (err, retry) => {
          if (err.response && err.response.status === 401) {
            return _react2.default.createElement(
              'div',
              { className: 'github-GithubLoginView-Container' },
              _react2.default.createElement(
                _githubLoginView2.default,
                { onLogin: this.handleLogin },
                _react2.default.createElement(
                  'p',
                  null,
                  'The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.'
                )
              )
            );
          } else {
            return _react2.default.createElement(
              'div',
              null,
              'An unknown error occurred.'
            );
          }
        }
      })
    );
  }

  handleLogin(token) {
    this.props.loginModel.setToken(this.props.host, token);
  }
}, _class2.propTypes = {
  onTitleChange: _propTypes2.default.func.isRequired,
  owner: _propTypes2.default.string.isRequired,
  repo: _propTypes2.default.string.isRequired,
  issueishNumber: _propTypes2.default.number.isRequired,
  host: _propTypes2.default.string,
  loginModel: _propTypes2.default.instanceOf(_githubLoginModel2.default).isRequired
}, _class2.defaultProps = {
  host: 'api.github.com'
}, _temp), (_applyDecoratedDescriptor(_class.prototype, 'fetchData', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'fetchData'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'renderWithToken', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'renderWithToken'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'handleLogin', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleLogin'), _class.prototype)), _class);
exports.default = IssueishPaneItemController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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