'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _desc, _value, _class, _class2, _temp;

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _atom = require('atom');

var _eventKit = require('event-kit');

var _coreDecorators = require('core-decorators');

var _switchboard = require('../switchboard');

var _switchboard2 = _interopRequireDefault(_switchboard);

var _filePatchView = require('../views/file-patch-view');

var _filePatchView2 = _interopRequireDefault(_filePatchView);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) {
  var desc = {};
  Object['ke' + 'ys'](descriptor).forEach(function (key) {
    desc[key] = descriptor[key];
  });
  desc.enumerable = !!desc.enumerable;
  desc.configurable = !!desc.configurable;

  if ('value' in desc || desc.initializer) {
    desc.writable = true;
  }

  desc = decorators.slice().reverse().reduce(function (desc, decorator) {
    return decorator(target, property, desc) || desc;
  }, desc);

  if (context && desc.initializer !== void 0) {
    desc.value = desc.initializer ? desc.initializer.call(context) : void 0;
    desc.initializer = undefined;
  }

  if (desc.initializer === void 0) {
    Object['define' + 'Property'](target, property, desc);
    desc = null;
  }

  return desc;
}

let FilePatchController = (_class = (_temp = _class2 = class FilePatchController extends _react2.default.Component {

  static resetConfirmedLargeFilePatches() {
    this.confirmedLargeFilePatches = new Set();
  }

  constructor(props, context) {
    super(props, context);

    this.stagingOperationInProgress = false;
    this.emitter = new _eventKit.Emitter();
  }

  serialize() {
    return null;
  }

  componentDidUpdate(prevProps) {
    if (this.getTitle(prevProps) !== this.getTitle()) {
      this.emitter.emit('did-change-title');
    }
  }

  render() {
    const hunks = this.props.filePatch.getHunks();
    if (!hunks.length) {
      return _react2.default.createElement(
        'div',
        { className: 'github-PaneView pane-item is-blank' },
        _react2.default.createElement(
          'span',
          { className: 'icon icon-info' },
          'File has no contents'
        )
      );
    } else if (!this.shouldDisplayLargeDiff(this.props.filePatch)) {
      return _react2.default.createElement(
        'div',
        { className: 'github-PaneView pane-item large-file-patch' },
        _react2.default.createElement(
          'p',
          null,
          'This is a large diff. For performance reasons, it is not rendered by default.'
        ),
        _react2.default.createElement(
          'button',
          { className: 'btn btn-primary', onClick: this.handleShowDiffClick },
          'Show Diff'
        )
      );
    } else {
      // NOTE: Outer div is required for etch to render elements correctly
      const filePath = this.props.filePatch.getPath();
      const hasUndoHistory = this.props.repository ? this.hasUndoHistory() : false;
      return _react2.default.createElement(
        'div',
        { className: 'github-PaneView pane-item' },
        _react2.default.createElement(_filePatchView2.default, {
          ref: c => {
            this.filePatchView = c;
          },
          commandRegistry: this.props.commandRegistry,
          tooltips: this.props.tooltips,
          hunks: hunks,
          filePath: filePath,
          stagingStatus: this.props.stagingStatus,
          isPartiallyStaged: this.props.isPartiallyStaged,
          attemptLineStageOperation: this.attemptLineStageOperation,
          attemptHunkStageOperation: this.attemptHunkStageOperation,
          didSurfaceFile: this.didSurfaceFile,
          didDiveIntoCorrespondingFilePatch: this.diveIntoCorrespondingFilePatch,
          switchboard: this.props.switchboard,
          openCurrentFile: this.openCurrentFile,
          discardLines: this.props.discardLines,
          undoLastDiscard: this.undoLastDiscard,
          hasUndoHistory: hasUndoHistory
        })
      );
    }
  }

  shouldDisplayLargeDiff(filePatch) {
    const fullPath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), this.props.filePatch.getPath());
    if (FilePatchController.confirmedLargeFilePatches.has(fullPath)) {
      return true;
    }

    const lineCount = filePatch.getHunks().reduce((acc, hunk) => hunk.getLines().length, 0);
    return lineCount < this.props.largeDiffLineThreshold;
  }

  onDidChangeTitle(callback) {
    return this.emitter.on('did-change-title', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  handleShowDiffClick() {
    if (this.props.repository) {
      const fullPath = _path2.default.join(this.props.repository.getWorkingDirectoryPath(), this.props.filePatch.getPath());
      FilePatchController.confirmedLargeFilePatches.add(fullPath);
      this.forceUpdate();
    }
  }

  stageHunk(hunk) {
    var _this = this;

    return _asyncToGenerator(function* () {
      _this.props.switchboard.didBeginStageOperation({ stage: true, hunk: true });

      yield _this.props.repository.applyPatchToIndex(_this.props.filePatch.getStagePatchForHunk(hunk));
      _this.props.switchboard.didFinishStageOperation({ stage: true, hunk: true });
    })();
  }

  unstageHunk(hunk) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      _this2.props.switchboard.didBeginStageOperation({ unstage: true, hunk: true });

      yield _this2.props.repository.applyPatchToIndex(_this2.props.filePatch.getUnstagePatchForHunk(hunk));

      _this2.props.switchboard.didFinishStageOperation({ unstage: true, hunk: true });
    })();
  }

  stageOrUnstageHunk(hunk) {
    if (this.props.stagingStatus === 'unstaged') {
      return this.stageHunk(hunk);
    } else if (this.props.stagingStatus === 'staged') {
      return this.unstageHunk(hunk);
    } else {
      throw new Error(`Unknown stagingStatus: ${this.props.stagingStatus}`);
    }
  }

  attemptHunkStageOperation(hunk) {
    if (this.stagingOperationInProgress) {
      return;
    }

    this.stagingOperationInProgress = true;
    this.props.switchboard.getChangePatchPromise().then(() => {
      this.stagingOperationInProgress = false;
    });

    this.stageOrUnstageHunk(hunk);
  }

  stageLines(lines) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      _this3.props.switchboard.didBeginStageOperation({ stage: true, line: true });

      yield _this3.props.repository.applyPatchToIndex(_this3.props.filePatch.getStagePatchForLines(lines));

      _this3.props.switchboard.didFinishStageOperation({ stage: true, line: true });
    })();
  }

  unstageLines(lines) {
    var _this4 = this;

    return _asyncToGenerator(function* () {
      _this4.props.switchboard.didBeginStageOperation({ unstage: true, line: true });

      yield _this4.props.repository.applyPatchToIndex(_this4.props.filePatch.getUnstagePatchForLines(lines));

      _this4.props.switchboard.didFinishStageOperation({ unstage: true, line: true });
    })();
  }

  stageOrUnstageLines(lines) {
    if (this.props.stagingStatus === 'unstaged') {
      return this.stageLines(lines);
    } else if (this.props.stagingStatus === 'staged') {
      return this.unstageLines(lines);
    } else {
      throw new Error(`Unknown stagingStatus: ${this.props.stagingStatus}`);
    }
  }

  attemptLineStageOperation(lines) {
    if (this.stagingOperationInProgress) {
      return;
    }

    this.stagingOperationInProgress = true;
    this.props.switchboard.getChangePatchPromise().then(() => {
      this.stagingOperationInProgress = false;
    });

    this.stageOrUnstageLines(lines);
  }

  getTitle() {
    let props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;

    let title = props.stagingStatus === 'staged' ? 'Staged' : 'Unstaged';
    title += ' Changes: ';
    title += props.filePatch.getPath();
    return title;
  }

  didSurfaceFile() {
    if (this.props.didSurfaceFile) {
      this.props.didSurfaceFile(this.props.filePatch.getPath(), this.props.stagingStatus);
    }
  }

  diveIntoCorrespondingFilePatch() {
    const filePath = this.props.filePatch.getPath();
    const stagingStatus = this.props.stagingStatus === 'staged' ? 'unstaged' : 'staged';
    this.props.quietlySelectItem(filePath, stagingStatus);
    return this.props.didDiveIntoFilePath(filePath, stagingStatus, { amending: this.props.isAmending });
  }

  focus() {
    if (this.filePatchView) {
      this.filePatchView.focus();
    }
  }

  wasActivated() {
    process.nextTick(() => this.focus());
  }

  openCurrentFile() {
    var _this5 = this;

    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    let lineNumber = _ref.lineNumber;
    return _asyncToGenerator(function* () {
      var _ref2 = yield _this5.props.openFiles([_this5.props.filePatch.getPath()]),
          _ref3 = _slicedToArray(_ref2, 1);

      const textEditor = _ref3[0];

      const position = new _atom.Point(lineNumber ? lineNumber - 1 : 0, 0);
      textEditor.scrollToBufferPosition(position, { center: true });
      textEditor.setCursorBufferPosition(position);
      return textEditor;
    })();
  }

  undoLastDiscard() {
    return this.props.undoLastDiscard(this.props.filePatch.getPath());
  }

  hasUndoHistory() {
    return this.props.repository.hasDiscardHistory(this.props.filePatch.getPath());
  }

  goToDiffLine(lineNumber) {
    return this.filePatchView.goToDiffLine(lineNumber);
  }

  /**
   * Used to detect the context when this PaneItem is active
   */
  getWorkingDirectory() {
    return this.props.activeWorkingDirectory;
  }

  destroy() {
    this.emitter.emit('did-destroy');
  }
}, _class2.propTypes = {
  largeDiffLineThreshold: _propTypes2.default.number,
  activeWorkingDirectory: _propTypes2.default.string,
  repository: _propTypes2.default.object.isRequired,
  commandRegistry: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  filePatch: _propTypes2.default.object.isRequired,
  stagingStatus: _propTypes2.default.oneOf(['unstaged', 'staged']).isRequired,
  isPartiallyStaged: _propTypes2.default.bool.isRequired,
  isAmending: _propTypes2.default.bool.isRequired,
  discardLines: _propTypes2.default.func.isRequired,
  didSurfaceFile: _propTypes2.default.func.isRequired,
  didDiveIntoFilePath: _propTypes2.default.func.isRequired,
  quietlySelectItem: _propTypes2.default.func.isRequired,
  undoLastDiscard: _propTypes2.default.func.isRequired,
  openFiles: _propTypes2.default.func.isRequired,
  switchboard: _propTypes2.default.instanceOf(_switchboard2.default)
}, _class2.defaultProps = {
  largeDiffLineThreshold: 1000,
  switchboard: new _switchboard2.default()
}, _class2.confirmedLargeFilePatches = new Set(), _temp), (_applyDecoratedDescriptor(_class.prototype, 'handleShowDiffClick', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'handleShowDiffClick'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'attemptHunkStageOperation', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'attemptHunkStageOperation'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'attemptLineStageOperation', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'attemptLineStageOperation'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'didSurfaceFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'didSurfaceFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'diveIntoCorrespondingFilePatch', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'diveIntoCorrespondingFilePatch'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'openCurrentFile', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'openCurrentFile'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'undoLastDiscard', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'undoLastDiscard'), _class.prototype), _applyDecoratedDescriptor(_class.prototype, 'hasUndoHistory', [_coreDecorators.autobind], Object.getOwnPropertyDescriptor(_class.prototype, 'hasUndoHistory'), _class.prototype)), _class);
exports.default = FilePatchController;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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