'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let UserMentionTooltip = (_temp = _class = class UserMentionTooltip extends _react2.default.Component {

  render() {
    const owner = this.props.repositoryOwner;
    const login = owner.login,
          company = owner.company,
          repositories = owner.repositories,
          members = owner.members;

    return _react2.default.createElement(
      'div',
      { className: 'github-UserMentionTooltip' },
      _react2.default.createElement(
        'div',
        { className: 'github-UserMentionTooltip-avatar' },
        _react2.default.createElement('img', { src: owner.avatarUrl })
      ),
      _react2.default.createElement(
        'div',
        { className: 'github-UserMentionTooltip-info' },
        _react2.default.createElement(
          'div',
          { className: 'github-UserMentionTooltip-info-username' },
          _react2.default.createElement(_octicon2.default, { icon: 'mention' }),
          _react2.default.createElement(
            'strong',
            null,
            login
          )
        ),
        company && _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'briefcase' }),
          _react2.default.createElement(
            'span',
            null,
            company
          )
        ),
        members && _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'organization' }),
          _react2.default.createElement(
            'span',
            null,
            members.totalCount,
            ' members'
          )
        ),
        _react2.default.createElement(
          'div',
          null,
          _react2.default.createElement(_octicon2.default, { icon: 'repo' }),
          _react2.default.createElement(
            'span',
            null,
            repositories.totalCount,
            ' repositories'
          )
        )
      ),
      _react2.default.createElement('div', { style: { clear: 'both' } })
    );
  }
}, _class.propTypes = {
  repositoryOwner: _propTypes2.default.shape({
    login: _propTypes2.default.string.isRequired,
    avatarUrl: _propTypes2.default.string.isRequired,
    repositories: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    }).isRequired,

    // Users
    company: _propTypes2.default.string,

    // Organizations
    members: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    })
  }).isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(UserMentionTooltip, {
  fragments: {
    repositoryOwner: () => function () {
      return {
        children: [{
          fieldName: 'login',
          kind: 'Field',
          metadata: {},
          type: 'String'
        }, {
          fieldName: 'avatarUrl',
          kind: 'Field',
          metadata: {},
          type: 'URI'
        }, {
          children: [{
            fieldName: 'totalCount',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }],
          fieldName: 'repositories',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'RepositoryConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }, {
          fieldName: '__typename',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'String'
        }, {
          children: [{
            fieldName: 'company',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'User',
          type: 'User'
        }, {
          children: [{
            children: [{
              fieldName: 'totalCount',
              kind: 'Field',
              metadata: {},
              type: 'Int'
            }],
            fieldName: 'members',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isConnection: true
            },
            type: 'UserConnection'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'Organization',
          type: 'Organization'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {
          isAbstract: true
        },
        name: 'User_RepositoryOwnerRelayQL',
        type: 'RepositoryOwner'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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