'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _octicon = require('../views/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

let IssueishTooltip = (_temp = _class = class IssueishTooltip extends _react2.default.Component {

  render() {
    const resource = this.props.resource;
    const repository = resource.repository,
          state = resource.state,
          number = resource.number,
          title = resource.title,
          author = resource.author,
          __typename = resource.__typename;

    const icons = typeAndStateToIcon[__typename] || {};
    const icon = icons[state] || '';
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishTooltip' },
      _react2.default.createElement(
        'div',
        { className: 'issueish-badge-and-link' },
        _react2.default.createElement(
          'span',
          { className: (0, _classnames2.default)('issueish-badge', 'badge', state.toLowerCase()) },
          _react2.default.createElement(_octicon2.default, { icon: icon }),
          state.toLowerCase()
        ),
        _react2.default.createElement(
          'span',
          { className: 'issueish-link' },
          repository.owner.login,
          '/',
          repository.name,
          '#',
          number
        )
      ),
      _react2.default.createElement(
        'h3',
        { className: 'issueish-title' },
        title
      ),
      _react2.default.createElement(
        'div',
        { className: 'issueish-avatar-and-title' },
        _react2.default.createElement('img', { className: 'author-avatar', src: author.avatarUrl, title: author.login }),
        _react2.default.createElement(
          'strong',
          null,
          author.login
        )
      )
    );
  }
}, _class.propTypes = {
  resource: _propTypes2.default.shape({
    issue: _propTypes2.default.shape({}),
    pullRequest: _propTypes2.default.shape({})
  }).isRequired
}, _temp);
exports.default = _reactRelay2.default.createContainer(IssueishTooltip, {
  fragments: {
    resource: () => function () {
      return {
        children: [{
          fieldName: '__typename',
          kind: 'Field',
          metadata: {
            isRequisite: true
          },
          type: 'String'
        }, {
          children: [{
            fieldName: 'state',
            kind: 'Field',
            metadata: {},
            type: 'IssueState'
          }, {
            fieldName: 'number',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }, {
            fieldName: 'title',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            children: [{
              fieldName: 'name',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              children: [{
                fieldName: 'login',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              fieldName: 'owner',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isAbstract: true
              },
              type: 'RepositoryOwner'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'repository',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'Repository'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'avatarUrl',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'author',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'Actor'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'Issue',
          type: 'Issue'
        }, {
          children: [{
            fieldName: 'state',
            kind: 'Field',
            metadata: {},
            type: 'PullRequestState'
          }, {
            fieldName: 'number',
            kind: 'Field',
            metadata: {},
            type: 'Int'
          }, {
            fieldName: 'title',
            kind: 'Field',
            metadata: {},
            type: 'String'
          }, {
            children: [{
              fieldName: 'name',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              children: [{
                fieldName: 'login',
                kind: 'Field',
                metadata: {},
                type: 'String'
              }, {
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              fieldName: 'owner',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isAbstract: true
              },
              type: 'RepositoryOwner'
            }, {
              fieldName: 'id',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'ID'
            }],
            fieldName: 'repository',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id'
            },
            type: 'Repository'
          }, {
            children: [{
              fieldName: 'login',
              kind: 'Field',
              metadata: {},
              type: 'String'
            }, {
              fieldName: 'avatarUrl',
              kind: 'Field',
              metadata: {},
              type: 'URI'
            }, {
              fieldName: '__typename',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [{
                fieldName: 'id',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'ID'
              }, {
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isGenerated: true,
                  isRequisite: true
                },
                type: 'String'
              }],
              id: _reactRelay2.default.QL.__id(),
              kind: 'Fragment',
              metadata: {
                isAbstract: true
              },
              name: 'IdFragment',
              type: 'Node'
            }],
            fieldName: 'author',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              inferredRootCallName: 'node',
              inferredPrimaryKey: 'id',
              isAbstract: true
            },
            type: 'Actor'
          }, {
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {},
          name: 'PullRequest',
          type: 'PullRequest'
        }, {
          children: [{
            fieldName: 'id',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'ID'
          }, {
            fieldName: '__typename',
            kind: 'Field',
            metadata: {
              isGenerated: true,
              isRequisite: true
            },
            type: 'String'
          }],
          id: _reactRelay2.default.QL.__id(),
          kind: 'Fragment',
          metadata: {
            isAbstract: true
          },
          name: 'IdFragment',
          type: 'Node'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {
          isAbstract: true
        },
        name: 'Issueish_ResourceRelayQL',
        type: 'UniformResourceLocatable'
      };
    }()
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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