'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IssueishTimeline = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _reactRelay2 = _interopRequireDefault(_reactRelay);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _commitsContainer = require('./timeline-items/commits-container.js');

var _commitsContainer2 = _interopRequireDefault(_commitsContainer);

var _issueCommentContainer = require('./timeline-items/issue-comment-container.js');

var _issueCommentContainer2 = _interopRequireDefault(_issueCommentContainer);

var _mergedEventContainer = require('./timeline-items/merged-event-container.js');

var _mergedEventContainer2 = _interopRequireDefault(_mergedEventContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const groupableTimelineItems = {
  Commit: _commitsContainer2.default
};

const nonGroupableTimelineItems = {
  IssueComment: _issueCommentContainer2.default,
  MergedEvent: _mergedEventContainer2.default
};

let IssueishTimeline = exports.IssueishTimeline = (_temp = _class = class IssueishTimeline extends _react2.default.Component {

  render() {
    const issueish = this.props.issue || this.props.pullRequest;
    const groupedEdges = this.groupEdges(issueish.timeline.edges);
    return _react2.default.createElement(
      'div',
      { className: 'github-PrTimeline' },
      groupedEdges.map((_ref) => {
        let type = _ref.type,
            edges = _ref.edges;

        if (groupableTimelineItems[type]) {
          return this.renderGroupableTimelineEvents(type, edges);
        } else if (nonGroupableTimelineItems[type]) {
          return this.renderNonGroupableTimelineEvents(type, edges);
        } else {
          // eslint-disable-next-line no-console
          console.warn(`unrecogized timeline event type: ${type}`);
          return null;
        }
      })
    );
  }

  renderGroupableTimelineEvents(type, edges) {
    const Component = groupableTimelineItems[type];
    return _react2.default.createElement(Component, {
      key: `${type}-${edges[0].cursor}`,
      nodes: edges.map(e => e.node),
      switchToIssueish: this.props.switchToIssueish
    });
  }

  renderNonGroupableTimelineEvents(type, edges) {
    const Component = nonGroupableTimelineItems[type];
    return edges.map((_ref2) => {
      let node = _ref2.node,
          cursor = _ref2.cursor;

      return _react2.default.createElement(Component, { key: `${type}-${cursor}`, item: node, switchToIssueish: this.props.switchToIssueish });
    });
  }

  groupEdges(edges) {
    let currentGroup;
    const groupedEdges = [];
    let lastEdgeType;
    edges.forEach((_ref3) => {
      let node = _ref3.node,
          cursor = _ref3.cursor;

      const currentEdgeType = node.__typename;
      if (currentEdgeType === lastEdgeType) {
        currentGroup.edges.push({ node, cursor });
      } else {
        currentGroup = {
          type: currentEdgeType,
          edges: [{ node, cursor }]
        };
        groupedEdges.push(currentGroup);
      }
      lastEdgeType = currentEdgeType;
    });
    return groupedEdges;
  }
}, _class.propTypes = {
  switchToIssueish: _propTypes2.default.func.isRequired,
  issue: _propTypes2.default.shape({
    timeline: _propTypes2.default.object.isRequired
  }),
  pullRequest: _propTypes2.default.shape({
    timeline: _propTypes2.default.object.isRequired
  })
}, _temp);
exports.default = _reactRelay2.default.createContainer(IssueishTimeline, {
  fragments: {
    issue: () => function (RQL_0, RQL_1) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'first',
            value: {
              kind: 'CallValue',
              callValue: 100
            }
          }],
          children: [{
            children: [{
              fieldName: 'cursor',
              kind: 'Field',
              metadata: {
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [].concat.apply([], [{
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isRequisite: true
                },
                type: 'String'
              }, _reactRelay2.default.QL.__frag(RQL_0), _reactRelay2.default.QL.__frag(RQL_1), {
                children: [{
                  fieldName: 'id',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'ID'
                }, {
                  fieldName: '__typename',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'String'
                }],
                id: _reactRelay2.default.QL.__id(),
                kind: 'Fragment',
                metadata: {
                  isAbstract: true
                },
                name: 'IdFragment',
                type: 'Node'
              }]),
              fieldName: 'node',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isAbstract: true,
                isRequisite: true
              },
              type: 'IssueTimelineItem'
            }],
            fieldName: 'edges',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'IssueTimelineItemEdge'
          }, {
            children: [{
              fieldName: 'hasNextPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }, {
              fieldName: 'hasPreviousPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }],
            fieldName: 'pageInfo',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isGenerated: true,
              isRequisite: true
            },
            type: 'PageInfo'
          }],
          fieldName: 'timeline',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'IssueTimelineConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_IssueRelayQL',
        type: 'Issue'
      };
    }(groupableTimelineItems.Commit.getFragment('nodes'), nonGroupableTimelineItems.IssueComment.getFragment('item')),
    pullRequest: () => function (RQL_0, RQL_1, RQL_2) {
      return {
        children: [{
          calls: [{
            kind: 'Call',
            metadata: {},
            name: 'first',
            value: {
              kind: 'CallValue',
              callValue: 100
            }
          }],
          children: [{
            children: [{
              fieldName: 'cursor',
              kind: 'Field',
              metadata: {
                isRequisite: true
              },
              type: 'String'
            }, {
              children: [].concat.apply([], [{
                fieldName: '__typename',
                kind: 'Field',
                metadata: {
                  isRequisite: true
                },
                type: 'String'
              }, _reactRelay2.default.QL.__frag(RQL_0), _reactRelay2.default.QL.__frag(RQL_1), _reactRelay2.default.QL.__frag(RQL_2), {
                children: [{
                  fieldName: 'id',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'ID'
                }, {
                  fieldName: '__typename',
                  kind: 'Field',
                  metadata: {
                    isGenerated: true,
                    isRequisite: true
                  },
                  type: 'String'
                }],
                id: _reactRelay2.default.QL.__id(),
                kind: 'Fragment',
                metadata: {
                  isAbstract: true
                },
                name: 'IdFragment',
                type: 'Node'
              }]),
              fieldName: 'node',
              kind: 'Field',
              metadata: {
                canHaveSubselections: true,
                inferredRootCallName: 'node',
                inferredPrimaryKey: 'id',
                isAbstract: true,
                isRequisite: true
              },
              type: 'PullRequestTimelineItem'
            }],
            fieldName: 'edges',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isPlural: true
            },
            type: 'PullRequestTimelineItemEdge'
          }, {
            children: [{
              fieldName: 'hasNextPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }, {
              fieldName: 'hasPreviousPage',
              kind: 'Field',
              metadata: {
                isGenerated: true,
                isRequisite: true
              },
              type: 'Boolean'
            }],
            fieldName: 'pageInfo',
            kind: 'Field',
            metadata: {
              canHaveSubselections: true,
              isGenerated: true,
              isRequisite: true
            },
            type: 'PageInfo'
          }],
          fieldName: 'timeline',
          kind: 'Field',
          metadata: {
            canHaveSubselections: true,
            isConnection: true
          },
          type: 'PullRequestTimelineConnection'
        }, {
          fieldName: 'id',
          kind: 'Field',
          metadata: {
            isGenerated: true,
            isRequisite: true
          },
          type: 'ID'
        }],
        id: _reactRelay2.default.QL.__id(),
        kind: 'Fragment',
        metadata: {},
        name: 'Issueish_PullRequestRelayQL',
        type: 'PullRequest'
      };
    }(groupableTimelineItems.Commit.getFragment('nodes'), nonGroupableTimelineItems.IssueComment.getFragment('item'), nonGroupableTimelineItems.MergedEvent.getFragment('item'))
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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