(function() {
  var CompositeDisposable, Directory, Emitter, File, Watcher, path, ref, ref1,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  ref = require('atom'), File = ref.File, Directory = ref.Directory;

  ref1 = require('atom'), CompositeDisposable = ref1.CompositeDisposable, Emitter = ref1.Emitter;

  path = require('path');

  module.exports = Watcher = (function() {
    function Watcher() {
      this.destroy = bind(this.destroy, this);
      this.emitter = new Emitter;
      this.disposables = new CompositeDisposable;
      this.entities = [];
    }

    Watcher.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };

    Watcher.prototype.onDidChangeGlobals = function(callback) {
      return this.emitter.on('did-change-globals', callback);
    };

    Watcher.prototype.destroy = function() {
      this.disposables.dispose();
      this.entities = null;
      this.emitter.emit('did-destroy');
      return this.emitter.dispose();
    };

    Watcher.prototype.watch = function() {};

    Watcher.prototype.loadStylesheet = function(stylesheetPath) {};

    Watcher.prototype.loadAllStylesheets = function() {};

    Watcher.prototype.emitGlobalsChanged = function() {
      return this.emitter.emit('did-change-globals');
    };

    Watcher.prototype.watchDirectory = function(directoryPath) {
      var entity;
      if (this.isInAsarArchive(directoryPath)) {
        return;
      }
      entity = new Directory(directoryPath);
      this.disposables.add(entity.onDidChange((function(_this) {
        return function() {
          return _this.loadAllStylesheets();
        };
      })(this)));
      return this.entities.push(entity);
    };

    Watcher.prototype.watchGlobalFile = function(filePath) {
      var entity;
      entity = new File(filePath);
      this.disposables.add(entity.onDidChange((function(_this) {
        return function() {
          return _this.emitGlobalsChanged();
        };
      })(this)));
      return this.entities.push(entity);
    };

    Watcher.prototype.watchFile = function(filePath) {
      var entity, reloadFn;
      if (this.isInAsarArchive(filePath)) {
        return;
      }
      reloadFn = (function(_this) {
        return function() {
          return _this.loadStylesheet(entity.getPath());
        };
      })(this);
      entity = new File(filePath);
      this.disposables.add(entity.onDidChange(reloadFn));
      this.disposables.add(entity.onDidDelete(reloadFn));
      this.disposables.add(entity.onDidRename(reloadFn));
      return this.entities.push(entity);
    };

    Watcher.prototype.isInAsarArchive = function(pathToCheck) {
      var resourcePath;
      resourcePath = atom.getLoadSettings().resourcePath;
      return pathToCheck.startsWith("" + resourcePath + path.sep) && path.extname(resourcePath) === '.asar';
    };

    return Watcher;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
