(function() {
  var PackageWatcher, Watcher, _, fs,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  _ = require('underscore-plus');

  fs = require('fs-plus');

  Watcher = require('./watcher');

  module.exports = PackageWatcher = (function(superClass) {
    extend(PackageWatcher, superClass);

    PackageWatcher.supportsPackage = function(pack, type) {
      if (pack.getType() === type && pack.getStylesheetPaths().length) {
        return true;
      }
      return false;
    };

    function PackageWatcher(pack1) {
      this.pack = pack1;
      this.loadAllStylesheets = bind(this.loadAllStylesheets, this);
      PackageWatcher.__super__.constructor.call(this);
      this.pack.onDidDeactivate(this.destroy);
      this.watch();
    }

    PackageWatcher.prototype.watch = function() {
      var i, len, onFile, onFolder, ref, stylesheet, stylesheetPaths, stylesheetsPath, watchPath, watchedPaths;
      watchedPaths = [];
      watchPath = (function(_this) {
        return function(stylesheet) {
          if (!_.contains(watchedPaths, stylesheet)) {
            _this.watchFile(stylesheet);
          }
          return watchedPaths.push(stylesheet);
        };
      })(this);
      stylesheetsPath = this.pack.getStylesheetsPath();
      if (fs.isDirectorySync(stylesheetsPath)) {
        this.watchDirectory(stylesheetsPath);
      }
      stylesheetPaths = this.pack.getStylesheetPaths();
      onFile = function(stylesheetPath) {
        return stylesheetPaths.push(stylesheetPath);
      };
      onFolder = function() {
        return true;
      };
      fs.traverseTreeSync(stylesheetsPath, onFile, onFolder);
      ref = _.uniq(stylesheetPaths);
      for (i = 0, len = ref.length; i < len; i++) {
        stylesheet = ref[i];
        watchPath(stylesheet);
      }
      return this.entities;
    };

    PackageWatcher.prototype.loadStylesheet = function(pathName) {
      if (pathName.indexOf('variables') > -1) {
        this.emitGlobalsChanged();
      }
      return this.loadAllStylesheets();
    };

    PackageWatcher.prototype.loadAllStylesheets = function() {
      console.log('Reloading package', this.pack.name);
      return this.pack.reloadStylesheets();
    };

    return PackageWatcher;

  })(Watcher);

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvYW5kcmVpL2F0b20tMS4xOS4yL291dC9hcHAvbm9kZV9tb2R1bGVzL2Rldi1saXZlLXJlbG9hZC9saWIvcGFja2FnZS13YXRjaGVyLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUEsOEJBQUE7SUFBQTs7OztFQUFBLENBQUEsR0FBSSxPQUFBLENBQVEsaUJBQVI7O0VBQ0osRUFBQSxHQUFLLE9BQUEsQ0FBUSxTQUFSOztFQUVMLE9BQUEsR0FBVSxPQUFBLENBQVEsV0FBUjs7RUFFVixNQUFNLENBQUMsT0FBUCxHQUNNOzs7SUFDSixjQUFDLENBQUEsZUFBRCxHQUFrQixTQUFDLElBQUQsRUFBTyxJQUFQO01BQ2hCLElBQWUsSUFBSSxDQUFDLE9BQUwsQ0FBQSxDQUFBLEtBQWtCLElBQWxCLElBQTJCLElBQUksQ0FBQyxrQkFBTCxDQUFBLENBQXlCLENBQUMsTUFBcEU7QUFBQSxlQUFPLEtBQVA7O2FBQ0E7SUFGZ0I7O0lBSUwsd0JBQUMsS0FBRDtNQUFDLElBQUMsQ0FBQSxPQUFEOztNQUNaLDhDQUFBO01BQ0EsSUFBQyxDQUFBLElBQUksQ0FBQyxlQUFOLENBQXNCLElBQUMsQ0FBQSxPQUF2QjtNQUNBLElBQUMsQ0FBQSxLQUFELENBQUE7SUFIVzs7NkJBS2IsS0FBQSxHQUFPLFNBQUE7QUFDTCxVQUFBO01BQUEsWUFBQSxHQUFlO01BQ2YsU0FBQSxHQUFZLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQyxVQUFEO1VBQ1YsSUFBQSxDQUE4QixDQUFDLENBQUMsUUFBRixDQUFXLFlBQVgsRUFBeUIsVUFBekIsQ0FBOUI7WUFBQSxLQUFDLENBQUEsU0FBRCxDQUFXLFVBQVgsRUFBQTs7aUJBQ0EsWUFBWSxDQUFDLElBQWIsQ0FBa0IsVUFBbEI7UUFGVTtNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUE7TUFJWixlQUFBLEdBQWtCLElBQUMsQ0FBQSxJQUFJLENBQUMsa0JBQU4sQ0FBQTtNQUVsQixJQUFvQyxFQUFFLENBQUMsZUFBSCxDQUFtQixlQUFuQixDQUFwQztRQUFBLElBQUMsQ0FBQSxjQUFELENBQWdCLGVBQWhCLEVBQUE7O01BRUEsZUFBQSxHQUFrQixJQUFDLENBQUEsSUFBSSxDQUFDLGtCQUFOLENBQUE7TUFDbEIsTUFBQSxHQUFTLFNBQUMsY0FBRDtlQUFvQixlQUFlLENBQUMsSUFBaEIsQ0FBcUIsY0FBckI7TUFBcEI7TUFDVCxRQUFBLEdBQVcsU0FBQTtlQUFHO01BQUg7TUFDWCxFQUFFLENBQUMsZ0JBQUgsQ0FBb0IsZUFBcEIsRUFBcUMsTUFBckMsRUFBNkMsUUFBN0M7QUFFQTtBQUFBLFdBQUEscUNBQUE7O1FBQUEsU0FBQSxDQUFVLFVBQVY7QUFBQTthQUVBLElBQUMsQ0FBQTtJQWpCSTs7NkJBbUJQLGNBQUEsR0FBZ0IsU0FBQyxRQUFEO01BQ2QsSUFBeUIsUUFBUSxDQUFDLE9BQVQsQ0FBaUIsV0FBakIsQ0FBQSxHQUFnQyxDQUFDLENBQTFEO1FBQUEsSUFBQyxDQUFBLGtCQUFELENBQUEsRUFBQTs7YUFDQSxJQUFDLENBQUEsa0JBQUQsQ0FBQTtJQUZjOzs2QkFJaEIsa0JBQUEsR0FBb0IsU0FBQTtNQUNsQixPQUFPLENBQUMsR0FBUixDQUFZLG1CQUFaLEVBQWlDLElBQUMsQ0FBQSxJQUFJLENBQUMsSUFBdkM7YUFDQSxJQUFDLENBQUEsSUFBSSxDQUFDLGlCQUFOLENBQUE7SUFGa0I7Ozs7S0FqQ087QUFON0IiLCJzb3VyY2VzQ29udGVudCI6WyJfID0gcmVxdWlyZSAndW5kZXJzY29yZS1wbHVzJ1xuZnMgPSByZXF1aXJlICdmcy1wbHVzJ1xuXG5XYXRjaGVyID0gcmVxdWlyZSAnLi93YXRjaGVyJ1xuXG5tb2R1bGUuZXhwb3J0cyA9XG5jbGFzcyBQYWNrYWdlV2F0Y2hlciBleHRlbmRzIFdhdGNoZXJcbiAgQHN1cHBvcnRzUGFja2FnZTogKHBhY2ssIHR5cGUpIC0+XG4gICAgcmV0dXJuIHRydWUgaWYgcGFjay5nZXRUeXBlKCkgaXMgdHlwZSBhbmQgcGFjay5nZXRTdHlsZXNoZWV0UGF0aHMoKS5sZW5ndGhcbiAgICBmYWxzZVxuXG4gIGNvbnN0cnVjdG9yOiAoQHBhY2spIC0+XG4gICAgc3VwZXIoKVxuICAgIEBwYWNrLm9uRGlkRGVhY3RpdmF0ZShAZGVzdHJveSlcbiAgICBAd2F0Y2goKVxuXG4gIHdhdGNoOiAtPlxuICAgIHdhdGNoZWRQYXRocyA9IFtdXG4gICAgd2F0Y2hQYXRoID0gKHN0eWxlc2hlZXQpID0+XG4gICAgICBAd2F0Y2hGaWxlKHN0eWxlc2hlZXQpIHVubGVzcyBfLmNvbnRhaW5zKHdhdGNoZWRQYXRocywgc3R5bGVzaGVldClcbiAgICAgIHdhdGNoZWRQYXRocy5wdXNoKHN0eWxlc2hlZXQpXG5cbiAgICBzdHlsZXNoZWV0c1BhdGggPSBAcGFjay5nZXRTdHlsZXNoZWV0c1BhdGgoKVxuXG4gICAgQHdhdGNoRGlyZWN0b3J5KHN0eWxlc2hlZXRzUGF0aCkgaWYgZnMuaXNEaXJlY3RvcnlTeW5jKHN0eWxlc2hlZXRzUGF0aClcblxuICAgIHN0eWxlc2hlZXRQYXRocyA9IEBwYWNrLmdldFN0eWxlc2hlZXRQYXRocygpXG4gICAgb25GaWxlID0gKHN0eWxlc2hlZXRQYXRoKSAtPiBzdHlsZXNoZWV0UGF0aHMucHVzaChzdHlsZXNoZWV0UGF0aClcbiAgICBvbkZvbGRlciA9IC0+IHRydWVcbiAgICBmcy50cmF2ZXJzZVRyZWVTeW5jKHN0eWxlc2hlZXRzUGF0aCwgb25GaWxlLCBvbkZvbGRlcilcblxuICAgIHdhdGNoUGF0aChzdHlsZXNoZWV0KSBmb3Igc3R5bGVzaGVldCBpbiBfLnVuaXEoc3R5bGVzaGVldFBhdGhzKVxuXG4gICAgQGVudGl0aWVzXG5cbiAgbG9hZFN0eWxlc2hlZXQ6IChwYXRoTmFtZSkgLT5cbiAgICBAZW1pdEdsb2JhbHNDaGFuZ2VkKCkgaWYgcGF0aE5hbWUuaW5kZXhPZigndmFyaWFibGVzJykgPiAtMVxuICAgIEBsb2FkQWxsU3R5bGVzaGVldHMoKVxuXG4gIGxvYWRBbGxTdHlsZXNoZWV0czogPT5cbiAgICBjb25zb2xlLmxvZyAnUmVsb2FkaW5nIHBhY2thZ2UnLCBAcGFjay5uYW1lXG4gICAgQHBhY2sucmVsb2FkU3R5bGVzaGVldHMoKVxuIl19
