(function() {
  var CompositeDisposable, Disposable, dontSaveIf, fs, ref, ref1, shouldSave;

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable;

  fs = require('fs-plus');

  ref1 = require('./controls'), dontSaveIf = ref1.dontSaveIf, shouldSave = ref1.shouldSave;

  module.exports = {
    subscriptions: null,
    provideService: function() {
      return {
        dontSaveIf: dontSaveIf
      };
    },
    activate: function() {
      var handleBeforeUnload, handleBlur;
      this.subscriptions = new CompositeDisposable;
      handleBeforeUnload = this.autosaveAllPaneItems.bind(this);
      window.addEventListener('beforeunload', handleBeforeUnload, true);
      this.subscriptions.add(new Disposable(function() {
        return window.removeEventListener('beforeunload', handleBeforeUnload, true);
      }));
      handleBlur = (function(_this) {
        return function(event) {
          if (event.target === window) {
            return _this.autosaveAllPaneItems();
          } else if (event.target.matches('atom-text-editor:not(mini)') && !event.target.contains(event.relatedTarget)) {
            return _this.autosavePaneItem(event.target.getModel());
          }
        };
      })(this);
      window.addEventListener('blur', handleBlur, true);
      this.subscriptions.add(new Disposable(function() {
        return window.removeEventListener('blur', handleBlur, true);
      }));
      return this.subscriptions.add(atom.workspace.onWillDestroyPaneItem((function(_this) {
        return function(arg) {
          var item;
          item = arg.item;
          return _this.autosavePaneItem(item);
        };
      })(this)));
    },
    deactivate: function() {
      return this.subscriptions.dispose();
    },
    autosavePaneItem: function(paneItem) {
      var pane;
      if (!atom.config.get('autosave.enabled')) {
        return;
      }
      if ((paneItem != null ? typeof paneItem.getURI === "function" ? paneItem.getURI() : void 0 : void 0) == null) {
        return;
      }
      if (!(paneItem != null ? typeof paneItem.isModified === "function" ? paneItem.isModified() : void 0 : void 0)) {
        return;
      }
      if (!(((paneItem != null ? typeof paneItem.getPath === "function" ? paneItem.getPath() : void 0 : void 0) != null) && fs.isFileSync(paneItem.getPath()))) {
        return;
      }
      if (!shouldSave(paneItem)) {
        return;
      }
      pane = atom.workspace.paneForItem(paneItem);
      if (pane != null) {
        return pane.saveItem(paneItem);
      } else {
        return typeof paneItem.save === "function" ? paneItem.save() : void 0;
      }
    },
    autosaveAllPaneItems: function() {
      var i, len, paneItem, ref2, results;
      ref2 = atom.workspace.getPaneItems();
      results = [];
      for (i = 0, len = ref2.length; i < len; i++) {
        paneItem = ref2[i];
        results.push(this.autosavePaneItem(paneItem));
      }
      return results;
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
